/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.concurrent.PriorityBlockingQueue;
import mrtjp.projectred.transportation.Router;

public class TableUpdateThread
extends Thread {
    private static PriorityBlockingQueue<RouteLayerUpdater> updateCalls = new PriorityBlockingQueue();
    private static Long average = 0L;

    public TableUpdateThread(int i) {
        super("PR TableUpdateThread #" + i);
        this.setDaemon(true);
        this.setPriority(5);
        this.start();
    }

    public static void add(Router r) {
        updateCalls.add(new RouteLayerUpdater(r));
    }

    public static boolean remove(Runnable run) {
        return updateCalls.remove(run);
    }

    public static int size() {
        return updateCalls.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getAverage() {
        Long l = average;
        synchronized (l) {
            return average;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        RouteLayerUpdater rlu = null;
        try {
            while ((rlu = updateCalls.take()) != null) {
                long starttime = System.nanoTime();
                rlu.run();
                long took = System.nanoTime() - starttime;
                Long l = average;
                synchronized (l) {
                    average = average == 0L ? Long.valueOf(took) : Long.valueOf((average * 999L + took) / 1000L);
                }
            }
            return;
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public static class RouteLayerUpdater
    implements Comparable<RouteLayerUpdater>,
    Runnable {
        int newVersion = 0;
        boolean complete = false;
        Router router;

        RouteLayerUpdater(Router router) {
            this.newVersion = router.getLinkStateID();
            this.router = router;
        }

        @Override
        public void run() {
            if (this.complete) {
                return;
            }
            try {
                if (this.router.getParent() == null) {
                    return;
                }
                for (int i = 0; i < 10 && !this.router.isLoaded(); ++i) {
                    Thread.sleep(10L);
                }
                if (!this.router.isLoaded()) {
                    return;
                }
                this.router.refreshRoutingTable(this.newVersion);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.complete = true;
        }

        @Override
        public int compareTo(RouteLayerUpdater o) {
            int c = 0;
            if (o.newVersion <= 0) {
                c = this.newVersion - o.newVersion;
            }
            if (c != 0) {
                return c;
            }
            c = this.router.getIPAddress() - o.router.getIPAddress();
            if (c != 0) {
                return c;
            }
            c = o.newVersion - this.newVersion;
            return c;
        }
    }
}

