/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.core.inventory.InventoryWrapper;
import mrtjp.projectred.core.inventory.SimpleInventory;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.transportation.ItemRoutingChip;
import mrtjp.projectred.transportation.RequestConsole;
import mrtjp.projectred.transportation.RouteFX;
import mrtjp.projectred.transportation.RoutingChipset;

public class RoutingChipset_ItemStockKeeper
extends RoutingChipset {
    public SimpleInventory filter = new SimpleInventory(9, "filter", 127);
    public boolean requestWhenEmpty = false;
    private final HashMap<ItemKey, Integer> enrouteItems = new HashMap();
    private int remainingDelay = this.operationDelay();
    private int operationsWithoutRequest = 0;

    private int operationDelay() {
        return 100;
    }

    private int throttleDelay() {
        int throttle = 10 * this.operationsWithoutRequest;
        throttle = Math.min(throttle, 1200);
        return throttle;
    }

    @Override
    public void update() {
        if (--this.remainingDelay > 0) {
            return;
        }
        mo real = this.inventoryProvider().getInventory();
        int side = this.inventoryProvider().getInterfacedSide();
        if (real == null || side < 0) {
            return;
        }
        InventoryWrapper inv = InventoryWrapper.wrapInventory((mo)real).setSlotsFromSide(side);
        InventoryWrapper filt = InventoryWrapper.wrapInventory((mo)this.filter).setSlotsAll();
        ArrayList checked = new ArrayList(9);
        boolean requestAttempted = false;
        boolean requestedSomething = false;
        for (int i = 0; i < this.filter.j_(); ++i) {
            int inInventory;
            int toRequest;
            int missing;
            ItemKeyStack keyStack = ItemKeyStack.get((ye)this.filter.a(i));
            if (keyStack == null || checked.contains(keyStack.key()) || (missing = (toRequest = filt.getItemCount(keyStack.key())) - (inInventory = inv.getItemCount(keyStack.key()) + this.getEnroute(keyStack.key()))) <= 0 || this.requestWhenEmpty && inInventory > 0) continue;
            RequestConsole req = new RequestConsole().setDestination(this.routeLayer().getRequester());
            req.setCrafting(true).setPulling(true).setPartials(true);
            ItemKeyStack request = ItemKeyStack.get((ItemKey)keyStack.key(), (int)missing);
            req.makeRequest(request);
            requestAttempted = true;
            if (req.requested() <= 0) continue;
            this.addToRequestList(request.key(), req.requested());
            requestedSomething = true;
        }
        if (requestAttempted) {
            RouteFX.spawnType1(RouteFX.color_request, 8, this.routeLayer().getCoords(), this.routeLayer().getWorld());
        }
        this.operationsWithoutRequest = requestAttempted && requestedSomething ? 0 : ++this.operationsWithoutRequest;
        this.remainingDelay = this.operationDelay() + this.throttleDelay();
    }

    private void addToRequestList(ItemKey item, int amount) {
        Integer current = this.enrouteItems.get(item);
        if (current == null) {
            this.enrouteItems.put(item, amount);
        } else {
            this.enrouteItems.put(item, current + amount);
        }
    }

    private void removeFromRequestList(ItemKey item, int amount) {
        Integer current = this.enrouteItems.get(item);
        if (current != null) {
            if ((current = Integer.valueOf(current - amount)) <= 0) {
                this.enrouteItems.remove(item);
            } else {
                this.enrouteItems.put(item, current);
            }
        }
    }

    private int getEnroute(ItemKey item) {
        Integer current = this.enrouteItems.get(item);
        if (current != null) {
            return current;
        }
        return 0;
    }

    @Override
    public void trackedItemLost(ItemKeyStack s) {
        this.removeFromRequestList(s.key(), s.stackSize);
    }

    @Override
    public void trackedItemReceived(ItemKeyStack s) {
        this.removeFromRequestList(s.key(), s.stackSize);
    }

    @Override
    public boolean weakTileChanges() {
        return true;
    }

    @Override
    public void onNeighborTileChanged(int side, boolean weak) {
        this.operationsWithoutRequest = 0;
        this.remainingDelay = Math.min(this.remainingDelay, this.operationDelay());
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        this.filter.save(tag);
        tag.a("mode", this.requestWhenEmpty);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.filter.load(tag);
        this.requestWhenEmpty = tag.n("mode");
    }

    @Override
    public List<String> infoCollection() {
        LinkedList<String> list = new LinkedList<String>();
        this.addModeInfo(list);
        this.addFilterInfo(list);
        return list;
    }

    public void addModeInfo(List<String> list) {
        list.add(a.h + "Stock Mode: " + (this.requestWhenEmpty ? "full refill" : "partial refill"));
    }

    public void addFilterInfo(List<String> list) {
        list.add(a.h + "Stock: ");
        boolean added = false;
        for (int i = 0; i < this.filter.j_(); ++i) {
            ye stack = this.filter.a(i);
            if (stack == null) continue;
            list.add(a.h + " - " + stack.s() + " (" + stack.b + ")");
            added = true;
        }
        if (!added) {
            list.add(a.h + " - empty");
        }
    }

    @Override
    public ItemRoutingChip.EnumRoutingChip getChipType() {
        return ItemRoutingChip.EnumRoutingChip.ITEMSTOCKKEEPER;
    }
}

