/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.core.inventory.InventoryWrapper;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.transportation.ItemRoutingChip;
import mrtjp.projectred.transportation.RoutedPayload;
import mrtjp.projectred.transportation.RoutingChipset;
import mrtjp.projectred.transportation.SyncResponse;
import org.lwjgl.input.Keyboard;

public class RoutingChipset_DynamicItemResponder
extends RoutingChipset {
    private static final RoutedPayload.SendPriority priority = RoutedPayload.SendPriority.PASSIVE;
    public int preference = 0;
    public boolean fuzzyMode = false;
    public int fuzzyDamageMode = 0;
    public static final int[] fuzzyPercent = new int[]{0, 25, 50, 75, 100};

    public void prefUp() {
        this.preference = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? (this.preference += 10) : ++this.preference;
        if (this.preference > 100) {
            this.preference = 100;
        }
    }

    public void prefDown() {
        this.preference = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? (this.preference -= 10) : --this.preference;
        if (this.preference < -100) {
            this.preference = -100;
        }
    }

    public void shiftFuzzy() {
        this.fuzzyDamageMode = (this.fuzzyDamageMode + 1) % 5;
    }

    @Override
    public SyncResponse getSyncResponse(ItemKey item, SyncResponse rival) {
        int room;
        InventoryWrapper inv;
        mo real = this.inventoryProvider().getInventory();
        int side = this.inventoryProvider().getInterfacedSide();
        if (real == null || side < 0) {
            return null;
        }
        if ((priority.ordinal() > rival.priority.ordinal() || priority.ordinal() == rival.priority.ordinal() && this.preference > rival.customPriority) && (inv = InventoryWrapper.wrapInventory((mo)real).setSlotsFromSide(side).setFuzzy(this.fuzzyMode).setFuzzyPercent(fuzzyPercent[this.fuzzyDamageMode])).hasItem(item) && (room = inv.getRoomAvailableForItem(item)) > 0) {
            return new SyncResponse().setPriority(priority).setCustomPriority(this.preference).setItemCount(room);
        }
        return null;
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        tag.a("cpri", this.preference);
        tag.a("fuz", this.fuzzyMode);
        tag.a("fuzd", (byte)this.fuzzyDamageMode);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.preference = tag.e("cpri");
        this.fuzzyMode = tag.n("fuz");
        this.fuzzyDamageMode = tag.c("fuzd");
    }

    @Override
    public List<String> infoCollection() {
        LinkedList<String> list = new LinkedList<String>();
        this.addPriorityInfo(list);
        this.addFilterInfo(list);
        return list;
    }

    public void addPriorityInfo(List<String> list) {
        list.add(a.h + "Preference: " + this.preference);
    }

    public void addFilterInfo(List<String> list) {
        list.add(a.h + "Fuzzy Mode: " + this.fuzzyMode);
        list.add(a.h + "Fuzzy Tool Damage: " + fuzzyPercent[this.fuzzyDamageMode] + "%");
    }

    @Override
    public ItemRoutingChip.EnumRoutingChip getChipType() {
        return ItemRoutingChip.EnumRoutingChip.DYNAMICITEMRESPONDER;
    }
}

