/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.core.IGuiPacketSender;
import codechicken.core.ServerUtils;
import codechicken.lib.packet.PacketCustom;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.transportation.IInventoryProvider;
import mrtjp.projectred.transportation.IRouteLayer;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.ItemRoutingChip;
import mrtjp.projectred.transportation.RequestBranchNode;
import mrtjp.projectred.transportation.RoutingChipContainerFactory;
import mrtjp.projectred.transportation.SyncResponse;
import mrtjp.projectred.transportation.TransportationSPH;

public abstract class RoutingChipset {
    private IInventoryProvider inventoryProvider;
    private IRouteLayer routeLayer;
    private int slot;
    private final UpgradeBus upgradeBus = this.createUpgradeBus();

    public void setEnvironment(IInventoryProvider inventoryProvider, IRouteLayer routeLayer, int slot) {
        this.inventoryProvider = inventoryProvider;
        this.routeLayer = routeLayer;
        this.slot = slot;
    }

    public IInventoryProvider inventoryProvider() {
        return this.inventoryProvider;
    }

    public IRouteLayer routeLayer() {
        return this.routeLayer;
    }

    public int slot() {
        return this.slot;
    }

    public void update() {
    }

    public SyncResponse getSyncResponse(ItemKey item, SyncResponse rival) {
        return null;
    }

    public void requestPromises(RequestBranchNode request, int existingPromises) {
    }

    public void deliverPromises(RequestBranchNode.DeliveryPromise promise, IWorldRequester requester) {
    }

    public void getProvidedItems(Map<ItemKey, Integer> map) {
    }

    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    public double getWorkLoad() {
        return 0.0;
    }

    public void trackedItemLost(ItemKeyStack s) {
    }

    public void trackedItemReceived(ItemKeyStack s) {
    }

    public void onPipeBroken() {
    }

    public void onNeighborTileChanged(int side, boolean weak) {
    }

    public boolean weakTileChanges() {
        return false;
    }

    public void save(by tag) {
        by tag2 = new by();
        this.getUpgradeBus().save(tag2);
        tag.a("upgrd", (cl)tag2);
    }

    public void load(by tag) {
        by tag2 = tag.l("upgrd");
        this.getUpgradeBus().load(tag2);
    }

    public abstract List<String> infoCollection();

    public abstract ItemRoutingChip.EnumRoutingChip getChipType();

    public void openGui(uf player) {
        if (player.q.I) {
            return;
        }
        ServerUtils.openSMPContainer((jv)((jv)player), (uy)this.createContainer(player), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(jv player, int windowId) {
                PacketCustom packet = new PacketCustom(TransportationSPH.channel, 5);
                packet.writeByte(player.bn.c);
                packet.writeByte(windowId);
                packet.sendToPlayer((uf)player);
            }
        });
    }

    public RoutingChipContainerFactory.ChipGhostContainer createContainer(uf player) {
        RoutingChipContainerFactory.ChipGhostContainer ghost = new RoutingChipContainerFactory.ChipGhostContainer(player);
        ghost.addPlayerInventory(8, 86);
        return ghost;
    }

    public UpgradeBus createUpgradeBus() {
        UpgradeBus bus = new UpgradeBus(0, 0);
        return bus;
    }

    public UpgradeBus getUpgradeBus() {
        return this.upgradeBus;
    }

    public void addUpgradeBusInfo(List<String> list) {
        LinkedList<String> list2 = new LinkedList<String>();
        UpgradeBus b = this.getUpgradeBus();
        if (b.containsUpgrades()) {
            list2.add("--- upgrades ---");
            String s = "";
            if (b.Lset[0]) {
                s = s + "LX";
            }
            if (b.Lset[1]) {
                s = s + " - LY";
            }
            if (b.Lset[2]) {
                s = s + " - LZ";
            }
            if (!s.isEmpty()) {
                list2.add(s);
            }
            String s2 = "";
            if (b.Rset[0]) {
                s2 = s2 + "RX";
            }
            if (b.Rset[1]) {
                s2 = s2 + " - RY";
            }
            if (b.Rset[2]) {
                s2 = s2 + " - RZ";
            }
            if (!s2.isEmpty()) {
                list2.add(s2);
            }
            list2.add("----------------");
            for (int i = 0; i < list2.size(); ++i) {
                list2.set(i, a.h + (String)list2.get(i));
            }
            list.addAll(list2);
        }
    }

    public static class UpgradeBus {
        public boolean[] Lset = new boolean[3];
        public boolean[] Rset = new boolean[3];
        public int LXLatency = 0;
        public int LYLatency = 0;
        public int LZLatency = 0;
        public int RXLatency = 0;
        public int RYLatency = 0;
        public int RZLatency = 0;
        public final int maxL;
        public final int maxR;
        public String Linfo;
        public String Lformula;
        public String Rinfo;
        public String Rformula;

        public UpgradeBus(int maxL, int maxR) {
            this.maxL = maxL;
            this.maxR = maxR;
        }

        public int LLatency() {
            int count = 0;
            if (this.Lset[0]) {
                count += this.LXLatency;
            }
            if (this.Lset[1]) {
                count += this.LYLatency;
            }
            if (this.Lset[2]) {
                count += this.LZLatency;
            }
            return count;
        }

        public int RLatency() {
            int count = 0;
            if (this.Rset[0]) {
                count += this.RXLatency;
            }
            if (this.Rset[1]) {
                count += this.RYLatency;
            }
            if (this.Rset[2]) {
                count += this.RZLatency;
            }
            return count;
        }

        public UpgradeBus setLatency(int lx, int ly, int lz, int rx, int ry, int rz) {
            this.LXLatency = lx;
            this.LYLatency = ly;
            this.LZLatency = lz;
            this.RXLatency = rx;
            this.RYLatency = ry;
            this.RZLatency = rz;
            return this;
        }

        public boolean installL(int i, boolean doInstall) {
            if (i >= this.maxL) {
                return false;
            }
            if (i - 1 >= 0 && !this.Lset[i - 1]) {
                return false;
            }
            if (!this.Lset[i]) {
                if (doInstall) {
                    this.Lset[i] = true;
                }
                return true;
            }
            return false;
        }

        public boolean installR(int i, boolean doInstall) {
            if (i >= this.maxR) {
                return false;
            }
            if (i - 1 >= 0 && !this.Rset[i - 1]) {
                return false;
            }
            if (!this.Rset[i]) {
                if (doInstall) {
                    this.Rset[i] = true;
                }
                return true;
            }
            return false;
        }

        public boolean containsUpgrades() {
            for (int i = 0; i < 3; ++i) {
                if (!this.Lset[i] && !this.Rset[i]) continue;
                return true;
            }
            return false;
        }

        public void save(by tag) {
            for (int i = 0; i < 3; ++i) {
                tag.a("L" + i, this.Lset[i]);
                tag.a("R" + i, this.Rset[i]);
            }
        }

        public void load(by tag) {
            for (int i = 0; i < 3; ++i) {
                this.Lset[i] = tag.n("L" + i);
                this.Rset[i] = tag.n("R" + i);
            }
        }
    }
}

