/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.transportation.IWorldRouter;
import mrtjp.projectred.transportation.LSPathFinder;
import mrtjp.projectred.transportation.RouterServices;
import mrtjp.projectred.transportation.TableUpdateThread;
import net.minecraftforge.common.ForgeDirection;

public class Router
implements Comparable<Router> {
    private List<ForgeDirection> routeTable = Collections.unmodifiableList(new ArrayList());
    private List<StartEndPath> routersByCost = Collections.unmodifiableList(new LinkedList());
    private EnumSet<ForgeDirection> routedExits = EnumSet.noneOf(ForgeDirection.class);
    private Map<Router, StartEndPath> adjacentLinks = new HashMap<Router, StartEndPath>();
    protected static final ReentrantReadWriteLock LSADatabaseLock = new ReentrantReadWriteLock();
    protected static final Lock LSADatabasereadLock = LSADatabaseLock.readLock();
    protected static final Lock LSADatabasewriteLock = LSADatabaseLock.writeLock();
    protected final ReentrantReadWriteLock routingTableLock = new ReentrantReadWriteLock();
    protected final Lock routingTableReadLock = this.routingTableLock.readLock();
    protected final Lock routingTableWriteLock = this.routingTableLock.writeLock();
    private static int[] LegacyLinkStateID = new int[0];
    private static LSA[] LSADatabase = new LSA[0];
    private LSA LSA;
    private int linkStateID = 0;
    private final int IPAddress;
    private final UUID ID;
    private final IWorldRouter parent;
    private static int nextIP = 1;
    private static BitSet usedIPs = new BitSet();
    private boolean decommissioned = false;

    public Router(UUID id, IWorldRouter parent) {
        this.ID = id == null ? UUID.randomUUID() : id;
        this.parent = parent;
        this.LSA = new LSA();
        LSADatabasewriteLock.lock();
        this.IPAddress = Router.claimIPAddress();
        if (LSADatabase.length <= this.IPAddress) {
            int newLength = (int)((double)this.IPAddress * 1.5) + 1;
            LSA[] SharedLSADatabase2 = new LSA[newLength];
            System.arraycopy(LSADatabase, 0, SharedLSADatabase2, 0, LSADatabase.length);
            LSADatabase = SharedLSADatabase2;
            int[] LSALegacyVersion2 = new int[newLength];
            System.arraycopy(LegacyLinkStateID, 0, LSALegacyVersion2, 0, LegacyLinkStateID.length);
            LegacyLinkStateID = LSALegacyVersion2;
        }
        Router.LegacyLinkStateID[this.IPAddress] = 0;
        Router.LSADatabase[this.IPAddress] = this.LSA;
        LSADatabasewriteLock.unlock();
    }

    public void update(boolean force) {
        if (force) {
            if (this.updateLSAIfNeeded()) {
                this.startLSAFloodfill();
            }
            this.refreshRouteTableIfNeeded(false);
            IWorldRouter r = this.getParent();
            if (r != null) {
                r.refreshState();
            }
            return;
        }
        if (Configurator.routerUpdateThreadCount > 0) {
            this.refreshRouteTableIfNeeded(false);
        }
    }

    private boolean updateLSAIfNeeded() {
        boolean adjacentChanged = false;
        IWorldRouter wr = this.getParent();
        if (wr == null) {
            return false;
        }
        LSPathFinder finder = new LSPathFinder(wr, Configurator.maxDetectionCount, Configurator.maxDetectionLength);
        HashMap<Router, StartEndPath> newAdjacent = finder.getResult();
        Iterator<Router> it = newAdjacent.keySet().iterator();
        while (it.hasNext()) {
            Router r = it.next();
            if (r.isLoaded()) continue;
            it.remove();
        }
        adjacentChanged = BasicUtils.compareMaps(newAdjacent, this.adjacentLinks);
        if (adjacentChanged) {
            EnumSet<ForgeDirection> newExits = EnumSet.noneOf(ForgeDirection.class);
            for (Map.Entry<Router, StartEndPath> r : newAdjacent.entrySet()) {
                newExits.add(ForgeDirection.getOrientation((int)r.getValue().dirToFirstHop));
            }
            this.adjacentLinks = Collections.unmodifiableMap(newAdjacent);
            this.routedExits = newExits;
            HashMap<Router, Integer> neighboursWithCost = new HashMap<Router, Integer>();
            for (Map.Entry<Router, StartEndPath> r : this.adjacentLinks.entrySet()) {
                neighboursWithCost.put(r.getKey(), r.getValue().distance);
            }
            LSADatabasewriteLock.lock();
            this.LSA.neighbors = neighboursWithCost;
            LSADatabasewriteLock.unlock();
        }
        return adjacentChanged;
    }

    private void startLSAFloodfill() {
        BitSet prev = new BitSet(Router.getEndOfIPPool());
        prev.set(this.IPAddress);
        for (Router r : this.adjacentLinks.keySet()) {
            r.LSAUpdateFloodfill(prev);
        }
        prev.clear();
        prev.set(this.IPAddress);
        this.flagForRoutingUpdate();
        for (Router r : this.adjacentLinks.keySet()) {
            r.adjacentUpdateFloodfill(prev);
        }
    }

    public void LSAUpdateFloodfill(BitSet prev) {
        if (prev.get(this.IPAddress)) {
            return;
        }
        prev.set(this.IPAddress);
        this.updateLSAIfNeeded();
        for (Router r : this.adjacentLinks.keySet()) {
            if (!r.isLoaded()) continue;
            r.LSAUpdateFloodfill(prev);
        }
    }

    public void adjacentUpdateFloodfill(BitSet prev) {
        if (prev.get(this.IPAddress)) {
            return;
        }
        prev.set(this.IPAddress);
        this.flagForRoutingUpdate();
        for (Router r : this.adjacentLinks.keySet()) {
            if (!r.isLoaded()) continue;
            r.adjacentUpdateFloodfill(prev);
        }
    }

    public void flagForRoutingUpdate() {
        ++this.linkStateID;
    }

    public void decommission() {
        LSADatabasewriteLock.lock();
        if (this.IPAddress < LSADatabase.length) {
            Router.LSADatabase[this.IPAddress] = null;
        }
        LSADatabasewriteLock.unlock();
        RouterServices.instance.removeRouter(this.IPAddress);
        this.decommissioned = true;
        this.startLSAFloodfill();
        Router.releaseIPAddress(this.IPAddress);
    }

    public int getLinkStateID() {
        return this.linkStateID;
    }

    public int getIPAddress() {
        return this.IPAddress;
    }

    public UUID getID() {
        return this.ID;
    }

    public List<ForgeDirection> getRouteTable() {
        this.refreshRouteTableIfNeeded(true);
        return this.routeTable;
    }

    public List<StartEndPath> getRoutesByCost() {
        this.refreshRouteTableIfNeeded(true);
        LinkedList<StartEndPath> valid = new LinkedList<StartEndPath>(this.routersByCost);
        Iterator it = valid.iterator();
        while (it.hasNext()) {
            if (((StartEndPath)it.next()).end.isLoaded()) continue;
            it.remove();
        }
        return valid;
    }

    public ForgeDirection getExitDirection(int destination) {
        if (destination < 0) {
            return ForgeDirection.UNKNOWN;
        }
        if (!RouterServices.instance.routerExists(destination)) {
            return ForgeDirection.UNKNOWN;
        }
        List<ForgeDirection> routeTable = this.getRouteTable();
        if (destination >= routeTable.size()) {
            return ForgeDirection.UNKNOWN;
        }
        ForgeDirection dir = routeTable.get(destination);
        if (dir == null) {
            return ForgeDirection.UNKNOWN;
        }
        return dir;
    }

    public boolean canRouteTo(int destination) {
        if (destination < 0) {
            return false;
        }
        if (!RouterServices.instance.routerExists(destination)) {
            return false;
        }
        List<ForgeDirection> routeTable = this.getRouteTable();
        if (destination >= routeTable.size()) {
            return false;
        }
        return routeTable.get(destination) != null;
    }

    private void refreshRouteTableIfNeeded(boolean force) {
        if (this.linkStateID > LegacyLinkStateID[this.IPAddress]) {
            if (Configurator.routerUpdateThreadCount > 0 && !force) {
                TableUpdateThread.add(this);
            } else {
                this.refreshRoutingTable(this.linkStateID);
            }
        }
    }

    public void refreshRoutingTable(int newVersion) {
        if (LegacyLinkStateID[this.IPAddress] >= newVersion) {
            return;
        }
        int sizeEstimate = Router.getEndOfIPPool();
        if (sizeEstimate == 0) {
            sizeEstimate = LSADatabase.length;
        }
        HashMap<Router, StartEndPath> tree2 = new HashMap<Router, StartEndPath>(sizeEstimate);
        ArrayList<StartEndPath> routersByCost2 = new ArrayList<StartEndPath>(sizeEstimate);
        PriorityQueue<StartEndPath> candidates2 = new PriorityQueue<StartEndPath>((int)Math.sqrt(sizeEstimate));
        tree2.put(this, new StartEndPath(this, this, -1, 0));
        for (Router r : this.adjacentLinks.keySet()) {
            StartEndPath l = this.adjacentLinks.get(r);
            candidates2.add(new StartEndPath(l.end, l.end, l.dirToFirstHop, l.distance));
        }
        routersByCost2.add(new StartEndPath(this, this, -1, 0));
        LSADatabasereadLock.lock();
        StartEndPath nextLowest = null;
        while ((nextLowest = (StartEndPath)candidates2.poll()) != null) {
            while (nextLowest != null && tree2.containsKey(nextLowest.end)) {
                nextLowest = (StartEndPath)candidates2.poll();
            }
            if (nextLowest == null) break;
            StartEndPath lowestPath = (StartEndPath)tree2.get(nextLowest.start);
            if (lowestPath == null) {
                lowestPath = nextLowest;
            }
            LSA lsa = null;
            if (nextLowest.end.getIPAddress() < LSADatabase.length) {
                lsa = LSADatabase[nextLowest.end.getIPAddress()];
            }
            if (lsa != null) {
                for (Router r : ((Map)lsa.neighbors.clone()).keySet()) {
                    if (tree2.containsKey(r)) continue;
                    int newCost = nextLowest.distance + lsa.neighbors.get(r);
                    candidates2.add(new StartEndPath(lowestPath.end, r, lowestPath.dirToFirstHop, newCost));
                }
            }
            nextLowest.start = lowestPath.start;
            tree2.put(nextLowest.end, nextLowest);
            routersByCost2.add(nextLowest);
        }
        LSADatabasereadLock.unlock();
        ArrayList<ForgeDirection> routeTable2 = new ArrayList<ForgeDirection>(Router.getEndOfIPPool() + 1);
        while (this.getIPAddress() >= routeTable2.size()) {
            routeTable2.add(null);
        }
        routeTable2.set(this.getIPAddress(), ForgeDirection.UNKNOWN);
        for (StartEndPath l : tree2.values()) {
            Router firstHop = l.start;
            if (firstHop == null) {
                while (l.end.getIPAddress() >= routeTable2.size()) {
                    routeTable2.add(null);
                }
                routeTable2.set(l.end.getIPAddress(), ForgeDirection.UNKNOWN);
                continue;
            }
            StartEndPath localOutPath = this.adjacentLinks.get(firstHop);
            if (localOutPath == null) continue;
            while (l.end.getIPAddress() >= routeTable2.size()) {
                routeTable2.add(null);
            }
            routeTable2.set(l.end.getIPAddress(), ForgeDirection.getOrientation((int)localOutPath.dirToFirstHop));
        }
        this.routingTableWriteLock.lock();
        if (newVersion == this.linkStateID) {
            LSADatabasereadLock.lock();
            if (LegacyLinkStateID[this.IPAddress] < newVersion) {
                Router.LegacyLinkStateID[this.IPAddress] = newVersion;
                this.routeTable = Collections.unmodifiableList(routeTable2);
                this.routersByCost = Collections.unmodifiableList(routersByCost2);
            }
            LSADatabasereadLock.unlock();
        }
        this.routingTableWriteLock.unlock();
    }

    public IWorldRouter getParent() {
        return this.parent;
    }

    public boolean isLoaded() {
        if (this.decommissioned) {
            return false;
        }
        IWorldRouter parent = this.getParent();
        if (this.getParent() == null) {
            return false;
        }
        if (this.getParent().needsWork()) {
            return false;
        }
        return parent.getContainer().tile() != null && !parent.getContainer().tile().r();
    }

    private static int claimIPAddress() {
        int ip = usedIPs.nextClearBit(nextIP);
        nextIP = ip + 1;
        usedIPs.set(ip);
        return ip;
    }

    private static void releaseIPAddress(int ip) {
        usedIPs.clear(ip);
        if (ip < nextIP) {
            nextIP = ip;
        }
    }

    public static int getEndOfIPPool() {
        return usedIPs.size();
    }

    public int hashCode() {
        return this.IPAddress;
    }

    public boolean LSAConnectionExists(ForgeDirection dir) {
        return this.routedExits.contains(dir);
    }

    @Override
    public int compareTo(Router o) {
        return this.IPAddress - o.getIPAddress();
    }

    public static void reboot() {
        LSADatabasewriteLock.lock();
        LSADatabase = new LSA[0];
        LegacyLinkStateID = new int[0];
        LSADatabasewriteLock.unlock();
        usedIPs.clear();
        nextIP = 1;
    }

    public static class StartEndPath
    implements Comparable<StartEndPath> {
        public int dirToFirstHop;
        public int distance;
        public Router start;
        public final Router end;

        public StartEndPath(Router start, Router end, int dir, int length) {
            this.start = start;
            this.end = end;
            this.dirToFirstHop = dir;
            this.distance = length;
        }

        public boolean equals(Object o) {
            if (o instanceof StartEndPath) {
                StartEndPath p = (StartEndPath)o;
                return this.dirToFirstHop == p.dirToFirstHop && this.distance == p.distance;
            }
            return false;
        }

        @Override
        public int compareTo(StartEndPath o) {
            int c = this.distance - o.distance;
            if (c == 0) {
                c = this.end.getIPAddress() - o.end.getIPAddress();
            }
            return c;
        }
    }

    private static class LSA {
        public HashMap<Router, Integer> neighbors = new HashMap();

        private LSA() {
        }
    }
}

