/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.INeighborTileChange;
import codechicken.multipart.TMultiPart;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.inventory.InventoryWrapper;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.transportation.EnumPipe;
import mrtjp.projectred.transportation.IInventoryProvider;
import mrtjp.projectred.transportation.RoutedJunctionPipePart;
import mrtjp.projectred.transportation.RoutedPayload;
import net.minecraftforge.common.ForgeDirection;

public abstract class RoutedPipePart_Inv
extends RoutedJunctionPipePart
implements IInventoryProvider,
INeighborTileChange {
    public int inOutSide = 0;

    @Override
    public void save(by tag) {
        super.save(tag);
        tag.a("io", (byte)this.inOutSide);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.inOutSide = tag.c("io");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte(this.inOutSide);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.inOutSide = packet.readByte();
    }

    @Override
    public void read(MCDataInput packet, int switch_key) {
        if (switch_key == 15) {
            this.inOutSide = packet.readUByte();
            this.tile().markRender();
        }
        super.read(packet, switch_key);
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.shiftOrientation(false);
    }

    @Override
    public void onPartChanged(TMultiPart p) {
        super.onPartChanged(p);
        this.shiftOrientation(false);
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.shiftOrientation(false);
    }

    public void sendOrientUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(15).writeByte(this.inOutSide);
    }

    @Override
    public boolean connect(int absDir) {
        if (super.connect(absDir)) {
            return true;
        }
        BlockCoord bc = new BlockCoord((asp)this.tile()).offset(absDir);
        asp t = (asp)BasicUtils.getTileEntity((acf)this.world(), (BlockCoord)bc, asp.class);
        return t instanceof mo;
    }

    @Override
    public boolean activate(uf player, ata hit, ye item) {
        if (super.activate(player, hit, item)) {
            return true;
        }
        if (player.ah()) {
            this.shiftOrientation(true);
            return true;
        }
        return false;
    }

    @Override
    public ForgeDirection getDirForIncomingItem(RoutedPayload r) {
        return ForgeDirection.getOrientation((int)this.inOutSide);
    }

    public void shiftOrientation(boolean force) {
        boolean invalid;
        if (this.world().I) {
            return;
        }
        boolean bl = invalid = force || !this.maskConnects(this.inOutSide) || !(BasicUtils.getTileEntity((acf)this.world(), (BlockCoord)new BlockCoord((asp)this.tile()).offset(this.inOutSide), asp.class) instanceof mo);
        if (!invalid) {
            return;
        }
        boolean found = false;
        int oldSide = this.inOutSide;
        for (int i = 0; i < 6; ++i) {
            this.inOutSide = (this.inOutSide + 1) % 6;
            if (!this.maskConnects(this.inOutSide)) continue;
            BlockCoord bc = new BlockCoord((asp)this.tile()).offset(this.inOutSide);
            asp t = (asp)BasicUtils.getTileEntity((acf)this.world(), (BlockCoord)bc, asp.class);
            if (!(t instanceof mo)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.inOutSide = -1;
        }
        if (oldSide != this.inOutSide) {
            this.sendOrientUpdate();
        }
    }

    @Override
    public mo getInventory() {
        if (this.inOutSide < 0 || this.inOutSide > 5) {
            return null;
        }
        return InventoryWrapper.getInventory((abw)this.world(), (BlockCoord)new BlockCoord((asp)this.tile()).offset(this.inOutSide));
    }

    @Override
    public int getInterfacedSide() {
        return this.inOutSide < 0 || this.inOutSide > 5 ? -1 : this.inOutSide ^ 1;
    }

    @Override
    public ms getIcon(int side) {
        ms[] array;
        ms[] msArray = array = side == this.inOutSide ? EnumPipe.ROUTEDINTERFACE.sprites : EnumPipe.ROUTEDJUNCTION.sprites;
        if ((this.linkMap & 1 << side) != 0) {
            return array[0];
        }
        return array[1];
    }

    @Override
    public int getActiveFreeSpace(ItemKey item) {
        mo real = this.getInventory();
        if (real == null) {
            return 0;
        }
        int side = this.getInterfacedSide();
        InventoryWrapper inv = InventoryWrapper.wrapInventory((mo)real).setSlotsFromSide(side);
        int free = inv.getRoomAvailableForItem(item);
        return free;
    }

    public void onNeighborTileChanged(int side, boolean weak) {
    }

    public boolean weakTileChanges() {
        return false;
    }

    @Override
    public abstract String getType();
}

