/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.core.IGuiPacketSender;
import codechicken.core.ServerUtils;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.DelayQueue;
import mrtjp.projectred.core.BasicGuiUtils;
import mrtjp.projectred.core.ItemDataCard;
import mrtjp.projectred.core.inventory.GhostContainer2;
import mrtjp.projectred.core.inventory.InventoryWrapper;
import mrtjp.projectred.core.inventory.SimpleInventory;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.core.utils.Pair2;
import mrtjp.projectred.core.utils.PostponedWorkItem;
import mrtjp.projectred.transportation.DeliveryManager;
import mrtjp.projectred.transportation.IWorldCrafter;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.RequestBranchNode;
import mrtjp.projectred.transportation.RequestConsole;
import mrtjp.projectred.transportation.RouteFX;
import mrtjp.projectred.transportation.RoutedPayload;
import mrtjp.projectred.transportation.RoutedPipePart_Inv;
import mrtjp.projectred.transportation.Router;
import mrtjp.projectred.transportation.RouterServices;
import mrtjp.projectred.transportation.TransportationSPH;

public class RoutedCraftingPipePart
extends RoutedPipePart_Inv
implements IWorldCrafter {
    private SimpleInventory matrix = new SimpleInventory(10, "matrix", 127);
    private SimpleInventory cardSlots = new SimpleInventory(9, "links", 1){

        public boolean b(int i, ye stack) {
            by tag;
            return ItemDataCard.hasCardData((ye)stack) && (tag = ItemDataCard.loadData((ye)stack, (String)"ext_pipe")).b("id");
        }

        public void e() {
            RoutedCraftingPipePart.this.refreshExtensions();
        }
    };
    private DeliveryManager manager = new DeliveryManager();
    private final LinkedList<Pair2<ItemKeyStack, IWorldRequester>> excess = new LinkedList();
    private final DelayQueue<PostponedWorkItem<ItemKeyStack>> lost = new DelayQueue();
    private final int[] extensionIPs = new int[9];
    public int priority = 0;
    private int remainingDelay = this.operationDelay();
    private int remainingDelay2 = this.operationDelay2();

    private int operationDelay() {
        return 10;
    }

    private int operationDelay2() {
        return 40;
    }

    protected int itemsToExtract() {
        return 1;
    }

    protected int stacksToExtract() {
        return 1;
    }

    @Override
    public void read(MCDataInput packet, int switch_key) {
        if (switch_key == 45) {
            this.priority = packet.readInt();
        } else {
            super.read(packet, switch_key);
        }
    }

    public void priorityUp() {
        int old = this.priority;
        this.priority = Math.min(100, this.priority + 1);
        if (old != this.priority) {
            this.sendPriorityUpdate();
        }
    }

    public void priorityDown() {
        int old = this.priority;
        this.priority = Math.max(-100, this.priority - 1);
        if (old != this.priority) {
            this.sendPriorityUpdate();
        }
    }

    private void sendPriorityUpdate() {
        if (!this.world().I) {
            this.tile().getWriteStream((TMultiPart)this).writeByte(45).writeInt(this.priority);
        }
    }

    @Override
    public void updateServer() {
        if (--this.remainingDelay <= 0) {
            this.remainingDelay = this.operationDelay();
            this.operationTick();
        }
        if (--this.remainingDelay2 <= 0) {
            this.remainingDelay2 = this.operationDelay2();
            this.lostHandleTick();
        }
    }

    private void operationTick() {
        if (!this.manager.hasOrders() && this.excess.isEmpty()) {
            return;
        }
        mo real = this.getInventory();
        if (real == null) {
            if (this.manager.hasOrders()) {
                this.manager.dispatchFailed();
            } else {
                this.excess.clear();
            }
            return;
        }
        int side = this.getInterfacedSide();
        InventoryWrapper inv = InventoryWrapper.wrapInventory((mo)real).setSlotsFromSide(side);
        List<ItemKeyStack> wanted = this.getCraftedItems();
        if (wanted == null || wanted.isEmpty()) {
            return;
        }
        RouteFX.spawnType1(RouteFX.color_checkInv, 8, new BlockCoord((asp)this.tile()), this.world());
        int itemsleft = this.itemsToExtract();
        int stacksleft = this.stacksToExtract();
        block0: while (itemsleft > 0 && stacksleft > 0 && (this.manager.hasOrders() || !this.excess.isEmpty())) {
            int numToSend;
            int available;
            Pair2<ItemKeyStack, IWorldRequester> nextOrder;
            boolean processingOrder = false;
            if (this.manager.hasOrders()) {
                nextOrder = this.manager.peek();
                processingOrder = true;
            } else {
                nextOrder = this.excess.getFirst();
            }
            ItemKeyStack keyStack = (ItemKeyStack)nextOrder.getValue1();
            int maxToSend = Math.min(itemsleft, keyStack.stackSize);
            maxToSend = Math.min(keyStack.key().getStackLimit(), maxToSend);
            if (available <= 0) break;
            ItemKey key = keyStack.key();
            for (available = inv.extractItem(keyStack.key(), maxToSend); available > 0; available -= numToSend) {
                numToSend = Math.min(available, key.getStackLimit());
                if ((numToSend = Math.min(numToSend, keyStack.stackSize)) == 0) continue block0;
                --stacksleft;
                itemsleft -= numToSend;
                ye toSend = key.makeStack(numToSend);
                if (processingOrder) {
                    this.queueStackToSend(toSend, side, RoutedPayload.SendPriority.ACTIVE, ((IWorldRequester)nextOrder.getValue2()).getRouter().getIPAddress());
                    this.manager.dispatchSuccessful(numToSend, false);
                    if (this.manager.hasOrders()) {
                        nextOrder = this.manager.peek();
                        continue;
                    }
                    processingOrder = false;
                    if (this.excess.isEmpty()) continue;
                    nextOrder = this.excess.getFirst();
                    continue;
                }
                this.removeExcess(key, numToSend);
                this.queueStackToSend(toSend, side, RoutedPayload.SendPriority.WANDERING, -1);
            }
        }
    }

    private void lostHandleTick() {
        if (this.lost.isEmpty()) {
            return;
        }
        PostponedWorkItem post = null;
        while ((post = (PostponedWorkItem)this.lost.poll()) != null) {
            ItemKeyStack stack = (ItemKeyStack)post.getItem();
            int toRequest = stack.stackSize;
            if ((toRequest = Math.min(toRequest, this.getActiveFreeSpace(stack.key()))) <= 0) {
                this.lost.add((PostponedWorkItem<ItemKeyStack>)new PostponedWorkItem((Object)stack, 5000L));
                continue;
            }
            RequestConsole req = new RequestConsole().setDestination(this);
            req.setPulling(true).setCrafting(true).setPartials(true);
            int requested = req.makeRequest(ItemKeyStack.get((ItemKey)stack.key(), (int)toRequest)).requested();
            if (requested >= stack.stackSize) continue;
            stack.stackSize -= requested;
            this.lost.add((PostponedWorkItem<ItemKeyStack>)new PostponedWorkItem((Object)stack, 5000L));
        }
    }

    @Override
    public void trackedItemLost(ItemKeyStack s) {
        this.lost.add((PostponedWorkItem<ItemKeyStack>)new PostponedWorkItem((Object)s, 5000L));
    }

    private void removeExcess(ItemKey item, int amount) {
        Iterator iter = this.excess.iterator();
        while (iter.hasNext()) {
            ItemKeyStack stack = (ItemKeyStack)((Pair2)iter.next()).getValue1();
            if (!stack.key().equals((Object)item)) continue;
            if (amount >= stack.stackSize) {
                iter.remove();
                if ((amount -= stack.stackSize) > 0) continue;
                return;
            }
            stack.stackSize -= amount;
            break;
        }
    }

    private void refreshExtensions() {
        for (int i = 0; i < 9; ++i) {
            ye inslot = this.cardSlots.a(i);
            if (inslot != null && ItemDataCard.hasCardData((ye)inslot)) {
                by data = ItemDataCard.loadData((ye)inslot, (String)"ext_pipe");
                if (!data.b("id")) continue;
                UUID id = null;
                try {
                    id = UUID.fromString(data.i("id"));
                }
                catch (Throwable t) {
                    continue;
                }
                this.extensionIPs[i] = RouterServices.instance.getIPforUUID(id);
                continue;
            }
            this.extensionIPs[i] = -1;
        }
    }

    private IWorldRequester getExtensionFor(int slot) {
        Router r;
        if (this.extensionIPs[slot] >= 0 && this.getRouter().canRouteTo(this.extensionIPs[slot]) && (r = RouterServices.instance.getRouter(this.extensionIPs[slot])) != null && r.isLoaded() && r.getParent() instanceof IWorldRequester) {
            return (IWorldRequester)r.getParent();
        }
        return this;
    }

    @Override
    public boolean activate(uf player, ata hit, ye item) {
        if (super.activate(player, hit, item)) {
            return true;
        }
        this.openGui(player);
        return true;
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (!this.world().I) {
            this.cardSlots.dropContents(this.world(), this.x(), this.y(), this.z());
        }
    }

    public void openGui(uf player) {
        if (this.world().I) {
            return;
        }
        ServerUtils.openSMPContainer((jv)((jv)player), (uy)this.createContainer(player), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(jv player, int windowId) {
                PacketCustom p = new PacketCustom(TransportationSPH.channel, 2);
                p.writeCoord(RoutedCraftingPipePart.this.x(), RoutedCraftingPipePart.this.y(), RoutedCraftingPipePart.this.z());
                p.writeByte(windowId);
                p.writeInt(RoutedCraftingPipePart.this.priority);
                p.sendToPlayer((uf)player);
            }
        });
    }

    public uy createContainer(uf player) {
        GhostContainer2 ghost = new GhostContainer2((mo)player.bn);
        int s = 0;
        for (Pair2 p : BasicGuiUtils.createSlotArray((int)8, (int)12, (int)9, (int)1, (int)0, (int)0)) {
            ghost.addCustomSlot(new GhostContainer2.SlotExtended((mo)this.matrix, s++, ((Integer)p.getValue1()).intValue(), ((Integer)p.getValue2()).intValue()).setGhosting(true));
        }
        ghost.addCustomSlot(new GhostContainer2.SlotExtended((mo)this.matrix, s++, 44, 74).setGhosting(true));
        int s2 = 0;
        for (Pair2 p : BasicGuiUtils.createSlotArray((int)8, (int)46, (int)9, (int)1, (int)0, (int)0)) {
            ghost.addCustomSlot(new GhostContainer2.SlotExtended((mo)this.cardSlots, s2++, ((Integer)p.getValue1()).intValue(), ((Integer)p.getValue2()).intValue()).setCheck((GhostContainer2.ISlotController)GhostContainer2.ISlotController.InventoryRulesController.instance));
        }
        ghost.addPlayerInventory(8, 138);
        return ghost;
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        this.matrix.save(tag, "m");
        this.cardSlots.save(tag, "l");
        tag.a("pri", this.priority);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.matrix.load(tag, "m");
        this.cardSlots.load(tag, "l");
        this.priority = tag.e("pri");
    }

    @Override
    public void requestPromises(RequestBranchNode request, int existingPromises) {
        if (this.excess.isEmpty()) {
            return;
        }
        ItemKey requestedItem = request.getRequestedPackage();
        List<ItemKeyStack> providedItem = this.getCraftedItems();
        for (ItemKeyStack item : providedItem) {
            if (item.key() != requestedItem) continue;
            return;
        }
        if (!providedItem.contains(requestedItem)) {
            return;
        }
        int remaining = 0;
        for (Pair2 pair2 : this.excess) {
            if (((ItemKeyStack)pair2.getValue1()).key() != requestedItem) continue;
            remaining += ((ItemKeyStack)pair2.getValue1()).stackSize;
        }
        if ((remaining -= existingPromises) <= 0) {
            return;
        }
        RequestBranchNode.ExcessPromise promise = new RequestBranchNode.ExcessPromise();
        promise.setUsed(true).setPackage(requestedItem).setSize(Math.min(remaining, request.getMissingCount())).setSender(this);
        request.addPromise(promise);
    }

    @Override
    public void deliverPromises(RequestBranchNode.DeliveryPromise promise, IWorldRequester requester) {
        if (promise instanceof RequestBranchNode.ExcessPromise) {
            this.removeExcess(promise.thePackage, promise.size);
        }
        this.manager.addOrder(ItemKeyStack.get((ItemKey)promise.thePackage, (int)promise.size), requester);
    }

    @Override
    public void getBroadcastedItems(Map<ItemKey, Integer> map) {
    }

    @Override
    public RequestBranchNode.CraftingPromise requestCraftPromise(ItemKey item) {
        List<ItemKeyStack> items = this.getCraftedItems();
        if (items == null) {
            return null;
        }
        ItemKeyStack craftingStack = null;
        for (ItemKeyStack craftable : items) {
            if (!craftable.key().equals((Object)item)) continue;
            craftingStack = craftable;
            break;
        }
        if (craftingStack == null) {
            return null;
        }
        IWorldRequester[] requesters = new IWorldRequester[9];
        for (int i = 0; i < 9; ++i) {
            requesters[i] = this.getExtensionFor(i);
        }
        RequestBranchNode.CraftingPromise promise = new RequestBranchNode.CraftingPromise(craftingStack, this, this.priority);
        for (int i = 0; i < 9; ++i) {
            ItemKeyStack keystack = ItemKeyStack.get((ye)this.matrix.a(i));
            if (keystack == null || keystack.stackSize <= 0) continue;
            promise.addIngredient(keystack, requesters[i]);
        }
        return promise;
    }

    @Override
    public void registerExcess(RequestBranchNode.DeliveryPromise promise) {
        ItemKeyStack keystack = ItemKeyStack.get((ItemKey)promise.thePackage, (int)promise.size);
        this.excess.add((Pair2<ItemKeyStack, IWorldRequester>)new Pair2((Object)keystack, null));
    }

    @Override
    public List<ItemKeyStack> getCraftedItems() {
        ArrayList<ItemKeyStack> list = new ArrayList<ItemKeyStack>(1);
        ye stack = this.matrix.a(9);
        if (stack != null) {
            list.add(ItemKeyStack.get((ye)stack));
        }
        return list;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public double getWorkLoad() {
        return ((double)this.manager.getTotalDeliveryCount() + 63.0) / 64.0;
    }

    @Override
    public int itemsToProcess() {
        return this.manager.getTotalDeliveryCount();
    }

    @Override
    public String getType() {
        return "pr_rcrafting";
    }
}

