/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.TreeSet;
import mrtjp.projectred.core.utils.HashPair2;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.core.utils.Pair2;
import mrtjp.projectred.transportation.IWorldBroadcaster;
import mrtjp.projectred.transportation.IWorldCrafter;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.IWorldRouter;
import mrtjp.projectred.transportation.LogisticPathFinder;
import mrtjp.projectred.transportation.RequestBranch;
import mrtjp.projectred.transportation.Router;

public class RequestBranchNode {
    private final ItemKeyStack requestedPackage;
    private final IWorldRequester requester;
    private final RequestBranchNode parent;
    protected final RequestBranch root;
    private List<RequestBranchNode> subRequests = new ArrayList<RequestBranchNode>();
    private List<DeliveryPromise> promises = new ArrayList<DeliveryPromise>();
    private List<ExcessPromise> excessPromises = new ArrayList<ExcessPromise>();
    private SortedSet<CraftingPromise> usedCrafters = new TreeSet<CraftingPromise>();
    private CraftingPromise parityBranch = null;
    private int promisedCount = 0;

    public RequestBranchNode(CraftingPromise parentCrafter, ItemKeyStack requestedPackage, IWorldRequester requester, RequestBranchNode parent, EnumSet<RequestBranch.RequestFlags> type) {
        this.requestedPackage = requestedPackage;
        this.requester = requester;
        this.parent = parent;
        if (parent != null) {
            parent.subRequests.add(this);
            this.root = parent.root;
        } else {
            this.root = (RequestBranch)this;
        }
        if (parentCrafter != null && !this.recurse_IsCrafterUsed(parentCrafter)) {
            this.usedCrafters.add(parentCrafter);
        }
        if (type.contains((Object)RequestBranch.RequestFlags.PULL) && this.getPromisesFromBroadcasters()) {
            return;
        }
        if (type.contains((Object)RequestBranch.RequestFlags.CRAFT) && this.getPromisesFromExcess()) {
            return;
        }
        if (type.contains((Object)RequestBranch.RequestFlags.CRAFT) && this.getPromisesFromCrafters()) {
            return;
        }
    }

    public int getPromisedCount() {
        return this.promisedCount;
    }

    public int getMissingCount() {
        return this.requestedPackage.stackSize - this.promisedCount;
    }

    public ItemKey getRequestedPackage() {
        return this.requestedPackage.key();
    }

    public boolean isDone() {
        return this.getMissingCount() <= 0;
    }

    public void addPromise(DeliveryPromise promise) {
        if (!promise.thePackage.equals((Object)this.getRequestedPackage())) {
            return;
        }
        if (promise.size > this.getMissingCount()) {
            int more = promise.size - this.getMissingCount();
            promise.size = this.getMissingCount();
            ExcessPromise excess = new ExcessPromise();
            excess.setPackage(promise.thePackage).setSize(more).setSender(promise.sender);
            this.excessPromises.add(excess);
        }
        if (promise.size <= 0) {
            return;
        }
        this.promises.add(promise);
        this.promisedCount += promise.size;
        this.root.promiseAdded(promise);
    }

    private boolean getPromisesFromCrafters() {
        List<Router.StartEndPath> allRouters = this.requester.getRouter().getRoutesByCost();
        Collections.sort(allRouters, new PathSorter(0.0));
        ArrayList<CraftingPromise> allCrafters = new ArrayList<CraftingPromise>(allRouters.size());
        for (Router.StartEndPath l : allRouters) {
            IWorldCrafter cr;
            CraftingPromise cp;
            Router r = l.end;
            if (!(r.getParent() instanceof IWorldCrafter) || (cp = (cr = (IWorldCrafter)r.getParent()).requestCraftPromise(this.getRequestedPackage())) == null) continue;
            allCrafters.add(cp);
        }
        Iterator allCraftersIt = allCrafters.iterator();
        PriorityQueue<CraftingTreeInteraction> balanced = new PriorityQueue<CraftingTreeInteraction>(5);
        ArrayList unbalanced = new ArrayList();
        boolean recursionFinished = false;
        CraftingPromise lastCrafter = null;
        int currentPriority = 0;
        while (!recursionFinished) {
            if (allCraftersIt.hasNext()) {
                if (lastCrafter == null) {
                    lastCrafter = (CraftingPromise)allCraftersIt.next();
                }
            } else if (lastCrafter == null) {
                recursionFinished = true;
            }
            int itemsNeeded = this.getMissingCount();
            if (lastCrafter != null && (balanced.isEmpty() || currentPriority == lastCrafter.getPriority())) {
                currentPriority = lastCrafter.getPriority();
                CraftingPromise crafter = lastCrafter;
                lastCrafter = null;
                if (this.recurse_IsCrafterUsed(crafter)) continue;
                CraftingTreeInteraction cti = new CraftingTreeInteraction(crafter, itemsNeeded, this);
                balanced.add(cti);
                continue;
            }
            if (unbalanced.isEmpty() && balanced.isEmpty()) continue;
            if (balanced.size() == 1) {
                unbalanced.add(balanced.poll());
                ((CraftingTreeInteraction)unbalanced.get(0)).addAdditionalItems(itemsNeeded);
            } else {
                if (!balanced.isEmpty()) {
                    unbalanced.add(balanced.poll());
                }
                while (!unbalanced.isEmpty() && itemsNeeded > 0) {
                    while (!balanced.isEmpty() && ((CraftingTreeInteraction)balanced.peek()).toDo() <= ((CraftingTreeInteraction)unbalanced.get(0)).toDo()) {
                        unbalanced.add(balanced.poll());
                    }
                    int cap = !balanced.isEmpty() ? ((CraftingTreeInteraction)balanced.peek()).toDo() : Integer.MAX_VALUE;
                    int floor = ((CraftingTreeInteraction)unbalanced.get(0)).toDo();
                    cap = Math.min(cap, floor + (itemsNeeded + unbalanced.size() - 1) / unbalanced.size());
                    for (CraftingTreeInteraction crafter : unbalanced) {
                        int request = Math.min(itemsNeeded, cap - floor);
                        if (request <= 0) continue;
                        int craftingDone = crafter.addAdditionalItems(request);
                        itemsNeeded -= craftingDone;
                    }
                }
            }
            Iterator iter = unbalanced.iterator();
            while (iter.hasNext()) {
                CraftingTreeInteraction c = (CraftingTreeInteraction)iter.next();
                if (c.setsRequested <= 0 || c.finalizeInteraction()) continue;
                iter.remove();
            }
            itemsNeeded = this.getMissingCount();
            if (itemsNeeded <= 0) break;
            if (unbalanced.isEmpty()) continue;
            recursionFinished = false;
        }
        return this.isDone();
    }

    private boolean getPromisesFromExcess() {
        LinkedList<ExcessPromise> availableExcess = this.root.getAllExcessFor(this.getRequestedPackage());
        for (ExcessPromise excess : availableExcess) {
            if (this.isDone()) break;
            if (excess.size <= 0) continue;
            excess.size = Math.min(excess.size, this.getMissingCount());
            this.addPromise(excess);
        }
        return this.isDone();
    }

    private boolean getPromisesFromBroadcasters() {
        List<Router.StartEndPath> allRouters = this.requester.getRouter().getRoutesByCost();
        Collections.sort(allRouters, new PathSorter(1.0));
        for (Router.StartEndPath l : allRouters) {
            IWorldRouter member;
            if (this.isDone()) break;
            Router r = l.end;
            if (!r.isLoaded() || !((member = r.getParent()) instanceof IWorldBroadcaster) || LogisticPathFinder.sharesInventory(this.requester.getContainer(), member.getContainer())) continue;
            IWorldBroadcaster member2 = (IWorldBroadcaster)member;
            member2.requestPromises(this, this.root.getExistingPromisesFor((HashPair2<IWorldBroadcaster, ItemKey>)new HashPair2((Object)member2, (Object)this.getRequestedPackage())));
        }
        return this.isDone();
    }

    private int getPotentialSubPromises(int numberOfSets, CraftingPromise crafter) {
        boolean failed = false;
        int potentialSets = numberOfSets;
        List<Pair2<ItemKeyStack, IWorldRequester>> ingredients = crafter.getScaledIngredients(numberOfSets);
        ArrayList<RequestBranchNode> children = new ArrayList<RequestBranchNode>(ingredients.size());
        for (Pair2<ItemKeyStack, IWorldRequester> item : ingredients) {
            RequestBranchNode req = new RequestBranchNode(crafter, (ItemKeyStack)item.getValue1(), (IWorldRequester)item.getValue2(), this, RequestBranch.RequestFlags.def);
            children.add(req);
            if (req.isDone()) continue;
            failed = true;
        }
        if (failed) {
            for (RequestBranchNode sub : children) {
                sub.destroy();
            }
            this.parityBranch = crafter;
            for (int i = 0; i < ingredients.size(); ++i) {
                potentialSets = Math.min(potentialSets, ((RequestBranchNode)children.get(i)).getPromisedCount() / (((ItemKeyStack)ingredients.get((int)i).getValue1()).stackSize / numberOfSets));
            }
            return this.getAbsoluteSubPromises(potentialSets, crafter);
        }
        return potentialSets;
    }

    private int getAbsoluteSubPromises(int numberOfSets, CraftingPromise crafter) {
        ArrayList<RequestBranchNode> children = new ArrayList<RequestBranchNode>();
        if (numberOfSets > 0) {
            List<Pair2<ItemKeyStack, IWorldRequester>> ingredients = crafter.getScaledIngredients(numberOfSets);
            boolean failed = false;
            for (Pair2<ItemKeyStack, IWorldRequester> item : ingredients) {
                RequestBranchNode req = new RequestBranchNode(crafter, (ItemKeyStack)item.getValue1(), (IWorldRequester)item.getValue2(), this, RequestBranch.RequestFlags.def);
                children.add(req);
                if (req.isDone()) continue;
                failed = true;
            }
            if (failed) {
                for (RequestBranchNode sub : children) {
                    sub.destroy();
                }
                return 0;
            }
        }
        return numberOfSets;
    }

    private void destroy() {
        this.parent.remove(this);
    }

    protected void remove(RequestBranchNode subNode) {
        this.subRequests.remove(subNode);
        subNode.recurse_RemoveSubPromisses();
    }

    protected void recurse_RemoveSubPromisses() {
        for (DeliveryPromise promise : this.promises) {
            this.root.promiseRemoved(promise);
        }
        for (RequestBranchNode subNode : this.subRequests) {
            subNode.recurse_RemoveSubPromisses();
        }
    }

    protected boolean recurse_IsCrafterUsed(CraftingPromise parentCrafter) {
        if (!this.usedCrafters.isEmpty() && this.usedCrafters.contains(parentCrafter)) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.recurse_IsCrafterUsed(parentCrafter);
    }

    protected void recurse_RequestDelivery() {
        for (RequestBranchNode requestBranchNode : this.subRequests) {
            requestBranchNode.recurse_RequestDelivery();
        }
        for (DeliveryPromise deliveryPromise : this.promises) {
            deliveryPromise.sender.deliverPromises(deliveryPromise, this.requester);
        }
        for (ExcessPromise excessPromise : this.excessPromises) {
            if (!(excessPromise.sender instanceof IWorldCrafter)) continue;
            ((IWorldCrafter)excessPromise.sender).registerExcess(excessPromise);
        }
    }

    protected void recurse_GatherExcess(ItemKey item, HashMap<IWorldBroadcaster, List<ExcessPromise>> excessMap) {
        for (ExcessPromise extra : this.excessPromises) {
            if (extra.thePackage != item) continue;
            List<ExcessPromise> extras = excessMap.get(extra.sender);
            if (extras == null) {
                extras = new LinkedList<ExcessPromise>();
                excessMap.put(extra.sender, extras);
            }
            extras.add(extra.copy());
        }
        for (RequestBranchNode subNode : this.subRequests) {
            subNode.recurse_GatherExcess(item, excessMap);
        }
    }

    protected void recurse_RemoveUnusableExcess(ItemKey item, HashMap<IWorldBroadcaster, List<ExcessPromise>> excessMap) {
        block0: for (DeliveryPromise promise : this.promises) {
            if (promise.thePackage != item || !(promise instanceof ExcessPromise)) continue;
            ExcessPromise epromise = (ExcessPromise)promise;
            if (epromise.used) continue;
            int usedcount = epromise.size;
            List<ExcessPromise> extras = excessMap.get(epromise.sender);
            if (extras == null) continue;
            Iterator<ExcessPromise> it = extras.iterator();
            while (it.hasNext()) {
                ExcessPromise extra = it.next();
                if (extra.size >= usedcount) {
                    extra.size -= usedcount;
                    usedcount = 0;
                    continue block0;
                }
                usedcount -= extra.size;
                it.remove();
            }
        }
        for (RequestBranchNode subNode : this.subRequests) {
            subNode.recurse_RemoveUnusableExcess(item, excessMap);
        }
    }

    protected void recurse_RebuildParityTree() {
        if (this.isDone()) {
            return;
        }
        if (this.parityBranch == null) {
            return;
        }
        int setsNeeded = (this.getMissingCount() + this.parityBranch.getSizeForSet() - 1) / this.parityBranch.getSizeForSet();
        List<Pair2<ItemKeyStack, IWorldRequester>> components = this.parityBranch.getScaledIngredients(setsNeeded);
        for (Pair2<ItemKeyStack, IWorldRequester> pair : components) {
            new RequestBranchNode(this.parityBranch, (ItemKeyStack)pair.getValue1(), (IWorldRequester)pair.getValue2(), this, RequestBranch.RequestFlags.def);
        }
        this.addPromise(this.parityBranch.getScaledPromise(setsNeeded));
        for (RequestBranchNode sub : this.subRequests) {
            sub.recurse_RebuildParityTree();
        }
    }

    protected void recurse_GatherStatisticsMissing(Map<ItemKey, Integer> map) {
        int missing = this.getMissingCount();
        if (missing > 0) {
            ItemKey item = this.getRequestedPackage();
            Integer current = map.get(item);
            if (current == null) {
                current = 0;
            }
            current = current + missing;
            map.put(item, current);
        }
        for (RequestBranchNode sub : this.subRequests) {
            sub.recurse_GatherStatisticsMissing(map);
        }
    }

    protected void recurse_GatherStatisticsUsed(Map<ItemKey, Integer> map) {
        int thisUsed = 0;
        for (DeliveryPromise p : this.promises) {
            if (p.sender instanceof IWorldCrafter) continue;
            thisUsed += p.size;
        }
        if (thisUsed > 0) {
            ItemKey item = this.getRequestedPackage();
            Integer current = map.get(item);
            if (current == null) {
                current = 0;
            }
            current = current + thisUsed;
            map.put(item, current);
        }
        for (RequestBranchNode sub : this.subRequests) {
            sub.recurse_GatherStatisticsUsed(map);
        }
    }

    private static class PathSorter
    implements Comparator<Router.StartEndPath> {
        private final double distanceWeight;

        public PathSorter(double distanceWeight) {
            this.distanceWeight = distanceWeight;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(Router.StartEndPath o1, Router.StartEndPath o2) {
            int p2;
            double c = 0.0;
            IWorldRouter wr1 = o1.end.getParent();
            IWorldRouter wr2 = o2.end.getParent();
            int p1 = wr1 instanceof IWorldBroadcaster ? ((IWorldBroadcaster)wr1).getPriority() : Integer.MIN_VALUE;
            int n = p2 = wr2 instanceof IWorldBroadcaster ? ((IWorldBroadcaster)wr2).getPriority() : Integer.MIN_VALUE;
            if (p1 > Integer.MIN_VALUE) {
                if (p2 <= Integer.MIN_VALUE) return -1;
                c = p2 - p1;
            } else if (p2 > Integer.MIN_VALUE) {
                return 1;
            }
            if (c != 0.0) {
                return (int)c;
            }
            int switchKey = 1;
            if (o1.end.getIPAddress() - o2.end.getIPAddress() > 0) {
                switchKey = -1;
                Router.StartEndPath temp = o1;
                o1 = o2;
                o2 = temp;
            }
            double l1 = wr1 instanceof IWorldBroadcaster ? ((IWorldBroadcaster)wr1).getWorkLoad() : 0.0;
            double l2 = wr2 instanceof IWorldBroadcaster ? ((IWorldBroadcaster)wr2).getWorkLoad() : 0.0;
            c = l1 - l2;
            if ((c += (double)(o1.distance - o2.distance) * this.distanceWeight) == 0.0) {
                return -switchKey;
            }
            if (!(c > 0.0)) return (int)(c - 0.5) * switchKey;
            return (int)(c + 0.5) * switchKey;
        }
    }

    private class CraftingTreeInteraction
    implements Comparable<CraftingTreeInteraction> {
        private int setsRequested;
        private final int setSize;
        private final int maxSetsAvailable;
        private final RequestBranchNode treeNode;
        public final CraftingPromise crafter;
        public final int originalToDo;

        private CraftingTreeInteraction(CraftingPromise crafter, int maxToCraft, RequestBranchNode interaction) {
            this.crafter = crafter;
            this.treeNode = interaction;
            this.originalToDo = crafter.getCrafter().itemsToProcess();
            this.setsRequested = 0;
            this.setSize = crafter.getSizeForSet();
            this.maxSetsAvailable = (this.treeNode.getMissingCount() + this.setSize - 1) / this.setSize;
        }

        public int toDo() {
            return this.originalToDo + this.setsRequested * this.setSize;
        }

        private int calculateMaxPotentialSets(int maxSets) {
            int needed = 0;
            needed = maxSets > 0 ? maxSets : (this.treeNode.getMissingCount() + this.setSize - 1) / this.setSize;
            if (needed <= 0) {
                return 0;
            }
            return RequestBranchNode.this.getPotentialSubPromises(needed, this.crafter);
        }

        public int addAdditionalItems(int additional) {
            int stacksRequested = (additional + this.setSize - 1) / this.setSize;
            this.setsRequested += stacksRequested;
            return stacksRequested * this.setSize;
        }

        public boolean finalizeInteraction() {
            int setsToCraft = Math.min(this.setsRequested, this.maxSetsAvailable);
            int setsAbleToCraft = this.calculateMaxPotentialSets(setsToCraft);
            if (setsAbleToCraft > 0) {
                DeliveryPromise delivery = this.crafter.getScaledPromise(setsAbleToCraft);
                if (delivery.size != setsAbleToCraft * this.setSize) {
                    return false;
                }
                this.treeNode.addPromise(delivery);
            }
            boolean isDone = setsToCraft == setsAbleToCraft;
            this.setsRequested = 0;
            return isDone;
        }

        @Override
        public int compareTo(CraftingTreeInteraction o2) {
            return this.toDo() - o2.toDo();
        }
    }

    public static class CraftingPromise
    implements Comparable<CraftingPromise> {
        private IWorldCrafter crafter;
        private ItemKeyStack result;
        private ArrayList<Pair2<ItemKeyStack, IWorldRequester>> ingredients = new ArrayList(9);
        private final int priority;

        public CraftingPromise(ItemKeyStack result, IWorldCrafter crafter, int priority) {
            this.result = result;
            this.crafter = crafter;
            this.priority = priority;
        }

        public IWorldCrafter getCrafter() {
            return this.crafter;
        }

        public int getPriority() {
            return this.priority;
        }

        public CraftingPromise addIngredient(ItemKeyStack ingredient, IWorldRequester crafter) {
            for (Pair2<ItemKeyStack, IWorldRequester> ing : this.ingredients) {
                if (!((ItemKeyStack)ing.getValue1()).key().equals((Object)ingredient.key()) || ing.getValue2() != crafter) continue;
                ((ItemKeyStack)ing.getValue1()).stackSize += ingredient.stackSize;
                return this;
            }
            this.ingredients.add((Pair2<ItemKeyStack, IWorldRequester>)new Pair2((Object)ingredient, (Object)crafter));
            return this;
        }

        public DeliveryPromise getScaledPromise(int sets) {
            DeliveryPromise p = new DeliveryPromise();
            p.setPackage(this.result.key().copy()).setSize(this.result.stackSize * sets).setSender(this.crafter);
            return p;
        }

        public List<Pair2<ItemKeyStack, IWorldRequester>> getScaledIngredients(int sets) {
            ArrayList<Pair2<ItemKeyStack, IWorldRequester>> components = new ArrayList<Pair2<ItemKeyStack, IWorldRequester>>(this.ingredients.size());
            for (Pair2<ItemKeyStack, IWorldRequester> ing : this.ingredients) {
                Pair2 newIng = new Pair2((Object)((ItemKeyStack)ing.getValue1()).copy(), ing.getValue2());
                ((ItemKeyStack)newIng.getValue1()).stackSize *= sets;
                components.add((Pair2<ItemKeyStack, IWorldRequester>)newIng);
            }
            return components;
        }

        @Override
        public int compareTo(CraftingPromise p2) {
            int c = this.priority - p2.priority;
            if (c == 0) {
                c = this.result.compareTo(p2.result);
            }
            if (c == 0) {
                c = this.crafter.getRouter().compareTo(p2.crafter.getRouter());
            }
            return c;
        }

        public boolean canCraft(ItemKey item) {
            return item.equals((Object)this.result);
        }

        public int getSizeForSet() {
            return this.result.stackSize;
        }

        public ItemKey getResultItem() {
            return this.result.key();
        }
    }

    public static class ExcessPromise
    extends DeliveryPromise {
        public boolean used;

        public ExcessPromise setUsed(boolean flag) {
            this.used = flag;
            return this;
        }

        @Override
        public ExcessPromise copy() {
            ExcessPromise p = new ExcessPromise();
            p.setPackage(this.thePackage).setSize(this.size).setSender(this.sender);
            p.setUsed(this.used);
            return p;
        }
    }

    public static class DeliveryPromise {
        public ItemKey thePackage;
        public int size;
        public IWorldBroadcaster sender;

        public DeliveryPromise setPackage(ItemKey thePackage) {
            this.thePackage = thePackage;
            return this;
        }

        public DeliveryPromise setSize(int size) {
            this.size = size;
            return this;
        }

        public DeliveryPromise setSender(IWorldBroadcaster sender) {
            this.sender = sender;
            return this;
        }

        public DeliveryPromise copy() {
            DeliveryPromise p = new DeliveryPromise();
            p.setPackage(this.thePackage).setSize(this.size).setSender(this.sender);
            return p;
        }
    }
}

