/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.LinkedList;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.core.utils.Pair2;
import mrtjp.projectred.transportation.IWorldRequester;

public class DeliveryManager {
    private LinkedList<Pair2<ItemKeyStack, IWorldRequester>> orders = new LinkedList();

    public void addOrder(ItemKeyStack stack, IWorldRequester requester) {
        for (Pair2 pair2 : this.orders) {
            if (pair2.getValue1() != stack || pair2.getValue2() != requester) continue;
            stack.stackSize += ((ItemKeyStack)pair2.getValue1()).stackSize;
            this.orders.remove(pair2);
            break;
        }
        this.orders.addLast((Pair2<ItemKeyStack, IWorldRequester>)new Pair2((Object)stack, (Object)requester));
        this.onOrdersChanged();
    }

    public void dispatchSuccessful(int amountSent, boolean reStack) {
        Pair2<ItemKeyStack, IWorldRequester> first = this.orders.getFirst();
        ((ItemKeyStack)first.getValue1()).stackSize -= amountSent;
        if (((ItemKeyStack)first.getValue1()).stackSize <= 0) {
            this.orders.removeFirst();
        } else if (reStack) {
            this.reStock();
        }
    }

    public void dispatchFailed() {
        Pair2<ItemKeyStack, IWorldRequester> first = this.orders.getFirst();
        ((IWorldRequester)first.getValue2()).trackedItemLost((ItemKeyStack)first.getValue1());
        if (!this.orders.isEmpty()) {
            this.orders.removeFirst();
        }
        this.onOrdersChanged();
    }

    public void reStock() {
        Pair2<ItemKeyStack, IWorldRequester> p = this.orders.removeFirst();
        this.orders.addLast(p);
    }

    public Pair2<ItemKeyStack, IWorldRequester> peek() {
        if (this.orders.isEmpty()) {
            return null;
        }
        return this.orders.getFirst();
    }

    public boolean hasOrders() {
        return !this.orders.isEmpty();
    }

    public int getDeliveryCount(ItemKey item) {
        int count = 0;
        for (Pair2 pair2 : this.orders) {
            if (!((ItemKeyStack)pair2.getValue1()).key().equals((Object)item)) continue;
            count += ((ItemKeyStack)pair2.getValue1()).stackSize;
        }
        return count;
    }

    public int getTotalDeliveryCount() {
        int count = 0;
        for (Pair2 pair2 : this.orders) {
            count += ((ItemKeyStack)pair2.getValue1()).stackSize;
        }
        return count;
    }

    public void onOrdersChanged() {
    }
}

