/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.IHollowConnect;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import codechicken.multipart.TileMultipart;
import java.util.Arrays;
import java.util.LinkedList;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.transportation.EnumPipe;
import mrtjp.projectred.transportation.IPipeConnectable;

public abstract class CorePipePart
extends TMultiPart
implements IPipeConnectable,
TSlottedPart,
JNormalOcclusion,
IHollowConnect {
    public static Cuboid6[] boundingBoxes = new Cuboid6[7];
    private static int expandBounds = -1;
    public int connMap;
    public byte meta;

    public void preparePlacement(int meta) {
        this.meta = (byte)meta;
    }

    public int getHollowSize() {
        return 8;
    }

    public float getStrength(ata hit, uf player) {
        return 2.0f;
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        if (expandBounds >= 0) {
            return Arrays.asList(boundingBoxes[expandBounds]);
        }
        return Arrays.asList(boundingBoxes[6]);
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        Iterable<Cuboid6> boxList = this.getCollisionBoxes();
        LinkedList<IndexedCuboid6> partList = new LinkedList<IndexedCuboid6>();
        for (Cuboid6 c : boxList) {
            partList.add(new IndexedCuboid6((Object)0, c));
        }
        return partList;
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        LinkedList<Cuboid6> list = new LinkedList<Cuboid6>();
        list.add(boundingBoxes[6]);
        for (int s = 0; s < 6; ++s) {
            if (!this.maskConnects(s)) continue;
            list.add(boundingBoxes[s]);
        }
        return list;
    }

    public int getSlotMask() {
        return 64;
    }

    public void save(by tag) {
        super.save(tag);
        tag.a("connMap", this.connMap);
        tag.a("meta", this.meta);
    }

    public void load(by tag) {
        super.load(tag);
        this.connMap = tag.e("connMap");
        this.meta = tag.c("meta");
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte(this.clientConnMap());
        packet.writeByte((int)this.meta);
    }

    public void readDesc(MCDataInput packet) {
        this.connMap = packet.readUByte();
        this.meta = packet.readByte();
    }

    public void read(MCDataInput packet) {
        this.read(packet, packet.readUByte());
    }

    public void read(MCDataInput packet, int switch_key) {
        if (switch_key == 0) {
            this.connMap = packet.readUByte();
            this.tile().markRender();
        }
    }

    public void onNeighborChanged() {
        if (!this.world().I && this.updateExternalConnections()) {
            this.sendConnUpdate();
        }
    }

    public void onPartChanged(TMultiPart part) {
        if (!this.world().I) {
            boolean changed = false;
            if (this.updateOpenConnections()) {
                changed |= this.updateExternalConnections();
            }
            if (changed) {
                this.sendConnUpdate();
            }
        }
    }

    public void onAdded() {
        if (!this.world().I) {
            this.updateOpenConnections();
            if (this.updateExternalConnections()) {
                this.sendConnUpdate();
            }
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.world().I) {
            for (int s = 0; s < 6; ++s) {
                if ((this.connMap & 1 << s) == 0) continue;
                this.notifyStraightChange(s);
            }
        }
    }

    public Iterable<ye> getDrops() {
        return Arrays.asList(this.getItem());
    }

    public ye pickItem(ata hit) {
        return this.getItem();
    }

    public ye getItem() {
        return EnumPipe.VALID_PIPE[this.meta].getItemStack();
    }

    public void notifyStraightChange(int s) {
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(s);
        this.world().g(pos.x, pos.y, pos.z, this.tile().q().cF);
    }

    public void onChunkLoad() {
    }

    public void onWorldJoin() {
        this.onNeighborChanged();
    }

    public int clientConnMap() {
        return this.connMap & 0x3F | this.connMap >> 6 & 0x3F;
    }

    public void sendConnUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(0).writeByte(this.clientConnMap());
    }

    protected boolean updateExternalConnections() {
        int newConn = 0;
        for (int s = 0; s < 6; ++s) {
            if (!this.maskOpen(s) || !this.connect(s)) continue;
            newConn |= 1 << s;
        }
        if (newConn != (this.connMap & 0x3F)) {
            this.connMap = this.connMap & 0xFFFFFFC0 | newConn;
            return true;
        }
        return false;
    }

    protected boolean updateOpenConnections() {
        int newConn = 0;
        for (int s = 0; s < 6; ++s) {
            if (!this.connectionOpen(s)) continue;
            newConn |= 1 << s + 12;
        }
        if (newConn != (this.connMap & 0x3F000)) {
            this.connMap = this.connMap & 0xFFFC0FFF | newConn;
            return true;
        }
        return false;
    }

    public boolean connectionOpen(int s) {
        TMultiPart facePart = this.tile().partMap(s);
        if (facePart == null) {
            return true;
        }
        if (facePart instanceof IPipeConnectable && this.canConnectTo((IPipeConnectable)facePart)) {
            return false;
        }
        expandBounds = s;
        boolean fits = this.tile().canReplacePart((TMultiPart)this, (TMultiPart)this);
        expandBounds = -1;
        return fits;
    }

    public boolean connect(int absDir) {
        TileMultipart t;
        TMultiPart tp;
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        asp te = (asp)BasicUtils.getTileEntity((acf)this.world(), (BlockCoord)pos, asp.class);
        if (te instanceof TileMultipart && (tp = (t = (TileMultipart)te).partMap(6)) instanceof IPipeConnectable) {
            return ((IPipeConnectable)tp).connect(this, absDir ^ 1);
        }
        return false;
    }

    @Override
    public boolean connect(IPipeConnectable tube, int fromAbsDir) {
        if (this.canConnectTo(tube) && this.maskOpen(fromAbsDir)) {
            int oldConn = this.connMap;
            this.connMap |= 1 << fromAbsDir;
            if (oldConn != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canConnectTo(IPipeConnectable tube) {
        return true;
    }

    public abstract String getType();

    public boolean maskConnects(int absDir) {
        return (this.connMap & 65 << absDir) != 0;
    }

    public boolean maskOpen(int absDir) {
        return (this.connMap & 4096 << absDir) != 0;
    }

    static {
        double w = 0.25;
        CorePipePart.boundingBoxes[6] = new Cuboid6(0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w);
        for (int s = 0; s < 6; ++s) {
            CorePipePart.boundingBoxes[s] = new Cuboid6(0.5 - w, 0.0, 0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w).apply(Rotation.sideRotations[s].at(Vector3.center));
        }
    }
}

