/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.transportation.IWorldBroadcaster;
import mrtjp.projectred.transportation.IWorldCrafter;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.IWorldRouter;
import mrtjp.projectred.transportation.Router;

public class CollectionPathFinder {
    private boolean collectBroadcasts = false;
    private boolean collectCrafts = false;
    private IWorldRequester requester;
    private Map<ItemKey, Integer> collected = null;

    public CollectionPathFinder setCollectBroadcasts(boolean flag) {
        this.collectBroadcasts = flag;
        return this;
    }

    public CollectionPathFinder setCollectCrafts(boolean flag) {
        this.collectCrafts = flag;
        return this;
    }

    public CollectionPathFinder setRequester(IWorldRequester requester) {
        this.requester = requester;
        return this;
    }

    public CollectionPathFinder collect() {
        HashMap<ItemKey, Integer> collected = new HashMap<ItemKey, Integer>();
        for (Router.StartEndPath l : this.requester.getRouter().getRoutesByCost()) {
            Router r = l.end;
            IWorldRouter wr = r.getParent();
            if (wr instanceof IWorldCrafter && this.collectCrafts) {
                IWorldCrafter c = (IWorldCrafter)wr;
                c.getBroadcastedItems(collected);
                List<ItemKeyStack> list = c.getCraftedItems();
                if (list == null) continue;
                for (ItemKeyStack stack : list) {
                    if (collected.containsKey(stack.key())) continue;
                    collected.put(stack.key(), null);
                }
                continue;
            }
            if (!(wr instanceof IWorldBroadcaster) || !this.collectBroadcasts) continue;
            IWorldBroadcaster b = (IWorldBroadcaster)wr;
            b.getBroadcastedItems(collected);
        }
        this.collected = collected;
        return this;
    }

    public Map<ItemKey, Integer> getCollection() {
        return this.collected;
    }
}

