/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TMultiPart;
import com.google.common.collect.BiMap;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.inventory.InventoryWrapper;
import mrtjp.projectred.transportation.CorePipePart;
import mrtjp.projectred.transportation.EnumPipe;
import mrtjp.projectred.transportation.PipeLogic;
import mrtjp.projectred.transportation.RenderPipe;
import mrtjp.projectred.transportation.RoutedPayload;
import net.minecraftforge.common.ForgeDirection;

public class BasicPipePart
extends CorePipePart {
    protected PayloadMovement itemFlow = new PayloadMovement();
    public PipeLogic logic;
    public boolean initialized = false;
    private List<mo> cachedInventories;

    @Override
    public void preparePlacement(int meta) {
        super.preparePlacement(meta);
        this.logic = PipeLogic.createPipeLogic(this, meta);
    }

    public PipeLogic getLogic() {
        return this.logic;
    }

    public void update() {
        if (!this.initialized) {
            this.initialized = true;
        }
        this.pushItemFlow();
        this.getLogic().tick();
    }

    protected void pushItemFlow() {
        this.itemFlow.executeLoad();
        this.itemFlow.exececuteRemove();
        Iterator i$ = this.itemFlow.iterator();
        while (i$.hasNext()) {
            RoutedPayload r = (RoutedPayload)i$.next();
            if (r.isCorrupted()) {
                this.itemFlow.scheduleRemoval(r);
                continue;
            }
            r.moveProgress(r.speed);
            if (r.isEntering && this.hasReachedMiddle(r)) {
                r.isEntering = false;
                r.progress = 0.5f;
                if (r.output == ForgeDirection.UNKNOWN) {
                    this.handleDrop(r);
                    continue;
                }
                this.centerReached(r);
                continue;
            }
            if (r.isEntering || !this.hasReachedEnd(r) || !this.itemFlow.scheduleRemoval(r)) continue;
            this.endReached(r);
        }
        this.itemFlow.exececuteRemove();
    }

    public void handleDrop(RoutedPayload r) {
        if (this.getLogic().handleDrop(r)) {
            return;
        }
        if (this.itemFlow.scheduleRemoval(r) && !this.world().I) {
            r.resetTrip();
            this.world().d((nn)r.getEntityForDrop(this.x(), this.y(), this.z()));
        }
    }

    public void resolveDestination(RoutedPayload r) {
        if (this.getLogic().resolveDestination(r)) {
            return;
        }
        this.chooseRandomDestination(r);
    }

    public void chooseRandomDestination(RoutedPayload r) {
        LinkedList<ForgeDirection> movements = new LinkedList<ForgeDirection>();
        for (int i = 0; i < 6; ++i) {
            if ((this.connMap & 1 << i) == 0 || i == r.input.getOpposite().ordinal()) continue;
            BlockCoord bc = new BlockCoord((asp)this.tile()).offset(i);
            TMultiPart t = BasicUtils.getMultiPart((acf)this.world(), (BlockCoord)bc, (int)6);
            if (!(t instanceof BasicPipePart)) continue;
            movements.add(ForgeDirection.getOrientation((int)i));
        }
        r.output = movements.isEmpty() ? r.input.getOpposite() : (ForgeDirection)movements.get(this.world().s.nextInt(movements.size()));
    }

    public void endReached(RoutedPayload r) {
        if (this.getLogic().centerReached(r)) {
            return;
        }
        if (!(this.world().I || this.maskConnects(r.output.ordinal()) && this.passToNextPipe(r))) {
            mo inv = InventoryWrapper.getInventory((abw)this.world(), (BlockCoord)new BlockCoord((asp)this.tile()).offset(r.output.ordinal()));
            if (inv != null) {
                InventoryWrapper w = InventoryWrapper.wrapInventory((mo)inv).setSlotsFromSide(r.output.getOpposite().ordinal());
                r.payload.stackSize -= w.injectItem(r.payload.makeStack(), true);
            }
            if (r.payload.stackSize > 0) {
                this.bounceStack(r);
            }
        }
    }

    public void bounceStack(RoutedPayload r) {
        this.itemFlow.unscheduleRemoval(r);
        r.isEntering = true;
        r.input = r.output.getOpposite();
        this.resolveDestination(r);
        this.adjustSpeed(r);
        this.sendItemUpdate(r);
    }

    public void centerReached(RoutedPayload r) {
        if (this.getLogic().centerReached(r)) {
            return;
        }
        if (!this.maskConnects(r.output.ordinal())) {
            this.resolveDestination(r);
        }
    }

    public boolean passToNextPipe(RoutedPayload r) {
        TMultiPart p = BasicUtils.getMultiPart((acf)this.world(), (BlockCoord)new BlockCoord((asp)this.tile()).offset(r.output.ordinal()), (int)6);
        if (p instanceof BasicPipePart) {
            BasicPipePart pipe = (BasicPipePart)p;
            pipe.injectPayload(r, r.output);
            return true;
        }
        return false;
    }

    public void adjustSpeed(RoutedPayload r) {
        r.speed = Math.max(r.speed - 0.01f, r.priority.speed);
    }

    protected boolean hasReachedMiddle(RoutedPayload r) {
        return r.progress >= 0.5f;
    }

    protected boolean hasReachedEnd(RoutedPayload r) {
        return r.progress >= 1.0f;
    }

    public void injectPayload(RoutedPayload r, ForgeDirection in) {
        if (r.isCorrupted()) {
            return;
        }
        r.bind(this);
        r.reset();
        r.input = in;
        this.itemFlow.add(r);
        this.adjustSpeed(r);
        if (r.progress > 0.0f) {
            r.progress -= 1.0f;
        }
        if (!this.world().I) {
            this.resolveDestination(r);
            this.sendItemUpdate(r);
        }
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        cg nbttaglist = new cg();
        Iterator i$ = this.itemFlow.iterator();
        while (i$.hasNext()) {
            RoutedPayload r = (RoutedPayload)i$.next();
            by payloadData = new by();
            nbttaglist.a((cl)payloadData);
            r.save(payloadData);
        }
        tag.a("itemFlow", (cl)nbttaglist);
        this.getLogic().save(tag);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        cg nbttaglist = tag.m("itemFlow");
        for (int j = 0; j < nbttaglist.c(); ++j) {
            try {
                by payloadData = (by)nbttaglist.b(j);
                RoutedPayload r = new RoutedPayload();
                r.bind(this);
                r.load(payloadData);
                if (r.isCorrupted()) continue;
                this.itemFlow.scheduleLoad(r);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.logic = PipeLogic.createPipeLogic(this, this.meta);
        this.getLogic().load(tag);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        this.getLogic().writeDesc(packet);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        if (this.getLogic() == null) {
            this.logic = PipeLogic.createPipeLogic(this, this.meta);
        }
        this.getLogic().readDesc(packet);
    }

    @Override
    public void read(MCDataInput packet, int switch_key) {
        super.read(packet, switch_key);
        if (switch_key == 1) {
            this.handleItemUpdatePacket(packet);
        }
        this.getLogic().read(packet, switch_key);
    }

    @Override
    public void onPartChanged(TMultiPart part) {
        super.onPartChanged(part);
        this.cachedInventories = null;
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.cachedInventories = null;
        int connCount = 0;
        for (int i = 0; i < 6; ++i) {
            if ((this.connMap & 1 << i) == 0) continue;
            ++connCount;
        }
        if (connCount == 0) {
            Iterator i$ = this.itemFlow.iterator();
            while (i$.hasNext()) {
                RoutedPayload r = (RoutedPayload)i$.next();
                if (!this.itemFlow.scheduleRemoval(r) || this.world().I) continue;
                r.resetTrip();
                this.world().d((nn)r.getEntityForDrop(this.x(), this.y(), this.z()));
            }
        }
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (!this.world().I) {
            Iterator i$ = this.itemFlow.iterator();
            while (i$.hasNext()) {
                RoutedPayload r = (RoutedPayload)i$.next();
                r.resetTrip();
                this.world().d((nn)r.getEntityForDrop(this.x(), this.y(), this.z()));
            }
        }
    }

    public void sendItemUpdate(RoutedPayload r) {
        MCDataOutput out = this.tile().getWriteStream((TMultiPart)this).writeByte(1);
        out.writeShort(r.payloadID);
        out.writeFloat(r.progress);
        out.writeItemStack(r.getItemStack());
        out.writeByte((int)((byte)r.input.ordinal()));
        out.writeByte((int)((byte)r.output.ordinal()));
        out.writeFloat(r.speed);
        out.writeByte(r.priority.ordinal());
    }

    public void handleItemUpdatePacket(MCDataInput packet) {
        short id = packet.readShort();
        float progress = packet.readFloat();
        RoutedPayload r = this.itemFlow.get(id);
        if (r == null) {
            r = new RoutedPayload(id);
            r.progress = progress;
            this.itemFlow.add(r);
        }
        r.setItemStack(packet.readItemStack());
        r.input = ForgeDirection.getOrientation((int)packet.readByte());
        r.output = ForgeDirection.getOrientation((int)packet.readByte());
        r.speed = packet.readFloat();
        r.setPriority(RoutedPayload.SendPriority.values()[packet.readByte()]);
    }

    @Override
    public String getType() {
        return "pr_ptube";
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBreaking(bfr r) {
        for (Cuboid6 box : this.getCollisionBoxes()) {
            RenderUtils.renderBlock((Cuboid6)box, (int)0, (Transformation)new Translation((double)this.x(), (double)this.y(), (double)this.z()), (IUVTransformation)new IconTransformation(r.d), null);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(Vector3 pos, LazyLightMatrix olm, int pass) {
        if (pass == 0) {
            TextureUtils.bindAtlas((int)0);
            CCRenderState.reset();
            CCRenderState.setBrightness((acf)this.world(), (int)this.x(), (int)this.y(), (int)this.z());
            CCRenderState.useModelColours((boolean)true);
            RenderPipe.render(this, pos, olm);
            CCRenderState.setColour((int)-1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            TextureUtils.bindAtlas((int)0);
            CCRenderState.reset();
            CCRenderState.setBrightness((acf)this.world(), (int)this.x(), (int)this.y(), (int)this.z());
            CCRenderState.useModelColours((boolean)true);
            RenderPipe.renderItemFlow(this, pos, frame);
            CCRenderState.setColour((int)-1);
        }
    }

    public ms getIcon(int side) {
        ms i = this.getLogic().getIcon(this, side);
        if (i != null) {
            return i;
        }
        return EnumPipe.BASIC.sprites[0];
    }

    public List<mo> getConnectedInventories() {
        if (this.cachedInventories != null) {
            return this.cachedInventories;
        }
        ArrayList<mo> adjacent = new ArrayList<mo>();
        BlockCoord bc = new BlockCoord((asp)this.tile());
        for (int i = 0; i < 6; ++i) {
            mo inv;
            if (!this.maskConnects(i) || (inv = InventoryWrapper.getInventory((abw)this.world(), (BlockCoord)bc.copy().offset(i))) == null) continue;
            adjacent.add(inv);
        }
        this.cachedInventories = Collections.unmodifiableList(adjacent);
        return this.cachedInventories;
    }

    protected static class PayloadMovement
    extends ForwardingSet<RoutedPayload> {
        private final BiMap<Integer, RoutedPayload> delegate = HashBiMap.create();
        private final Set<RoutedPayload> inputQueue = new HashSet<RoutedPayload>();
        private final Set<RoutedPayload> outputQueue = new HashSet<RoutedPayload>();
        private int delay = 0;

        protected PayloadMovement() {
        }

        public Set<RoutedPayload> delegate() {
            return this.delegate.values();
        }

        public boolean add(RoutedPayload item) {
            if (this.delegate.containsValue((Object)item)) {
                return false;
            }
            this.delegate.put((Object)item.payloadID, (Object)item);
            return true;
        }

        public boolean addAll(Collection<? extends RoutedPayload> collection) {
            boolean changed = false;
            for (RoutedPayload routedPayload : collection) {
                changed |= this.add(routedPayload);
            }
            return changed;
        }

        public RoutedPayload get(int id) {
            return (RoutedPayload)this.delegate.get((Object)id);
        }

        public void scheduleLoad(RoutedPayload item) {
            this.delay = 10;
            this.inputQueue.add(item);
        }

        public void executeLoad() {
            if (this.delay-- > 0) {
                return;
            }
            this.addAll(this.inputQueue);
            this.inputQueue.clear();
        }

        public boolean scheduleRemoval(RoutedPayload item) {
            return this.outputQueue.add(item);
        }

        public boolean unscheduleRemoval(RoutedPayload item) {
            return this.outputQueue.remove(item);
        }

        public void exececuteRemove() {
            this.removeAll(this.outputQueue);
            this.outputQueue.clear();
        }
    }
}

