/*
 * Decompiled with CFR 0.152.
 */
package uk.binarycraft.storagesilo;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import uk.binarycraft.storagesilo.CraftingRecipes;
import uk.binarycraft.storagesilo.blocks.ModBlocks;
import uk.binarycraft.storagesilo.blocks.craftingsilo.TileEntityCraftingSilo;
import uk.binarycraft.storagesilo.blocks.storagesilo.TileEntityStorageSilo;
import uk.binarycraft.storagesilo.proxy.CommonProxy;

@Mod(modid="storageSilo", version="1.2.2", name="StorageSilo", acceptedMinecraftVersions="[1.8]")
public class StorageSilo {
    public static int siloCapacity;
    public static boolean storageSiloEnabled;
    public static boolean craftingSiloEnabled;
    @Mod.Instance(value="storageSilo")
    public static StorageSilo instance;
    @SidedProxy(clientSide="uk.binarycraft.storagesilo.proxy.ClientProxy", serverSide="uk.binarycraft.storagesilo.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs storageSiloCreativeTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws Exception {
        this.getConfiguration(event);
        ModBlocks.preInit();
    }

    private void registerTileEntities() {
        if (storageSiloEnabled) {
            GameRegistry.registerTileEntity(TileEntityStorageSilo.class, (String)"tileEntityStorageSilo");
        }
        if (craftingSiloEnabled) {
            GameRegistry.registerTileEntity(TileEntityCraftingSilo.class, (String)"tileEntityCraftingSilo");
        }
    }

    private void getConfiguration(FMLPreInitializationEvent event) throws Exception {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        siloCapacity = config.getInt("StorageSiloCapacity", "general", 999, 54, 999, "The number of available slots in each StorageSilo");
        storageSiloEnabled = config.getBoolean("StorageSiloEnabled", "general", true, "Enable or disable the StorageSilo block");
        craftingSiloEnabled = config.getBoolean("CraftingSiloEnabled", "general", true, "Enable or disable the CraftingSilo block");
        config.save();
        if (!storageSiloEnabled && !craftingSiloEnabled) {
            throw new Exception("The configuration for the StorageSilo mod is invalid, as it completely disables the mod with both blocks disabled.");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerItemModels();
        this.registerTileEntities();
        proxy.initClient();
        proxy.initCommon();
        proxy.initServer();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        new CraftingRecipes().init();
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
    }

    static {
        storageSiloCreativeTab = new CreativeTabs("StorageSilo"){

            public Item func_78016_d() {
                if (storageSiloEnabled) {
                    return new ItemStack(ModBlocks.storageSilo).func_77973_b();
                }
                return new ItemStack(ModBlocks.craftingSilo).func_77973_b();
            }
        };
    }
}

