/*
 * Decompiled with CFR 0.152.
 */
package uk.binarycraft.storagesilo.blocks.craftingsilo;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import uk.binarycraft.storagesilo.blocks.craftingsilo.TileEntityCraftingSilo;
import uk.binarycraft.storagesilo.inventory.ContainerBase;
import uk.binarycraft.storagesilo.inventory.SlotSearchable;

public class ContainerCraftingSilo
extends ContainerBase {
    public InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 3, 3);
    private int numRows;
    private TileEntityCraftingSilo tileEntityCraftingSilo;
    private IInventory craftResult;
    private World world;

    public ContainerCraftingSilo(EntityPlayer player, TileEntityCraftingSilo tileEntityCraftingSilo) {
        super(tileEntityCraftingSilo);
        this.tileEntityCraftingSilo = tileEntityCraftingSilo;
        this.craftResult = new InventoryCraftResult();
        this.world = player.field_70170_p;
        this.numRows = tileEntityCraftingSilo.func_70302_i_() / 9;
        for (int row = 0; row < this.numRows; ++row) {
            for (int slot = 0; slot < 9; ++slot) {
                this.func_75146_a(new SlotSearchable(this.tileEntityCraftingSilo, slot + row * 9, 8 + slot * 18, 22 + row * 18));
            }
        }
        this.func_75146_a((Slot)new SlotCrafting(player, this.craftMatrix, this.craftResult, 9, 130, 97));
        this.addCraftingGrid((IInventory)this.craftMatrix, 0, 31, 80, 3, 3);
        this.addPlayerInventorySlots(player.field_71071_by);
    }

    public void func_75130_a(IInventory inventory) {
        this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.craftMatrix, this.world));
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.world.field_72995_K) {
            return;
        }
        for (int craftGridLoop = 0; craftGridLoop < 9; ++craftGridLoop) {
            ItemStack itemStack = this.craftMatrix.func_70301_a(craftGridLoop);
            if (itemStack == null) continue;
            player.func_71019_a(itemStack, false);
        }
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer entityPlayer, int i) {
        ItemStack result = this.transferStackInSlotHelper(entityPlayer, i);
        if (result == null) {
            return null;
        }
        if (i != 999) {
            return result;
        }
        for (int loop = 0; loop < 9; ++loop) {
            ItemStack currentSlot = this.craftMatrix.func_70301_a(loop);
            if (currentSlot == null || currentSlot.field_77994_a <= 0) continue;
            this.craftMatrix.func_70298_a(loop, 1);
        }
        this.craftMatrix.func_70296_d();
        return result;
    }

    @Override
    protected void addPlayerInventorySlots(InventoryPlayer inventory) {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int slot = 0; slot < 9; ++slot) {
                this.func_75146_a(new Slot((IInventory)inventory, slot + row * 9 + 9, 8 + slot * 18, 139 + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.func_75146_a(new Slot((IInventory)inventory, row, 8 + row * 18, 197));
        }
    }

    private void addCraftingGrid(IInventory inventory, int startSlot, int x, int y, int width, int height) {
        int i = 0;
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                this.func_75146_a(new Slot(inventory, startSlot + i++, x + w * 18, y + h * 18));
            }
        }
    }
}

