/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.forge;

import mapwriter.Mw;
import mapwriter.config.Config;
import mapwriter.overlay.OverlaySlime;
import mapwriter.util.Logging;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandler {
    Mw mw;

    public EventHandler(Mw mw) {
        this.mw = mw;
    }

    @SubscribeEvent
    public void eventChunkLoad(ChunkEvent.Load event) {
        if (event.world.field_72995_K) {
            this.mw.onChunkLoad(event.getChunk());
        }
    }

    @SubscribeEvent
    public void eventChunkUnload(ChunkEvent.Unload event) {
        if (event.world.field_72995_K) {
            this.mw.onChunkUnload(event.getChunk());
        }
    }

    @SubscribeEvent
    public void onClientChat(ClientChatReceivedEvent event) {
        if (OverlaySlime.seedFound || !OverlaySlime.seedAsked) {
            return;
        }
        try {
            ChatComponentText component;
            String msg;
            if (event.message instanceof ChatComponentTranslation) {
                ChatComponentTranslation component2 = (ChatComponentTranslation)event.message;
                if (component2.func_150268_i().equals("commands.seed.success")) {
                    OverlaySlime.setSeed((Long)component2.func_150271_j()[0]);
                    event.setCanceled(true);
                }
            } else if (event.message instanceof ChatComponentText && (msg = (component = (ChatComponentText)event.message).func_150260_c()).startsWith("Seed: ")) {
                OverlaySlime.setSeed(Long.parseLong(msg.substring(6)));
                event.setCanceled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void eventPlayerDeath(LivingDeathEvent event) {
        if (!event.isCanceled() && event.entityLiving.func_145782_y() == Minecraft.func_71410_x().field_71439_g.func_145782_y()) {
            this.mw.onPlayerDeath((EntityPlayerMP)event.entityLiving);
        }
    }

    @SubscribeEvent
    public void renderMap(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            Mw.getInstance().onTick();
        }
    }

    @SubscribeEvent
    public void onTextureStitchEventPost(TextureStitchEvent.Post event) {
        if (Config.reloadColours) {
            Logging.logInfo("Skipping the first generation of blockcolours, models are not loaded yet", null);
        } else {
            this.mw.reloadBlockColours();
        }
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (Mw.getInstance().ready) {
            Mw.getInstance().markerManager.drawMarkersWorld(event.partialTicks);
        }
    }

    @SubscribeEvent
    public void onGuiOpenEvent(GuiOpenEvent event) {
        if (event.gui instanceof GuiMainMenu && Config.reloadColours) {
            this.mw.reloadBlockColours();
            Config.reloadColours = false;
        }
    }
}

