/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Point;
import java.awt.geom.Point2D;
import mapwriter.Mw;
import mapwriter.MwUtil;
import mapwriter.api.IMwDataProvider;
import mapwriter.api.MwAPI;
import mapwriter.forge.MwKeyHandler;
import mapwriter.gui.MwGuiDimensionDialog;
import mapwriter.gui.MwGuiMarkerDialog;
import mapwriter.gui.MwGuiMarkerDialogNew;
import mapwriter.gui.MwGuiOptions;
import mapwriter.gui.MwGuiTeleportDialog;
import mapwriter.map.MapRenderer;
import mapwriter.map.MapView;
import mapwriter.map.Marker;
import mapwriter.map.mapmode.FullScreenMapMode;
import mapwriter.map.mapmode.MapMode;
import mapwriter.tasks.MergeTask;
import mapwriter.tasks.RebuildRegionsTask;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class MwGui
extends GuiScreen {
    private Mw mw;
    private MapMode mapMode;
    private MapView mapView;
    private MapRenderer map;
    private static final double PAN_FACTOR = 0.3;
    private static final int menuY = 5;
    private static final int menuX = 5;
    private int mouseLeftHeld = 0;
    private int mouseLeftDragStartX = 0;
    private int mouseLeftDragStartY = 0;
    private double viewXStart;
    private double viewZStart;
    private Marker movingMarker = null;
    private int movingMarkerXStart = 0;
    private int movingMarkerZStart = 0;
    private int mouseBlockX = 0;
    private int mouseBlockY = 0;
    private int mouseBlockZ = 0;
    private int exit = 0;
    private Label helpLabel;
    private Label optionsLabel;
    private Label dimensionLabel;
    private Label groupLabel;
    private Label overlayLabel;

    public MwGui(Mw mw) {
        this.mw = mw;
        this.mapMode = new FullScreenMapMode(mw.config);
        this.mapView = new MapView(this.mw);
        this.map = new MapRenderer(this.mw, this.mapMode, this.mapView);
        this.mapView.setDimension(this.mw.miniMap.view.getDimension());
        this.mapView.setViewCentreScaled(this.mw.playerX, this.mw.playerZ, this.mw.playerDimension);
        this.mapView.setZoomLevel(0);
        this.helpLabel = new Label();
        this.optionsLabel = new Label();
        this.dimensionLabel = new Label();
        this.groupLabel = new Label();
        this.overlayLabel = new Label();
    }

    public MwGui(Mw mw, int dim, int x, int z) {
        this(mw);
        this.mapView.setDimension(dim);
        this.mapView.setViewCentreScaled(x, z, dim);
        this.mapView.setZoomLevel(0);
    }

    public void func_73866_w_() {
    }

    protected void func_146284_a(GuiButton button) {
    }

    public void exitGui() {
        this.mw.miniMap.view.setDimension(this.mapView.getDimension());
        this.mapMode.close();
        Keyboard.enableRepeatEvents((boolean)false);
        this.field_146297_k.func_147108_a((GuiScreen)null);
        this.field_146297_k.func_71381_h();
        this.field_146297_k.func_147118_V().func_147687_e();
    }

    public Marker getMarkerNearScreenPos(int x, int y) {
        Marker nearMarker = null;
        for (Marker marker : this.mw.markerManager.visibleMarkerList) {
            if (marker.screenPos == null || !(marker.screenPos.distanceSq(x, y) < 6.0)) continue;
            nearMarker = marker;
        }
        return nearMarker;
    }

    public int getHeightAtBlockPos(int bX, int bZ) {
        int bY = 0;
        int worldDimension = this.mw.mc.field_71441_e.field_73011_w.field_76574_g;
        if (worldDimension == this.mapView.getDimension() && worldDimension != -1) {
            bY = this.mw.mc.field_71441_e.func_72938_d(bX, bZ).func_76611_b(bX & 0xF, bZ & 0xF);
        }
        return bY;
    }

    public boolean isPlayerNearScreenPos(int x, int y) {
        Point2D.Double p = this.map.playerArrowScreenPos;
        return p.distanceSq(x, y) < 9.0;
    }

    public void deleteSelectedMarker() {
        if (this.mw.markerManager.selectedMarker != null) {
            this.mw.markerManager.delMarker(this.mw.markerManager.selectedMarker);
            this.mw.markerManager.update();
            this.mw.markerManager.selectedMarker = null;
        }
    }

    public void mergeMapViewToImage() {
        this.mw.chunkManager.saveChunks();
        this.mw.executor.addTask(new MergeTask(this.mw.regionManager, (int)this.mapView.getX(), (int)this.mapView.getZ(), (int)this.mapView.getWidth(), (int)this.mapView.getHeight(), this.mapView.getDimension(), this.mw.worldDir, this.mw.worldDir.getName()));
        MwUtil.printBoth("merging to '" + this.mw.worldDir.getAbsolutePath() + "'");
    }

    public void regenerateView() {
        MwUtil.printBoth(String.format("regenerating %dx%d blocks starting from (%d, %d)", (int)this.mapView.getWidth(), (int)this.mapView.getHeight(), (int)this.mapView.getMinX(), (int)this.mapView.getMinZ()));
        this.mw.reloadBlockColours();
        this.mw.executor.addTask(new RebuildRegionsTask(this.mw, (int)this.mapView.getMinX(), (int)this.mapView.getMinZ(), (int)this.mapView.getWidth(), (int)this.mapView.getHeight(), this.mapView.getDimension()));
    }

    protected void func_73869_a(char c, int key) {
        switch (key) {
            case 1: {
                this.exitGui();
                break;
            }
            case 211: {
                this.deleteSelectedMarker();
                break;
            }
            case 57: {
                this.mw.markerManager.nextGroup();
                this.mw.markerManager.update();
                break;
            }
            case 46: {
                if (this.mw.markerManager.selectedMarker == null) break;
                this.mw.markerManager.selectedMarker.colourNext();
                break;
            }
            case 49: {
                this.mw.markerManager.selectNextMarker();
                break;
            }
            case 199: {
                this.mapView.setViewCentreScaled(this.mw.playerX, this.mw.playerZ, this.mw.playerDimension);
                break;
            }
            case 207: {
                if (this.mw.markerManager.selectedMarker == null) break;
                this.mapView.setViewCentreScaled(this.mw.markerManager.selectedMarker.x, this.mw.markerManager.selectedMarker.z, 0);
                break;
            }
            case 25: {
                this.mergeMapViewToImage();
                this.exitGui();
                break;
            }
            case 20: {
                if (this.mw.markerManager.selectedMarker != null) {
                    this.mw.teleportToMarker(this.mw.markerManager.selectedMarker);
                    this.exitGui();
                    break;
                }
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiTeleportDialog(this, this.mw, this.mapView, this.mouseBlockX, this.mw.defaultTeleportHeight, this.mouseBlockZ));
                break;
            }
            case 203: {
                this.mapView.panView(-0.3, 0.0);
                break;
            }
            case 205: {
                this.mapView.panView(0.3, 0.0);
                break;
            }
            case 200: {
                this.mapView.panView(0.0, -0.3);
                break;
            }
            case 208: {
                this.mapView.panView(0.0, 0.3);
                break;
            }
            case 19: {
                this.regenerateView();
                this.exitGui();
                break;
            }
            default: {
                if (key == MwKeyHandler.keyMapGui.func_151463_i()) {
                    this.exit = 1;
                    break;
                }
                if (key == MwKeyHandler.keyZoomIn.func_151463_i()) {
                    this.mapView.adjustZoomLevel(-1);
                    break;
                }
                if (key == MwKeyHandler.keyZoomOut.func_151463_i()) {
                    this.mapView.adjustZoomLevel(1);
                    break;
                }
                if (key == MwKeyHandler.keyNextGroup.func_151463_i()) {
                    this.mw.markerManager.nextGroup();
                    this.mw.markerManager.update();
                    break;
                }
                if (key != MwKeyHandler.keyUndergroundMode.func_151463_i()) break;
                this.mw.toggleUndergroundMode();
                this.mapView.setUndergroundMode(this.mw.undergroundMode);
            }
        }
    }

    public void func_146274_d() {
        if (MwAPI.getCurrentDataProvider() != null && MwAPI.getCurrentDataProvider().onMouseInput(this.mapView, this.mapMode)) {
            return;
        }
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int direction = Mouse.getEventDWheel();
        if (direction != 0) {
            this.mouseDWheelScrolled(x, y, direction);
        }
        super.func_146274_d();
    }

    protected void func_73864_a(int x, int y, int button) {
        Marker marker = this.getMarkerNearScreenPos(x, y);
        Marker prevMarker = this.mw.markerManager.selectedMarker;
        if (button == 0) {
            if (this.dimensionLabel.posWithin(x, y)) {
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiDimensionDialog((GuiScreen)this, this.mw, this.mapView, this.mapView.getDimension()));
            } else if (this.optionsLabel.posWithin(x, y)) {
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiOptions(this, this.mw));
            } else {
                this.mouseLeftHeld = 1;
                this.mouseLeftDragStartX = x;
                this.mouseLeftDragStartY = y;
                this.mw.markerManager.selectedMarker = marker;
                if (marker != null && prevMarker == marker) {
                    this.movingMarker = marker;
                    this.movingMarkerXStart = marker.x;
                    this.movingMarkerZStart = marker.z;
                }
            }
        } else if (button == 1) {
            if (marker != null && prevMarker == marker) {
                this.field_146297_k.func_147108_a((GuiScreen)new MwGuiMarkerDialog(this, this.mw.markerManager, marker));
            } else if (marker == null) {
                int mz;
                int my;
                int mx;
                String group = this.mw.markerManager.getVisibleGroupName();
                if (group.equals("none")) {
                    group = "group";
                }
                if (this.isPlayerNearScreenPos(x, y)) {
                    mx = this.mw.playerXInt;
                    my = this.mw.playerYInt;
                    mz = this.mw.playerZInt;
                } else {
                    mx = this.mouseBlockX;
                    my = this.mouseBlockY > 0 ? this.mouseBlockY : this.mw.defaultTeleportHeight;
                    mz = this.mouseBlockZ;
                }
                if (this.mw.newMarkerDialog) {
                    this.field_146297_k.func_147108_a((GuiScreen)new MwGuiMarkerDialogNew(this, this.mw.markerManager, "", group, mx, my, mz, this.mapView.getDimension()));
                } else {
                    this.field_146297_k.func_147108_a((GuiScreen)new MwGuiMarkerDialog(this, this.mw.markerManager, "", group, mx, my, mz, this.mapView.getDimension()));
                }
            }
        } else if (button == 2) {
            Point blockPoint = this.mapMode.screenXYtoBlockXZ(this.mapView, x, y);
            IMwDataProvider provider = MwAPI.getCurrentDataProvider();
            if (provider != null) {
                provider.onMiddleClick(this.mapView.getDimension(), blockPoint.x, blockPoint.y, this.mapView);
            }
        }
        this.viewXStart = this.mapView.getX();
        this.viewZStart = this.mapView.getZ();
    }

    protected void func_146286_b(int x, int y, int button) {
        if (button == 0) {
            this.mouseLeftHeld = 0;
            this.movingMarker = null;
        } else if (button == 1) {
            // empty if block
        }
    }

    public void mouseDWheelScrolled(int x, int y, int direction) {
        Marker marker = this.getMarkerNearScreenPos(x, y);
        if (marker != null && marker == this.mw.markerManager.selectedMarker) {
            if (direction > 0) {
                marker.colourNext();
            } else {
                marker.colourPrev();
            }
        } else if (this.dimensionLabel.posWithin(x, y)) {
            int n = direction > 0 ? 1 : -1;
            this.mapView.nextDimension(this.mw.dimensionList, n);
        } else if (this.groupLabel.posWithin(x, y)) {
            int n = direction > 0 ? 1 : -1;
            this.mw.markerManager.nextGroup(n);
            this.mw.markerManager.update();
        } else if (this.overlayLabel.posWithin(x, y)) {
            int n;
            int n2 = n = direction > 0 ? 1 : -1;
            if (MwAPI.getCurrentDataProvider() != null) {
                MwAPI.getCurrentDataProvider().onOverlayDeactivated(this.mapView);
            }
            if (n == 1) {
                MwAPI.setNextProvider();
            } else {
                MwAPI.setPrevProvider();
            }
            if (MwAPI.getCurrentDataProvider() != null) {
                MwAPI.getCurrentDataProvider().onOverlayActivated(this.mapView);
            }
        } else {
            int zF = direction > 0 ? -1 : 1;
            this.mapView.zoomToPoint(this.mapView.getZoomLevel() + zF, this.mouseBlockX, this.mouseBlockZ);
        }
    }

    public void func_73876_c() {
        if (this.exit > 0) {
            ++this.exit;
        }
        if (this.exit > 2) {
            this.exitGui();
        }
        super.func_73876_c();
    }

    public void drawStatus(int bX, int bY, int bZ) {
        IMwDataProvider provider;
        String s = bY != 0 ? String.format("cursor: (%d, %d, %d)", bX, bY, bZ) : String.format("cursor: (%d, ?, %d)", bX, bZ);
        if (this.field_146297_k.field_71441_e != null && !this.field_146297_k.field_71441_e.func_72938_d(bX, bZ).func_76621_g()) {
            s = s + String.format(", biome: %s", this.field_146297_k.field_71441_e.func_72807_a((int)bX, (int)bZ).field_76791_y);
        }
        if ((provider = MwAPI.getCurrentDataProvider()) != null) {
            s = s + provider.getStatusString(this.mapView.getDimension(), bX, bY, bZ);
        }
        MwGui.func_73734_a((int)10, (int)(this.field_146295_m - 21), (int)(this.field_146294_l - 20), (int)(this.field_146295_m - 6), (int)Integer.MIN_VALUE);
        this.func_73732_a(this.field_146289_q, s, this.field_146294_l / 2, this.field_146295_m - 18, 0xFFFFFF);
    }

    public void drawHelp() {
        MwGui.func_73734_a((int)10, (int)20, (int)(this.field_146294_l - 20), (int)(this.field_146295_m - 30), (int)Integer.MIN_VALUE);
        this.field_146289_q.func_78279_b("Keys:\n\n  Space\n  Delete\n  C\n  Home\n  End\n  N\n  T\n  P\n  R\n  U\n\nLeft click drag or arrow keys pan the map.\nMouse wheel or Page Up/Down zooms map.\nRight click map to create a new marker.\nLeft click drag a selected marker to move it.\nMouse wheel over selected marker to cycle colour.\nMouse wheel over dimension or group box to cycle.\n", 15, 24, this.field_146294_l - 30, 0xFFFFFF);
        this.field_146289_q.func_78279_b("| Next marker group\n| Delete selected marker\n| Cycle selected marker colour\n| Centre map on player\n| Centre map on selected marker\n| Select next marker\n| Teleport to cursor or selected marker\n| Save PNG of visible map area\n| Regenerate visible map area from region files\n| Underground map mode\n", 75, 42, this.field_146294_l - 90, 0xFFFFFF);
    }

    public void drawMouseOverHint(int x, int y, String title, int mX, int mY, int mZ) {
        String desc = String.format("(%d, %d, %d)", mX, mY, mZ);
        int stringW = Math.max(this.field_146289_q.func_78256_a(title), this.field_146289_q.func_78256_a(desc));
        x = Math.min(x, this.field_146294_l - (stringW + 16));
        y = Math.min(Math.max(10, y), this.field_146295_m - 14);
        MwGui.func_73734_a((int)(x + 8), (int)(y - 10), (int)(x + stringW + 16), (int)(y + 14), (int)Integer.MIN_VALUE);
        this.func_73731_b(this.field_146289_q, title, x + 10, y - 8, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, desc, x + 10, y + 4, 0xCCCCCC);
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        double xOffset = 0.0;
        double yOffset = 0.0;
        if (this.mouseLeftHeld > 2) {
            xOffset = (double)(this.mouseLeftDragStartX - mouseX) * this.mapView.getWidth() / (double)this.mapMode.w;
            yOffset = (double)(this.mouseLeftDragStartY - mouseY) * this.mapView.getHeight() / (double)this.mapMode.h;
            if (this.movingMarker != null) {
                double scale = this.mapView.getDimensionScaling(this.movingMarker.dimension);
                this.movingMarker.x = this.movingMarkerXStart - (int)(xOffset / scale);
                this.movingMarker.z = this.movingMarkerZStart - (int)(yOffset / scale);
            } else {
                this.mapView.setViewCentre(this.viewXStart + xOffset, this.viewZStart + yOffset);
            }
        }
        if (this.mouseLeftHeld > 0) {
            ++this.mouseLeftHeld;
        }
        this.map.draw();
        Point p = this.mapMode.screenXYtoBlockXZ(this.mapView, mouseX, mouseY);
        this.mouseBlockX = p.x;
        this.mouseBlockZ = p.y;
        this.mouseBlockY = this.getHeightAtBlockPos(this.mouseBlockX, this.mouseBlockZ);
        Marker marker = this.getMarkerNearScreenPos(mouseX, mouseY);
        if (marker != null) {
            this.drawMouseOverHint(mouseX, mouseY, marker.name, marker.x, marker.y, marker.z);
        }
        if (this.isPlayerNearScreenPos(mouseX, mouseY)) {
            this.drawMouseOverHint(mouseX, mouseY, this.field_146297_k.field_71439_g.getDisplayName(), this.mw.playerXInt, this.mw.playerYInt, this.mw.playerZInt);
        }
        this.drawStatus(this.mouseBlockX, this.mouseBlockY, this.mouseBlockZ);
        this.helpLabel.draw(5, 5, "[help]");
        this.optionsLabel.drawToRightOf(this.helpLabel, "[options]");
        String dimString = String.format("[dimension: %d]", this.mapView.getDimension());
        this.dimensionLabel.drawToRightOf(this.optionsLabel, dimString);
        String groupString = String.format("[group: %s]", this.mw.markerManager.getVisibleGroupName());
        this.groupLabel.drawToRightOf(this.dimensionLabel, groupString);
        String overlayString = String.format("[overlay : %s]", MwAPI.getCurrentProviderName());
        this.overlayLabel.drawToRightOf(this.groupLabel, overlayString);
        if (this.helpLabel.posWithin(mouseX, mouseY)) {
            this.drawHelp();
        }
        super.func_73863_a(mouseX, mouseY, f);
    }

    class Label {
        int x = 0;
        int y = 0;
        int w = 1;
        int h = 12;

        public void draw(int x, int y, String s) {
            this.x = x;
            this.y = y;
            this.w = MwGui.this.field_146289_q.func_78256_a(s) + 4;
            MwGui.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.w), (int)(this.y + this.h), (int)Integer.MIN_VALUE);
            MwGui.this.func_73731_b(MwGui.this.field_146289_q, s, this.x + 2, this.y + 2, 0xFFFFFF);
        }

        public void drawToRightOf(Label label, String s) {
            this.draw(label.x + label.w + 5, label.y, s);
        }

        public boolean posWithin(int x, int y) {
            return x >= this.x && y >= this.y && x <= this.x + this.w && y <= this.y + this.h;
        }
    }
}

