/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.util;

import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mapwriter.config.Config;
import mapwriter.util.Logging;
import mapwriter.util.Reference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.chunk.Chunk;

public class Utils {
    public static String RealmsWorldName = "";
    private static int[] colours = new int[]{0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0xFF8000, 0x8000FF};
    public static int colourIndex = 0;

    public static int[] integerListToIntArray(List<Integer> list) {
        int size = list.size();
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static String mungeString(String s) {
        s = s.replace('.', '_');
        s = s.replace('-', '_');
        s = s.replace(' ', '_');
        s = s.replace('/', '_');
        s = s.replace('\\', '_');
        return Reference.patternInvalidChars.matcher(s).replaceAll("");
    }

    public static String mungeStringForConfig(String s) {
        return Reference.patternInvalidChars2.matcher(s).replaceAll("");
    }

    public static File getFreeFilename(File dir, String baseName, String ext) {
        int i;
        File outputFile = dir != null ? new File(dir, baseName + "." + ext) : new File(baseName + "." + ext);
        for (i = 0; outputFile.exists() && i < 1000; ++i) {
            outputFile = dir != null ? new File(dir, baseName + "." + i + "." + ext) : new File(baseName + "." + i + "." + ext);
        }
        return i < 1000 ? outputFile : null;
    }

    public static void printBoth(String msg) {
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (thePlayer != null) {
            thePlayer.func_145747_a((ITextComponent)new TextComponentString(msg));
        }
        Logging.log("%s", msg);
    }

    public static File getDimensionDir(File worldDir, int dimension) {
        File dimDir = dimension != 0 ? new File(worldDir, "DIM" + dimension) : worldDir;
        return dimDir;
    }

    public static IntBuffer allocateDirectIntBuffer(int size) {
        if (size < 1) {
            int NewSize = Minecraft.func_71369_N();
            return ByteBuffer.allocateDirect(NewSize * NewSize * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        }
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public static int nextHighestPowerOf2(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return v + 1;
    }

    public static String getCurrentDateString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmm");
        return dateFormat.format(new Date());
    }

    public static int distToChunkSq(int x, int z, Chunk chunk) {
        int dx = (chunk.field_76635_g << 4) + 8 - x;
        int dz = (chunk.field_76647_h << 4) + 8 - z;
        return dx * dx + dz * dz;
    }

    public static String getWorldName() {
        String worldName;
        if (Minecraft.func_71410_x().func_71387_A()) {
            IntegratedServer server = Minecraft.func_71410_x().func_71401_C();
            worldName = server != null ? server.func_71270_I() : "sp_world";
        } else if (Minecraft.func_71410_x().func_181540_al()) {
            worldName = RealmsWorldName != "" ? RealmsWorldName : "Realms";
        } else {
            worldName = Minecraft.func_71410_x().func_147104_D().field_78845_b;
            worldName = !Config.portNumberInWorldNameEnabled ? worldName.substring(0, worldName.indexOf(":")) : (worldName.indexOf(":") == -1 ? worldName + "_25565" : worldName.replace(":", "_"));
        }
        worldName = Utils.mungeString(worldName);
        if (worldName == "") {
            worldName = "default";
        }
        return worldName;
    }

    public static void openWebLink(URI p_175282_1_) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, p_175282_1_);
        }
        catch (Throwable throwable) {
            Logging.logError("Couldn't open link %s", throwable.getStackTrace().toString());
        }
    }

    public static String stringArrayToString(String[] arr) {
        StringBuilder builder = new StringBuilder();
        for (String s : arr) {
            builder.append(I18n.func_135052_a((String)s, (Object[])new Object[0]));
            builder.append("\n");
        }
        return builder.toString();
    }

    public static int getMaxWidth(String[] arr, String[] arr2) {
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        int Width = 1;
        for (int i = 0; i < arr.length; ++i) {
            String s;
            int w1 = 0;
            int w2 = 0;
            if (i < arr.length) {
                s = I18n.func_135052_a((String)arr[i], (Object[])new Object[0]);
                w1 = fontRendererObj.func_78256_a(s);
            }
            if (arr2 != null && i < arr2.length) {
                s = I18n.func_135052_a((String)arr2[i], (Object[])new Object[0]);
                w2 = fontRendererObj.func_78256_a(s);
                w2 += 65;
            }
            int wTot = w1 > w2 ? w1 : w2;
            Width = Width > wTot ? Width : wTot;
        }
        return Width;
    }

    private static int getColoursLengt() {
        return colours.length;
    }

    public static int getCurrentColour() {
        return 0xFF000000 | colours[colourIndex];
    }

    public static int getNextColour() {
        colourIndex = (colourIndex + 1) % Utils.getColoursLengt();
        return Utils.getCurrentColour();
    }

    public static int getPrevColour() {
        colourIndex = (colourIndex + Utils.getColoursLengt() - 1) % Utils.getColoursLengt();
        return Utils.getCurrentColour();
    }

    public static <K, V> Map<K, V> checkedMapByCopy(Map rawMap, Class<K> keyType, Class<V> valueType, boolean strict) throws ClassCastException {
        HashMap<K, V> m2 = new HashMap<K, V>(rawMap.size() * 4 / 3 + 1);
        for (Map.Entry e : rawMap.entrySet()) {
            try {
                m2.put(keyType.cast(e.getKey()), valueType.cast(e.getValue()));
            }
            catch (ClassCastException x) {
                if (strict) {
                    throw x;
                }
                System.out.println("not assignable");
            }
        }
        return m2;
    }
}

