/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.furnus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mrriegel.furnus.CraftingRecipes;
import mrriegel.furnus.block.ModBlocks;
import mrriegel.furnus.handler.ConfigurationHandler;
import mrriegel.furnus.handler.CrunchHandler;
import mrriegel.furnus.handler.GuiHandler;
import mrriegel.furnus.handler.PacketHandler;
import mrriegel.furnus.item.ItemDust;
import mrriegel.furnus.item.ModItems;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

@Mod(modid="furnus", name="Furnus", version="1.75", acceptedMinecraftVersions="[1.9]")
public class Furnus {
    public static final String MODID = "furnus";
    public static final String VERSION = "1.75";
    public static final String MODNAME = "Furnus";
    @Mod.Instance(value="furnus")
    public static Furnus instance;
    private List<Recipe> recipes;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        File configFile = event.getSuggestedConfigurationFile();
        ConfigurationHandler.config = new Configuration(configFile);
        ConfigurationHandler.config.load();
        ConfigurationHandler.refreshConfig();
        PacketHandler.init();
        File questFile = new File(event.getModConfigurationDirectory(), "furnus_recipes.json");
        if (!questFile.exists()) {
            questFile.createNewFile();
            FileWriter fw = new FileWriter(questFile);
            ArrayList<Recipe> lis = new ArrayList<Recipe>();
            lis.add(new Recipe("cobblestone:1", "minecraft:gravel:0:1", 0.1f));
            lis.add(new Recipe("minecraft:gravel:0:1", "minecraft:sand:0:1", 0.1f));
            lis.add(new Recipe("stone:1", "cobblestone:1", 0.1f));
            lis.add(new Recipe("minecraft:stonebrick:-1:1", "cobblestone:1", 0.1f));
            lis.add(new Recipe("oreQuartz:1", "gemQuartz:3", 0.3f));
            lis.add(new Recipe("denseoreQuartz:1", "gemQuartz:9", 0.9f));
            lis.add(new Recipe("oreCoal:1", "minecraft:coal:0:3", 0.3f));
            lis.add(new Recipe("oreNetherCoal:1", "minecraft:coal:0:6", 0.6f));
            lis.add(new Recipe("denseoreCoal:1", "minecraft:coal:0:9", 0.9f));
            lis.add(new Recipe("oreLapis:1", "gemLapis:8", 0.3f));
            lis.add(new Recipe("oreNetherLapis:1", "gemLapis:16", 0.6f));
            lis.add(new Recipe("denseoreLapis:1", "gemLapis:24", 0.9f));
            lis.add(new Recipe("denseoreDiamond:1", "gemDiamond:6", 3.0f));
            lis.add(new Recipe("oreRedstone:1", "dustRedstone:8", 0.3f));
            lis.add(new Recipe("oreNetherRedstone:1", "dustRedstone:16", 0.6f));
            lis.add(new Recipe("denseoreRedstone:1", "dustRedstone:24", 0.9f));
            lis.add(new Recipe("denseoreEmerald:1", "gemEmerald:6", 3.0f));
            lis.add(new Recipe("minecraft:quartz_block:-1:1", "gemQuartz:4", 0.3f));
            lis.add(new Recipe("glowstone:1", "dustGlowstone:4", 0.3f));
            lis.add(new Recipe("minecraft:blaze_rod:0:1", "minecraft:blaze_powder:0:4", 0.4f));
            lis.add(new Recipe("minecraft:bone:0:1", "minecraft:dye:15:6", 0.1f));
            lis.add(new Recipe("minecraft:wool:-1:1", "minecraft:string:0:4", 0.1f));
            lis.add(new Recipe("minecraft:red_flower:0:1", "minecraft:dye:1:3", 0.1f));
            lis.add(new Recipe("minecraft:red_flower:4:1", "minecraft:dye:1:3", 0.1f));
            lis.add(new Recipe("minecraft:red_flower:3:1", "minecraft:dye:7:3", 0.1f));
            lis.add(new Recipe("minecraft:red_flower:6:1", "minecraft:dye:7:3", 0.1f));
            lis.add(new Recipe("minecraft:red_flower:8:1", "minecraft:dye:7:3", 0.1f));
            lis.add(new Recipe("minecraft:red_flower:7:1", "minecraft:dye:9:3", 0.1f));
            lis.add(new Recipe("minecraft:yellow_flower:0:1", "minecraft:dye:11:3", 0.1f));
            lis.add(new Recipe("minecraft:red_flower:1:1", "minecraft:dye:12:3", 0.1f));
            lis.add(new Recipe("minecraft:red_flower:2:1", "minecraft:dye:13:3", 0.1f));
            lis.add(new Recipe("minecraft:red_flower:5:1", "minecraft:dye:14:3", 0.1f));
            fw.write(new GsonBuilder().setPrettyPrinting().create().toJson(lis));
            fw.close();
        }
        this.recipes = (List)new Gson().fromJson((Reader)new BufferedReader(new FileReader(questFile)), new TypeToken<List<Recipe>>(){}.getType());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        ModBlocks.init();
        ModItems.init();
        CraftingRecipes.init();
        if (event.getSide() == Side.CLIENT) {
            this.initModels();
        }
    }

    private void initModels() {
        int i;
        ItemModelMesher mesh = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        mesh.func_178086_a(Item.func_150898_a((Block)ModBlocks.furnus), 0, new ModelResourceLocation("furnus:furnus", "inventory"));
        mesh.func_178086_a(Item.func_150898_a((Block)ModBlocks.pulvus), 0, new ModelResourceLocation("furnus:pulvus", "inventory"));
        for (i = 0; i < 7; ++i) {
            ModelBakery.registerItemVariants((Item)ModItems.upgrade, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("furnus:upgrade_" + i)});
            mesh.func_178086_a(ModItems.upgrade, i, new ModelResourceLocation("furnus:upgrade_" + i, "inventory"));
        }
        for (i = 0; i < ItemDust.Dust.values().length; ++i) {
            ModelBakery.registerItemVariants((Item)ModItems.dust, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("furnus:dust_" + ItemDust.Dust.values()[i].toString().toLowerCase())});
            mesh.func_178086_a(ModItems.dust, i, new ModelResourceLocation("furnus:dust_" + ItemDust.Dust.values()[i].toString().toLowerCase(), "inventory"));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (Recipe r : this.recipes) {
            ArrayList<ItemStack> inl = new ArrayList<ItemStack>();
            ArrayList<ItemStack> outl = new ArrayList<ItemStack>();
            if (this.string2Stack(r.inputItem) != null) {
                inl.add(this.string2Stack(r.inputItem));
            } else {
                inl.addAll(this.oreName2Stacklist(r.inputItem));
            }
            if (this.string2Stack(r.outputItem) != null) {
                outl.add(this.string2Stack(r.outputItem));
            } else if (!this.oreName2Stacklist(r.outputItem).isEmpty()) {
                outl.add(this.oreName2Stacklist(r.outputItem).get(0));
            }
            for (ItemStack in : inl) {
                for (ItemStack out : outl) {
                    CrunchHandler.instance().addItemStack(in, out, r.experience);
                }
            }
        }
        List<String> black = Arrays.asList(ConfigurationHandler.blacklistDusts);
        for (String ore : OreDictionary.getOreNames()) {
            if (ore.startsWith("ore") && !OreDictionary.getOres((String)("dust" + ore.substring(3))).isEmpty() && !black.contains("dust" + ore.substring(3)) && !OreDictionary.getOres((String)ore).isEmpty()) {
                for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                    CrunchHandler.instance().addItemStack(stack, CrunchHandler.resize((ItemStack)OreDictionary.getOres((String)("dust" + ore.substring(3))).get(0), 2), 0.5f);
                }
            } else if (ore.startsWith("ore") && !OreDictionary.getOres((String)("gem" + ore.substring(3))).isEmpty() && !black.contains("gem" + ore.substring(3)) && !OreDictionary.getOres((String)ore).isEmpty()) {
                for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                    CrunchHandler.instance().addItemStack(stack, CrunchHandler.resize((ItemStack)OreDictionary.getOres((String)("gem" + ore.substring(3))).get(0), 2), 0.4f);
                }
            }
            if (ore.startsWith("oreNether") && !OreDictionary.getOres((String)("dust" + ore.substring(9))).isEmpty() && !black.contains("dust" + ore.substring(9)) && !OreDictionary.getOres((String)ore).isEmpty()) {
                for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                    CrunchHandler.instance().addItemStack(stack, CrunchHandler.resize((ItemStack)OreDictionary.getOres((String)("dust" + ore.substring(9))).get(0), 4), 1.0f);
                }
            }
            if (ore.startsWith("oreNether") && !OreDictionary.getOres((String)("gem" + ore.substring(9))).isEmpty() && !black.contains("gem" + ore.substring(9)) && !OreDictionary.getOres((String)ore).isEmpty()) {
                for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                    CrunchHandler.instance().addItemStack(stack, CrunchHandler.resize((ItemStack)OreDictionary.getOres((String)("gem" + ore.substring(9))).get(0), 4), 1.2f);
                }
                continue;
            }
            if (ore.startsWith("denseore") && !OreDictionary.getOres((String)("dust" + ore.substring(8))).isEmpty() && !black.contains("dust" + ore.substring(8)) && !OreDictionary.getOres((String)ore).isEmpty()) {
                for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                    CrunchHandler.instance().addItemStack(stack, CrunchHandler.resize((ItemStack)OreDictionary.getOres((String)("dust" + ore.substring(8))).get(0), 6), 2.0f);
                }
                continue;
            }
            if (ore.startsWith("denseore") && !OreDictionary.getOres((String)("gem" + ore.substring(8))).isEmpty() && !black.contains("gem" + ore.substring(8)) && !OreDictionary.getOres((String)ore).isEmpty()) {
                for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                    CrunchHandler.instance().addItemStack(stack, CrunchHandler.resize((ItemStack)OreDictionary.getOres((String)("gem" + ore.substring(8))).get(0), 6), 2.0f);
                }
                continue;
            }
            if (!ore.startsWith("ingot") || OreDictionary.getOres((String)("dust" + ore.substring(5))).isEmpty() || black.contains("dust" + ore.substring(5)) || OreDictionary.getOres((String)ore).isEmpty()) continue;
            for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                CrunchHandler.instance().addItemStack(stack, (ItemStack)OreDictionary.getOres((String)("dust" + ore.substring(5))).get(0), 0.1f);
            }
        }
    }

    private ItemStack string2Stack(String s) {
        Item tmp;
        ItemStack stack = null;
        if (StringUtils.countMatches((CharSequence)s, (CharSequence)":") == 3 && (tmp = GameRegistry.findItem((String)s.split(":")[0], (String)s.split(":")[1])) != null) {
            stack = new ItemStack(tmp, Integer.valueOf(s.split(":")[3]).intValue(), Integer.valueOf(s.split(":")[2]) == -1 ? Short.MAX_VALUE : Integer.valueOf(s.split(":")[2]));
        }
        if (stack == null) {
            return null;
        }
        return stack.func_77946_l();
    }

    private List<ItemStack> oreName2Stacklist(String s) {
        ArrayList<ItemStack> lis = new ArrayList<ItemStack>();
        if (StringUtils.countMatches((CharSequence)s, (CharSequence)":") == 1 && !OreDictionary.getOres((String)s.split(":")[0]).isEmpty()) {
            for (ItemStack ore : OreDictionary.getOres((String)s.split(":")[0])) {
                ItemStack stack = ore.func_77946_l();
                stack.field_77994_a = Integer.valueOf(s.split(":")[1]);
                lis.add(stack);
            }
        }
        return lis;
    }

    private class Recipe {
        String inputItem;
        String outputItem;
        float experience;

        public Recipe(String in, String out, float exp) {
            this.inputItem = in;
            this.outputItem = out;
            this.experience = exp;
        }
    }
}

