/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.furnus.block;

import com.google.common.base.Predicate;
import java.util.Random;
import mrriegel.furnus.CreativeTab;
import mrriegel.furnus.block.AbstractMachine;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractBlock
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool STATE = PropertyBool.func_177716_a((String)"state");

    public AbstractBlock() {
        super(Material.field_151576_e);
        this.func_149711_c(4.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)STATE, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(CreativeTab.tab1);
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState func_176217_b(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(meta % 6));
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)STATE, (Comparable)Boolean.valueOf(meta > 5));
    }

    public int func_176201_c(IBlockState state) {
        int p = (Boolean)state.func_177229_b((IProperty)STATE) != false ? 0 : 6;
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + p;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING, STATE});
    }

    public void setState(World world, BlockPos pos, IBlockState state, boolean on) {
        TileEntity tileentity = world.func_175625_s(pos);
        world.func_180501_a(pos, state.func_177226_a((IProperty)STATE, (Comparable)Boolean.valueOf(on)), 2);
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_175690_a(pos, tileentity);
        }
        world.func_175689_h(pos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            Block block = worldIn.func_180495_p(pos.func_177978_c()).func_177230_c();
            Block block1 = worldIn.func_180495_p(pos.func_177968_d()).func_177230_c();
            Block block2 = worldIn.func_180495_p(pos.func_177976_e()).func_177230_c();
            Block block3 = worldIn.func_180495_p(pos.func_177974_f()).func_177230_c();
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_149730_j() && !block1.func_149730_j()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_149730_j() && !block.func_149730_j()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_149730_j() && !block3.func_149730_j()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_149730_j() && !block2.func_149730_j()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
            worldIn.func_175689_h(pos);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)STATE, (Comparable)Boolean.valueOf(false));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)STATE, (Comparable)Boolean.valueOf(false)), 2);
        worldIn.func_175689_h(pos);
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)STATE) != false ? 13 : 0;
    }

    public int func_149645_b() {
        return 3;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_175625_s(pos) instanceof AbstractMachine) {
            AbstractMachine tileentity = (AbstractMachine)worldIn.func_175625_s(pos);
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)tileentity);
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.func_175625_s(pos) instanceof AbstractMachine && ((Boolean)state.func_177229_b((IProperty)STATE)).booleanValue()) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            AbstractMachine tile = (AbstractMachine)worldIn.func_175625_s(pos);
            block6: for (int i = 0; i < tile.getSpeed() + 1; ++i) {
                switch (enumfacing) {
                    case WEST: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        continue block6;
                    }
                    case EAST: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        continue block6;
                    }
                    case NORTH: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                        continue block6;
                    }
                    case SOUTH: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }
}

