/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.furnus;

import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class InventoryHelper {
    public static boolean insert(IInventory inv, ItemStack is, boolean simulate) {
        int space;
        ItemStack in;
        int slot;
        int i;
        ItemStack stack = is.func_77946_l();
        Integer[] slots = InventoryHelper.getSlotsWith(inv, stack.func_77973_b(), stack.func_77952_i());
        int empty = InventoryHelper.findEmptySlot(inv);
        int max = Math.min(inv.func_70297_j_(), stack.func_77976_d());
        int addable = 0;
        ArrayList<Integer> validslots = new ArrayList<Integer>();
        for (i = 0; i < slots.length && stack.field_77994_a > 0; ++i) {
            slot = slots[i];
            if (!inv.func_94041_b(slot, stack) || !InventoryHelper.areStacksEqual(stack, in = inv.func_70301_a(slot), true)) continue;
            space = Math.min(max - in.field_77994_a, stack.field_77994_a);
            addable += space;
            validslots.add(slot);
        }
        if (empty != -1) {
            addable += stack.func_77976_d();
        }
        if (addable < stack.field_77994_a) {
            return false;
        }
        for (i = 0; i < validslots.size() && stack.field_77994_a > 0; ++i) {
            slot = (Integer)validslots.get(i);
            in = inv.func_70301_a(slot);
            space = Math.min(max - in.field_77994_a, stack.field_77994_a);
            if (!simulate) {
                in.field_77994_a += space;
            }
            stack.field_77994_a -= space;
        }
        if (stack.field_77994_a <= 0) {
            return true;
        }
        if (empty != -1) {
            if (!simulate) {
                inv.func_70299_a(empty, stack.func_77946_l());
            }
            return true;
        }
        return false;
    }

    public static int addToInventoryWithLeftover(ItemStack stack, IInventory inventory, boolean simulate) {
        ItemStack in;
        int i;
        int left = stack.field_77994_a;
        int max = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            int space;
            int add;
            in = inventory.func_70301_a(i);
            if (!inventory.func_94041_b(i, stack) || in == null || !stack.func_77969_a(in) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)in) || (add = Math.min(space = max - in.field_77994_a, stack.field_77994_a)) <= 0) continue;
            if (!simulate) {
                in.field_77994_a += add;
            }
            if ((left -= add) > 0) continue;
            return 0;
        }
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            in = inventory.func_70301_a(i);
            if (!inventory.func_94041_b(i, stack) || in != null) continue;
            int add = Math.min(max, left);
            if (!simulate) {
                inventory.func_70299_a(i, InventoryHelper.copyStack(stack, add));
            }
            if ((left -= add) > 0) continue;
            return 0;
        }
        return left;
    }

    public static int addToSidedInventoryWithLeftover(ItemStack stack, ISidedInventory inventory, EnumFacing side, boolean simulate) {
        ItemStack in;
        int left = stack.field_77994_a;
        int max = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        if (inventory.func_180463_a(side) == null) {
            return left;
        }
        for (int i : inventory.func_180463_a(side)) {
            int space;
            int add;
            in = inventory.func_70301_a(i);
            if (!inventory.func_94041_b(i, stack) || !inventory.func_180462_a(i, stack, side) || in == null || !stack.func_77969_a(in) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)in) || (add = Math.min(space = max - in.field_77994_a, stack.field_77994_a)) <= 0) continue;
            if (!simulate) {
                in.field_77994_a += add;
            }
            if ((left -= add) > 0) continue;
            return 0;
        }
        for (int i : inventory.func_180463_a(side)) {
            in = inventory.func_70301_a(i);
            if (!inventory.func_94041_b(i, stack) || !inventory.func_180462_a(i, stack, side) || in != null) continue;
            int add = Math.min(max, left);
            if (!simulate) {
                inventory.func_70299_a(i, InventoryHelper.copyStack(stack, add));
            }
            if ((left -= add) > 0) continue;
            return 0;
        }
        return left;
    }

    private static int findEmptySlot(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_() - (inv instanceof InventoryPlayer ? 4 : 0); ++i) {
            ItemStack is = inv.func_70301_a(i);
            if (is == null) {
                return i;
            }
            if (is.field_77994_a > 0) continue;
            is = null;
            return i;
        }
        return -1;
    }

    public static ItemStack copyStack(ItemStack stack, int size) {
        if (stack == null) {
            return null;
        }
        ItemStack tmp = stack.func_77946_l();
        tmp.field_77994_a = size;
        return tmp;
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2, boolean tags) {
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (!tags) {
            return stack1.func_77969_a(stack2);
        }
        return stack1.func_77969_a(stack2) && (stack1.func_77978_p() == null && stack2.func_77978_p() == null || stack1.func_77978_p() != null && stack2.func_77978_p() != null && stack1.func_77978_p().equals((Object)stack2.func_77978_p()));
    }

    public static boolean decrStackSize(IInventory inv, int slot, int num) {
        ItemStack stack = inv.func_70301_a(slot).func_77946_l();
        if (stack == null || stack.field_77994_a < num) {
            return false;
        }
        if (stack.field_77994_a == num) {
            inv.func_70299_a(slot, null);
            inv.func_70296_d();
            return true;
        }
        stack.field_77994_a -= num;
        inv.func_70299_a(slot, stack);
        inv.func_70296_d();
        return true;
    }

    public static boolean incrStackSize(IInventory inv, int slot, int num) {
        ItemStack stack = inv.func_70301_a(slot);
        if (stack == null || stack.field_77994_a + num > stack.func_77976_d()) {
            return false;
        }
        stack.field_77994_a += num;
        inv.func_70299_a(slot, stack);
        inv.func_70296_d();
        return true;
    }

    public static boolean incrStackInSlot(IInventory inv, int slot, ItemStack stack) {
        if (InventoryHelper.incrStackSize(inv, slot, stack.field_77994_a)) {
            return true;
        }
        if (InventoryHelper.canFillSlot(inv, slot, stack)) {
            inv.func_70299_a(slot, stack);
            return true;
        }
        return false;
    }

    public static boolean canFillSlot(IInventory inv, int slot, ItemStack stack) {
        if (inv.func_70301_a(slot) == null) {
            return true;
        }
        if (!InventoryHelper.areStacksEqual(stack, inv.func_70301_a(slot), true)) {
            return false;
        }
        return inv.func_70301_a((int)slot).field_77994_a + stack.field_77994_a <= stack.func_77976_d();
    }

    public static Integer[] getSlotsWith(IInventory inv, Item item, int meta) {
        ArrayList<Integer> ar = new ArrayList<Integer>();
        for (int i = 0; i < inv.func_70302_i_() - (inv instanceof InventoryPlayer ? 4 : 0); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !stack.func_77973_b().equals(item) || stack.func_77952_i() != meta && meta != Short.MAX_VALUE) continue;
            ar.add(i);
        }
        return ar.toArray(new Integer[ar.size()]);
    }

    public static Integer[] getSlotsWith(ItemStack[] inv, Item item, int meta) {
        ArrayList<Integer> ar = new ArrayList<Integer>();
        for (int i = 0; i < inv.length; ++i) {
            ItemStack stack = inv[i];
            if (stack == null || !stack.func_77973_b().equals(item) || stack.func_77952_i() != meta && meta != Short.MAX_VALUE) continue;
            ar.add(i);
        }
        return ar.toArray(new Integer[ar.size()]);
    }
}

