/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.furnus.block;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mrriegel.furnus.InvHelper;
import mrriegel.furnus.block.AbstractBlock;
import mrriegel.furnus.block.CrunchTEInventory;
import mrriegel.furnus.handler.ConfigHandler;
import mrriegel.furnus.handler.PacketHandler;
import mrriegel.furnus.message.ProgressMessage;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.item.IExoflameHeatable;

public abstract class AbstractMachine
extends CrunchTEInventory
implements ISidedInventory,
ITickable,
IExoflameHeatable,
IEnergyReceiver {
    protected boolean burning;
    protected boolean eco;
    protected boolean inout;
    protected boolean split;
    protected boolean rf;
    protected int speed;
    protected int effi;
    protected int slots;
    protected int bonus;
    protected int xp;
    protected int fuel;
    protected int maxFuel;
    protected int remainTicks;
    protected Map<Direction, Mode> input;
    protected Map<Direction, Mode> output;
    protected Map<Direction, Mode> fuelput;
    protected Map<Integer, Integer> progress;
    public EnergyStorage en = new EnergyStorage(64000, 0x7FFFFFF5, 0);

    protected AbstractMachine(int size) {
        super(size);
    }

    protected AbstractMachine() {
        super(15);
        this.input = new HashMap<Direction, Mode>();
        this.output = new HashMap<Direction, Mode>();
        this.fuelput = new HashMap<Direction, Mode>();
        for (Direction f : Direction.values()) {
            this.input.put(f, Mode.X);
            this.output.put(f, Mode.X);
            this.fuelput.put(f, Mode.X);
        }
        this.input.put(Direction.TOP, Mode.ENABLED);
        for (Direction f : Direction.values()) {
            if (f == Direction.TOP || f == Direction.BOTTOM) continue;
            this.fuelput.put(f, Mode.ENABLED);
        }
        this.output.put(Direction.BOTTOM, Mode.ENABLED);
        this.progress = new HashMap<Integer, Integer>();
        for (int i = 0; i < 3; ++i) {
            this.progress.put(i, 0);
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    protected void readSyncableDataFromNBT(NBTTagCompound tag) {
        this.burning = tag.func_74767_n("burning");
        this.eco = tag.func_74767_n("eco");
        this.inout = tag.func_74767_n("inout");
        this.split = tag.func_74767_n("split");
        this.rf = tag.func_74767_n("rf");
        this.speed = tag.func_74762_e("speed");
        this.effi = tag.func_74762_e("effi");
        this.slots = tag.func_74762_e("slot");
        this.bonus = tag.func_74762_e("bonus");
        this.xp = tag.func_74762_e("xp");
        this.fuel = tag.func_74762_e("fuel");
        this.maxFuel = tag.func_74762_e("maxFuel");
        this.remainTicks = tag.func_74762_e("remainTicks");
        this.input = (Map)new Gson().fromJson(tag.func_74779_i("input"), new TypeToken<Map<Direction, Mode>>(){}.getType());
        this.output = (Map)new Gson().fromJson(tag.func_74779_i("output"), new TypeToken<Map<Direction, Mode>>(){}.getType());
        this.fuelput = (Map)new Gson().fromJson(tag.func_74779_i("fuelput"), new TypeToken<Map<Direction, Mode>>(){}.getType());
        this.progress = (Map)new Gson().fromJson(tag.func_74779_i("progress"), new TypeToken<Map<Integer, Integer>>(){}.getType());
        this.en.readFromNBT(tag);
    }

    @Override
    protected void writeSyncableDataToNBT(NBTTagCompound tag) {
        tag.func_74757_a("burning", this.burning);
        tag.func_74757_a("eco", this.eco);
        tag.func_74757_a("inout", this.inout);
        tag.func_74757_a("split", this.split);
        tag.func_74757_a("rf", this.rf);
        tag.func_74768_a("speed", this.speed);
        tag.func_74768_a("effi", this.effi);
        tag.func_74768_a("slot", this.slots);
        tag.func_74768_a("bonus", this.bonus);
        tag.func_74768_a("xp", this.xp);
        tag.func_74768_a("fuel", this.fuel);
        tag.func_74768_a("maxFuel", this.maxFuel);
        tag.func_74768_a("remainTicks", this.remainTicks);
        tag.func_74778_a("input", new Gson().toJson(this.input));
        tag.func_74778_a("output", new Gson().toJson(this.output));
        tag.func_74778_a("fuelput", new Gson().toJson(this.fuelput));
        tag.func_74778_a("progress", new Gson().toJson(this.progress));
        this.en.writeToNBT(tag);
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean burning) {
        this.burning = burning;
    }

    public boolean isEco() {
        return this.eco;
    }

    public void setEco(boolean eco) {
        this.eco = eco;
    }

    public boolean isInout() {
        return this.inout;
    }

    public void setInout(boolean inout) {
        this.inout = inout;
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public boolean isRf() {
        return this.rf;
    }

    public void setRf(boolean rf) {
        this.rf = rf;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getEffi() {
        return this.effi;
    }

    public void setEffi(int effi) {
        this.effi = effi;
    }

    public int getSlots() {
        return this.slots;
    }

    public void setSlots(int slots) {
        this.slots = slots;
    }

    public int getBonus() {
        return this.bonus;
    }

    public void setBonus(int bonus) {
        this.bonus = bonus;
    }

    public int getXp() {
        return this.xp;
    }

    public void setXp(int xp) {
        this.xp = xp;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public int getMaxFuel() {
        return this.maxFuel;
    }

    public int getRemainTicks() {
        return this.remainTicks;
    }

    public void setRemainTicks(int remainTicks) {
        this.remainTicks = remainTicks;
    }

    public void setMaxFuel(int maxFuel) {
        this.maxFuel = maxFuel;
    }

    public Map<Direction, Mode> getInput() {
        return this.input;
    }

    public void setInput(Map<Direction, Mode> input) {
        this.input = input;
    }

    public Map<Direction, Mode> getOutput() {
        return this.output;
    }

    public void setOutput(Map<Direction, Mode> output) {
        this.output = output;
    }

    public Map<Direction, Mode> getFuelput() {
        return this.fuelput;
    }

    public void setFuelput(Map<Direction, Mode> fuelput) {
        this.fuelput = fuelput;
    }

    public Map<Integer, Integer> getProgress() {
        return this.progress;
    }

    public void setProgress(Map<Integer, Integer> progress) {
        this.progress = progress;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (!this.inout) {
            return new int[0];
        }
        ArrayList<Integer> lis = new ArrayList<Integer>();
        Direction wrongSide = this.getWrongSide(side);
        if (this.input.get((Object)wrongSide) != Mode.X) {
            lis.addAll(this.getInputSlots());
        }
        if (this.output.get((Object)wrongSide) != Mode.X) {
            lis.addAll(this.getOutputSlots());
        }
        if (this.fuelput.get((Object)wrongSide) != Mode.X) {
            lis.add(9);
        }
        int[] end = new int[lis.size()];
        for (int i = 0; i < lis.size(); ++i) {
            end[i] = (Integer)lis.get(i);
        }
        return end;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        if (!this.inout) {
            return false;
        }
        if (!this.getInputSlots().contains(slot) && slot != 9) {
            return false;
        }
        Direction wrongSide = this.getWrongSide(side);
        if (this.input.get((Object)wrongSide) != Mode.X && this.getInputSlots().contains(slot)) {
            return this.func_94041_b(slot, stack);
        }
        if (this.fuelput.get((Object)wrongSide) != Mode.X && slot == 9) {
            return this.func_94041_b(slot, stack);
        }
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        if (!this.inout) {
            return false;
        }
        if (!this.getOutputSlots().contains(slot) && slot != 9) {
            return false;
        }
        Direction wrongSide = this.getWrongSide(side);
        if (this.output.get((Object)wrongSide) != Mode.X && this.getOutputSlots().contains(slot)) {
            return true;
        }
        return this.fuelput.get((Object)wrongSide) != Mode.X && slot == 9 && !TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return newSate.func_177230_c() != oldState.func_177230_c();
    }

    protected ArrayList<Integer> getOutputSlots() {
        if (this.slots == 2) {
            return new ArrayList<Integer>(Arrays.asList(3, 4, 5, 6, 7, 8));
        }
        if (this.slots == 1) {
            return new ArrayList<Integer>(Arrays.asList(3, 4, 6, 7));
        }
        return new ArrayList<Integer>(Arrays.asList(3, 6));
    }

    protected ArrayList<Integer> getInputSlots() {
        if (this.slots == 2) {
            return new ArrayList<Integer>(Arrays.asList(0, 1, 2));
        }
        if (this.slots == 1) {
            return new ArrayList<Integer>(Arrays.asList(0, 1));
        }
        return new ArrayList<Integer>(Arrays.asList(0));
    }

    protected boolean equalOreDict(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        int[] ar = OreDictionary.getOreIDs((ItemStack)a);
        int[] br = OreDictionary.getOreIDs((ItemStack)b);
        for (int i = 0; i < ar.length; ++i) {
            for (int j = 0; j < br.length; ++j) {
                if (ar[i] != br[j]) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public abstract boolean func_94041_b(int var1, ItemStack var2);

    public void updateStats(EntityPlayer player) {
        int i;
        int s = this.getSlots();
        HashMap<Integer, Integer> upgrades = new HashMap<Integer, Integer>();
        for (i = 0; i < 8; ++i) {
            upgrades.put(i, 0);
        }
        for (i = 10; i < 15; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            int meta = stack.func_77952_i();
            upgrades.put(meta, stack.field_77994_a);
        }
        for (Map.Entry e : upgrades.entrySet()) {
            switch ((Integer)e.getKey()) {
                case 0: {
                    this.setSpeed(ConfigHandler.speed ? (Integer)e.getValue() : 0);
                    break;
                }
                case 1: {
                    this.setEffi(ConfigHandler.effi ? (Integer)e.getValue() : 0);
                    break;
                }
                case 2: {
                    this.setInout(ConfigHandler.io ? (Integer)e.getValue() > 0 : false);
                    break;
                }
                case 3: {
                    this.setSlots(ConfigHandler.slot ? (Integer)e.getValue() : 0);
                    break;
                }
                case 4: {
                    this.setBonus(ConfigHandler.bonus ? (Integer)e.getValue() : 0);
                    break;
                }
                case 5: {
                    this.setXp(ConfigHandler.xp ? (Integer)e.getValue() : 0);
                    break;
                }
                case 6: {
                    this.setEco(ConfigHandler.eco ? (Integer)e.getValue() > 0 : false);
                    break;
                }
                case 7: {
                    this.setRf(ConfigHandler.rf ? (Integer)e.getValue() > 0 : false);
                }
            }
        }
        if (s <= this.getSlots()) {
            return;
        }
        ArrayList<Integer> lis = new ArrayList<Integer>();
        lis.addAll(Arrays.asList(2, 5, 8));
        if (this.getSlots() == 0) {
            lis.addAll(Arrays.asList(1, 4, 7));
        }
        Iterator iterator = lis.iterator();
        while (iterator.hasNext()) {
            int i2 = (Integer)iterator.next();
            if (this.func_70301_a(i2) == null) continue;
            ItemStack stack = this.func_70301_a(i2).func_77946_l();
            player.func_71019_a(stack, false);
            this.func_70299_a(i2, null);
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.output();
        this.input();
        this.split();
        this.move();
        if (this.fuel > this.maxFuel) {
            this.maxFuel = this.fuel;
        }
        if (this.fuel < 0) {
            this.fuel = 0;
        }
        if (this.field_145850_b.func_82737_E() % 5L == 0L) {
            if (this.fuel > 0 && !this.burning) {
                this.burning = true;
                ((AbstractBlock)this.func_145838_q()).setState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.burning);
            } else if (this.fuel <= 0 && this.burning) {
                this.burning = false;
                ((AbstractBlock)this.func_145838_q()).setState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.burning);
            }
        }
        for (int i = 0; i <= this.speed * ConfigHandler.speedMulti; ++i) {
            this.burn(0);
            if (this.slots >= 2) {
                this.burn(2);
            }
            if (this.slots < 1) continue;
            this.burn(1);
        }
    }

    protected void fuelUp(int slot) {
        if (this.fuel >= 1 || !this.canProcess(slot)) {
            return;
        }
        int fuelTime = 0;
        if (this.func_70301_a(9) != null && TileEntityFurnace.func_145954_b((ItemStack)this.func_70301_a(9))) {
            fuelTime = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(9)) * 100;
            if (this.func_70301_a(9).func_77973_b().getContainerItem(this.func_70301_a(9)) == null) {
                this.func_70298_a(9, 1);
            } else {
                this.func_70299_a(9, this.func_70301_a(9).func_77973_b().getContainerItem(this.func_70301_a(9)));
            }
        } else {
            int fac = ConfigHandler.RF;
            fuelTime = (int)((double)this.consumeRF(1600 * fac) / new Double(fac) * 100.0);
        }
        this.fuel += fuelTime;
        this.maxFuel = fuelTime;
    }

    protected void burn(int slot) {
        if (this.func_70301_a(slot) == null && this.progress.get(slot) != 0) {
            this.progress.put(slot, 0);
        }
        this.fuelUp(slot);
        boolean progressed = false;
        if (this.fuel > 0) {
            if (this.canProcess(slot)) {
                this.progress.put(slot, this.progress.get(slot) + 1);
                progressed = true;
                if (this.progress.get(slot) >= 200) {
                    this.processItem(slot);
                    this.progress.put(slot, 0);
                }
            }
        } else if (!this.eco) {
            this.progress.put(slot, 0);
        }
        if (this.fuel > 0 && (progressed || !this.progressing(slot) && !this.eco)) {
            this.fuel = (int)((double)this.fuel - this.getCalc() * 100.0);
        }
        this.calculateTicks();
        this.sendMessage();
    }

    private void calculateTicks() {
        if (this.fuel <= 0) {
            this.remainTicks = 0;
        }
        int ticks = this.fuel / 100;
        ticks /= this.speed * ConfigHandler.speedMulti + 1;
        ticks /= Math.max(1, this.processes());
        this.remainTicks = ticks = (int)((double)ticks / this.getCalc());
    }

    public double getCalc() {
        return ((double)this.getSpeed() * (ConfigHandler.speedFuelMulti / 10.0) + (double)this.getBonus() * (ConfigHandler.bonusFuelMulti / 10.0) + 1.0) / ((double)this.getEffi() * (ConfigHandler.effiMulti / 10.0) + 1.0);
    }

    boolean progressing(int slot) {
        for (int i = 0; i < 3; ++i) {
            if (i == slot || !this.canProcess(i)) continue;
            return true;
        }
        return false;
    }

    void sendMessage() {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new ProgressMessage(this.burning, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), this.fuel, this.maxFuel, this.progress, this.en.getEnergyStored(), this.remainTicks), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 12.0));
    }

    protected abstract void processItem(int var1);

    protected abstract boolean canProcess(int var1);

    protected void output() {
        if (!this.inout || this.field_145850_b.func_82737_E() % 50L / (long)(this.speed + this.slots + 1) != 0L) {
            return;
        }
        block0: for (TileEntity t : this.getIInventories()) {
            for (int i : this.getOutputSlots()) {
                if (this.func_70301_a(i) == null || this.output.get((Object)this.getWrongSide(this.getDirection(this, t))) != Mode.AUTO) continue;
                int num = this.func_70301_a((int)i).field_77994_a;
                IItemHandler ir = InvHelper.getItemHandler(t, this.getDirection(this, t).func_176734_d());
                ItemStack res = ItemHandlerHelper.insertItem((IItemHandler)ir, (ItemStack)this.func_70301_a(i).func_77946_l(), (boolean)false);
                int rest = res == null ? 0 : res.field_77994_a;
                if (num == rest) continue;
                this.func_70299_a(i, rest > 0 ? ItemHandlerHelper.copyStackWithSize((ItemStack)this.func_70301_a(i).func_77946_l(), (int)rest) : null);
                continue block0;
            }
        }
    }

    protected void input() {
        if (!this.inout || this.field_145850_b.func_82737_E() % 60L / (long)(this.speed + this.slots + 1) != 0L) {
            return;
        }
        block0: for (TileEntity t : this.getIInventories()) {
            if (this.input.get((Object)this.getWrongSide(this.getDirection(this, t))) != Mode.AUTO && this.fuelput.get((Object)this.getWrongSide(this.getDirection(this, t))) != Mode.AUTO) continue;
            IItemHandler ir = InvHelper.getItemHandler(t, this.getDirection(this, t).func_176734_d());
            IItemHandler that = InvHelper.getItemHandler(this, this.getDirection(this, t));
            for (int i = 0; i < ir.getSlots(); ++i) {
                int inserted;
                ItemStack exed;
                int rest;
                if (ir.getStackInSlot(i) == null) continue;
                int num = ir.getStackInSlot((int)i).field_77994_a;
                ItemStack res = ItemHandlerHelper.insertItem((IItemHandler)that, (ItemStack)ir.getStackInSlot(i).func_77946_l(), (boolean)true);
                int n = rest = res == null ? 0 : res.field_77994_a;
                if (num == rest || (exed = ir.extractItem(i, inserted = num - rest, false)) == null) continue;
                ItemHandlerHelper.insertItem((IItemHandler)that, (ItemStack)exed.func_77946_l(), (boolean)false);
                continue block0;
            }
        }
    }

    protected EnumFacing getDirection(TileEntity von, TileEntity zu) {
        if (von.func_174877_v().func_177956_o() == zu.func_174877_v().func_177956_o() + 1) {
            return EnumFacing.DOWN;
        }
        if (von.func_174877_v().func_177956_o() == zu.func_174877_v().func_177956_o() - 1) {
            return EnumFacing.UP;
        }
        if (von.func_174877_v().func_177952_p() == zu.func_174877_v().func_177952_p() + 1) {
            return EnumFacing.NORTH;
        }
        if (von.func_174877_v().func_177952_p() == zu.func_174877_v().func_177952_p() - 1) {
            return EnumFacing.SOUTH;
        }
        if (von.func_174877_v().func_177958_n() == zu.func_174877_v().func_177958_n() + 1) {
            return EnumFacing.WEST;
        }
        if (von.func_174877_v().func_177958_n() == zu.func_174877_v().func_177958_n() - 1) {
            return EnumFacing.EAST;
        }
        return null;
    }

    protected List<TileEntity> getIInventories() {
        ArrayList lis = Lists.newArrayList();
        for (EnumFacing face : EnumFacing.values()) {
            BlockPos p = this.func_174877_v().func_177972_a(face);
            if (!InvHelper.hasItemHandler(this.field_145850_b, p, face.func_176734_d())) continue;
            lis.add(this.field_145850_b.func_175625_s(p));
        }
        return lis;
    }

    Direction getWrongSide(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return Direction.TOP;
        }
        if (side == EnumFacing.DOWN) {
            return Direction.BOTTOM;
        }
        EnumFacing face = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)AbstractBlock.FACING);
        if (face == EnumFacing.NORTH) {
            switch (side) {
                case NORTH: {
                    return Direction.FRONT;
                }
                case SOUTH: {
                    return Direction.BACK;
                }
                case WEST: {
                    return Direction.RIGHT;
                }
                case EAST: {
                    return Direction.LEFT;
                }
            }
        }
        if (face == EnumFacing.SOUTH) {
            switch (side) {
                case NORTH: {
                    return Direction.BACK;
                }
                case SOUTH: {
                    return Direction.FRONT;
                }
                case WEST: {
                    return Direction.LEFT;
                }
                case EAST: {
                    return Direction.RIGHT;
                }
            }
        }
        if (face == EnumFacing.EAST) {
            switch (side) {
                case NORTH: {
                    return Direction.RIGHT;
                }
                case SOUTH: {
                    return Direction.LEFT;
                }
                case WEST: {
                    return Direction.BACK;
                }
                case EAST: {
                    return Direction.FRONT;
                }
            }
        }
        if (face == EnumFacing.WEST) {
            switch (side) {
                case NORTH: {
                    return Direction.LEFT;
                }
                case SOUTH: {
                    return Direction.RIGHT;
                }
                case WEST: {
                    return Direction.FRONT;
                }
                case EAST: {
                    return Direction.BACK;
                }
            }
        }
        return null;
    }

    protected void split() {
        if (this.slots == 0 || !this.split || this.field_145850_b.func_82737_E() % 4L != 0L) {
            return;
        }
        boolean x = false;
        for (int i : this.getInputSlots()) {
            if (this.func_70301_a(i) == null) continue;
            x = true;
            break;
        }
        if (!x) {
            return;
        }
        for (int i : this.getInputSlots()) {
            for (int j : this.getInputSlots()) {
                if (i < j) continue;
                this.tryMerge(j, i);
            }
        }
    }

    protected void move() {
        if (this.slots == 0 || this.split || this.field_145850_b.func_82737_E() % 5L != 0L) {
            return;
        }
        for (int i : this.getInputSlots()) {
            for (int j : this.getInputSlots()) {
                if (this.func_70301_a(j) != null || this.func_70301_a(i) == null || this.canProcess(i) || !this.fit(this.func_70301_a(i), j)) continue;
                this.func_70299_a(j, this.func_70301_a(i).func_77946_l());
                this.func_70299_a(i, null);
            }
        }
    }

    protected abstract boolean fit(ItemStack var1, int var2);

    protected void tryMerge(int i1, int i2) {
        ItemStack stack1 = this.func_70301_a(i1);
        ItemStack stack2 = this.func_70301_a(i2);
        if (stack1 == null && stack2 == null) {
            return;
        }
        if (stack1 == null) {
            if (stack2.field_77994_a <= 1 || !this.fit(stack2, i1)) {
                return;
            }
            stack1 = stack2.func_77946_l();
            stack1.field_77994_a = this.split(stack2.field_77994_a)[0];
            stack2.field_77994_a = this.split(stack2.field_77994_a)[1];
            this.func_70299_a(i1, (ItemStack)(stack1.field_77994_a > 0 ? stack1 : null));
            this.func_70299_a(i2, (ItemStack)(stack2.field_77994_a > 0 ? stack2 : null));
            return;
        }
        if (stack2 == null) {
            if (stack1.field_77994_a <= 1 || !this.fit(stack1, i2)) {
                return;
            }
            stack2 = stack1.func_77946_l();
            stack2.field_77994_a = this.split(stack1.field_77994_a)[0];
            stack1.field_77994_a = this.split(stack1.field_77994_a)[1];
            this.func_70299_a(i1, (ItemStack)(stack1.field_77994_a > 0 ? stack1 : null));
            this.func_70299_a(i2, (ItemStack)(stack2.field_77994_a > 0 ? stack2 : null));
            return;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack2)) {
            int s = stack1.field_77994_a + stack2.field_77994_a;
            stack1.field_77994_a = this.split(s)[0];
            stack2.field_77994_a = this.split(s)[1];
            this.func_70299_a(i1, (ItemStack)(stack1.field_77994_a > 0 ? stack1 : null));
            this.func_70299_a(i2, (ItemStack)(stack2.field_77994_a > 0 ? stack2 : null));
            return;
        }
    }

    int[] split(int a) {
        if (a % 2 == 0) {
            return new int[]{a / 2, a / 2};
        }
        return new int[]{a / 2 + 1, a / 2};
    }

    boolean canProcessAny() {
        for (int i : this.getInputSlots()) {
            if (!this.canProcess(i)) continue;
            return true;
        }
        return false;
    }

    int processes() {
        int processes = 0;
        for (int i : this.getInputSlots()) {
            if (!this.canProcess(i)) continue;
            ++processes;
        }
        return processes;
    }

    @Override
    public boolean canSmelt() {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        return this.canProcessAny();
    }

    @Override
    public int getBurnTime() {
        return this.remainTicks;
    }

    @Override
    public void boostBurnTime() {
        if (!this.canProcessAny() || this.fuel > 20000) {
            return;
        }
        this.fuel += 20000 - this.fuel;
        this.maxFuel = 20000;
    }

    @Override
    public void boostCookTime() {
    }

    boolean consumeRF(int num, boolean simulate) {
        int value = num;
        if (this.en.getEnergyStored() < value) {
            return false;
        }
        if (!simulate) {
            this.en.modifyEnergyStored(-value);
        }
        return true;
    }

    int consumeRF(int max) {
        int m = Math.min(max, this.en.getEnergyStored());
        this.en.modifyEnergyStored(-m);
        return m;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.en.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.en.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.isRf();
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.en.receiveEnergy(maxReceive, simulate);
    }

    public static Map<Direction, Mode> getMap(String id, AbstractMachine tile) {
        if (id.equals("I")) {
            return tile.getInput();
        }
        if (id.equals("O")) {
            return tile.getOutput();
        }
        if (id.equals("F")) {
            return tile.getFuelput();
        }
        return null;
    }

    public static enum Direction {
        TOP,
        FRONT,
        LEFT,
        RIGHT,
        BOTTOM,
        BACK;

    }

    public static enum Mode {
        ENABLED,
        AUTO,
        X;

        protected static Mode[] vals;

        public Mode next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = Mode.values();
        }
    }
}

