/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.furnus;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InvHelper {
    public static boolean hasItemHandler(World world, BlockPos pos, EnumFacing facing) {
        return InvHelper.getItemHandler(world.func_175625_s(pos), facing) != null;
    }

    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        if (tile instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)tile, side);
        }
        if (tile instanceof IInventory) {
            return new InvWrapper((IInventory)tile);
        }
        return null;
    }

    public static ItemStack insert(TileEntity tile, ItemStack stack, EnumFacing side) {
        if (tile == null) {
            return stack;
        }
        IItemHandler inv = InvHelper.getItemHandler(tile, side);
        return ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
    }

    public static int canInsert(IItemHandler inv, ItemStack stack) {
        if (inv == null || stack == null) {
            return 0;
        }
        ItemStack s = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)true);
        int rest = s == null ? 0 : s.field_77994_a;
        return stack.field_77994_a - rest;
    }

    public static boolean contains(IItemHandler inv, ItemStack stack) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }
}

