/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.furnus.block;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public abstract class CrunchTEInventory
extends TileEntity
implements IInventory {
    public final int INVSIZE;
    protected ItemStack[] inv;
    protected final int stackLimit;

    public CrunchTEInventory(int size, int stackLimit) {
        this.INVSIZE = size;
        this.inv = new ItemStack[size];
        this.stackLimit = stackLimit;
    }

    public CrunchTEInventory(int size) {
        this(size, 64);
    }

    public ItemStack[] getInv() {
        return this.inv;
    }

    public void clear() {
        this.inv = new ItemStack[this.INVSIZE];
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList invList = tag.func_150295_c("crunchTE", 10);
        for (int i = 0; i < invList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = invList.func_150305_b(i);
            byte slot = stackTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
        }
        this.readSyncableDataFromNBT(tag);
    }

    protected abstract void readSyncableDataFromNBT(NBTTagCompound var1);

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(stackTag);
            invList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("crunchTE", (NBTBase)invList);
        this.writeSyncableDataToNBT(tag);
    }

    protected abstract void writeSyncableDataToNBT(NBTTagCompound var1);

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeSyncableDataToNBT(syncData);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readSyncableDataFromNBT(pkt.func_148857_g());
    }

    public int func_70302_i_() {
        return this.INVSIZE;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (this.inv[slot] != null) {
            if (this.inv[slot].field_77994_a <= size) {
                ItemStack itemstack = this.inv[slot];
                this.inv[slot] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.inv[slot].func_77979_a(size);
            if (this.inv[slot].field_77994_a == 0) {
                this.inv[slot] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inv[slot] != null) {
            ItemStack itemstack = this.inv[slot];
            this.inv[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149732_F();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : p_70300_1_.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }
}

