/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.furnus.block;

import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mrriegel.furnus.InventoryHelper;
import mrriegel.furnus.block.CrunchTEInventory;
import mrriegel.furnus.handler.ConfigurationHandler;
import mrriegel.furnus.handler.PacketHandler;
import mrriegel.furnus.message.ProgressMessage;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.item.IExoflameHeatable;

public abstract class AbstractMachine
extends CrunchTEInventory
implements ISidedInventory,
ExternalHeaterHandler.IExternalHeatable,
IExoflameHeatable {
    protected boolean burning;
    protected boolean eco;
    protected boolean inout;
    protected boolean split;
    protected int speed;
    protected int effi;
    protected int slots;
    protected int bonus;
    protected int xp;
    protected int fuel;
    protected int maxFuel;
    protected int remainTicks;
    protected int fuelPerTick;
    protected Map<Direction, Mode> input;
    protected Map<Direction, Mode> output;
    protected Map<Direction, Mode> fuelput;
    protected Map<Integer, Integer> progress;
    int tmp = 0;

    public AbstractMachine(int size) {
        super(size);
    }

    public AbstractMachine() {
        super(15);
        this.input = new HashMap<Direction, Mode>();
        this.output = new HashMap<Direction, Mode>();
        this.fuelput = new HashMap<Direction, Mode>();
        for (Direction f : Direction.values()) {
            this.input.put(f, Mode.X);
            this.output.put(f, Mode.X);
            this.fuelput.put(f, Mode.X);
        }
        this.input.put(Direction.TOP, Mode.ENABLED);
        for (Direction f : Direction.values()) {
            if (f == Direction.TOP || f == Direction.BOTTOM) continue;
            this.fuelput.put(f, Mode.ENABLED);
        }
        this.output.put(Direction.BOTTOM, Mode.ENABLED);
        this.progress = new HashMap<Integer, Integer>();
        for (int i = 0; i < 3; ++i) {
            this.progress.put(i, 0);
        }
    }

    @Override
    protected void readSyncableDataFromNBT(NBTTagCompound tag) {
        this.burning = tag.func_74767_n("burning");
        this.eco = tag.func_74767_n("eco");
        this.inout = tag.func_74767_n("inout");
        this.split = tag.func_74767_n("split");
        this.speed = tag.func_74762_e("speed");
        this.effi = tag.func_74762_e("effi");
        this.slots = tag.func_74762_e("slot");
        this.bonus = tag.func_74762_e("bonus");
        this.xp = tag.func_74762_e("xp");
        this.fuel = tag.func_74762_e("fuel");
        this.maxFuel = tag.func_74762_e("maxFuel");
        this.remainTicks = tag.func_74762_e("remainTicks");
        this.fuelPerTick = tag.func_74762_e("fuelPerTick");
        this.input = (Map)new Gson().fromJson(tag.func_74779_i("input"), new TypeToken<Map<Direction, Mode>>(){}.getType());
        this.output = (Map)new Gson().fromJson(tag.func_74779_i("output"), new TypeToken<Map<Direction, Mode>>(){}.getType());
        this.fuelput = (Map)new Gson().fromJson(tag.func_74779_i("fuelput"), new TypeToken<Map<Direction, Mode>>(){}.getType());
        this.progress = (Map)new Gson().fromJson(tag.func_74779_i("progress"), new TypeToken<Map<Integer, Integer>>(){}.getType());
    }

    @Override
    protected void writeSyncableDataToNBT(NBTTagCompound tag) {
        tag.func_74757_a("burning", this.burning);
        tag.func_74757_a("eco", this.eco);
        tag.func_74757_a("inout", this.inout);
        tag.func_74757_a("split", this.split);
        tag.func_74768_a("speed", this.speed);
        tag.func_74768_a("effi", this.effi);
        tag.func_74768_a("slot", this.slots);
        tag.func_74768_a("bonus", this.bonus);
        tag.func_74768_a("xp", this.xp);
        tag.func_74768_a("fuel", this.fuel);
        tag.func_74768_a("maxFuel", this.maxFuel);
        tag.func_74768_a("remainTicks", this.remainTicks);
        tag.func_74768_a("fuelPerTick", this.fuelPerTick);
        tag.func_74778_a("input", new Gson().toJson(this.input));
        tag.func_74778_a("output", new Gson().toJson(this.output));
        tag.func_74778_a("fuelput", new Gson().toJson(this.fuelput));
        tag.func_74778_a("progress", new Gson().toJson(this.progress));
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean burning) {
        this.burning = burning;
    }

    public boolean isEco() {
        return this.eco;
    }

    public void setEco(boolean eco) {
        this.eco = eco;
    }

    public boolean isInout() {
        return this.inout;
    }

    public void setInout(boolean inout) {
        this.inout = inout;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getEffi() {
        return this.effi;
    }

    public void setEffi(int effi) {
        this.effi = effi;
    }

    public int getSlots() {
        return this.slots;
    }

    public void setSlots(int slots) {
        this.slots = slots;
    }

    public int getBonus() {
        return this.bonus;
    }

    public void setBonus(int bonus) {
        this.bonus = bonus;
    }

    public int getXp() {
        return this.xp;
    }

    public void setXp(int xp) {
        this.xp = xp;
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public int getMaxFuel() {
        return this.maxFuel;
    }

    public void setMaxFuel(int maxFuel) {
        this.maxFuel = maxFuel;
    }

    public int getRemainTicks() {
        return this.remainTicks;
    }

    public void setRemainTicks(int remainTicks) {
        this.remainTicks = remainTicks;
    }

    public Map<Direction, Mode> getInput() {
        return this.input;
    }

    public void setInput(Map<Direction, Mode> input) {
        this.input = input;
    }

    public Map<Direction, Mode> getOutput() {
        return this.output;
    }

    public void setOutput(Map<Direction, Mode> output) {
        this.output = output;
    }

    public Map<Direction, Mode> getFuelput() {
        return this.fuelput;
    }

    public void setFuelput(Map<Direction, Mode> fuelput) {
        this.fuelput = fuelput;
    }

    public Map<Integer, Integer> getProgress() {
        return this.progress;
    }

    public void setProgress(Map<Integer, Integer> progress) {
        this.progress = progress;
    }

    public int[] func_94128_d(int side) {
        if (!this.inout) {
            return new int[0];
        }
        ArrayList<Integer> lis = new ArrayList<Integer>();
        Direction wrongSide = this.getWrongSide(side);
        if (this.input.get((Object)wrongSide) != Mode.X) {
            lis.addAll(this.getInputSlots());
        }
        if (this.output.get((Object)wrongSide) != Mode.X) {
            lis.addAll(this.getOutputSlots());
        }
        if (this.fuelput.get((Object)wrongSide) != Mode.X) {
            lis.add(9);
        }
        int[] end = new int[lis.size()];
        for (int i = 0; i < lis.size(); ++i) {
            end[i] = (Integer)lis.get(i);
        }
        return end;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (!this.inout) {
            return false;
        }
        if (!this.getInputSlots().contains(slot) && slot != 9) {
            return false;
        }
        Direction wrongSide = this.getWrongSide(side);
        if (this.input.get((Object)wrongSide) != Mode.X && this.getInputSlots().contains(slot)) {
            return this.func_94041_b(slot, stack);
        }
        if (this.fuelput.get((Object)wrongSide) != Mode.X && slot == 9) {
            return this.func_94041_b(slot, stack);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (!this.inout) {
            return false;
        }
        if (!this.getOutputSlots().contains(slot) && slot != 9) {
            return false;
        }
        Direction wrongSide = this.getWrongSide(side);
        if (this.output.get((Object)wrongSide) != Mode.X && this.getOutputSlots().contains(slot)) {
            return true;
        }
        return this.fuelput.get((Object)wrongSide) != Mode.X && slot == 9 && !TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return newBlock != oldBlock;
    }

    protected boolean equalOreDict(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        int[] ar = OreDictionary.getOreIDs((ItemStack)a);
        int[] br = OreDictionary.getOreIDs((ItemStack)b);
        for (int i = 0; i < ar.length; ++i) {
            for (int j = 0; j < br.length; ++j) {
                if (ar[i] != br[j]) continue;
                return true;
            }
        }
        return false;
    }

    protected ArrayList<Integer> getOutputSlots() {
        if (this.slots == 2) {
            return new ArrayList<Integer>(Arrays.asList(3, 4, 5, 6, 7, 8));
        }
        if (this.slots == 1) {
            return new ArrayList<Integer>(Arrays.asList(3, 4, 6, 7));
        }
        return new ArrayList<Integer>(Arrays.asList(3, 6));
    }

    protected ArrayList<Integer> getInputSlots() {
        if (this.slots == 2) {
            return new ArrayList<Integer>(Arrays.asList(0, 1, 2));
        }
        if (this.slots == 1) {
            return new ArrayList<Integer>(Arrays.asList(0, 1));
        }
        return new ArrayList<Integer>(Arrays.asList(0));
    }

    @Override
    public abstract boolean func_94041_b(int var1, ItemStack var2);

    public void updateStats(EntityPlayer player) {
        int i;
        int s = this.getSlots();
        HashMap<Integer, Integer> upgrades = new HashMap<Integer, Integer>();
        for (i = 0; i < 8; ++i) {
            upgrades.put(i, 0);
        }
        for (i = 10; i < 15; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            int meta = stack.func_77960_j();
            upgrades.put(meta, stack.field_77994_a);
        }
        for (Map.Entry e : upgrades.entrySet()) {
            switch ((Integer)e.getKey()) {
                case 0: {
                    this.setSpeed(ConfigurationHandler.speed ? (Integer)e.getValue() : 0);
                    break;
                }
                case 1: {
                    this.setEffi(ConfigurationHandler.effi ? (Integer)e.getValue() : 0);
                    break;
                }
                case 2: {
                    this.setInout(ConfigurationHandler.io ? (Integer)e.getValue() > 0 : false);
                    break;
                }
                case 3: {
                    this.setSlots(ConfigurationHandler.slot ? (Integer)e.getValue() : 0);
                    break;
                }
                case 4: {
                    this.setBonus(ConfigurationHandler.bonus ? (Integer)e.getValue() : 0);
                    break;
                }
                case 5: {
                    this.setXp(ConfigurationHandler.xp ? (Integer)e.getValue() : 0);
                    break;
                }
                case 6: {
                    this.setEco(ConfigurationHandler.eco ? (Integer)e.getValue() > 0 : false);
                }
            }
        }
        if (s <= this.getSlots()) {
            return;
        }
        ArrayList<Integer> lis = new ArrayList<Integer>();
        lis.addAll(Arrays.asList(2, 5, 8));
        if (this.getSlots() == 0) {
            lis.addAll(Arrays.asList(1, 4, 7));
        }
        Iterator iterator = lis.iterator();
        while (iterator.hasNext()) {
            int i2 = (Integer)iterator.next();
            if (this.func_70301_a(i2) == null) continue;
            ItemStack stack = this.func_70301_a(i2).func_77946_l();
            player.func_71019_a(stack, false);
            this.func_70299_a(i2, null);
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.output();
        this.input();
        this.split();
        this.move();
        if (this.fuel > 0 && !this.burning) {
            this.burning = true;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (this.fuel <= 0 && this.burning) {
            this.burning = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.tmp = 0;
        for (int i = 0; i <= this.speed * ConfigurationHandler.speedMulti; ++i) {
            this.burn(0);
            if (this.slots >= 2) {
                this.burn(2);
            }
            if (this.slots < 1) continue;
            this.burn(1);
        }
        this.fuelPerTick = this.tmp;
    }

    protected void fuelUp(int slot) {
        if (this.fuel >= 1 || this.func_70301_a(9) == null || !TileEntityFurnace.func_145954_b((ItemStack)this.func_70301_a(9)) || !this.canProcess(slot)) {
            return;
        }
        int fuelTime = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(9)) * 100;
        this.fuel += fuelTime;
        this.maxFuel = fuelTime;
        if (this.func_70301_a(9).func_77973_b().getContainerItem(this.func_70301_a(9)) == null) {
            InventoryHelper.decrStackSize(this, 9, 1);
        } else {
            this.func_70299_a(9, this.func_70301_a(9).func_77973_b().getContainerItem(this.func_70301_a(9)));
        }
    }

    protected void burn(int slot) {
        if (this.func_70301_a(slot) == null && this.progress.get(slot) != 0) {
            this.progress.put(slot, 0);
        }
        this.fuelUp(slot);
        boolean progressed = false;
        if (this.fuel > 0) {
            if (this.canProcess(slot)) {
                this.progress.put(slot, this.progress.get(slot) + 1);
                progressed = true;
                if (this.progress.get(slot) >= 200) {
                    this.processItem(slot);
                    this.progress.put(slot, 0);
                }
            }
        } else if (!this.eco) {
            this.progress.put(slot, 0);
        }
        if (this.fuel > 0 && (progressed || !this.progressing(slot) && !this.eco)) {
            double effi = ((double)this.getSpeed() * (ConfigurationHandler.speedFuelMulti / 10.0) + (double)this.getBonus() * (ConfigurationHandler.bonusFuelMulti / 10.0) + 1.0) / ((double)this.getEffi() * (ConfigurationHandler.effiMulti / 10.0) + 1.0);
            this.fuel = (int)((double)this.fuel - effi * 100.0);
            this.tmp = (int)((double)this.tmp + effi * 100.0);
        }
        this.calculateTicks();
        this.sendMessage();
    }

    private void calculateTicks() {
        if (this.fuel <= 0) {
            this.remainTicks = 0;
        }
        int ticks = this.fuel / 100;
        ticks /= this.speed * ConfigurationHandler.speedMulti + 1;
        ticks /= this.slots + 1;
        double effi = ((double)this.getSpeed() * (ConfigurationHandler.speedFuelMulti / 10.0) + (double)this.getBonus() * (ConfigurationHandler.bonusFuelMulti / 10.0) + 1.0) / ((double)this.getEffi() * (ConfigurationHandler.effiMulti / 10.0) + 1.0);
        this.remainTicks = ticks = (int)((double)ticks / effi);
    }

    boolean progressing(int slot) {
        for (int i = 0; i < 3; ++i) {
            if (i == slot || !this.canProcess(i)) continue;
            return true;
        }
        return false;
    }

    void sendMessage() {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new ProgressMessage(this.burning, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.fuel, this.maxFuel, this.progress), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 12.0));
    }

    protected abstract void processItem(int var1);

    protected abstract boolean canProcess(int var1);

    protected void output() {
        if (!this.inout || this.field_145850_b.func_82737_E() % 50L / (long)(this.speed + this.slots + 1) != 0L) {
            return;
        }
        block0: for (IInventory ir : this.getIInventories()) {
            for (int i : this.getOutputSlots()) {
                TileEntity inv;
                int rest;
                int num;
                if (this.func_70301_a(i) == null || this.output.get((Object)this.getWrongSide(this.getDirection(this, (TileEntity)ir))) != Mode.AUTO) continue;
                if (!(ir instanceof ISidedInventory)) {
                    num = this.func_70301_a((int)i).field_77994_a;
                    rest = InventoryHelper.addToInventoryWithLeftover(this.func_70301_a(i).func_77946_l(), ir, false);
                    if (num == rest) continue;
                    this.func_70299_a(i, rest > 0 ? InventoryHelper.copyStack(this.func_70301_a(i).func_77946_l(), rest) : null);
                    inv = (TileEntity)ir;
                    this.field_145850_b.func_147471_g(inv.field_145851_c, inv.field_145848_d, inv.field_145849_e);
                    continue block0;
                }
                if (!(ir instanceof ISidedInventory) || (num = this.func_70301_a((int)i).field_77994_a) == (rest = InventoryHelper.addToSidedInventoryWithLeftover(this.func_70301_a(i).func_77946_l(), (ISidedInventory)ir, this.getDirection((TileEntity)ir, this), false))) continue;
                this.func_70299_a(i, rest > 0 ? InventoryHelper.copyStack(this.func_70301_a(i).func_77946_l(), rest) : null);
                inv = (TileEntity)ir;
                this.field_145850_b.func_147471_g(inv.field_145851_c, inv.field_145848_d, inv.field_145849_e);
                continue block0;
            }
        }
    }

    protected void input() {
        if (!this.inout || this.field_145850_b.func_82737_E() % 60L / (long)(this.speed + this.slots + 1) != 0L) {
            return;
        }
        block0: for (IInventory ir : this.getIInventories()) {
            if (this.input.get((Object)this.getWrongSide(this.getDirection(this, (TileEntity)ir))) != Mode.AUTO && this.fuelput.get((Object)this.getWrongSide(this.getDirection(this, (TileEntity)ir))) != Mode.AUTO) continue;
            int side = this.getDirection(this, (TileEntity)ir);
            if (!(ir instanceof ISidedInventory)) {
                for (int i = 0; i < ir.func_70302_i_(); ++i) {
                    int rest;
                    int num;
                    if (ir.func_70301_a(i) == null || (num = ir.func_70301_a((int)i).field_77994_a) == (rest = InventoryHelper.addToSidedInventoryWithLeftover(ir.func_70301_a(i).func_77946_l(), this, side, false))) continue;
                    ir.func_70299_a(i, rest > 0 ? InventoryHelper.copyStack(ir.func_70301_a(i).func_77946_l(), rest) : null);
                    TileEntity inv = (TileEntity)ir;
                    this.field_145850_b.func_147471_g(inv.field_145851_c, inv.field_145848_d, inv.field_145849_e);
                    continue block0;
                }
                continue;
            }
            if (!(ir instanceof ISidedInventory) || ((ISidedInventory)ir).func_94128_d(side) == null) continue;
            for (int i : ((ISidedInventory)ir).func_94128_d(side)) {
                if (ir.func_70301_a(i) == null) continue;
                if (!((ISidedInventory)ir).func_102008_b(i, ir.func_70301_a(i), this.getDirection((TileEntity)ir, this))) continue block0;
                int num = ir.func_70301_a((int)i).field_77994_a;
                int rest = InventoryHelper.addToSidedInventoryWithLeftover(ir.func_70301_a(i).func_77946_l(), this, side, false);
                if (num == rest) continue;
                ir.func_70299_a(i, rest > 0 ? InventoryHelper.copyStack(ir.func_70301_a(i).func_77946_l(), rest) : null);
                TileEntity inv = (TileEntity)ir;
                this.field_145850_b.func_147471_g(inv.field_145851_c, inv.field_145848_d, inv.field_145849_e);
                continue block0;
            }
        }
    }

    protected int getDirection(TileEntity von, TileEntity zu) {
        if (von.field_145848_d == zu.field_145848_d + 1) {
            return 0;
        }
        if (von.field_145848_d == zu.field_145848_d - 1) {
            return 1;
        }
        if (von.field_145849_e == zu.field_145849_e + 1) {
            return 2;
        }
        if (von.field_145849_e == zu.field_145849_e - 1) {
            return 3;
        }
        if (von.field_145851_c == zu.field_145851_c + 1) {
            return 4;
        }
        if (von.field_145851_c == zu.field_145851_c - 1) {
            return 5;
        }
        return -1;
    }

    protected List<IInventory> getIInventories() {
        TileEntity f;
        TileEntity e;
        TileEntity d;
        TileEntity c;
        TileEntity b;
        ArrayList<IInventory> lis = new ArrayList<IInventory>();
        TileEntity a = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (a != null && a instanceof IInventory) {
            lis.add((IInventory)a);
        }
        if ((b = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) != null && b instanceof IInventory) {
            lis.add((IInventory)b);
        }
        if ((c = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)) != null && c instanceof IInventory) {
            lis.add((IInventory)c);
        }
        if ((d = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) != null && d instanceof IInventory) {
            lis.add((IInventory)d);
        }
        if ((e = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)) != null && e instanceof IInventory) {
            lis.add((IInventory)e);
        }
        if ((f = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) != null && f instanceof IInventory) {
            lis.add((IInventory)f);
        }
        return lis;
    }

    Direction getWrongSide(int side) {
        if (side == 1) {
            return Direction.TOP;
        }
        if (side == 0) {
            return Direction.BOTTOM;
        }
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (meta == 2) {
            switch (side) {
                case 2: {
                    return Direction.FRONT;
                }
                case 3: {
                    return Direction.BACK;
                }
                case 4: {
                    return Direction.RIGHT;
                }
                case 5: {
                    return Direction.LEFT;
                }
            }
        }
        if (meta == 3) {
            switch (side) {
                case 2: {
                    return Direction.BACK;
                }
                case 3: {
                    return Direction.FRONT;
                }
                case 4: {
                    return Direction.LEFT;
                }
                case 5: {
                    return Direction.RIGHT;
                }
            }
        }
        if (meta == 5) {
            switch (side) {
                case 2: {
                    return Direction.RIGHT;
                }
                case 3: {
                    return Direction.LEFT;
                }
                case 4: {
                    return Direction.BACK;
                }
                case 5: {
                    return Direction.FRONT;
                }
            }
        }
        if (meta == 4) {
            switch (side) {
                case 2: {
                    return Direction.LEFT;
                }
                case 3: {
                    return Direction.RIGHT;
                }
                case 4: {
                    return Direction.FRONT;
                }
                case 5: {
                    return Direction.BACK;
                }
            }
        }
        return null;
    }

    protected void split() {
        if (this.slots == 0 || !this.split || this.field_145850_b.func_82737_E() % 4L != 0L) {
            return;
        }
        boolean x = false;
        for (int i : this.getInputSlots()) {
            if (this.func_70301_a(i) == null) continue;
            x = true;
            break;
        }
        if (!x) {
            return;
        }
        for (int i : this.getInputSlots()) {
            for (int j : this.getInputSlots()) {
                if (i < j) continue;
                this.tryMerge(j, i);
            }
        }
    }

    protected void move() {
        if (this.slots == 0 || this.split || this.field_145850_b.func_82737_E() % 5L != 0L) {
            return;
        }
        for (int i : this.getInputSlots()) {
            for (int j : this.getInputSlots()) {
                if (this.func_70301_a(j) != null || this.func_70301_a(i) == null || this.canProcess(i) || !this.fit(this.func_70301_a(i), j)) continue;
                this.func_70299_a(j, this.func_70301_a(i).func_77946_l());
                this.func_70299_a(i, null);
            }
        }
    }

    public abstract boolean fit(ItemStack var1, int var2);

    protected void tryMerge(int i1, int i2) {
        ItemStack stack1 = this.func_70301_a(i1);
        ItemStack stack2 = this.func_70301_a(i2);
        if (stack1 == null && stack2 == null) {
            return;
        }
        if (stack1 == null) {
            if (stack2.field_77994_a <= 1 || !this.fit(stack2, i1)) {
                return;
            }
            stack1 = stack2.func_77946_l();
            stack1.field_77994_a = this.split(stack2.field_77994_a)[0];
            stack2.field_77994_a = this.split(stack2.field_77994_a)[1];
            this.func_70299_a(i1, (ItemStack)(stack1.field_77994_a > 0 ? stack1 : null));
            this.func_70299_a(i2, (ItemStack)(stack2.field_77994_a > 0 ? stack2 : null));
            return;
        }
        if (stack2 == null) {
            if (stack1.field_77994_a <= 1 || !this.fit(stack1, i2)) {
                return;
            }
            stack2 = stack1.func_77946_l();
            stack2.field_77994_a = this.split(stack1.field_77994_a)[0];
            stack1.field_77994_a = this.split(stack1.field_77994_a)[1];
            this.func_70299_a(i1, (ItemStack)(stack1.field_77994_a > 0 ? stack1 : null));
            this.func_70299_a(i2, (ItemStack)(stack2.field_77994_a > 0 ? stack2 : null));
            return;
        }
        if (InventoryHelper.areStacksEqual(stack1, stack2, true)) {
            int s = stack1.field_77994_a + stack2.field_77994_a;
            stack1.field_77994_a = this.split(s)[0];
            stack2.field_77994_a = this.split(s)[1];
            this.func_70299_a(i1, (ItemStack)(stack1.field_77994_a > 0 ? stack1 : null));
            this.func_70299_a(i2, (ItemStack)(stack2.field_77994_a > 0 ? stack2 : null));
            return;
        }
    }

    int[] split(int a) {
        if (a % 2 == 0) {
            return new int[]{a / 2, a / 2};
        }
        return new int[]{a / 2 + 1, a / 2};
    }

    boolean canProcessAny() {
        for (int i : this.getInputSlots()) {
            if (!this.canProcess(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int doHeatTick(int energyAvailable, boolean redstone) {
        int consume;
        double multiplier = 0.08;
        if (energyAvailable <= 0 || redstone || !this.canProcessAny() || this.remainTicks > 4) {
            return 0;
        }
        for (consume = energyAvailable; consume > 256; --consume) {
        }
        this.maxFuel = this.fuel = (int)((double)this.fuel + (double)consume / 0.08);
        return consume;
    }

    @Override
    public boolean canSmelt() {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        return this.canProcessAny();
    }

    @Override
    public int getBurnTime() {
        return this.remainTicks;
    }

    @Override
    public void boostBurnTime() {
        if (!this.canProcessAny() || this.fuel > 20000) {
            return;
        }
        this.fuel += 20000 - this.fuel;
        this.maxFuel = 20000;
    }

    @Override
    public void boostCookTime() {
    }

    public static Map<Direction, Mode> getMap(String id, AbstractMachine tile) {
        if (id.equals("I")) {
            return tile.getInput();
        }
        if (id.equals("O")) {
            return tile.getOutput();
        }
        if (id.equals("F")) {
            return tile.getFuelput();
        }
        return null;
    }

    public static enum Direction {
        TOP,
        FRONT,
        LEFT,
        RIGHT,
        BOTTOM,
        BACK;

    }

    public static enum Mode {
        ENABLED,
        AUTO,
        X;

        protected static Mode[] vals;

        public Mode next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = Mode.values();
        }
    }
}

