/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseUtils;
import gcewing.architecture.ShapeKind;
import gcewing.architecture.ShapeTE;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public class WindowShapeKinds {
    public static ShapeKind.Window PlainWindow = new PlainWindow();
    public static ShapeKind.Window MullionWindow = new MullionWindow();
    public static ShapeKind.Window CornerWindow = new CornerWindow();

    public static class CornerWindow
    extends ShapeKind.Window {
        public CornerWindow() {
            this.frameSides = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.WEST};
            this.frameAlways = new boolean[]{false, false, false, false};
            this.frameKinds = new ShapeKind.Window.FrameKind[]{ShapeKind.Window.FrameKind.Corner, ShapeKind.Window.FrameKind.Corner, ShapeKind.Window.FrameKind.None, ShapeKind.Window.FrameKind.Plain, ShapeKind.Window.FrameKind.Plain, ShapeKind.Window.FrameKind.None};
            this.frameOrientations = new EnumFacing[]{EnumFacing.EAST, EnumFacing.EAST, null, EnumFacing.UP, EnumFacing.UP, null};
            this.frameTrans = new Trans3[]{Trans3.ident, Trans3.ident.rotY(-90.0).rotZ(90.0), Trans3.ident.rotY(-90.0).rotZ(180.0), Trans3.ident.rotZ(270.0)};
        }

        @Override
        protected void addCentreBoxesToList(double d, double d2, Trans3 trans3, List list) {
            trans3.addBox(-d, -0.5, -d, d, 0.5, d, list);
        }

        @Override
        protected void addFrameBoxesToList(int n, double d, double d2, Trans3 trans3, List list) {
            if ((n & 1) == 0) {
                trans3.addBox(-0.5, -0.5, -d2, d2, -0.5 + d, d2, list);
                trans3.addBox(-d2, -0.5, -d2, d2, -0.5 + d, 0.5, list);
            } else {
                super.addFrameBoxesToList(n, d, d2, trans3, list);
            }
        }

        @Override
        protected void addGlassBoxesToList(double d, double d2, double d3, double[] dArray, Trans3 trans3, List list) {
            trans3.addBox(-dArray[3], -dArray[0], -d3, -d2, dArray[2], d3, list);
            trans3.addBox(-d3, -dArray[0], d2, d3, dArray[2], dArray[1], list);
        }

        @Override
        public boolean orientOnPlacement(EntityPlayer entityPlayer, ShapeTE shapeTE, ShapeTE shapeTE2, EnumFacing enumFacing, Vector3 vector3) {
            if (shapeTE2 != null && !entityPlayer.func_70093_af() && shapeTE2.shape.kind instanceof ShapeKind.Window) {
                ShapeKind.Window window = (ShapeKind.Window)shapeTE2.shape.kind;
                EnumFacing enumFacing2 = shapeTE2.localFace(enumFacing);
                ShapeKind.Window.FrameKind frameKind = window.frameKindForLocalSide(enumFacing2);
                switch (frameKind) {
                    case Corner: {
                        shapeTE.setSide(shapeTE2.side);
                        shapeTE.setTurn(shapeTE2.turn);
                        return true;
                    }
                    case Plain: {
                        EnumFacing enumFacing3 = shapeTE2.globalFace(window.frameOrientationForLocalSide(enumFacing2));
                        return this.orientFromAdjacentCorner(shapeTE, enumFacing3, vector3) || this.orientFromAdjacentCorner(shapeTE, enumFacing3.func_176734_d(), vector3);
                    }
                }
            }
            return super.orientOnPlacement(entityPlayer, shapeTE, shapeTE2, enumFacing, vector3);
        }

        protected boolean orientFromAdjacentCorner(ShapeTE shapeTE, EnumFacing enumFacing, Vector3 vector3) {
            EnumFacing enumFacing2;
            ShapeKind.Window window;
            ShapeKind.Window.FrameKind frameKind;
            ShapeTE shapeTE2 = ShapeTE.get((IBlockAccess)shapeTE.func_145831_w(), shapeTE.func_174877_v().func_177972_a(enumFacing.func_176734_d()));
            if (shapeTE2 != null && shapeTE2.shape.kind instanceof ShapeKind.Window && (frameKind = (window = (ShapeKind.Window)shapeTE2.shape.kind).frameKindForLocalSide(enumFacing2 = shapeTE2.localFace(enumFacing))) == ShapeKind.Window.FrameKind.Corner) {
                shapeTE.setSide(shapeTE2.side);
                shapeTE.setTurn(shapeTE2.turn);
                return true;
            }
            return false;
        }
    }

    public static class MullionWindow
    extends PlainWindow {
        @Override
        protected void addCentreBoxesToList(double d, double d2, Trans3 trans3, List list) {
            trans3.addBox(-d, -0.5, -d2, d, 0.5, d2, list);
        }

        @Override
        protected void addGlassBoxesToList(double d, double d2, double d3, double[] dArray, Trans3 trans3, List list) {
            trans3.addBox(-dArray[3], -dArray[0], -d3, -d, dArray[2], d3, list);
            trans3.addBox(d, -dArray[0], -d3, dArray[1], dArray[2], d3, list);
        }
    }

    public static class PlainWindow
    extends ShapeKind.Window {
        public PlainWindow() {
            this.frameSides = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.UP, EnumFacing.WEST};
            this.frameAlways = new boolean[]{false, false, false, false};
            this.frameKinds = new ShapeKind.Window.FrameKind[]{ShapeKind.Window.FrameKind.Plain, ShapeKind.Window.FrameKind.Plain, ShapeKind.Window.FrameKind.None, ShapeKind.Window.FrameKind.None, ShapeKind.Window.FrameKind.Plain, ShapeKind.Window.FrameKind.Plain};
            this.frameOrientations = new EnumFacing[]{EnumFacing.EAST, EnumFacing.EAST, null, null, EnumFacing.UP, EnumFacing.UP};
            this.frameTrans = new Trans3[]{Trans3.ident, Trans3.ident.rotZ(90.0), Trans3.ident.rotZ(180.0), Trans3.ident.rotZ(270.0)};
        }

        @Override
        public boolean orientOnPlacement(EntityPlayer entityPlayer, ShapeTE shapeTE, ShapeTE shapeTE2, EnumFacing enumFacing, Vector3 vector3) {
            if (shapeTE2 != null && !entityPlayer.func_70093_af()) {
                EnumFacing enumFacing2;
                ShapeKind.Window.FrameKind frameKind;
                if (shapeTE2.shape.kind instanceof PlainWindow) {
                    shapeTE.setSide(shapeTE2.side);
                    shapeTE.setTurn(shapeTE2.turn);
                    return true;
                }
                if (shapeTE2.shape.kind instanceof CornerWindow && (frameKind = ((ShapeKind.Window)shapeTE2.shape.kind).frameKindForLocalSide(enumFacing2 = shapeTE2.localFace(enumFacing))) == ShapeKind.Window.FrameKind.Plain) {
                    EnumFacing enumFacing3 = enumFacing.func_176734_d();
                    shapeTE.setSide(shapeTE2.side);
                    switch (enumFacing2) {
                        case SOUTH: {
                            shapeTE.setTurn(BaseUtils.turnToFace(EnumFacing.WEST, enumFacing3));
                            return true;
                        }
                        case WEST: {
                            shapeTE.setTurn(BaseUtils.turnToFace(EnumFacing.EAST, enumFacing3));
                            return true;
                        }
                    }
                }
            }
            return super.orientOnPlacement(entityPlayer, shapeTE, shapeTE2, enumFacing, vector3);
        }
    }
}

