/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;

public class Vector3 {
    static Vector3 zero = new Vector3(0.0, 0.0, 0.0);
    static Vector3 unitX = new Vector3(1.0, 0.0, 0.0);
    static Vector3 unitY = new Vector3(0.0, 1.0, 0.0);
    static Vector3 unitZ = new Vector3(0.0, 0.0, 1.0);
    static Vector3 unitNX = new Vector3(-1.0, 0.0, 0.0);
    static Vector3 unitNY = new Vector3(0.0, -1.0, 0.0);
    static Vector3 unitNZ = new Vector3(0.0, 0.0, -1.0);
    static Vector3 unitPYNZ = new Vector3(0.0, 0.707, -0.707);
    static Vector3 unitPXPY = new Vector3(0.707, 0.707, 0.0);
    static Vector3 unitPYPZ = new Vector3(0.0, 0.707, 0.707);
    static Vector3 unitNXPY = new Vector3(-0.707, 0.707, 0.0);
    double x;
    double y;
    double z;
    public static Vector3[][] faceBases = new Vector3[][]{{unitX, unitZ}, {unitX, unitNZ}, {unitNX, unitY}, {unitX, unitY}, {unitZ, unitY}, {unitNZ, unitY}};
    public static Vec3i[] directionVec = new Vec3i[]{new Vec3i(0, -1, 0), new Vec3i(0, 1, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1), new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0)};

    public Vector3(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3(Vec3 vec3) {
        this(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
    }

    public Vector3(Vec3i vec3i) {
        this(vec3i.func_177958_n(), vec3i.func_177956_o(), vec3i.func_177952_p());
    }

    public Vector3(EnumFacing enumFacing) {
        this(Vector3.getDirectionVec(enumFacing));
    }

    public Vec3 toVec3() {
        return new Vec3(this.x, this.y, this.z);
    }

    public String toString() {
        return String.format("(%.3f,%.3f,%.3f)", this.x, this.y, this.z);
    }

    public Vector3 add(double d, double d2, double d3) {
        return new Vector3(this.x + d, this.y + d2, this.z + d3);
    }

    public Vector3 add(Vector3 vector3) {
        return this.add(vector3.x, vector3.y, vector3.z);
    }

    public Vector3 sub(double d, double d2, double d3) {
        return new Vector3(this.x - d, this.y - d2, this.z - d3);
    }

    public Vector3 sub(Vector3 vector3) {
        return this.sub(vector3.x, vector3.y, vector3.z);
    }

    public static Vector3 sub(double[] dArray, double[] dArray2) {
        return new Vector3(dArray[0] - dArray2[0], dArray[1] - dArray2[1], dArray[2] - dArray2[2]);
    }

    public Vector3 mul(double d) {
        return new Vector3(d * this.x, d * this.y, d * this.z);
    }

    public double dot(Vector3 vector3) {
        return this.dot(vector3.x, vector3.y, vector3.z);
    }

    public double dot(double[] dArray) {
        return this.dot(dArray[0], dArray[1], dArray[2]);
    }

    public double dot(EnumFacing enumFacing) {
        Vec3i vec3i = Vector3.getDirectionVec(enumFacing);
        return this.dot(vec3i.func_177958_n(), vec3i.func_177956_o(), vec3i.func_177952_p());
    }

    public double dot(double d, double d2, double d3) {
        return this.x * d + this.y * d2 + this.z * d3;
    }

    public Vector3 cross(Vector3 vector3) {
        return new Vector3(this.y * vector3.z - this.z * vector3.y, this.z * vector3.x - this.x * vector3.z, this.x * vector3.y - this.y * vector3.x);
    }

    public Vector3 min(Vector3 vector3) {
        return new Vector3(Math.min(this.x, vector3.x), Math.min(this.y, vector3.y), Math.min(this.z, vector3.z));
    }

    public Vector3 max(Vector3 vector3) {
        return new Vector3(Math.max(this.x, vector3.x), Math.max(this.y, vector3.y), Math.max(this.z, vector3.z));
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double distance(Vector3 vector3) {
        double d = this.x - vector3.x;
        double d2 = this.y - vector3.y;
        double d3 = this.z - vector3.z;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public static Vector3 unit(Vector3 vector3) {
        return vector3.mul(1.0 / vector3.length());
    }

    public static Vector3 average(Vector3 ... vector3Array) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (Vector3 vector3 : vector3Array) {
            d += vector3.x;
            d2 += vector3.y;
            d3 += vector3.z;
        }
        int n = vector3Array.length;
        return new Vector3(d / (double)n, d2 / (double)n, d3 / (double)n);
    }

    public static Vector3 average(double[] ... dArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (double[] dArray2 : dArray) {
            d += dArray2[0];
            d2 += dArray2[1];
            d3 += dArray2[2];
        }
        int n = dArray.length;
        return new Vector3(d / (double)n, d2 / (double)n, d3 / (double)n);
    }

    public int floorX() {
        return (int)Math.floor(this.x);
    }

    public int floorY() {
        return (int)Math.floor(this.y);
    }

    public int floorZ() {
        return (int)Math.floor(this.z);
    }

    public EnumFacing facing() {
        return Vector3.facing(this.x, this.y, this.z);
    }

    public static EnumFacing facing(double d, double d2, double d3) {
        double d4 = Math.abs(d);
        double d5 = Math.abs(d2);
        double d6 = Math.abs(d3);
        if (d5 >= d4 && d5 >= d6) {
            return d2 < 0.0 ? EnumFacing.DOWN : EnumFacing.UP;
        }
        if (d4 >= d6) {
            return d < 0.0 ? EnumFacing.WEST : EnumFacing.EAST;
        }
        return d3 < 0.0 ? EnumFacing.NORTH : EnumFacing.SOUTH;
    }

    public static Vector3[] faceBasis(EnumFacing enumFacing) {
        return faceBases[enumFacing.ordinal()];
    }

    public static Vec3i getDirectionVec(EnumFacing enumFacing) {
        return directionVec[enumFacing.ordinal()];
    }
}

