/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseModClient;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public abstract class BaseTexture
implements BaseModClient.ITexture {
    public int tintIndex;
    public double red = 1.0;
    public double green = 1.0;
    public double blue = 1.0;
    public boolean isEmissive;
    public boolean isProjected;

    @Override
    public int tintIndex() {
        return this.tintIndex;
    }

    @Override
    public double red() {
        return this.red;
    }

    @Override
    public double green() {
        return this.green;
    }

    @Override
    public double blue() {
        return this.blue;
    }

    @Override
    public boolean isEmissive() {
        return this.isEmissive;
    }

    @Override
    public boolean isProjected() {
        return this.isProjected;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    public static BaseModClient.ITexture fromSprite(TextureAtlasSprite textureAtlasSprite) {
        return new Sprite(textureAtlasSprite);
    }

    public static BaseModClient.ITexture fromImage(ResourceLocation resourceLocation) {
        return new Image(resourceLocation);
    }

    @Override
    public ResourceLocation location() {
        return null;
    }

    @Override
    public BaseModClient.ITexture tinted(int n) {
        Proxy proxy = new Proxy(this);
        proxy.tintIndex = n;
        return proxy;
    }

    @Override
    public BaseModClient.ITexture colored(double d, double d2, double d3) {
        Proxy proxy = new Proxy(this);
        proxy.red = d;
        proxy.green = d2;
        proxy.blue = d3;
        return proxy;
    }

    @Override
    public BaseModClient.ITexture projected() {
        Proxy proxy = new Proxy(this);
        proxy.isProjected = true;
        return proxy;
    }

    public static class Debug
    extends Sprite {
        public Debug(TextureAtlasSprite textureAtlasSprite) {
            super(textureAtlasSprite);
        }

        @Override
        public double interpolateU(double d) {
            double d2 = super.interpolateU(d);
            System.out.printf("BaseTexture: %s u (%s - %s)\n", this.icon.func_94215_i(), Float.valueOf(this.icon.func_94209_e()), Float.valueOf(this.icon.func_94212_f()));
            System.out.printf("BaseTexture: u %s --> %s\n", d, d2);
            return d2;
        }

        @Override
        public double interpolateV(double d) {
            double d2 = super.interpolateV(d);
            System.out.printf("BaseTexture: %s v (%s - %s)\n", this.icon.func_94215_i(), Float.valueOf(this.icon.func_94206_g()), Float.valueOf(this.icon.func_94210_h()));
            System.out.printf("BaseTexture: v %s --> %s\n", d, d2);
            return d2;
        }
    }

    public static class Solid
    extends BaseTexture {
        public Solid(double d, double d2, double d3) {
            this.red = d;
            this.green = d2;
            this.blue = d3;
        }

        @Override
        public boolean isSolid() {
            return true;
        }

        @Override
        public double interpolateU(double d) {
            return 0.0;
        }

        @Override
        public double interpolateV(double d) {
            return 0.0;
        }
    }

    public static class Image
    extends BaseTexture {
        public ResourceLocation location;

        public Image(ResourceLocation resourceLocation) {
            this.location = resourceLocation;
        }

        @Override
        public ResourceLocation location() {
            return this.location;
        }

        @Override
        public double interpolateU(double d) {
            return d;
        }

        @Override
        public double interpolateV(double d) {
            return d;
        }
    }

    public static class Sprite
    extends BaseTexture {
        public TextureAtlasSprite icon;

        public Sprite(TextureAtlasSprite textureAtlasSprite) {
            this.icon = textureAtlasSprite;
            this.blue = 1.0;
            this.green = 1.0;
            this.red = 1.0;
        }

        @Override
        public double interpolateU(double d) {
            return this.icon.func_94214_a(d * 16.0);
        }

        @Override
        public double interpolateV(double d) {
            return this.icon.func_94207_b(d * 16.0);
        }
    }

    public static class Proxy
    extends BaseTexture {
        public BaseModClient.ITexture base;

        public Proxy(BaseModClient.ITexture iTexture) {
            this.base = iTexture;
            this.tintIndex = iTexture.tintIndex();
            this.red = iTexture.red();
            this.green = iTexture.green();
            this.blue = iTexture.blue();
            this.isEmissive = iTexture.isEmissive();
            this.isProjected = iTexture.isProjected();
        }

        @Override
        public ResourceLocation location() {
            return this.base.location();
        }

        @Override
        public boolean isSolid() {
            return this.base.isSolid();
        }

        @Override
        public double interpolateU(double d) {
            return this.base.interpolateU(d);
        }

        @Override
        public double interpolateV(double d) {
            return this.base.interpolateV(d);
        }
    }
}

