/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBakedRenderTarget;
import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseModelRenderer;
import gcewing.architecture.BaseSubsystem;
import gcewing.architecture.BaseTexture;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BaseWorldRenderTarget;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class BaseModClient<MOD extends BaseMod<? extends BaseModClient>>
implements IGuiHandler {
    MOD base;
    boolean customRenderingRequired;
    boolean debugSound = false;
    Map<Integer, Class<? extends GuiScreen>> screenClasses = new HashMap<Integer, Class<? extends GuiScreen>>();
    protected Map<Block, ICustomRenderer> renderers = new HashMap<Block, ICustomRenderer>();
    protected Map<IBlockState, ICustomRenderer> stateRendererCache = new HashMap<IBlockState, ICustomRenderer>();
    protected Map<ResourceLocation, ITexture> textureCache = new HashMap<ResourceLocation, ITexture>();
    protected Map<ResourceLocation, IModel> modelCache = new HashMap<ResourceLocation, IModel>();
    protected CustomBlockRendererDispatcher customBlockRendererDispatcher;
    protected CustomItemModelMesher customItemModelMesher;

    public BaseModClient(MOD MOD) {
        this.base = MOD;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
    }

    public void init(FMLInitializationEvent fMLInitializationEvent) {
    }

    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        this.registerScreens();
        this.registerRenderers();
        this.registerOther();
        for (BaseSubsystem baseSubsystem : ((BaseMod)this.base).subsystems) {
            baseSubsystem.registerScreens();
            baseSubsystem.registerRenderers();
            baseSubsystem.registerModelLocations();
            baseSubsystem.registerOtherClient();
        }
        this.registerSavedVillagerSkins();
        if (this.customRenderingRequired) {
            this.enableCustomRendering();
        }
    }

    void registerSavedVillagerSkins() {
        VillagerRegistry villagerRegistry = VillagerRegistry.instance();
        for (BaseMod.VSBinding vSBinding : ((BaseMod)this.base).registeredVillagers) {
            villagerRegistry.registerVillagerSkin(vSBinding.id, (ResourceLocation)vSBinding.object);
        }
    }

    void registerOther() {
    }

    void registerScreens() {
    }

    public void addScreen(Enum enum_, Class<? extends GuiScreen> clazz) {
        this.addScreen(enum_.ordinal(), clazz);
    }

    public void addScreen(int n, Class<? extends GuiScreen> clazz) {
        this.screenClasses.put(n, clazz);
    }

    void registerRenderers() {
    }

    void addTileEntityRenderer(Class<? extends TileEntity> clazz, TileEntitySpecialRenderer tileEntitySpecialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(clazz, (TileEntitySpecialRenderer)tileEntitySpecialRenderer);
    }

    void addEntityRenderer(Class<? extends Entity> clazz, Render render) {
        RenderingRegistry.registerEntityRenderingHandler(clazz, (Render)render);
    }

    public static void openClientGui(GuiScreen guiScreen) {
        FMLClientHandler.instance().getClient().func_147108_a(guiScreen);
    }

    public ResourceLocation textureLocation(String string) {
        return ((BaseMod)this.base).resourceLocation("textures/" + string);
    }

    public void bindTexture(String string) {
        BaseModClient.bindTexture(this.textureLocation(string));
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(resourceLocation);
    }

    public Object getServerGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return ((BaseMod)this.base).getServerGuiElement(n, entityPlayer, world, n2, n3, n4);
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return this.getClientGuiElement(n, entityPlayer, world, new BlockPos(n2, n3, n4));
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        Class<? extends GuiScreen> clazz;
        int n2 = n >> 16;
        n &= 0xFFFF;
        Object object = null;
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: for id %s\n", n);
        }
        if ((clazz = this.screenClasses.get(n)) != null) {
            block14: {
                Class<? extends Container> clazz2;
                if (((BaseMod)this.base).debugGui) {
                    System.out.printf("BaseModClient.getClientGuiElement: Instantiating %s\n", clazz);
                }
                if ((clazz2 = ((BaseMod)this.base).containerClasses.get(n)) != null) {
                    try {
                        Object object2;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Looking for constructor taking %s\n", clazz2);
                        }
                        Constructor<? extends GuiScreen> constructor = clazz.getConstructor(clazz2);
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating container\n", new Object[0]);
                        }
                        if ((object2 = ((BaseMod)this.base).createGuiElement(clazz2, entityPlayer, world, blockPos, n2)) == null) break block14;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating screen with container\n", new Object[0]);
                        }
                        try {
                            object = constructor.newInstance(object2);
                        }
                        catch (Exception exception) {
                            BaseMod.reportExceptionCause(exception);
                            return null;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (object == null) {
                object = ((BaseMod)this.base).createGuiElement(clazz, entityPlayer, world, blockPos, n2);
            }
        } else {
            object = this.getGuiScreen(n, entityPlayer, world, blockPos, n2);
        }
        ((BaseMod)this.base).setModOf(object);
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: returning %s\n", object);
        }
        return object;
    }

    GuiScreen getGuiScreen(int n, EntityPlayer entityPlayer, World world, BlockPos blockPos, int n2) {
        System.out.printf("%s: BaseModClient.getGuiScreen: No GuiScreen class found for gui id %d\n", this, n);
        return null;
    }

    public void addBlockRenderer(Block block, ICustomRenderer iCustomRenderer) {
        this.renderers.put(block, iCustomRenderer);
        this.customRenderingRequired = true;
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            this.addItemRenderer(item, iCustomRenderer);
        }
    }

    public void addItemRenderer(Item item, ICustomRenderer iCustomRenderer) {
        this.getCustomItemModelMesher().renderers.put(item, iCustomRenderer);
    }

    protected ICustomRenderer getCustomRenderer(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState) {
        Block block = iBlockState.func_177230_c();
        ICustomRenderer iCustomRenderer = this.renderers.get(block);
        if (iCustomRenderer == null && block instanceof BaseMod.IBlock) {
            IBlockState iBlockState2 = block.func_176221_a(iBlockState, iBlockAccess, blockPos);
            iCustomRenderer = this.getCustomRendererForState(iBlockState2);
        }
        return iCustomRenderer;
    }

    protected ICustomRenderer getCustomRendererForSpec(BaseMod.ModelSpec modelSpec) {
        IModel iModel = this.getModel(modelSpec.modelName);
        ITexture[] iTextureArray = new ITexture[modelSpec.textureNames.length];
        for (int i = 0; i < iTextureArray.length; ++i) {
            iTextureArray[i] = this.getTexture(modelSpec.textureNames[i]);
        }
        return new BaseModelRenderer(iModel, iTextureArray);
    }

    protected ICustomRenderer getCustomRendererForState(IBlockState iBlockState) {
        BaseMod.ModelSpec modelSpec;
        Block block;
        ICustomRenderer iCustomRenderer = this.stateRendererCache.get(iBlockState);
        if (iCustomRenderer == null && (block = iBlockState.func_177230_c()) instanceof BaseMod.IBlock && (modelSpec = ((BaseMod.IBlock)block).getModelSpec(iBlockState)) != null) {
            iCustomRenderer = this.getCustomRendererForSpec(modelSpec);
            this.stateRendererCache.put(iBlockState, iCustomRenderer);
        }
        return iCustomRenderer;
    }

    public IModel getModel(String string) {
        return ((BaseMod)this.base).getModel(string);
    }

    public ITexture getTexture(String string) {
        ResourceLocation resourceLocation = ((BaseMod)this.base).textureLocation(string);
        return this.textureCache.get(resourceLocation);
    }

    @SubscribeEvent
    public void onTextureStitchEventPre(TextureStitchEvent.Pre pre) {
        this.textureCache.clear();
        for (Block block : ((BaseMod)this.base).registeredBlocks) {
            this.registerSprites(pre.map, block);
        }
        for (Item item : ((BaseMod)this.base).registeredItems) {
            this.registerSprites(pre.map, item);
        }
    }

    protected void registerSprites(TextureMap textureMap, Object object) {
        System.out.printf("BaseModClient.registerSprites: for %s\n", object);
        if (object instanceof BaseMod.ITextureConsumer) {
            String[] stringArray = ((BaseMod.ITextureConsumer)object).getTextureNames();
            System.out.printf("BaseModClient.registerSprites: texture names = %s\n", new Object[]{stringArray});
            if (stringArray != null) {
                this.customRenderingRequired = true;
                for (String string : stringArray) {
                    ResourceLocation resourceLocation = ((BaseMod)this.base).textureLocation(string);
                    if (this.textureCache.get(resourceLocation) != null) continue;
                    TextureAtlasSprite textureAtlasSprite = textureMap.func_174942_a(resourceLocation);
                    ITexture iTexture = BaseTexture.fromSprite(textureAtlasSprite);
                    this.textureCache.put(resourceLocation, iTexture);
                }
            }
        }
    }

    protected CustomBlockRendererDispatcher getCustomBlockRendererDispatcher() {
        if (this.customBlockRendererDispatcher == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            this.customBlockRendererDispatcher = new CustomBlockRendererDispatcher(minecraft.func_175602_ab());
            BaseUtils.setField(minecraft, "blockRenderDispatcher", "field_175618_aM", (Object)this.customBlockRendererDispatcher);
        }
        return this.customBlockRendererDispatcher;
    }

    protected CustomItemModelMesher getCustomItemModelMesher() {
        if (this.customItemModelMesher == null) {
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            this.customItemModelMesher = new CustomItemModelMesher(renderItem.func_175037_a());
            BaseUtils.setField(renderItem, "itemModelMesher", "field_175059_m", (Object)this.customItemModelMesher);
        }
        return this.customItemModelMesher;
    }

    public void enableCustomRendering() {
        this.getCustomBlockRendererDispatcher();
        this.getCustomItemModelMesher();
    }

    protected class CustomItemModelMesher
    extends ItemModelMesher {
        protected ItemModelMesher base;
        protected Map<Item, ICustomRenderer> renderers;

        public CustomItemModelMesher(ItemModelMesher itemModelMesher) {
            super(null);
            this.renderers = new HashMap<Item, ICustomRenderer>();
            this.base = itemModelMesher;
        }

        public TextureAtlasSprite func_178082_a(Item item) {
            return this.base.func_178082_a(item);
        }

        public TextureAtlasSprite func_178087_a(Item item, int n) {
            return this.base.func_178087_a(item, n);
        }

        public void func_178086_a(Item item, int n, ModelResourceLocation modelResourceLocation) {
            this.base.func_178086_a(item, n, modelResourceLocation);
        }

        public void func_178080_a(Item item, ItemMeshDefinition itemMeshDefinition) {
            this.base.func_178080_a(item, itemMeshDefinition);
        }

        public ModelManager func_178083_a() {
            return this.base.func_178083_a();
        }

        public void func_178085_b() {
            this.base.func_178085_b();
        }

        public IBakedModel func_178089_a(ItemStack itemStack) {
            Object object;
            Item item = itemStack.func_77973_b();
            ICustomRenderer iCustomRenderer = this.renderers.get(item);
            if (iCustomRenderer == null && item instanceof BaseMod.IItem && (object = ((BaseMod.IItem)item).getModelSpec(itemStack)) != null) {
                iCustomRenderer = BaseModClient.this.getCustomRendererForSpec((BaseMod.ModelSpec)object);
            }
            if (iCustomRenderer == null && (object = Block.func_149634_a((Item)item)) != null) {
                iCustomRenderer = BaseModClient.this.getCustomRendererForState(object.func_176223_P());
            }
            if (iCustomRenderer != null) {
                GlStateManager.func_179103_j((int)7425);
                object = new BaseBakedRenderTarget();
                iCustomRenderer.renderItemStack(itemStack, (IRenderTarget)object);
                return ((BaseBakedRenderTarget)object).getBakedModel();
            }
            return this.base.func_178089_a(itemStack);
        }
    }

    protected class CustomBlockRendererDispatcher
    extends BlockRendererDispatcher {
        protected BlockRendererDispatcher base;
        ChunkCoordIntPair lastChunk;
        int numBlocks;

        public CustomBlockRendererDispatcher(BlockRendererDispatcher blockRendererDispatcher) {
            super(null, null);
            this.base = blockRendererDispatcher;
        }

        public BlockModelShapes func_175023_a() {
            return this.base.func_175023_a();
        }

        public BlockModelRenderer func_175019_b() {
            return this.base.func_175019_b();
        }

        public IBakedModel func_175022_a(IBlockState iBlockState, IBlockAccess iBlockAccess, BlockPos blockPos) {
            return this.base.func_175022_a(iBlockState, iBlockAccess, blockPos);
        }

        public void func_175016_a(IBlockState iBlockState, float f) {
            this.base.func_175016_a(iBlockState, f);
        }

        public boolean func_175021_a(Block block, int n) {
            return this.base.func_175021_a(block, n);
        }

        public void func_175020_a(IBlockState iBlockState, BlockPos blockPos, TextureAtlasSprite textureAtlasSprite, IBlockAccess iBlockAccess) {
            ICustomRenderer iCustomRenderer = BaseModClient.this.getCustomRenderer(iBlockAccess, blockPos, iBlockState);
            if (iCustomRenderer != null) {
                WorldRenderer worldRenderer = Tessellator.func_178181_a().func_178180_c();
                this.customRenderBlock(iBlockAccess, blockPos, iBlockState, worldRenderer, textureAtlasSprite, iCustomRenderer);
            } else {
                this.base.func_175020_a(iBlockState, blockPos, textureAtlasSprite, iBlockAccess);
            }
        }

        public boolean func_175018_a(IBlockState iBlockState, BlockPos blockPos, IBlockAccess iBlockAccess, WorldRenderer worldRenderer) {
            ICustomRenderer iCustomRenderer = BaseModClient.this.getCustomRenderer(iBlockAccess, blockPos, iBlockState);
            if (iCustomRenderer != null) {
                return this.customRenderBlock(iBlockAccess, blockPos, iBlockState, worldRenderer, null, iCustomRenderer);
            }
            return this.base.func_175018_a(iBlockState, blockPos, iBlockAccess, worldRenderer);
        }

        protected boolean customRenderBlock(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, WorldRenderer worldRenderer, TextureAtlasSprite textureAtlasSprite, ICustomRenderer iCustomRenderer) {
            BaseWorldRenderTarget baseWorldRenderTarget = new BaseWorldRenderTarget(iBlockAccess, blockPos, worldRenderer, textureAtlasSprite);
            iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, baseWorldRenderTarget, MinecraftForgeClient.getRenderLayer());
            return baseWorldRenderTarget.end();
        }
    }

    public static interface IModel {
        public AxisAlignedBB getBounds();

        public void addBoxesToList(Trans3 var1, List var2);

        public void render(Trans3 var1, IRenderTarget var2, ITexture ... var3);
    }

    public static interface IRenderTarget {
        public void setTexture(ITexture var1);

        public void setColor(double var1, double var3, double var5, double var7);

        public void setNormal(Vector3 var1);

        public void beginTriangle();

        public void beginQuad();

        public void addVertex(Vector3 var1, double var2, double var4);

        public void addProjectedVertex(Vector3 var1, EnumFacing var2);

        public void endFace();
    }

    public static interface ITexture {
        public ResourceLocation location();

        public int tintIndex();

        public double red();

        public double green();

        public double blue();

        public double interpolateU(double var1);

        public double interpolateV(double var1);

        public boolean isEmissive();

        public boolean isProjected();

        public boolean isSolid();

        public ITexture tinted(int var1);

        public ITexture colored(double var1, double var3, double var5);

        public ITexture projected();
    }

    public static interface ICustomRenderer {
        public void renderBlock(IBlockAccess var1, BlockPos var2, IBlockState var3, IRenderTarget var4, EnumWorldBlockLayer var5);

        public void renderItemStack(ItemStack var1, IRenderTarget var2);
    }
}

