/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.Trans3;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseBlock<TE extends TileEntity>
extends BlockContainer
implements BaseMod.IBlock {
    public static boolean debugState = false;
    public static IOrientationHandler orient1Way = new Orient1Way();
    protected IProperty[] properties;
    protected Object[][] propertyValues;
    protected int numProperties;
    protected int renderID = 3;
    protected Class<? extends TileEntity> tileEntityClass = null;

    public BaseBlock(Material material) {
        this(material, null);
    }

    public BaseBlock(Material material, Class<TE> clazz) {
        this(material, clazz, null);
    }

    public BaseBlock(Material material, Class<TE> clazz, String string) {
        super(material);
        this.tileEntityClass = clazz;
        if (clazz != null) {
            if (string == null) {
                string = clazz.getName();
            }
            try {
                GameRegistry.registerTileEntity(clazz, (String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public IOrientationHandler getOrientationHandler() {
        return orient1Way;
    }

    protected void defineProperties() {
        this.properties = new IProperty[4];
        this.propertyValues = new Object[4][];
        this.getOrientationHandler().defineProperties(this);
    }

    protected void addProperty(IProperty iProperty) {
        if (debugState) {
            System.out.printf("BaseBlock.addProperty: %s to %s\n", iProperty, this.getClass().getName());
        }
        if (this.numProperties >= 4) {
            throw new IllegalStateException("Block " + this.getClass().getName() + " has too many properties");
        }
        int n = this.numProperties++;
        this.properties[n] = iProperty;
        Object[] objectArray = BaseUtils.arrayOf(iProperty.func_177700_c());
        Arrays.sort(objectArray);
        this.propertyValues[n] = objectArray;
        System.out.printf("BaseBlock.addProperty: %s now has %s properties\n", this.getClass().getName(), this.numProperties);
    }

    protected BlockState func_180661_e() {
        if (debugState) {
            System.out.printf("BaseBlock.createBlockState: Defining properties\n", new Object[0]);
        }
        this.defineProperties();
        if (debugState) {
            this.dumpProperties();
        }
        this.checkProperties();
        IProperty[] iPropertyArray = Arrays.copyOf(this.properties, this.numProperties);
        if (debugState) {
            System.out.printf("BaseBlock.createBlockState: Creating BlockState with %s properties\n", iPropertyArray.length);
        }
        return new BlockState((Block)this, iPropertyArray);
    }

    private void dumpProperties() {
        System.out.printf("BaseBlock: Properties of %s:\n", this.getClass().getName());
        for (int i = 0; i < this.numProperties; ++i) {
            System.out.printf("%s: %s\n", i, this.properties[i]);
            Object[] objectArray = this.propertyValues[i];
            for (int j = 0; j < objectArray.length; ++j) {
                System.out.printf("   %s: %s\n", j, objectArray[j]);
            }
        }
    }

    protected void checkProperties() {
        int n = 1;
        for (int i = 0; i < this.numProperties; ++i) {
            n *= this.propertyValues[i].length;
        }
        if (n > 16) {
            throw new IllegalStateException(String.format("Block %s has %s combinations of property values (16 allowed)", this.getClass().getName(), n));
        }
    }

    public int func_176201_c(IBlockState iBlockState) {
        int n = 0;
        for (int i = this.numProperties - 1; i >= 0; --i) {
            Comparable comparable = iBlockState.func_177229_b(this.properties[i]);
            Object[] objectArray = this.propertyValues[i];
            int n2 = Arrays.binarySearch(objectArray, comparable);
            if (debugState) {
                System.out.printf("BaseBlock.getMetaFromState: property %s value %s --> %s of %s\n", i, comparable, n2, objectArray.length);
            }
            if (n2 < 0) {
                n2 = 0;
            }
            n = n * objectArray.length + n2;
        }
        if (debugState) {
            System.out.printf("BaseBlock.getMetaFromState: %s --> %s\n", iBlockState, n);
        }
        return n & 0xF;
    }

    public IBlockState func_176203_a(int n) {
        IBlockState iBlockState = this.func_176223_P();
        int n2 = n;
        for (int i = this.numProperties - 1; i >= 0; --i) {
            Object[] objectArray = this.propertyValues[i];
            int n3 = objectArray.length;
            int n4 = n2 % n3;
            n2 /= n3;
            iBlockState = iBlockState.func_177226_a(this.properties[i], (Comparable)objectArray[n4]);
        }
        if (debugState) {
            System.out.printf("BaseBlock.getStateFromMeta: %s --> %s\n", n, iBlockState);
        }
        return iBlockState;
    }

    public int func_149645_b() {
        return this.renderID;
    }

    @Override
    public String[] getTextureNames() {
        return null;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState iBlockState) {
        return null;
    }

    @Override
    public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState) {
        IOrientationHandler iOrientationHandler = this.getOrientationHandler();
        return iOrientationHandler.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState);
    }

    public boolean hasTileEntity(IBlockState iBlockState) {
        return this.tileEntityClass != null;
    }

    public TE getTileEntity(IBlockAccess iBlockAccess, BlockPos blockPos) {
        if (this.func_149716_u()) {
            return (TE)iBlockAccess.func_175625_s(blockPos);
        }
        return null;
    }

    public TileEntity func_149915_a(World world, int n) {
        if (this.tileEntityClass != null) {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    public IBlockState func_180642_a(World world, BlockPos blockPos, EnumFacing enumFacing, float f, float f2, float f3, int n, EntityLivingBase entityLivingBase) {
        IBlockState iBlockState = this.getOrientationHandler().onBlockPlaced((Block)this, world, blockPos, enumFacing, f, f2, f3, n, entityLivingBase);
        return iBlockState;
    }

    public void func_176213_c(World world, BlockPos blockPos, IBlockState iBlockState) {
        TE TE;
        super.func_176213_c(world, blockPos, iBlockState);
        if (this.hasTileEntity(iBlockState) && (TE = this.getTileEntity((IBlockAccess)world, blockPos)) instanceof BaseMod.ITileEntity) {
            ((BaseMod.ITileEntity)TE).onAddedToWorld();
        }
    }

    public void func_180663_b(World world, BlockPos blockPos, IBlockState iBlockState) {
        TileEntity tileEntity;
        if (this.hasTileEntity(iBlockState) && (tileEntity = world.func_175625_s(blockPos)) instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)blockPos, (IInventory)((IInventory)tileEntity));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition movingObjectPosition, EffectRenderer effectRenderer) {
        BlockPos blockPos = movingObjectPosition.func_178782_a();
        IBlockState iBlockState = this.getParticleState((IBlockAccess)world, blockPos);
        int n = blockPos.func_177958_n();
        int n2 = blockPos.func_177956_o();
        int n3 = blockPos.func_177952_p();
        float f = 0.1f;
        double d = (double)n + RANDOM.nextDouble() * (this.func_149753_y() - this.func_149704_x() - (double)(f * 2.0f)) + (double)f + this.func_149704_x();
        double d2 = (double)n2 + RANDOM.nextDouble() * (this.func_149669_A() - this.func_149665_z() - (double)(f * 2.0f)) + (double)f + this.func_149665_z();
        double d3 = (double)n3 + RANDOM.nextDouble() * (this.func_149693_C() - this.func_149706_B() - (double)(f * 2.0f)) + (double)f + this.func_149706_B();
        switch (movingObjectPosition.field_178784_b) {
            case DOWN: {
                d2 = (double)n2 + this.func_149665_z() - (double)f;
                break;
            }
            case UP: {
                d2 = (double)n2 + this.func_149669_A() + (double)f;
                break;
            }
            case NORTH: {
                d3 = (double)n3 + this.func_149706_B() - (double)f;
                break;
            }
            case SOUTH: {
                d3 = (double)n3 + this.func_149693_C() + (double)f;
                break;
            }
            case WEST: {
                d = (double)n + this.func_149704_x() - (double)f;
                break;
            }
            case EAST: {
                d = (double)n + this.func_149753_y() + (double)f;
            }
        }
        DiggingFX diggingFX = new DiggingFX(world, d, d2, d3, 0.0, 0.0, 0.0, iBlockState);
        effectRenderer.func_78873_a(diggingFX.func_174846_a(blockPos).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos blockPos, EffectRenderer effectRenderer) {
        IBlockState iBlockState = this.getParticleState((IBlockAccess)world, blockPos);
        int n = 4;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n; ++k) {
                    double d = (double)blockPos.func_177958_n() + ((double)i + 0.5) / (double)n;
                    double d2 = (double)blockPos.func_177956_o() + ((double)j + 0.5) / (double)n;
                    double d3 = (double)blockPos.func_177952_p() + ((double)k + 0.5) / (double)n;
                    DiggingFX diggingFX = new DiggingFX(world, d, d2, d3, d - (double)blockPos.func_177958_n() - 0.5, d2 - (double)blockPos.func_177956_o() - 0.5, d3 - (double)blockPos.func_177952_p() - 0.5, iBlockState);
                    effectRenderer.func_78873_a((EntityFX)diggingFX.func_174846_a(blockPos));
                }
            }
        }
        return true;
    }

    public IBlockState getParticleState(IBlockAccess iBlockAccess, BlockPos blockPos) {
        IBlockState iBlockState = iBlockAccess.func_180495_p(blockPos);
        return this.func_176221_a(iBlockState, iBlockAccess, blockPos);
    }

    @SideOnly(value=Side.CLIENT)
    public static class DiggingFX
    extends EntityDiggingFX {
        public DiggingFX(World world, double d, double d2, double d3, double d4, double d5, double d6, IBlockState iBlockState) {
            super(world, d, d2, d3, d4, d5, d6, iBlockState);
        }
    }

    public static class Orient1Way
    implements IOrientationHandler {
        @Override
        public void defineProperties(BaseBlock baseBlock) {
        }

        @Override
        public IBlockState onBlockPlaced(Block block, World world, BlockPos blockPos, EnumFacing enumFacing, float f, float f2, float f3, int n, EntityLivingBase entityLivingBase) {
            return block.func_176223_P();
        }

        @Override
        public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState) {
            return new Trans3((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
        }
    }

    public static interface IOrientationHandler {
        public void defineProperties(BaseBlock var1);

        public IBlockState onBlockPlaced(Block var1, World var2, BlockPos var3, EnumFacing var4, float var5, float var6, float var7, int var8, EntityLivingBase var9);

        public Trans3 localToGlobalTransformation(IBlockAccess var1, BlockPos var2, IBlockState var3);
    }
}

