/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseRenderTarget;
import gcewing.architecture.Vector3;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IColoredBakedQuad;

public class BaseBakedRenderTarget
extends BaseRenderTarget {
    protected static List<BakedQuad> emptyQuads = new ArrayList<BakedQuad>();
    protected static List<List<BakedQuad>> faceQuads = new ArrayList<List<BakedQuad>>();
    protected VertexFormat format = Attributes.DEFAULT_BAKED_FORMAT;
    protected int bytesPerVertex = this.format.func_177338_f();
    protected int intsPerVertex = this.bytesPerVertex / 4;
    protected ByteBuffer buf = ByteBuffer.allocate(this.bytesPerVertex * 4);
    protected List<BakedQuad> quads = new ArrayList<BakedQuad>();
    protected static ItemCameraTransforms transforms;

    public BaseBakedRenderTarget() {
        super(0.0, 0.0, 0.0);
    }

    @Override
    protected void setMode(int n) {
        super.setMode(n);
        this.buf.clear();
    }

    @Override
    public void endFace() {
        int n;
        super.endFace();
        this.buf.flip();
        int n2 = this.intsPerVertex * 4;
        int[] nArray = new int[n2];
        IntBuffer intBuffer = this.buf.asIntBuffer();
        intBuffer.get(nArray, 0, n);
        for (n = intBuffer.limit(); n < n2; ++n) {
            nArray[n] = nArray[n - this.intsPerVertex];
        }
        this.prescrambleVertexColors(nArray);
        this.quads.add((BakedQuad)new IColoredBakedQuad.ColoredBakedQuad(nArray, 0, EnumFacing.UP));
    }

    protected void dumpVertexData(int[] nArray, int n) {
        System.out.printf("BaseBakedRenderTarget.endFace: Vertex data:\n", new Object[0]);
        for (int i = 0; i < 4; ++i) {
            int n2 = i * this.intsPerVertex;
            System.out.printf("[%s] coords (%.3f,%.3f,%.3f) color %08x\n", i, Float.valueOf(Float.intBitsToFloat(nArray[n2])), Float.valueOf(Float.intBitsToFloat(nArray[n2 + 1])), Float.valueOf(Float.intBitsToFloat(nArray[n2 + 2])), nArray[n2 + 3]);
        }
    }

    protected void prescrambleVertexColors(int[] nArray) {
        int n;
        int[] nArray2 = new int[4];
        for (n = 0; n < 4; ++n) {
            nArray2[n] = nArray[n * this.intsPerVertex + 3];
        }
        for (n = 0; n < 4; ++n) {
            nArray[n * this.intsPerVertex + 3] = nArray2[3 - n];
        }
    }

    public IBakedModel getBakedModel() {
        if (this.verticesPerFace != 0) {
            throw new IllegalStateException("Rendering ended with incomplete face");
        }
        return new SimpleBakedModel(this.quads, faceQuads, false, true, null, transforms);
    }

    @Override
    protected void rawAddVertex(Vector3 vector3, double d, double d2) {
        block5: for (VertexFormatElement vertexFormatElement : this.format.func_177343_g()) {
            switch (vertexFormatElement.func_177375_c()) {
                case POSITION: {
                    this.putElement(vertexFormatElement, vector3.x, vector3.y, vector3.z);
                    continue block5;
                }
                case COLOR: {
                    this.putElement(vertexFormatElement, Float.valueOf(this.alpha), Float.valueOf(this.shade * this.blue), Float.valueOf(this.shade * this.green), Float.valueOf(this.shade * this.red));
                    continue block5;
                }
                case UV: {
                    this.putElement(vertexFormatElement, d, d2);
                    continue block5;
                }
            }
            this.putElement(vertexFormatElement, new Number[0]);
        }
    }

    protected void putElement(VertexFormatElement vertexFormatElement, Number ... numberArray) {
        block9: for (int i = 0; i < vertexFormatElement.func_177370_d(); ++i) {
            Number number = i < numberArray.length ? (Number)numberArray[i] : (Number)0;
            switch (vertexFormatElement.func_177367_b()) {
                case BYTE: {
                    this.buf.put((byte)(number.floatValue() * 127.0f));
                    continue block9;
                }
                case UBYTE: {
                    this.buf.put((byte)(number.floatValue() * 255.0f));
                    continue block9;
                }
                case SHORT: {
                    this.buf.putShort((short)(number.floatValue() * 32767.0f));
                    continue block9;
                }
                case USHORT: {
                    this.buf.putShort((short)(number.floatValue() * 65535.0f));
                    continue block9;
                }
                case INT: {
                    this.buf.putInt((int)(number.doubleValue() * 2.147483647E9));
                    continue block9;
                }
                case UINT: {
                    this.buf.putInt((int)(number.doubleValue() * -1.0));
                    continue block9;
                }
                case FLOAT: {
                    this.buf.putFloat(number.floatValue());
                }
            }
        }
    }

    static {
        for (int i = 0; i < 6; ++i) {
            faceQuads.add(emptyQuads);
        }
        transforms = new ItemCameraTransforms(new ItemTransformVec3f(new Vector3f(10.0f, -45.0f, 170.0f), new Vector3f(0.0f, 0.09375f, -0.171875f), new Vector3f(0.375f, 0.375f, 0.375f)), ItemCameraTransforms.field_178357_a.field_178356_c, ItemCameraTransforms.field_178357_a.field_178353_d, ItemCameraTransforms.field_178357_a.field_178354_e);
    }
}

