/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseTileEntity;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BlockPos;
import gcewing.architecture.CladdingItem;
import gcewing.architecture.EnumWorldBlockLayer;
import gcewing.architecture.IBlockState;
import gcewing.architecture.Shape;
import gcewing.architecture.Trans3;
import gcewing.architecture.Utils;
import gcewing.architecture.Vector3;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public class ShapeTE
extends BaseTileEntity {
    public Shape shape;
    public IBlockState baseBlockState;
    public IBlockState secondaryBlockState;
    public int disabledConnections;
    private byte offsetX;

    public static ShapeTE get(IBlockAccess iBlockAccess, BlockPos blockPos) {
        TileEntity tileEntity;
        if (iBlockAccess != null && (tileEntity = BaseBlockUtils.getWorldTileEntity(iBlockAccess, blockPos)) instanceof ShapeTE) {
            return (ShapeTE)tileEntity;
        }
        return null;
    }

    public ShapeTE() {
        this.shape = Shape.RoofTile;
        this.baseBlockState = BaseBlockUtils.getDefaultBlockState(Blocks.field_150344_f);
    }

    public ShapeTE(Shape shape, IBlockState iBlockState) {
        this.shape = shape;
        this.baseBlockState = iBlockState;
    }

    public ShapeTE(Shape shape, Block block, int n) {
        this.shape = shape;
        this.baseBlockState = BaseBlockUtils.getBlockStateFromMeta(block, n);
    }

    double getOffsetX() {
        return (double)this.offsetX * 0.0625;
    }

    public void setOffsetX(double d) {
        this.offsetX = (byte)(16.0 * d);
    }

    @Override
    public Trans3 localToGlobalTransformation(Vector3 vector3) {
        return super.localToGlobalTransformation(vector3).translate(this.getOffsetX(), 0.0, 0.0);
    }

    public boolean connectionIsEnabledGlobal(EnumFacing enumFacing) {
        return (this.disabledConnections & 1 << enumFacing.ordinal()) == 0;
    }

    public void setConnectionEnabledGlobal(EnumFacing enumFacing, boolean bl) {
        int n = 1 << enumFacing.ordinal();
        this.disabledConnections = bl ? (this.disabledConnections &= ~n) : (this.disabledConnections |= n);
        this.markChanged();
    }

    public void toggleConnectionGlobal(EnumFacing enumFacing) {
        boolean bl = !this.connectionIsEnabledGlobal(enumFacing);
        this.setConnectionEnabledGlobal(enumFacing, bl);
        ShapeTE shapeTE = this.getNeighbourGlobal(enumFacing);
        if (shapeTE != null) {
            shapeTE.setConnectionEnabledGlobal(BaseUtils.oppositeFacing(enumFacing), bl);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.readShapeFromNBT(nBTTagCompound);
        this.readSecondaryMaterialFromNBT(nBTTagCompound);
        this.offsetX = nBTTagCompound.func_74771_c("offsetX");
    }

    @Override
    public void readFromItemStackNBT(NBTTagCompound nBTTagCompound) {
        this.readShapeFromNBT(nBTTagCompound);
    }

    protected void readShapeFromNBT(NBTTagCompound nBTTagCompound) {
        this.shape = Shape.forId(nBTTagCompound.func_74762_e("Shape"));
        this.baseBlockState = this.nbtGetBlockState(nBTTagCompound, "BaseName", "BaseData");
        if (this.baseBlockState == null) {
            this.baseBlockState = BaseBlockUtils.getDefaultBlockState(Blocks.field_150344_f);
        }
        this.disabledConnections = nBTTagCompound.func_74762_e("Disconnected");
    }

    protected void readSecondaryMaterialFromNBT(NBTTagCompound nBTTagCompound) {
        this.secondaryBlockState = this.nbtGetBlockState(nBTTagCompound, "Name2", "Data2");
    }

    protected IBlockState nbtGetBlockState(NBTTagCompound nBTTagCompound, String string, String string2) {
        String string3 = nBTTagCompound.func_74779_i(string);
        if (string3 != null && string3.length() > 0) {
            Block block = Block.func_149684_b((String)string3);
            int n = nBTTagCompound.func_74762_e(string2);
            IBlockState iBlockState = BaseBlockUtils.getBlockStateFromMeta(block, n);
            return iBlockState;
        }
        return null;
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        this.writeShapeToNBT(nBTTagCompound);
        this.writeSecondaryMaterialToNBT(nBTTagCompound);
        if (this.offsetX != 0) {
            nBTTagCompound.func_74774_a("offsetX", this.offsetX);
        }
    }

    @Override
    public void writeToItemStackNBT(NBTTagCompound nBTTagCompound) {
        this.writeShapeToNBT(nBTTagCompound);
    }

    protected void writeShapeToNBT(NBTTagCompound nBTTagCompound) {
        if (this.shape != null) {
            nBTTagCompound.func_74768_a("Shape", this.shape.id);
            this.nbtSetBlockState(nBTTagCompound, "BaseName", "BaseData", this.baseBlockState);
        }
        if (this.disabledConnections != 0) {
            nBTTagCompound.func_74768_a("Disconnected", this.disabledConnections);
        }
    }

    protected void writeSecondaryMaterialToNBT(NBTTagCompound nBTTagCompound) {
        this.nbtSetBlockState(nBTTagCompound, "Name2", "Data2", this.secondaryBlockState);
    }

    protected void nbtSetBlockState(NBTTagCompound nBTTagCompound, String string, String string2, IBlockState iBlockState) {
        if (iBlockState != null) {
            Block block = iBlockState.getBlock();
            nBTTagCompound.func_74778_a(string, BaseBlockUtils.getNameForBlock(block));
            nBTTagCompound.func_74768_a(string2, BaseBlockUtils.getMetaFromBlockState(iBlockState));
        }
    }

    public void onChiselUse(EntityPlayer entityPlayer, EnumFacing enumFacing, float f, float f2, float f3) {
        this.shape.kind.onChiselUse(this, entityPlayer, enumFacing, this.hitVec(f, f2, f3));
    }

    public void onHammerUse(EntityPlayer entityPlayer, EnumFacing enumFacing, float f, float f2, float f3) {
        this.shape.kind.onHammerUse(this, entityPlayer, enumFacing, this.hitVec(f, f2, f3));
    }

    protected Vector3 hitVec(float f, float f2, float f3) {
        return new Vector3((double)f - 0.5, (double)f2 - 0.5, (double)f3 - 0.5);
    }

    public EnumFacing globalFace(EnumFacing enumFacing) {
        return this.localToGlobalRotation().t(enumFacing);
    }

    public EnumFacing localFace(EnumFacing enumFacing) {
        return this.localToGlobalRotation().it(enumFacing);
    }

    public boolean applySecondaryMaterial(ItemStack itemStack, EntityPlayer entityPlayer) {
        IBlockState iBlockState = null;
        Item item = itemStack.func_77973_b();
        if (item instanceof CladdingItem && this.shape.kind.acceptsCladding()) {
            iBlockState = ((CladdingItem)item).blockStateFromStack(itemStack);
        } else {
            IBlockState iBlockState2;
            Block block = Block.func_149634_a((Item)item);
            if (block != null && this.shape.kind.isValidSecondaryMaterial(iBlockState2 = BaseBlockUtils.getBlockStateFromMeta(block, BaseUtils.getStackMetadata(itemStack)))) {
                iBlockState = iBlockState2;
            }
        }
        if (iBlockState != null) {
            if (this.secondaryBlockState == null) {
                this.setSecondaryMaterial(iBlockState);
                if (!Utils.playerIsInCreativeMode(entityPlayer)) {
                    --itemStack.field_77994_a;
                }
            }
            return true;
        }
        return false;
    }

    public void setSecondaryMaterial(IBlockState iBlockState) {
        this.secondaryBlockState = iBlockState;
        this.markChanged();
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer enumWorldBlockLayer) {
        if (BaseBlockUtils.blockCanRenderInLayer(this.baseBlockState.getBlock(), enumWorldBlockLayer)) {
            return true;
        }
        if (this.secondaryBlockState != null) {
            return BaseBlockUtils.blockCanRenderInLayer(this.secondaryBlockState.getBlock(), enumWorldBlockLayer);
        }
        return false;
    }

    public ShapeTE getNeighbourGlobal(EnumFacing enumFacing) {
        return ShapeTE.get((IBlockAccess)this.field_145850_b, this.getPos().offset(enumFacing));
    }

    public ShapeTE getConnectedNeighbourGlobal(EnumFacing enumFacing) {
        ShapeTE shapeTE;
        if (this.field_145850_b != null && this.connectionIsEnabledGlobal(enumFacing) && (shapeTE = this.getNeighbourGlobal(enumFacing)) != null && shapeTE.connectionIsEnabledGlobal(BaseUtils.oppositeFacing(enumFacing))) {
            return shapeTE;
        }
        return null;
    }
}

