/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseTexture;
import gcewing.architecture.BlockPos;
import gcewing.architecture.EnumWorldBlockLayer;
import gcewing.architecture.IBlockState;
import gcewing.architecture.ShapeTE;
import gcewing.architecture.Trans3;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class ShapeRenderDispatch
implements BaseModClient.ICustomRenderer {
    @Override
    public void renderBlock(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, BaseModClient.IRenderTarget iRenderTarget, EnumWorldBlockLayer enumWorldBlockLayer, Trans3 trans3) {
        ShapeTE shapeTE = ShapeTE.get(iBlockAccess, blockPos);
        if (shapeTE != null) {
            Trans3 trans32 = trans3.t(shapeTE.localToGlobalRotation());
            boolean bl = shapeTE.baseBlockState != null && BaseBlockUtils.blockCanRenderInLayer(shapeTE.baseBlockState.getBlock(), enumWorldBlockLayer);
            boolean bl2 = shapeTE.secondaryBlockState != null && BaseBlockUtils.blockCanRenderInLayer(shapeTE.secondaryBlockState.getBlock(), enumWorldBlockLayer);
            this.renderShapeTE(shapeTE, iRenderTarget, trans32, bl, bl2);
        }
    }

    @Override
    public void renderItemStack(ItemStack itemStack, BaseModClient.IRenderTarget iRenderTarget, Trans3 trans3) {
        ShapeTE shapeTE = new ShapeTE();
        shapeTE.readFromItemStack(itemStack);
        this.renderShapeTE(shapeTE, iRenderTarget, trans3.t(Trans3.sideTurn(0, 3)), shapeTE.baseBlockState != null, shapeTE.secondaryBlockState != null);
    }

    protected void renderShapeTE(ShapeTE shapeTE, BaseModClient.IRenderTarget iRenderTarget, Trans3 trans3, boolean bl, boolean bl2) {
        IBlockState iBlockState;
        if (shapeTE.shape != null && (bl || bl2) && (iBlockState = shapeTE.baseBlockState) != null) {
            IIcon iIcon = BaseBlockUtils.getSpriteForBlockState(iBlockState);
            IIcon iIcon2 = BaseBlockUtils.getSpriteForBlockState(shapeTE.secondaryBlockState);
            if (iIcon != null) {
                BaseModClient.ITexture[] iTextureArray = new BaseModClient.ITexture[4];
                if (bl) {
                    iTextureArray[0] = BaseTexture.fromSprite(iIcon);
                    iTextureArray[1] = iTextureArray[0].projected();
                }
                if (bl2) {
                    if (iIcon2 != null) {
                        iTextureArray[2] = BaseTexture.fromSprite(iIcon2);
                        iTextureArray[3] = iTextureArray[2].projected();
                    } else {
                        bl2 = false;
                    }
                }
                if (bl && shapeTE.shape.kind.secondaryDefaultsToBase() && (iIcon2 == null || shapeTE.secondaryBlockState != null && shapeTE.secondaryBlockState.getBlock().func_149701_w() != 0)) {
                    iTextureArray[2] = iTextureArray[0];
                    iTextureArray[3] = iTextureArray[1];
                    bl2 = bl;
                }
                shapeTE.shape.kind.renderShape(shapeTE, iTextureArray, iRenderTarget, trans3, bl, bl2);
            }
        }
    }
}

