/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.ArchitectureCraft;
import gcewing.architecture.BaseBlock;
import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseDirections;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseModel;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BlockPos;
import gcewing.architecture.IBlockState;
import gcewing.architecture.Profile;
import gcewing.architecture.RenderRoof;
import gcewing.architecture.RenderWindow;
import gcewing.architecture.Shape;
import gcewing.architecture.ShapeSymmetry;
import gcewing.architecture.ShapeTE;
import gcewing.architecture.Trans3;
import gcewing.architecture.Utils;
import gcewing.architecture.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public abstract class ShapeKind {
    public Object[] profiles;
    public static Roof Roof = new Roof();
    public static Cladding Cladding = new Cladding();

    public Object profileForLocalFace(Shape shape, EnumFacing enumFacing) {
        if (this.profiles != null) {
            return this.profiles[enumFacing.ordinal()];
        }
        return null;
    }

    public double placementOffsetX() {
        return 0.0;
    }

    public abstract void renderShape(ShapeTE var1, BaseModClient.ITexture[] var2, BaseModClient.IRenderTarget var3, Trans3 var4, boolean var5, boolean var6);

    public ItemStack newStack(Shape shape, Block block, int n, int n2) {
        ShapeTE shapeTE = new ShapeTE(shape, block, n);
        return BaseUtils.blockStackWithTileEntity((Block)ArchitectureCraft.blockShape, n2, shapeTE);
    }

    public boolean orientOnPlacement(EntityPlayer entityPlayer, ShapeTE shapeTE, BlockPos blockPos, IBlockState iBlockState, TileEntity tileEntity, EnumFacing enumFacing, Vector3 vector3) {
        if (tileEntity instanceof ShapeTE) {
            return this.orientOnPlacement(entityPlayer, shapeTE, (ShapeTE)tileEntity, enumFacing, vector3);
        }
        return this.orientOnPlacement(entityPlayer, shapeTE, null, enumFacing, vector3);
    }

    public boolean orientOnPlacement(EntityPlayer entityPlayer, ShapeTE shapeTE, ShapeTE shapeTE2, EnumFacing enumFacing, Vector3 vector3) {
        Object object;
        if (shapeTE2 != null && !entityPlayer.func_70093_af() && (object = Profile.getProfileGlobal(shapeTE2.shape, shapeTE2.side, shapeTE2.turn, enumFacing)) != null) {
            EnumFacing enumFacing2 = BaseUtils.oppositeFacing(enumFacing);
            for (int i = 0; i < 4; ++i) {
                int n = shapeTE2.turn + i & 3;
                Object object2 = Profile.getProfileGlobal(shapeTE.shape, shapeTE2.side, n, enumFacing2);
                if (!Profile.matches(object2, object)) continue;
                shapeTE.setSide(shapeTE2.side);
                shapeTE.setTurn(n);
                shapeTE.setOffsetX(shapeTE2.getOffsetX());
                return true;
            }
        }
        return false;
    }

    public boolean canPlaceUpsideDown() {
        return true;
    }

    public double sideZoneSize() {
        return 0.25;
    }

    public boolean highlightZones() {
        return false;
    }

    public void onChiselUse(ShapeTE shapeTE, EntityPlayer entityPlayer, EnumFacing enumFacing, Vector3 vector3) {
        EnumFacing enumFacing2 = this.zoneHit(enumFacing, vector3);
        if (enumFacing2 != null) {
            this.chiselUsedOnSide(shapeTE, entityPlayer, enumFacing2);
        } else {
            this.chiselUsedOnCentre(shapeTE, entityPlayer);
        }
    }

    public void chiselUsedOnSide(ShapeTE shapeTE, EntityPlayer entityPlayer, EnumFacing enumFacing) {
        shapeTE.toggleConnectionGlobal(enumFacing);
    }

    public void chiselUsedOnCentre(ShapeTE shapeTE, EntityPlayer entityPlayer) {
        ItemStack itemStack;
        if (shapeTE.secondaryBlockState != null && (itemStack = this.newSecondaryMaterialStack(shapeTE.secondaryBlockState)) != null) {
            if (!Utils.playerIsInCreativeMode(entityPlayer)) {
                BaseBlock baseBlock = (BaseBlock)shapeTE.func_145838_q();
                baseBlock.spawnAsEntity(BaseBlockUtils.getTileEntityWorld(shapeTE), BaseBlockUtils.getTileEntityPos(shapeTE), itemStack);
            }
            shapeTE.setSecondaryMaterial(null);
        }
    }

    protected ItemStack newSecondaryMaterialStack(IBlockState iBlockState) {
        if (this.acceptsCladding()) {
            return ArchitectureCraft.itemCladding.newStack(iBlockState, 1);
        }
        return null;
    }

    public void onHammerUse(ShapeTE shapeTE, EntityPlayer entityPlayer, EnumFacing enumFacing, Vector3 vector3) {
        if (entityPlayer.func_70093_af()) {
            shapeTE.setSide((shapeTE.side + 1) % 6);
        } else {
            double d = shapeTE.getOffsetX();
            if (d != 0.0) {
                d = -d;
                shapeTE.setOffsetX(d);
            }
            if (d >= 0.0) {
                shapeTE.setTurn((shapeTE.turn + 1) % 4);
            }
        }
        shapeTE.markChanged();
    }

    public EnumFacing zoneHit(EnumFacing enumFacing, Vector3 vector3) {
        double d = 0.5 - this.sideZoneSize();
        int n = enumFacing.ordinal();
        if (vector3.x <= -d && n != 4) {
            return BaseDirections.F_WEST;
        }
        if (vector3.x >= d && n != 5) {
            return BaseDirections.F_EAST;
        }
        if (vector3.y <= -d && n != 0) {
            return BaseDirections.F_DOWN;
        }
        if (vector3.y >= d && n != 1) {
            return BaseDirections.F_UP;
        }
        if (vector3.z <= -d && n != 2) {
            return BaseDirections.F_NORTH;
        }
        if (vector3.z >= d && n != 3) {
            return BaseDirections.F_SOUTH;
        }
        return null;
    }

    public boolean acceptsCladding() {
        return false;
    }

    public boolean isValidSecondaryMaterial(IBlockState iBlockState) {
        return false;
    }

    public boolean secondaryDefaultsToBase() {
        return false;
    }

    public AxisAlignedBB getBounds(ShapeTE shapeTE, IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity, Trans3 trans3) {
        ArrayList<AxisAlignedBB> arrayList = new ArrayList<AxisAlignedBB>();
        this.addCollisionBoxesToList(shapeTE, iBlockAccess, blockPos, iBlockState, entity, trans3, arrayList);
        return Utils.unionOfBoxes(arrayList);
    }

    public void addCollisionBoxesToList(ShapeTE shapeTE, IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity, Trans3 trans3, List list) {
        int n = shapeTE.shape.occlusionMask;
        int n2 = n & 0xFF;
        switch (n & 0xFF00) {
            case 0: {
                for (int i = 0; i < 8; ++i) {
                    if ((n & 1 << i) == 0) continue;
                    Vector3 vector3 = new Vector3((i & 1) != 0 ? 0.5 : -0.5, (i & 4) != 0 ? 0.5 : -0.5, (i & 2) != 0 ? 0.5 : -0.5);
                    this.addBox(Vector3.zero, vector3, trans3, list);
                }
                break;
            }
            case 256: {
                double d = (double)n2 / 16.0;
                this.addBox(new Vector3(-d, -0.5, -d), new Vector3(d, 0.5, d), trans3, list);
                break;
            }
            case 512: {
                double d = (double)n2 / 32.0;
                this.addBox(new Vector3(-0.5, -0.5, -d), new Vector3(0.5, 0.5, d), trans3, list);
                break;
            }
            case 768: {
                double d = (double)((n2 & 0xF) + 1) / 16.0;
                double d2 = (double)((n2 >> 4) + 1) / 16.0;
                this.addBox(new Vector3(-0.5, -0.5, 0.5 - d), new Vector3(-0.5 + d, -0.5 + d2, 0.5), trans3, list);
                break;
            }
            case 1024: 
            case 1280: {
                double d = (double)((n2 & 0xF) + 1) / 16.0;
                double d3 = (double)((n2 >> 4) + 1) / 16.0;
                this.addBox(new Vector3(-0.5, -0.5, 0.5 - d), new Vector3(0.5, -0.5 + d3, 0.5), trans3, list);
                if ((n & 0x100) == 0) break;
                this.addBox(new Vector3(-0.5, -0.5, -0.5), new Vector3(-0.5 + d, -0.5 + d3, 0.5), trans3, list);
                break;
            }
            default: {
                this.addBox(new Vector3(-0.5, -0.5, -0.5), new Vector3(0.5, 0.5, 0.5), trans3, list);
            }
        }
    }

    protected void addBox(Vector3 vector3, Vector3 vector32, Trans3 trans3, List list) {
        trans3.addBox(vector3, vector32, list);
    }

    public static Model Model(String string) {
        return new Model(string, null);
    }

    public static Model Model(String string, Object[] objectArray) {
        return new Model(string, objectArray);
    }

    public static Model Banister(String string) {
        return new Banister(string);
    }

    public static class Banister
    extends Model {
        private static EnumFacing[] stairsFacingMap = new EnumFacing[]{BaseDirections.F_WEST, BaseDirections.F_EAST, BaseDirections.F_SOUTH, BaseDirections.F_NORTH};

        public Banister(String string) {
            super(string, (Object[])Profile.Generic.tbOffset);
        }

        @Override
        public boolean orientOnPlacement(EntityPlayer entityPlayer, ShapeTE shapeTE, BlockPos blockPos, IBlockState iBlockState, TileEntity tileEntity, EnumFacing enumFacing, Vector3 vector3) {
            int n;
            int n2 = enumFacing.ordinal();
            if (!entityPlayer.func_70093_af() && (n2 == 1 || n2 == 0) && iBlockState.getBlock() instanceof BlockStairs && (n = BaseUtils.oppositeFacing(enumFacing).ordinal()) == Banister.stairsSide(iBlockState)) {
                Vector3 vector32 = Trans3.sideTurn(n, 0).ip(vector3);
                int n3 = Shape.turnForPlacementHit(n, vector3, ShapeSymmetry.Bilateral);
                int n4 = BaseUtils.turnToFace(BaseDirections.F_NORTH, Banister.stairsFacing(iBlockState));
                double d = -shapeTE.shape.offsetXForPlacementHit(n, n3, vector3);
                n3 = d > 0.0 ? --n3 : ++n3;
                shapeTE.setSide(n);
                shapeTE.setTurn(n3 & 3);
                shapeTE.setOffsetX(d);
                return true;
            }
            return super.orientOnPlacement(entityPlayer, shapeTE, blockPos, iBlockState, tileEntity, enumFacing, vector3);
        }

        private static EnumFacing stairsFacing(IBlockState iBlockState) {
            int n = BaseBlockUtils.getMetaFromBlockState(iBlockState);
            return stairsFacingMap[n & 3];
        }

        private static int stairsSide(IBlockState iBlockState) {
            int n = BaseBlockUtils.getMetaFromBlockState(iBlockState);
            return n >> 2 & 1;
        }

        @Override
        public double placementOffsetX() {
            return 0.375;
        }
    }

    public static class Cladding
    extends ShapeKind {
        @Override
        public void renderShape(ShapeTE shapeTE, BaseModClient.ITexture[] iTextureArray, BaseModClient.IRenderTarget iRenderTarget, Trans3 trans3, boolean bl, boolean bl2) {
        }

        @Override
        public ItemStack newStack(Shape shape, Block block, int n, int n2) {
            return ArchitectureCraft.itemCladding.newStack(block, n, n2);
        }
    }

    public static abstract class Window
    extends ShapeKind {
        public EnumFacing[] frameSides;
        public boolean[] frameAlways;
        public FrameKind[] frameKinds;
        public EnumFacing[] frameOrientations;
        public Trans3[] frameTrans;

        @Override
        public boolean orientOnPlacement(EntityPlayer entityPlayer, ShapeTE shapeTE, ShapeTE shapeTE2, EnumFacing enumFacing, Vector3 vector3) {
            int n = -1;
            if (!(entityPlayer.func_70093_af() || shapeTE2 != null && shapeTE2.shape.kind instanceof Window)) {
                switch (enumFacing.ordinal()) {
                    case 4: 
                    case 5: {
                        n = 0;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n = 1;
                    }
                }
            }
            if (n >= 0) {
                shapeTE.setSide(0);
                shapeTE.setTurn(n);
                return true;
            }
            return false;
        }

        public FrameKind frameKindForLocalSide(EnumFacing enumFacing) {
            return this.frameKinds[enumFacing.ordinal()];
        }

        public EnumFacing frameOrientationForLocalSide(EnumFacing enumFacing) {
            return this.frameOrientations[enumFacing.ordinal()];
        }

        @Override
        public boolean canPlaceUpsideDown() {
            return false;
        }

        @Override
        public double sideZoneSize() {
            return 0.125;
        }

        @Override
        public boolean highlightZones() {
            return true;
        }

        @Override
        public void renderShape(ShapeTE shapeTE, BaseModClient.ITexture[] iTextureArray, BaseModClient.IRenderTarget iRenderTarget, Trans3 trans3, boolean bl, boolean bl2) {
            new RenderWindow(shapeTE, iTextureArray, trans3, iRenderTarget, bl, bl2).render();
        }

        @Override
        protected ItemStack newSecondaryMaterialStack(IBlockState iBlockState) {
            return BaseBlockUtils.blockStackWithState(iBlockState, 1);
        }

        @Override
        public boolean isValidSecondaryMaterial(IBlockState iBlockState) {
            Block block = iBlockState.getBlock();
            return block == Blocks.field_150410_aZ || block == Blocks.field_150397_co;
        }

        @Override
        public void addCollisionBoxesToList(ShapeTE shapeTE, IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity, Trans3 trans3, List list) {
            double[] dArray = new double[4];
            this.addCentreBoxesToList(0.125, 0.09375, trans3, list);
            for (int i = 0; i <= 3; ++i) {
                boolean bl;
                boolean bl2 = bl = this.frameAlways[i] || !this.isConnectedGlobal(shapeTE, trans3.t(this.frameSides[i]));
                if (entity == null || bl) {
                    Trans3 trans32 = trans3.t(this.frameTrans[i]);
                    this.addFrameBoxesToList(i, 0.125, 0.09375, trans32, list);
                }
                dArray[i] = bl ? 0.375 : 0.5;
            }
            if (shapeTE.secondaryBlockState != null) {
                this.addGlassBoxesToList(0.125, 0.09375, 0.03125, dArray, trans3, list);
            }
        }

        protected void addCentreBoxesToList(double d, double d2, Trans3 trans3, List list) {
        }

        protected void addFrameBoxesToList(int n, double d, double d2, Trans3 trans3, List list) {
            trans3.addBox(-0.5, -0.5, -d2, 0.5, -0.5 + d, d2, list);
        }

        protected void addGlassBoxesToList(double d, double d2, double d3, double[] dArray, Trans3 trans3, List list) {
            trans3.addBox(-dArray[3], -dArray[0], -d3, dArray[1], dArray[2], d3, list);
        }

        protected boolean isConnectedGlobal(ShapeTE shapeTE, EnumFacing enumFacing) {
            return this.getConnectedWindowGlobal(shapeTE, enumFacing) != null;
        }

        public ShapeTE getConnectedWindowGlobal(ShapeTE shapeTE, EnumFacing enumFacing) {
            EnumFacing enumFacing2 = shapeTE.localFace(enumFacing);
            FrameKind frameKind = this.frameKindForLocalSide(enumFacing2);
            if (frameKind != FrameKind.None) {
                EnumFacing enumFacing3;
                Window window;
                FrameKind frameKind2;
                EnumFacing enumFacing4 = this.frameOrientationForLocalSide(enumFacing2);
                ShapeTE shapeTE2 = shapeTE.getConnectedNeighbourGlobal(enumFacing);
                if (shapeTE2 != null && shapeTE2.shape.kind instanceof Window && (frameKind2 = (window = (Window)shapeTE2.shape.kind).frameKindForLocalSide(enumFacing3 = shapeTE2.localFace(BaseUtils.oppositeFacing(enumFacing)))) != FrameKind.None) {
                    EnumFacing enumFacing5 = window.frameOrientationForLocalSide(enumFacing3);
                    if (this.framesMatch(frameKind, frameKind2, shapeTE.globalFace(enumFacing4), shapeTE2.globalFace(enumFacing5))) {
                        return shapeTE2;
                    }
                }
            }
            return null;
        }

        protected boolean framesMatch(FrameKind frameKind, FrameKind frameKind2, EnumFacing enumFacing, EnumFacing enumFacing2) {
            if (frameKind == frameKind2) {
                switch (frameKind) {
                    case Plain: {
                        return BaseUtils.facingAxesEqual(enumFacing, enumFacing2);
                    }
                }
                return enumFacing == enumFacing2;
            }
            return false;
        }

        public static enum FrameKind {
            None,
            Plain,
            Corner;

        }
    }

    public static class Model
    extends ShapeKind {
        protected String modelName;
        private BaseModClient.IModel model;

        public Model(String string, Object[] objectArray) {
            this.modelName = "shape/" + string + ".smeg";
            this.profiles = objectArray;
        }

        @Override
        public boolean secondaryDefaultsToBase() {
            return true;
        }

        @Override
        public AxisAlignedBB getBounds(ShapeTE shapeTE, IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity, Trans3 trans3) {
            return trans3.t(this.getModel().getBounds());
        }

        @Override
        public void renderShape(ShapeTE shapeTE, BaseModClient.ITexture[] iTextureArray, BaseModClient.IRenderTarget iRenderTarget, Trans3 trans3, boolean bl, boolean bl2) {
            BaseModClient.IModel iModel = this.getModel();
            iModel.render(trans3, iRenderTarget, iTextureArray);
        }

        protected BaseModClient.IModel getModel() {
            if (this.model == null) {
                this.model = ArchitectureCraft.mod.getModel(this.modelName);
            }
            return this.model;
        }

        @Override
        public boolean acceptsCladding() {
            BaseModel baseModel = (BaseModel)this.getModel();
            for (BaseModel.Face face : baseModel.faces) {
                if (face.texture < 2) continue;
                return true;
            }
            return false;
        }

        @Override
        public void addCollisionBoxesToList(ShapeTE shapeTE, IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity, Trans3 trans3, List list) {
            if (shapeTE.shape.occlusionMask == 0) {
                this.getModel().addBoxesToList(trans3, list);
            } else {
                super.addCollisionBoxesToList(shapeTE, iBlockAccess, blockPos, iBlockState, entity, trans3, list);
            }
        }

        @Override
        public double placementOffsetX() {
            ArrayList<AxisAlignedBB> arrayList = new ArrayList<AxisAlignedBB>();
            this.getModel().addBoxesToList(Trans3.ident, arrayList);
            AxisAlignedBB axisAlignedBB = Utils.unionOfBoxes(arrayList);
            if (Shape.debugPlacement) {
                for (AxisAlignedBB axisAlignedBB2 : arrayList) {
                    System.out.printf("ShapeKind.Model.placementOffsetX: %s\n", axisAlignedBB2);
                }
                System.out.printf("ShapeKind.Model.placementOffsetX: bounds = %s\n", axisAlignedBB);
            }
            return 0.5 * (1.0 - (axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a));
        }
    }

    public static class Roof
    extends ShapeKind {
        @Override
        public boolean acceptsCladding() {
            return true;
        }

        @Override
        public boolean secondaryDefaultsToBase() {
            return true;
        }

        @Override
        public void renderShape(ShapeTE shapeTE, BaseModClient.ITexture[] iTextureArray, BaseModClient.IRenderTarget iRenderTarget, Trans3 trans3, boolean bl, boolean bl2) {
            new RenderRoof(shapeTE, iTextureArray, trans3, iRenderTarget, bl, bl2).render();
        }

        @Override
        public Object profileForLocalFace(Shape shape, EnumFacing enumFacing) {
            int n = enumFacing.ordinal();
            switch (shape) {
                case RoofTile: 
                case RoofOverhang: {
                    switch (n) {
                        case 5: {
                            return RoofProfile.Left;
                        }
                        case 4: {
                            return RoofProfile.Right;
                        }
                    }
                    break;
                }
                case RoofOuterCorner: 
                case RoofOverhangOuterCorner: {
                    switch (n) {
                        case 3: {
                            return RoofProfile.Left;
                        }
                        case 4: {
                            return RoofProfile.Right;
                        }
                    }
                    break;
                }
                case RoofInnerCorner: 
                case RoofOverhangInnerCorner: {
                    switch (n) {
                        case 5: {
                            return RoofProfile.Left;
                        }
                        case 2: {
                            return RoofProfile.Right;
                        }
                    }
                    break;
                }
                case RoofRidge: 
                case RoofSmartRidge: 
                case RoofOverhangRidge: {
                    return RoofProfile.Ridge;
                }
                case RoofValley: 
                case RoofSmartValley: 
                case RoofOverhangValley: {
                    return RoofProfile.Valley;
                }
            }
            return RoofProfile.None;
        }

        static {
            Profile.declareOpposite((Object)RoofProfile.Left, (Object)RoofProfile.Right);
        }

        protected static enum RoofProfile {
            None,
            Left,
            Right,
            Ridge,
            Valley;

        }
    }
}

