/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.architecture.BaseBlock;
import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseOrientation;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BlockPos;
import gcewing.architecture.EnumWorldBlockLayer;
import gcewing.architecture.IBlockState;
import gcewing.architecture.ShapeTE;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ShapeBlock
extends BaseBlock<ShapeTE> {
    protected AxisAlignedBB boxHit;

    public ShapeBlock() {
        super(Material.field_151576_e, ShapeTE.class);
    }

    @Override
    public BaseBlock.IOrientationHandler getOrientationHandler() {
        return BaseOrientation.orient24WaysByTE;
    }

    @Override
    public boolean isFullCube() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World world, BlockPos blockPos, Vec3 vec3, Vec3 vec32) {
        int n;
        MovingObjectPosition movingObjectPosition = null;
        double d = 0.0;
        IBlockState iBlockState = BaseBlockUtils.getWorldBlockState((IBlockAccess)world, blockPos);
        List<AxisAlignedBB> list = this.getGlobalCollisionBoxes((IBlockAccess)world, blockPos, iBlockState, null);
        if (list != null) {
            n = list.size();
            for (int i = 0; i < n; ++i) {
                AxisAlignedBB axisAlignedBB = list.get(i);
                MovingObjectPosition movingObjectPosition2 = axisAlignedBB.func_72327_a(vec3, vec32);
                if (movingObjectPosition2 == null) continue;
                movingObjectPosition2.subHit = i;
                double d2 = vec3.func_72436_e(movingObjectPosition2.field_72307_f);
                if (movingObjectPosition != null && !(d2 < d)) continue;
                movingObjectPosition = movingObjectPosition2;
                d = d2;
            }
        }
        if (movingObjectPosition != null) {
            n = movingObjectPosition.subHit;
            this.boxHit = list.get(n).func_72317_d((double)(-blockPos.getX()), (double)(-blockPos.getY()), (double)(-blockPos.getZ()));
            movingObjectPosition = BaseUtils.newMovingObjectPosition(movingObjectPosition.field_72307_f, movingObjectPosition.field_72310_e, blockPos);
            movingObjectPosition.subHit = n;
        }
        return movingObjectPosition;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iBlockAccess, BlockPos blockPos) {
        Object object;
        if (this.boxHit != null && (object = ShapeTE.get(iBlockAccess, blockPos)) != null && ((ShapeTE)object).shape.kind.highlightZones()) {
            this.setBlockBounds(this.boxHit);
            return;
        }
        object = BaseBlockUtils.getWorldBlockState(iBlockAccess, blockPos);
        AxisAlignedBB axisAlignedBB = this.getLocalBounds(iBlockAccess, blockPos, (IBlockState)object, null);
        if (axisAlignedBB != null) {
            this.setBlockBounds(axisAlignedBB);
        } else {
            super.setBlockBoundsBasedOnState(iBlockAccess, blockPos);
        }
    }

    public void setBlockBounds(AxisAlignedBB axisAlignedBB) {
        this.func_149676_a((float)axisAlignedBB.field_72340_a, (float)axisAlignedBB.field_72338_b, (float)axisAlignedBB.field_72339_c, (float)axisAlignedBB.field_72336_d, (float)axisAlignedBB.field_72337_e, (float)axisAlignedBB.field_72334_f);
    }

    @Override
    public void addCollisionBoxesToList(World world, BlockPos blockPos, IBlockState iBlockState, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        List<AxisAlignedBB> list2 = this.getGlobalCollisionBoxes((IBlockAccess)world, blockPos, iBlockState, entity);
        if (list2 != null) {
            for (AxisAlignedBB axisAlignedBB2 : list2) {
                if (!axisAlignedBB.func_72326_a(axisAlignedBB2)) continue;
                list.add(axisAlignedBB2);
            }
        }
    }

    protected List<AxisAlignedBB> getGlobalCollisionBoxes(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity) {
        ShapeTE shapeTE = (ShapeTE)BaseBlockUtils.getWorldTileEntity(iBlockAccess, blockPos);
        if (shapeTE != null) {
            Trans3 trans3 = shapeTE.localToGlobalTransformation();
            return this.getCollisionBoxes(shapeTE, iBlockAccess, blockPos, iBlockState, trans3, entity);
        }
        return null;
    }

    protected List<AxisAlignedBB> getLocalCollisionBoxes(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity) {
        ShapeTE shapeTE = (ShapeTE)BaseBlockUtils.getWorldTileEntity(iBlockAccess, blockPos);
        if (shapeTE != null) {
            Trans3 trans3 = shapeTE.localToGlobalTransformation(Vector3.zero);
            return this.getCollisionBoxes(shapeTE, iBlockAccess, blockPos, iBlockState, trans3, entity);
        }
        return null;
    }

    protected AxisAlignedBB getLocalBounds(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity) {
        ShapeTE shapeTE = (ShapeTE)BaseBlockUtils.getWorldTileEntity(iBlockAccess, blockPos);
        if (shapeTE != null) {
            Trans3 trans3 = shapeTE.localToGlobalTransformation(Vector3.blockCenter);
            return shapeTE.shape.kind.getBounds(shapeTE, iBlockAccess, blockPos, iBlockState, entity, trans3);
        }
        return null;
    }

    protected List<AxisAlignedBB> getCollisionBoxes(ShapeTE shapeTE, IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Trans3 trans3, Entity entity) {
        ArrayList<AxisAlignedBB> arrayList = new ArrayList<AxisAlignedBB>();
        shapeTE.shape.kind.addCollisionBoxesToList(shapeTE, iBlockAccess, blockPos, iBlockState, entity, trans3, arrayList);
        return arrayList;
    }

    @Override
    public boolean canHarvestBlock(IBlockState iBlockState, EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer entityPlayer, BlockPos blockPos, IBlockState iBlockState, TileEntity tileEntity) {
        if (tileEntity instanceof ShapeTE) {
            ShapeTE shapeTE = (ShapeTE)tileEntity;
            ItemStack itemStack = BaseUtils.blockStackWithTileEntity((Block)this, 1, shapeTE);
            this.spawnAsEntity(world, blockPos, itemStack);
            if (shapeTE.secondaryBlockState != null) {
                itemStack = BaseBlockUtils.blockStackWithState(shapeTE.secondaryBlockState, 1);
                this.spawnAsEntity(world, blockPos, itemStack);
            }
        }
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition movingObjectPosition, World world, BlockPos blockPos) {
        ShapeTE shapeTE = ShapeTE.get((IBlockAccess)world, blockPos);
        if (shapeTE != null) {
            return BaseUtils.blockStackWithTileEntity((Block)this, 1, shapeTE);
        }
        return null;
    }

    public IBlockState getBaseBlockState(IBlockAccess iBlockAccess, BlockPos blockPos) {
        ShapeTE shapeTE = (ShapeTE)this.getTileEntity(iBlockAccess, blockPos);
        if (shapeTE != null) {
            return shapeTE.baseBlockState;
        }
        return null;
    }

    @Override
    public float getPlayerRelativeBlockHardness(EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        float f = 1.0f;
        IBlockState iBlockState = this.getBaseBlockState((IBlockAccess)world, blockPos);
        if (iBlockState != null) {
            f = ShapeBlock.acBlockStrength(iBlockState, entityPlayer, world, blockPos);
        }
        return f;
    }

    public static float acBlockStrength(IBlockState iBlockState, EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        float f = BaseBlockUtils.getBlockHardness(iBlockState.getBlock(), world, blockPos);
        if (f < 0.0f) {
            return 0.0f;
        }
        float f2 = BaseBlockUtils.getPlayerBreakSpeed(entityPlayer, iBlockState, blockPos) / f;
        if (!ShapeBlock.acCanHarvestBlock(iBlockState, entityPlayer)) {
            return f2 / 100.0f;
        }
        return f2 / 30.0f;
    }

    public static boolean acCanHarvestBlock(IBlockState iBlockState, EntityPlayer entityPlayer) {
        Block block = iBlockState.getBlock();
        if (block.func_149688_o().func_76229_l()) {
            return true;
        }
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        String string = BaseBlockUtils.getBlockHarvestTool(iBlockState);
        if (itemStack == null || string == null) {
            return entityPlayer.func_146099_a(block);
        }
        int n = itemStack.func_77973_b().getHarvestLevel(itemStack, string);
        if (n < 0) {
            return entityPlayer.func_146099_a(block);
        }
        return n >= BaseBlockUtils.getBlockHarvestLevel(iBlockState);
    }

    @Override
    public IBlockState getParticleState(IBlockAccess iBlockAccess, BlockPos blockPos) {
        IBlockState iBlockState = this.getBaseBlockState(iBlockAccess, blockPos);
        if (iBlockState != null) {
            return iBlockState;
        }
        return this.getDefaultState();
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos blockPos, IBlockState iBlockState, EntityPlayer entityPlayer, EnumFacing enumFacing, float f, float f2, float f3) {
        ShapeTE shapeTE;
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        if (itemStack != null && (shapeTE = ShapeTE.get((IBlockAccess)world, blockPos)) != null) {
            return shapeTE.applySecondaryMaterial(itemStack, entityPlayer);
        }
        return false;
    }

    @Override
    public boolean canRenderInLayer(EnumWorldBlockLayer enumWorldBlockLayer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_149685_I() {
        return 0.8f;
    }
}

