/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseModClient;
import gcewing.architecture.RenderShape;
import gcewing.architecture.Shape;
import gcewing.architecture.ShapeTE;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import net.minecraft.util.EnumFacing;

public class RenderRoof
extends RenderShape {
    protected static final Shape[] ridgeShapes = new Shape[]{Shape.RoofRidge, Shape.RoofSmartRidge};
    protected static final Shape[] ridgeOrSlopeShapes = new Shape[]{Shape.RoofRidge, Shape.RoofSmartRidge, Shape.RoofTile, Shape.RoofOuterCorner, Shape.RoofInnerCorner};
    protected static final Shape[] valleyShapes = new Shape[]{Shape.RoofValley, Shape.RoofSmartValley};
    protected static final Shape[] valleyOrSlopeShapes = new Shape[]{Shape.RoofValley, Shape.RoofSmartValley, Shape.RoofTile, Shape.RoofInnerCorner};
    protected EnumFacing face;
    protected boolean outerFace;
    protected boolean renderBase;
    protected boolean renderSecondary;

    public RenderRoof(ShapeTE shapeTE, BaseModClient.ITexture[] iTextureArray, Trans3 trans3, BaseModClient.IRenderTarget iRenderTarget, boolean bl, boolean bl2) {
        super(shapeTE, iTextureArray, trans3, iRenderTarget);
        this.renderBase = bl;
        this.renderSecondary = bl2;
    }

    @Override
    protected void render() {
        switch (this.te.shape) {
            case RoofTile: {
                this.renderSlope();
                break;
            }
            case RoofOuterCorner: {
                this.renderOuterCorner();
                break;
            }
            case RoofInnerCorner: {
                this.renderInnerCorner();
                break;
            }
            case RoofRidge: {
                this.renderRidge();
                break;
            }
            case RoofSmartRidge: {
                this.renderSmartRidge();
                break;
            }
            case RoofValley: {
                this.renderValley();
                break;
            }
            case RoofSmartValley: {
                this.renderSmartValley();
            }
        }
    }

    protected void renderSlope() {
        boolean bl = this.valleyAt(0, 0, 1);
        if (this.renderSecondary) {
            this.beginNegZSlope();
            if (bl) {
                this.beginTriangle();
                this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
                this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
                this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
                this.newTriangle();
                this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
                this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
                this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
                this.newTriangle();
                this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
                this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
                this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
                this.endFace();
                this.connectValleyBack();
            } else {
                this.beginQuad();
                this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
                this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
                this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
                this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
                this.endFace();
            }
        }
        if (this.renderBase) {
            this.leftTriangle();
            this.rightTriangle();
            this.bottomQuad();
            if (!bl) {
                this.backQuad();
            }
        }
        if (this.renderSecondary && this.ridgeAt(0, 0, -1)) {
            this.connectRidgeFront();
        }
    }

    protected void renderOuterCorner() {
        if (this.renderSecondary) {
            this.beginNegZSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
            this.beginPosXSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
            this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.beginPosZFace();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
            this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
            this.endFace();
            this.rightTriangle();
            this.bottomQuad();
        }
        if (this.renderSecondary) {
            if (this.ridgeAt(0, 0, -1)) {
                this.connectRidgeFront();
            }
            if (this.ridgeAt(1, 0, 0)) {
                this.connectRidgeLeft();
            }
        }
    }

    protected void renderInnerCorner() {
        if (this.renderSecondary) {
            this.beginPosXSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
            this.beginNegZSlope();
            this.beginTriangle();
            this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.endFace();
        }
        if (this.renderBase) {
            this.beginNegZFace();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
            this.leftTriangle();
            this.bottomQuad();
        }
        if (this.valleyAt(0, 0, 1)) {
            this.connectValleyBack();
        } else {
            this.terminateValleyBack();
        }
        if (this.valleyAt(-1, 0, 0)) {
            this.connectValleyRight();
        } else {
            this.terminateValleyRight();
        }
    }

    protected void renderRidge() {
        if (this.renderSecondary) {
            this.beginNegZSlope();
            this.beginQuad();
            this.vertex(1.0, 0.5, 0.5, 0.0, 0.5);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
            this.vertex(0.0, 0.5, 0.5, 1.0, 0.5);
            this.endFace();
            this.ridgeBackSlope();
            this.ridgeFront(false);
            this.ridgeBack(false);
        }
        if (this.renderBase) {
            this.ridgeLeftFace();
            this.ridgeRightFace();
            this.bottomQuad();
        }
    }

    protected void renderSmartRidge() {
        if (this.renderSecondary) {
            this.ridgeLeft();
            this.ridgeRight();
            this.ridgeBack(true);
            this.ridgeFront(true);
        }
        if (this.renderBase) {
            this.bottomQuad();
        }
    }

    protected void renderValley() {
        this.connectValleyLeft();
        this.connectValleyRight();
        this.smartValleyFront();
        this.smartValleyBack();
        if (this.renderBase) {
            this.bottomQuad();
        }
    }

    protected void renderSmartValley() {
        this.smartValleyLeft();
        this.smartValleyRight();
        this.smartValleyFront();
        this.smartValleyBack();
        if (this.renderBase) {
            this.bottomQuad();
        }
    }

    protected void smartValleyLeft() {
        if (this.valleyOrSlopeAt(1, 0, 0)) {
            this.connectValleyLeft();
        } else {
            this.terminateValleyLeft();
        }
    }

    protected void terminateValleyLeft() {
        if (this.renderSecondary) {
            this.beginNegXSlope();
            this.beginTriangle();
            this.vertex(1.0, 1.0, 0.0, 0.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 1.0, 1.0, 1.0, 0.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.leftQuad();
        }
    }

    protected void smartValleyRight() {
        if (this.valleyOrSlopeAt(-1, 0, 0)) {
            this.connectValleyRight();
        } else {
            this.terminateValleyRight();
        }
    }

    protected void terminateValleyRight() {
        if (this.renderSecondary) {
            this.beginPosXSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.rightQuad();
        }
    }

    protected void smartValleyFront() {
        if (this.valleyOrSlopeAt(0, 0, -1)) {
            this.connectValleyFront();
        } else {
            this.terminateValleyFront();
        }
    }

    protected void terminateValleyFront() {
        if (this.renderSecondary) {
            this.beginPosZSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 0.0, 0.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 1.0, 0.0, 1.0, 0.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.frontQuad();
        }
    }

    protected void smartValleyBack() {
        if (this.valleyOrSlopeAt(0, 0, 1)) {
            this.connectValleyBack();
        } else {
            this.terminateValleyBack();
        }
    }

    protected void terminateValleyBack() {
        if (this.renderSecondary) {
            this.beginNegZSlope();
            this.beginTriangle();
            this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.backQuad();
        }
    }

    protected void leftQuad() {
        this.beginPosXFace();
        this.beginQuad();
        this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(1.0, 1.0, 0.0, 1.0, 0.0);
        this.endFace();
    }

    protected void rightQuad() {
        this.beginNegXFace();
        this.beginQuad();
        this.vertex(0.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
        this.endFace();
    }

    protected void frontQuad() {
        this.beginNegZFace();
        this.beginQuad();
        this.vertex(1.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
        this.endFace();
    }

    protected void backQuad() {
        this.beginPosZFace();
        this.beginQuad();
        this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, 1.0, 1.0, 1.0, 0.0);
        this.endFace();
    }

    protected void bottomQuad() {
        this.beginBottomFace();
        this.beginQuad();
        this.vertex(0.0, 0.0, 1.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 0.0);
        this.endFace();
    }

    protected void leftTriangle() {
        this.beginPosXFace();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.endFace();
    }

    protected void rightTriangle() {
        this.beginNegXFace();
        this.beginTriangle();
        this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeLeftFace() {
        this.beginPosXFace();
        this.beginTriangle();
        this.vertex(1.0, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeRightFace() {
        this.beginNegXFace();
        this.beginTriangle();
        this.vertex(0.0, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeBackFace() {
        this.beginPosZFace();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 1.0, 0.5, 0.5);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeFrontFace() {
        this.beginNegZFace();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.0, 0.5, 0.5);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeFrontSlope() {
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeBackSlope() {
        this.beginPosZSlope();
        this.beginQuad();
        this.vertex(0.0, 0.5, 0.5, 0.0, 0.5);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, 0.5, 0.5, 1.0, 0.5);
        this.endFace();
    }

    protected void ridgeLeft() {
        if (this.ridgeOrSlopeAt(1, 0, 0)) {
            this.connectRidgeLeft();
        } else {
            this.beginPosXSlope();
            this.beginTriangle();
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
            this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
        }
    }

    protected void connectRidgeLeft() {
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.5, 0.5, 0.0, 0.5);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.endFace();
        this.beginPosZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, 0.5, 0.5, 1.0, 0.5);
        this.endFace();
    }

    protected void ridgeRight() {
        if (this.ridgeOrSlopeAt(-1, 0, 0)) {
            this.connectRidgeRight();
        } else {
            this.beginNegXSlope();
            this.beginTriangle();
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
            this.endFace();
        }
    }

    protected void connectRidgeRight() {
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.0, 0.5, 0.5, 1.0, 0.5);
        this.endFace();
        this.beginPosZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.5, 0.5, 0.0, 0.5);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.endFace();
    }

    protected void ridgeFront(boolean bl) {
        if (this.ridgeOrSlopeAt(0, 0, -1)) {
            this.connectRidgeFront();
        } else if (bl) {
            this.beginNegZSlope();
            this.beginTriangle();
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
        }
    }

    protected void connectRidgeFront() {
        this.beginPosXSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.5, 0.5, 0.0, 1.0, 0.5);
        this.endFace();
        this.beginNegXSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.5, 0.5, 0.0, 0.0, 0.5);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.endFace();
    }

    protected void ridgeBack(boolean bl) {
        if (this.ridgeOrSlopeAt(0, 0, 1)) {
            this.connectRidgeBack();
        } else if (bl) {
            this.beginPosZSlope();
            this.beginTriangle();
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
            this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
            this.endFace();
        }
    }

    protected void connectRidgeBack() {
        this.beginPosXSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.5, 0.5, 1.0, 0.0, 0.5);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.endFace();
        this.beginNegXSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.5, 0.5, 1.0, 1.0, 0.5);
        this.endFace();
    }

    protected void connectValleyLeft() {
        this.beginPosZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.5, 0.5, 1.0, 0.5);
        this.vertex(1.0, 1.0, 0.0, 1.0, 0.0);
        this.endFace();
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(1.0, 0.5, 0.5, 0.0, 0.5);
        this.endFace();
        this.valleyEndLeft();
    }

    protected void connectValleyRight() {
        this.beginPosZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(0.0, 0.5, 0.5, 0.0, 0.5);
        this.endFace();
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.5, 0.5, 1.0, 0.5);
        this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
        this.endFace();
        this.valleyEndRight();
    }

    protected void connectValleyFront() {
        this.beginPosXSlope();
        this.beginTriangle();
        this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.5, 0.5, 0.0, 1.0, 0.5);
        this.endFace();
        this.beginNegXSlope();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(0.5, 0.5, 0.0, 0.0, 0.5);
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.endFace();
        this.valleyEndFront();
    }

    protected void connectValleyBack() {
        this.beginPosXSlope();
        this.beginTriangle();
        this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(0.5, 0.5, 1.0, 0.0, 0.5);
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.endFace();
        this.beginNegXSlope();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 1.0, 1.0, 0.0);
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.5, 0.5, 1.0, 1.0, 0.5);
        this.endFace();
        this.valleyEndBack();
    }

    protected void valleyEndLeft() {
        this.beginPosXFace();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.5, 0.5, 0.5, 0.5);
        this.newTriangle();
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(1.0, 0.5, 0.5, 0.5, 0.5);
        this.newTriangle();
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(1.0, 1.0, 0.0, 1.0, 0.0);
        this.vertex(1.0, 0.5, 0.5, 0.5, 0.5);
        this.endFace();
    }

    protected void valleyEndRight() {
        this.beginNegXFace();
        this.beginTriangle();
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
        this.vertex(0.0, 0.5, 0.5, 0.5, 0.5);
        this.newTriangle();
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.0, 0.5, 0.5, 0.5, 0.5);
        this.newTriangle();
        this.vertex(0.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.5, 0.5, 0.5, 0.5);
        this.endFace();
    }

    protected void valleyEndFront() {
        this.beginNegZFace();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.5, 0.5, 0.0, 0.5, 0.5);
        this.newTriangle();
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.5, 0.5, 0.0, 0.5, 0.5);
        this.newTriangle();
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
        this.vertex(0.5, 0.5, 0.0, 0.5, 0.5);
        this.endFace();
    }

    protected void valleyEndBack() {
        this.beginPosZFace();
        this.beginTriangle();
        this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(0.5, 0.5, 1.0, 0.5, 0.5);
        this.newTriangle();
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.5, 0.5, 1.0, 0.5, 0.5);
        this.newTriangle();
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, 1.0, 1.0, 1.0, 0.0);
        this.vertex(0.5, 0.5, 1.0, 0.5, 0.5);
        this.endFace();
    }

    protected boolean ridgeAt(int n, int n2, int n3) {
        return this.hasNeighbour(n, n2, n3, ridgeShapes);
    }

    protected boolean ridgeOrSlopeAt(int n, int n2, int n3) {
        return this.hasNeighbour(n, n2, n3, ridgeOrSlopeShapes);
    }

    protected boolean valleyAt(int n, int n2, int n3) {
        return this.hasNeighbour(n, n2, n3, valleyShapes);
    }

    protected boolean valleyOrSlopeAt(int n, int n2, int n3) {
        return this.hasNeighbour(n, n2, n3, valleyOrSlopeShapes);
    }

    protected boolean hasNeighbour(int n, int n2, int n3, Shape[] shapeArray) {
        Vector3 vector3 = this.t.v(n, n2, n3);
        EnumFacing enumFacing = vector3.facing();
        ShapeTE shapeTE = this.te.getConnectedNeighbourGlobal(enumFacing);
        if (shapeTE != null) {
            for (int i = 0; i < shapeArray.length; ++i) {
                if (shapeTE.shape != shapeArray[i]) continue;
                return true;
            }
        }
        return false;
    }

    protected void beginTopFace() {
        this.beginOuterFaces(Vector3.unitY);
    }

    protected void beginBottomFace() {
        this.beginOuterFaces(Vector3.unitNY);
    }

    protected void beginPosXFace() {
        this.beginOuterFaces(Vector3.unitX);
    }

    protected void beginNegXFace() {
        this.beginOuterFaces(Vector3.unitNX);
    }

    protected void beginPosZFace() {
        this.beginOuterFaces(Vector3.unitZ);
    }

    protected void beginNegZFace() {
        this.beginOuterFaces(Vector3.unitNZ);
    }

    protected void beginPosXSlope() {
        this.beginInnerFaces(Vector3.unitPXPY);
    }

    protected void beginNegXSlope() {
        this.beginInnerFaces(Vector3.unitNXPY);
    }

    protected void beginPosZSlope() {
        this.beginInnerFaces(Vector3.unitPYPZ);
    }

    protected void beginNegZSlope() {
        this.beginInnerFaces(Vector3.unitPYNZ);
    }

    protected void beginInnerFaces(Vector3 vector3) {
        this.outerFace = false;
        this.normal(vector3);
        this.target.setTexture(this.textures[2]);
    }

    protected void beginOuterFaces(Vector3 vector3) {
        this.outerFace = true;
        this.normal(vector3);
        this.target.setTexture(this.textures[1]);
    }

    protected void beginTriangle() {
        this.target.beginTriangle();
    }

    protected void beginQuad() {
        this.target.beginQuad();
    }

    protected void newTriangle() {
        this.endFace();
        this.beginTriangle();
    }

    protected void newQuad() {
        this.endFace();
        this.beginQuad();
    }

    protected void endFace() {
        this.target.endFace();
    }

    protected void normal(Vector3 vector3) {
        Vector3 vector32 = this.t.v(vector3);
        this.face = vector32.facing();
        this.target.setNormal(vector32);
    }

    protected void vertex(double d, double d2, double d3, double d4, double d5) {
        Vector3 vector3 = this.t.p(d - 0.5, d2 - 0.5, d3 - 0.5);
        this.target.addVertex(vector3, d4, d5);
    }
}

