/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gcewing.architecture.PropertyHelper;
import java.util.Collection;
import java.util.Map;

public class PropertyEnum<T extends Enum>
extends PropertyHelper<T> {
    private final ImmutableSet<T> allowedValues;
    private final Map<String, T> nameToValue = Maps.newHashMap();

    protected PropertyEnum(String string, Class<T> clazz, Collection<T> collection) {
        super(string, clazz);
        this.allowedValues = ImmutableSet.copyOf(collection);
        for (Enum enum_ : collection) {
            String string2 = this.getName(enum_);
            if (this.nameToValue.containsKey(string2)) {
                throw new IllegalArgumentException("Multiple values have the same name '" + string2 + "'");
            }
            this.nameToValue.put(string2, enum_);
        }
    }

    @Override
    public Collection<T> getAllowedValues() {
        return this.allowedValues;
    }

    @Override
    public String getName(T t) {
        return ((Enum)t).toString().toLowerCase();
    }

    public static <T extends Enum<T>> PropertyEnum<T> create(String string, Class<T> clazz) {
        return PropertyEnum.create(string, clazz, Predicates.alwaysTrue());
    }

    public static <T extends Enum<T>> PropertyEnum<T> create(String string, Class<T> clazz, Predicate<T> predicate) {
        return PropertyEnum.create(string, clazz, Collections2.filter((Collection)Lists.newArrayList((Object[])clazz.getEnumConstants()), predicate));
    }

    public static <T extends Enum<T>> PropertyEnum<T> create(String string, Class<T> clazz, T ... TArray) {
        return PropertyEnum.create(string, clazz, Lists.newArrayList((Object[])TArray));
    }

    public static <T extends Enum<T>> PropertyEnum<T> create(String string, Class<T> clazz, Collection<T> collection) {
        return new PropertyEnum<T>(string, clazz, collection);
    }
}

