/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseRenderTarget;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BlockPos;
import gcewing.architecture.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BaseWorldRenderTarget
extends BaseRenderTarget {
    protected IBlockAccess world;
    protected BlockPos blockPos;
    protected Block block;
    protected Tessellator tess;
    protected float cmr = 1.0f;
    protected float cmg = 1.0f;
    protected float cmb = 1.0f;
    protected boolean ao;
    protected boolean axisAlignedNormal;
    protected boolean renderingOccurred;
    protected float vr;
    protected float vg;
    protected float vb;
    protected float va;
    protected int vlm1;
    protected int vlm2;

    public BaseWorldRenderTarget(IBlockAccess iBlockAccess, BlockPos blockPos, Tessellator tessellator, IIcon iIcon) {
        super(blockPos.getX(), blockPos.getY(), blockPos.getZ(), iIcon);
        this.world = iBlockAccess;
        this.blockPos = blockPos;
        this.block = iBlockAccess.func_147439_a(blockPos.x, blockPos.y, blockPos.z);
        this.tess = tessellator;
        this.ao = Minecraft.func_71379_u() && this.block.func_149750_m() == 0;
        this.expandTrianglesToQuads = true;
    }

    @Override
    public void setNormal(Vector3 vector3) {
        super.setNormal(vector3);
        this.axisAlignedNormal = vector3.dot(this.face) >= 0.99;
    }

    @Override
    protected void rawAddVertex(Vector3 vector3, double d, double d2) {
        this.lightVertex(vector3);
        this.tess.func_78369_a(this.vr, this.vg, this.vb, this.va);
        this.tess.func_78385_a(d, d2);
        this.tess.func_78380_c(this.vlm1 << 16 | this.vlm2);
        this.tess.func_78377_a(vector3.x, vector3.y, vector3.z);
        this.renderingOccurred = true;
    }

    protected void lightVertex(Vector3 vector3) {
        if (this.ao) {
            this.aoLightVertex(vector3);
        } else {
            this.brLightVertex(vector3);
        }
    }

    protected void aoLightVertex(Vector3 vector3) {
        int n;
        Vector3 vector32 = this.normal;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = vector3.x + 0.5 * vector32.x;
        double d6 = vector3.y + 0.5 * vector32.y;
        double d7 = vector3.z + 0.5 * vector32.z;
        for (n = -1; n <= 1; n += 2) {
            for (int i = -1; i <= 1; i += 2) {
                for (int j = -1; j <= 1; j += 2) {
                    int n2;
                    double d8;
                    double d9;
                    int n3 = BaseUtils.ifloor(d5 + 0.5 * (double)n);
                    int n4 = BaseUtils.ifloor(d6 + 0.5 * (double)i);
                    int n5 = BaseUtils.ifloor(d7 + 0.5 * (double)j);
                    BlockPos blockPos = new BlockPos(n3, n4, n5);
                    double d10 = n < 0 ? (double)(n3 + 1) - (d5 - 0.5) : d5 + 0.5 - (double)n3;
                    double d11 = d10 * (d9 = i < 0 ? (double)(n4 + 1) - (d6 - 0.5) : d6 + 0.5 - (double)n4) * (d8 = j < 0 ? (double)(n5 + 1) - (d7 - 0.5) : d7 + 0.5 - (double)n5);
                    if (!(d11 > 0.0)) continue;
                    try {
                        n2 = this.block.func_149677_c(this.world, blockPos.x, blockPos.y, blockPos.z);
                    }
                    catch (RuntimeException runtimeException) {
                        System.out.printf("BaseWorldRenderTarget.aoLightVertex: getMixedBrightnessForBlock(%s) with weight %s for block at %s: %s\n", blockPos, d11, this.blockPos, runtimeException);
                        System.out.printf("BaseWorldRenderTarget.aoLightVertex: v = %s n = %s\n", vector3, vector32);
                        throw runtimeException;
                    }
                    float f = !blockPos.equals(this.blockPos) ? this.world.func_147439_a(blockPos.x, blockPos.y, blockPos.z).func_149685_I() : 1.0f;
                    if (n2 != 0) {
                        double d12 = (double)(n2 >> 16 & 0xFF) / 240.0;
                        double d13 = (double)(n2 & 0xFF) / 240.0;
                        d += d11 * d12;
                        d2 += d11 * d13;
                        d4 += d11;
                    }
                    d3 += d11 * (double)f;
                }
            }
        }
        n = d4 > 0.0 ? BaseUtils.iround(d / d4 * 240.0) << 16 | BaseUtils.iround(d2 / d4 * 240.0) : this.block.func_149677_c(this.world, this.blockPos.x, this.blockPos.y, this.blockPos.z);
        float f = (float)d3;
        this.setLight(this.shade * f, n);
    }

    protected void brLightVertex(Vector3 vector3) {
        Vector3 vector32 = this.normal;
        BlockPos blockPos = this.axisAlignedNormal ? new BlockPos((int)Math.floor(vector3.x + 0.01 * vector32.x), (int)Math.floor(vector3.y + 0.01 * vector32.y), (int)Math.floor(vector3.z + 0.01 * vector32.z)) : this.blockPos;
        int n = this.block.func_149677_c(this.world, blockPos.x, blockPos.y, blockPos.z);
        this.setLight(this.shade, n);
    }

    protected void setLight(float f, int n) {
        this.vr = f * this.cmr * this.r();
        this.vg = f * this.cmg * this.g();
        this.vb = f * this.cmb * this.b();
        this.va = this.a();
        this.vlm1 = n >> 16;
        this.vlm2 = n & 0xFFFF;
    }

    public boolean end() {
        super.finish();
        return this.renderingOccurred;
    }

    public void setRenderingOccurred() {
        this.renderingOccurred = true;
    }
}

