/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import com.google.gson.Gson;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;

public class BaseModel
implements BaseModClient.IModel {
    public double[] bounds;
    public Face[] faces;
    public double[][] boxes;
    static Gson gson = new Gson();

    public static BaseModel fromResource(ResourceLocation resourceLocation) {
        String string = String.format("/assets/%s/%s", resourceLocation.func_110624_b(), resourceLocation.func_110623_a());
        InputStream inputStream = BaseModel.class.getResourceAsStream(string);
        if (inputStream == null) {
            throw new RuntimeException(String.format("Cannot find resource %s", string));
        }
        BaseModel baseModel = (BaseModel)gson.fromJson((Reader)new InputStreamReader(inputStream), BaseModel.class);
        baseModel.prepare();
        return baseModel;
    }

    @Override
    public AxisAlignedBB getBounds() {
        return AxisAlignedBB.func_72330_a((double)this.bounds[0], (double)this.bounds[1], (double)this.bounds[2], (double)this.bounds[3], (double)this.bounds[4], (double)this.bounds[5]);
    }

    void prepare() {
        for (Face face : this.faces) {
            double[][] dArray = face.vertices;
            int[] nArray = face.triangles[0];
            face.normal = Vector3.unit(Vector3.sub(dArray[nArray[1]], dArray[nArray[0]]).cross(Vector3.sub(dArray[nArray[2]], dArray[nArray[0]])));
        }
    }

    @Override
    public void addBoxesToList(Trans3 trans3, List list) {
        if (this.boxes != null) {
            for (int i = 0; i < this.boxes.length; ++i) {
                double[] dArray = this.boxes[i];
                trans3.addBox(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], list);
            }
        }
    }

    @Override
    public void render(Trans3 trans3, BaseModClient.IRenderTarget iRenderTarget, BaseModClient.ITexture ... iTextureArray) {
        Vector3 vector3 = null;
        Vector3 vector32 = null;
        for (Face face : this.faces) {
            BaseModClient.ITexture iTexture = iTextureArray[face.texture];
            if (iTexture == null) continue;
            iRenderTarget.setTexture(iTexture);
            for (int[] nArray : face.triangles) {
                iRenderTarget.beginTriangle();
                for (int i = 0; i < 3; ++i) {
                    int n = nArray[i];
                    double[] dArray = face.vertices[n];
                    vector3 = trans3.p(dArray[0], dArray[1], dArray[2]);
                    vector32 = trans3.v(dArray[3], dArray[4], dArray[5]);
                    iRenderTarget.setNormal(vector32);
                    iRenderTarget.addVertex(vector3, dArray[6], dArray[7]);
                }
                iRenderTarget.endFace();
            }
        }
    }

    public static class Face {
        int texture;
        double[][] vertices;
        int[][] triangles;
        Vector3 normal;
    }
}

