/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.VillagerRegistry;
import gcewing.architecture.BaseBlock;
import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseGLRenderTarget;
import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseModelRenderer;
import gcewing.architecture.BaseSubsystem;
import gcewing.architecture.BaseTexture;
import gcewing.architecture.BaseWorldRenderTarget;
import gcewing.architecture.BlockPos;
import gcewing.architecture.EnumWorldBlockLayer;
import gcewing.architecture.IBlockState;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class BaseModClient<MOD extends BaseMod<? extends BaseModClient>>
implements IGuiHandler {
    public boolean debugModelRegistration = false;
    MOD base;
    boolean customRenderingRequired;
    boolean debugSound = false;
    Map<Integer, Class<? extends GuiScreen>> screenClasses = new HashMap<Integer, Class<? extends GuiScreen>>();
    protected Map<BaseMod.IBlock, ICustomRenderer> blockRenderers = new HashMap<BaseMod.IBlock, ICustomRenderer>();
    protected Map<Item, ICustomRenderer> itemRenderers = new HashMap<Item, ICustomRenderer>();
    protected Map<IBlockState, ICustomRenderer> stateRendererCache = new HashMap<IBlockState, ICustomRenderer>();
    protected TextureCache[] textureCaches = new TextureCache[2];
    public static EnumWorldBlockLayer[][] passLayers = new EnumWorldBlockLayer[][]{{EnumWorldBlockLayer.SOLID, EnumWorldBlockLayer.CUTOUT_MIPPED, EnumWorldBlockLayer.CUTOUT, EnumWorldBlockLayer.TRANSLUCENT}, {EnumWorldBlockLayer.SOLID, EnumWorldBlockLayer.CUTOUT_MIPPED, EnumWorldBlockLayer.CUTOUT}, {EnumWorldBlockLayer.TRANSLUCENT}};
    protected BlockRenderDispatcher blockRenderDispatcher;
    public static boolean debugRenderBlock = false;
    public static boolean debugRenderItem = false;
    protected ItemRenderDispatcher itemRenderDispatcher;
    protected static BaseGLRenderTarget glTarget = new BaseGLRenderTarget();
    protected static Trans3 entityTrans = Trans3.blockCenter;
    protected static Trans3 equippedTrans = Trans3.blockCenter;
    protected static Trans3 firstPersonTrans = Trans3.blockCenterSideTurn(0, 3);
    protected static Trans3 inventoryTrans = Trans3.blockCenter;
    protected static AltBlockAccess altBlockAccess = new AltBlockAccess();
    protected static RenderBlocks altRenderBlocks = new RenderBlocks((IBlockAccess)altBlockAccess);

    public BaseModClient(MOD MOD) {
        for (int i = 0; i < 2; ++i) {
            this.textureCaches[i] = new TextureCache();
        }
        this.base = MOD;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        this.registerSavedVillagerSkins();
        for (BaseSubsystem baseSubsystem : ((BaseMod)this.base).subsystems) {
            baseSubsystem.registerBlockRenderers();
            baseSubsystem.registerItemRenderers();
        }
        this.registerDefaultRenderers();
        this.removeUnusedDefaultTextureNames();
    }

    public void init(FMLInitializationEvent fMLInitializationEvent) {
    }

    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        for (BaseSubsystem baseSubsystem : ((BaseMod)this.base).subsystems) {
            baseSubsystem.registerModelLocations();
            baseSubsystem.registerTileEntityRenderers();
            baseSubsystem.registerEntityRenderers();
            baseSubsystem.registerScreens();
            baseSubsystem.registerOtherClient();
        }
    }

    void registerSavedVillagerSkins() {
        VillagerRegistry villagerRegistry = VillagerRegistry.instance();
        for (BaseMod.VSBinding vSBinding : ((BaseMod)this.base).registeredVillagers) {
            villagerRegistry.registerVillagerSkin(vSBinding.id, (ResourceLocation)vSBinding.object);
        }
    }

    void registerOther() {
    }

    void registerScreens() {
    }

    public void addScreen(Enum enum_, Class<? extends GuiScreen> clazz) {
        this.addScreen(enum_.ordinal(), clazz);
    }

    public void addScreen(int n, Class<? extends GuiScreen> clazz) {
        this.screenClasses.put(n, clazz);
    }

    protected void registerBlockRenderers() {
    }

    protected void registerItemRenderers() {
    }

    protected void registerEntityRenderers() {
    }

    protected void registerTileEntityRenderers() {
    }

    public void addTileEntityRenderer(Class<? extends TileEntity> clazz, TileEntitySpecialRenderer tileEntitySpecialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(clazz, (TileEntitySpecialRenderer)tileEntitySpecialRenderer);
    }

    public void addEntityRenderer(Class<? extends Entity> clazz, Render render) {
        RenderingRegistry.registerEntityRenderingHandler(clazz, (Render)render);
    }

    public void addEntityRenderer(Class<? extends Entity> clazz, Class<? extends Render> clazz2) {
        Render render;
        try {
            render = clazz2.newInstance();
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        this.addEntityRenderer(clazz, render);
    }

    protected void registerDefaultRenderers() {
        for (Block block : ((BaseMod)this.base).registeredBlocks) {
            Item item = Item.func_150898_a((Block)block);
            if (block instanceof BaseMod.IBlock) {
                String string;
                if (this.debugModelRegistration) {
                    System.out.printf("BaseModClient.registerDefaultRenderers: %s %s\n", block, block.func_149739_a());
                }
                if (!this.blockRenderers.containsKey(block) && (string = ((BaseMod.IBlock)block).getQualifiedRendererClassName()) != null) {
                    try {
                        Class<?> clazz = Class.forName(string);
                        this.addBlockRenderer((BaseMod.IBlock)block, (ICustomRenderer)clazz.newInstance());
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
                if (this.blockNeedsCustomRendering(block)) {
                    this.installCustomBlockRenderDispatcher((BaseMod.IBlock)block);
                    this.installCustomItemRenderDispatcher(item);
                }
            }
            if (!this.itemNeedsCustomRendering(item)) continue;
            this.installCustomItemRenderDispatcher(item);
        }
        for (Item item : ((BaseMod)this.base).registeredItems) {
            if (this.debugModelRegistration) {
                System.out.printf("BaseModClient.registerDefaultRenderers: %s %s\n", item, item.func_77658_a());
            }
            if (!this.itemNeedsCustomRendering(item)) continue;
            this.installCustomItemRenderDispatcher(item);
        }
    }

    protected void installCustomBlockRenderDispatcher(BaseMod.IBlock iBlock) {
        if (this.debugModelRegistration) {
            System.out.printf("BaseModClient.installCustomBlockRenderDisatcher: %s\n", iBlock);
        }
        iBlock.setRenderType(this.getCustomBlockRenderType());
    }

    protected void installCustomItemRenderDispatcher(Item item) {
        if (item != null) {
            if (this.debugModelRegistration) {
                System.out.printf("BaseModClient.installCustomItemRenderDispatcher: %s\n", item);
            }
            MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)this.getItemRenderDispatcher());
        }
    }

    protected void removeUnusedDefaultTextureNames() {
        for (Block block : ((BaseMod)this.base).registeredBlocks) {
            if (!this.blockNeedsCustomRendering(block)) continue;
            if (this.debugModelRegistration) {
                System.out.printf("BaseModClient: Removing default texture from block %s\n", block.func_149739_a());
            }
            block.func_149658_d("minecraft:stone");
        }
        for (Item item : ((BaseMod)this.base).registeredItems) {
            if (!this.itemNeedsCustomRendering(item)) continue;
            if (this.debugModelRegistration) {
                System.out.printf("BaseModClient: Removing default texture from item %s\n", item.func_77658_a());
            }
            item.func_111206_d("minecraft:apple");
        }
    }

    public static void openClientGui(GuiScreen guiScreen) {
        FMLClientHandler.instance().getClient().func_147108_a(guiScreen);
    }

    public ResourceLocation textureLocation(String string) {
        return ((BaseMod)this.base).resourceLocation("textures/" + string);
    }

    public void bindTexture(String string) {
        BaseModClient.bindTexture(this.textureLocation(string));
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(resourceLocation);
    }

    public Object getServerGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return ((BaseMod)this.base).getServerGuiElement(n, entityPlayer, world, n2, n3, n4);
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return this.getClientGuiElement(n, entityPlayer, world, new BlockPos(n2, n3, n4));
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        Class<? extends GuiScreen> clazz;
        int n2 = n >> 16;
        n &= 0xFFFF;
        Object object = null;
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: for id %s\n", n);
        }
        if ((clazz = this.screenClasses.get(n)) != null) {
            block14: {
                Class<? extends Container> clazz2;
                if (((BaseMod)this.base).debugGui) {
                    System.out.printf("BaseModClient.getClientGuiElement: Instantiating %s\n", clazz);
                }
                if ((clazz2 = ((BaseMod)this.base).containerClasses.get(n)) != null) {
                    try {
                        Object object2;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Looking for constructor taking %s\n", clazz2);
                        }
                        Constructor<? extends GuiScreen> constructor = clazz.getConstructor(clazz2);
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating container\n", new Object[0]);
                        }
                        if ((object2 = ((BaseMod)this.base).createGuiElement(clazz2, entityPlayer, world, blockPos, n2)) == null) break block14;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating screen with container\n", new Object[0]);
                        }
                        try {
                            object = constructor.newInstance(object2);
                        }
                        catch (Exception exception) {
                            BaseMod.reportExceptionCause(exception);
                            return null;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (object == null) {
                object = ((BaseMod)this.base).createGuiElement(clazz, entityPlayer, world, blockPos, n2);
            }
        } else {
            object = this.getGuiScreen(n, entityPlayer, world, blockPos, n2);
        }
        ((BaseMod)this.base).setModOf(object);
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: returning %s\n", object);
        }
        return object;
    }

    GuiScreen getGuiScreen(int n, EntityPlayer entityPlayer, World world, BlockPos blockPos, int n2) {
        System.out.printf("%s: BaseModClient.getGuiScreen: No GuiScreen class found for gui id %d\n", this, n);
        return null;
    }

    public void addBlockRenderer(BaseMod.IBlock iBlock, ICustomRenderer iCustomRenderer) {
        this.blockRenderers.put(iBlock, iCustomRenderer);
        this.customRenderingRequired = true;
        Item item = Item.func_150898_a((Block)((Block)iBlock));
        if (item != null && !this.itemRenderers.containsKey(item)) {
            this.addItemRenderer(item, iCustomRenderer);
        }
    }

    public void addItemRenderer(Item item, ICustomRenderer iCustomRenderer) {
        this.itemRenderers.put(item, iCustomRenderer);
    }

    protected boolean blockNeedsCustomRendering(Block block) {
        return this.blockRenderers.containsKey(block) || this.specifiesTextures(block);
    }

    protected boolean itemNeedsCustomRendering(Item item) {
        return this.itemRenderers.containsKey(item) || this.specifiesTextures(item);
    }

    protected boolean specifiesTextures(Object object) {
        return object instanceof BaseMod.ITextureConsumer && ((BaseMod.ITextureConsumer)object).getTextureNames() != null;
    }

    protected int getCustomBlockRenderType() {
        return this.getBlockRenderDispatcher().renderID;
    }

    protected BlockRenderDispatcher getBlockRenderDispatcher() {
        if (this.blockRenderDispatcher == null) {
            this.blockRenderDispatcher = new BlockRenderDispatcher();
        }
        return this.blockRenderDispatcher;
    }

    protected ItemRenderDispatcher getItemRenderDispatcher() {
        if (this.itemRenderDispatcher == null) {
            this.itemRenderDispatcher = new ItemRenderDispatcher();
        }
        return this.itemRenderDispatcher;
    }

    protected ICustomRenderer getCustomBlockRenderer(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState) {
        BaseBlock baseBlock = (BaseBlock)iBlockState.getBlock();
        ICustomRenderer iCustomRenderer = this.blockRenderers.get(baseBlock);
        if (iCustomRenderer == null && baseBlock instanceof BaseMod.IBlock) {
            IBlockState iBlockState2 = baseBlock.getActualState(iBlockState, iBlockAccess, blockPos);
            iCustomRenderer = this.getModelRendererForState(iBlockState2);
        }
        return iCustomRenderer;
    }

    protected ICustomRenderer getModelRendererForSpec(BaseMod.ModelSpec modelSpec, int n) {
        IModel iModel = this.getModel(modelSpec.modelName);
        ITexture[] iTextureArray = new ITexture[modelSpec.textureNames.length];
        for (int i = 0; i < iTextureArray.length; ++i) {
            iTextureArray[i] = this.getTexture(n, modelSpec.textureNames[i]);
        }
        return new BaseModelRenderer(iModel, modelSpec.origin, iTextureArray);
    }

    protected ICustomRenderer getModelRendererForState(IBlockState iBlockState) {
        BaseMod.ModelSpec modelSpec;
        Block block;
        ICustomRenderer iCustomRenderer = this.stateRendererCache.get(iBlockState);
        if (iCustomRenderer == null && (block = iBlockState.getBlock()) instanceof BaseMod.IBlock && (modelSpec = ((BaseMod.IBlock)block).getModelSpec(iBlockState)) != null) {
            iCustomRenderer = this.getModelRendererForSpec(modelSpec, 0);
            this.stateRendererCache.put(iBlockState, iCustomRenderer);
        }
        return iCustomRenderer;
    }

    protected ICustomRenderer getModelRendererForItemStack(ItemStack itemStack) {
        BaseMod.ModelSpec modelSpec;
        Item item = itemStack.func_77973_b();
        if (debugRenderItem) {
            System.out.printf("BaseModClient.getModelRendererForItemStack: item = %s %s\n", item, item.func_77658_a());
        }
        if (item instanceof BaseMod.IItem && (modelSpec = ((BaseMod.IItem)item).getModelSpec(itemStack)) != null) {
            return this.getModelRendererForSpec(modelSpec, 1);
        }
        if (item instanceof ItemBlock) {
            modelSpec = ((ItemBlock)item).field_150939_a;
            if (debugRenderItem) {
                System.out.printf("BaseModClient.getModelRendererForItemStack: block = %s %s\n", modelSpec, modelSpec.func_149739_a());
            }
            if (modelSpec instanceof BaseBlock) {
                IBlockState iBlockState = BaseBlockUtils.getBlockStateFromItemStack(itemStack);
                BaseMod.ModelSpec modelSpec2 = ((BaseMod.IBlock)((Object)modelSpec)).getModelSpec(iBlockState);
                return this.getModelRendererForSpec(modelSpec2, 0);
            }
        }
        return null;
    }

    public void renderBlockUsingModelSpec(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, IRenderTarget iRenderTarget, EnumWorldBlockLayer enumWorldBlockLayer, Trans3 trans3) {
        ICustomRenderer iCustomRenderer = this.getModelRendererForState(iBlockState);
        if (iCustomRenderer != null) {
            iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, iRenderTarget, enumWorldBlockLayer, trans3);
        }
    }

    public void renderItemStackUsingModelSpec(ItemStack itemStack, IRenderTarget iRenderTarget, Trans3 trans3) {
        ICustomRenderer iCustomRenderer = this.getModelRendererForItemStack(itemStack);
        if (debugRenderItem) {
            System.out.printf("BaseModClient.renderItemStackUsingModelSpec: renderer = %s\n", iCustomRenderer);
        }
        if (iCustomRenderer != null) {
            iCustomRenderer.renderItemStack(itemStack, iRenderTarget, trans3);
        }
    }

    public IModel getModel(String string) {
        return ((BaseMod)this.base).getModel(string);
    }

    public ITexture getTexture(int n, String string) {
        ResourceLocation resourceLocation = ((BaseMod)this.base).resourceLocation(string);
        return (ITexture)this.textureCaches[n].get(resourceLocation);
    }

    public IIcon getIcon(int n, String string) {
        return ((BaseTexture.Sprite)this.getTexture((int)n, (String)string)).icon;
    }

    @SubscribeEvent
    public void onTextureStitchEventPre(TextureStitchEvent.Pre pre) {
        int n = pre.map.func_130086_a();
        if (n >= 0 && n <= 1) {
            TextureCache textureCache = this.textureCaches[n];
            textureCache.clear();
            switch (n) {
                case 0: {
                    for (Block block : ((BaseMod)this.base).registeredBlocks) {
                        this.registerSprites(pre.map, textureCache, block);
                    }
                    break;
                }
                case 1: {
                    for (Item item : ((BaseMod)this.base).registeredItems) {
                        this.registerSprites(pre.map, textureCache, item);
                    }
                    break;
                }
            }
        }
    }

    protected void registerSprites(TextureMap textureMap, TextureCache textureCache, Object object) {
        String[] stringArray;
        if (this.debugModelRegistration) {
            System.out.printf("BaseModClient.registerSprites: for %s\n", object);
        }
        if (object instanceof BaseMod.ITextureConsumer && (stringArray = ((BaseMod.ITextureConsumer)object).getTextureNames()) != null) {
            this.customRenderingRequired = true;
            for (String string : stringArray) {
                ResourceLocation resourceLocation = ((BaseMod)this.base).resourceLocation(string);
                if (textureCache.get(resourceLocation) != null) continue;
                if (this.debugModelRegistration) {
                    System.out.printf("BaseModClient.registerSprites: %s\n", resourceLocation);
                }
                IIcon iIcon = textureMap.func_94245_a(resourceLocation.toString());
                BaseTexture.Sprite sprite = BaseTexture.fromSprite(iIcon);
                textureCache.put(resourceLocation, sprite);
            }
        }
    }

    public void renderAlternateBlock(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, IRenderTarget iRenderTarget) {
        int n;
        Block block = iBlockState.getBlock();
        if (!block.hasTileEntity(n = BaseBlockUtils.getMetaFromBlockState(iBlockState))) {
            altBlockAccess.setup(iBlockAccess, blockPos.x, blockPos.y, blockPos.z, n);
            altRenderBlocks.func_147769_a(block, blockPos.x, blockPos.y, blockPos.z);
            ((BaseWorldRenderTarget)iRenderTarget).setRenderingOccurred();
        }
    }

    protected static class AltBlockAccess
    implements IBlockAccess {
        IBlockAccess base;
        int targetX;
        int targetY;
        int targetZ;
        int metadata;

        protected AltBlockAccess() {
        }

        void setup(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
            this.base = iBlockAccess;
            this.targetX = n;
            this.targetY = n2;
            this.targetZ = n3;
            this.metadata = n4;
        }

        public Block func_147439_a(int n, int n2, int n3) {
            return this.base.func_147439_a(n, n2, n3);
        }

        public TileEntity func_147438_o(int n, int n2, int n3) {
            return this.base.func_147438_o(n, n2, n3);
        }

        public int func_72802_i(int n, int n2, int n3, int n4) {
            return this.base.func_72802_i(n, n2, n3, n4);
        }

        public int func_72805_g(int n, int n2, int n3) {
            if (n == this.targetX && n2 == this.targetY && n3 == this.targetZ) {
                return this.metadata;
            }
            return this.base.func_72805_g(n, n2, n3);
        }

        public int func_72879_k(int n, int n2, int n3, int n4) {
            return this.base.func_72879_k(n, n2, n3, n4);
        }

        public boolean func_147437_c(int n, int n2, int n3) {
            return this.base.func_147437_c(n, n2, n3);
        }

        public BiomeGenBase func_72807_a(int n, int n2) {
            return this.base.func_72807_a(n, n2);
        }

        public int func_72800_K() {
            return this.base.func_72800_K();
        }

        public boolean func_72806_N() {
            return this.base.func_72806_N();
        }

        public boolean isSideSolid(int n, int n2, int n3, ForgeDirection forgeDirection, boolean bl) {
            return this.base.isSideSolid(n, n2, n3, forgeDirection, bl);
        }
    }

    protected class ItemRenderDispatcher
    implements IItemRenderer {
        protected ItemRenderDispatcher() {
        }

        public boolean handleRenderType(ItemStack itemStack, IItemRenderer.ItemRenderType itemRenderType) {
            return itemRenderType != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
        }

        public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, IItemRenderer.ItemRendererHelper itemRendererHelper) {
            return true;
        }

        public void renderItem(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, Object ... objectArray) {
            if (debugRenderItem) {
                System.out.printf("BaseModClient.ItemRenderDispatcher.renderItem: %s %s\n", itemRenderType, itemStack);
            }
            ICustomRenderer iCustomRenderer = BaseModClient.this.itemRenderers.get(itemStack.func_77973_b());
            if (debugRenderItem) {
                System.out.printf("BaseModClient.ItemRenderDispatcher.renderItem: Custom renderer = %s\n", iCustomRenderer);
            }
            if (iCustomRenderer == null) {
                iCustomRenderer = BaseModClient.this.getModelRendererForItemStack(itemStack);
                if (debugRenderItem) {
                    System.out.printf("BaseModClient.ItemRenderDispatcher.renderItem: Model renderer = %s\n", iCustomRenderer);
                }
            }
            if (iCustomRenderer != null) {
                Trans3 trans3;
                switch (itemRenderType) {
                    case ENTITY: {
                        trans3 = entityTrans;
                        break;
                    }
                    case EQUIPPED: {
                        trans3 = equippedTrans;
                        break;
                    }
                    case EQUIPPED_FIRST_PERSON: {
                        trans3 = firstPersonTrans;
                        break;
                    }
                    case INVENTORY: {
                        trans3 = inventoryTrans;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                glTarget.start(false);
                iCustomRenderer.renderItemStack(itemStack, glTarget, trans3);
                glTarget.finish();
            }
        }
    }

    protected class BlockRenderDispatcher
    implements ISimpleBlockRenderingHandler {
        protected int renderID = RenderingRegistry.getNextAvailableRenderId();

        public BlockRenderDispatcher() {
            RenderingRegistry.registerBlockHandler((int)this.renderID, (ISimpleBlockRenderingHandler)this);
        }

        public boolean renderWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
            ICustomRenderer iCustomRenderer;
            boolean bl = false;
            BlockPos blockPos = new BlockPos(n, n2, n3);
            int n5 = iBlockAccess.func_72805_g(n, n2, n3);
            BaseBlock baseBlock = (BaseBlock)block;
            IBlockState iBlockState = baseBlock.getStateFromMeta(n5);
            if (debugRenderBlock) {
                System.out.printf("BaseModClient.BlockRenderDispatcher.renderWorldBlock: %s with meta %s state %s\n", block, n5, iBlockState);
            }
            if ((iCustomRenderer = BaseModClient.this.getCustomBlockRenderer(iBlockAccess, blockPos, iBlockState)) != null) {
                if (debugRenderBlock) {
                    System.out.printf("BaseModClient.BlockRenderDispatcher.renderWorldBlock: using %s\n", iCustomRenderer);
                }
                int n6 = ForgeHooksClient.getWorldRenderPass();
                for (EnumWorldBlockLayer enumWorldBlockLayer : passLayers[n6 + 1]) {
                    if (debugRenderBlock) {
                        System.out.printf("BaseModClient.BlockRenderDispatcher.renderWorldBlock: %s in layer %s\n", new Object[]{block, enumWorldBlockLayer});
                    }
                    if (!baseBlock.canRenderInLayer(enumWorldBlockLayer)) continue;
                    BaseWorldRenderTarget baseWorldRenderTarget = new BaseWorldRenderTarget(iBlockAccess, blockPos, Tessellator.field_78398_a, renderBlocks.field_147840_d);
                    Trans3 trans3 = Trans3.blockCenter(blockPos);
                    iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, baseWorldRenderTarget, enumWorldBlockLayer, trans3);
                    if (!baseWorldRenderTarget.end()) continue;
                    bl = true;
                }
            }
            return bl;
        }

        public void renderInventoryBlock(Block block, int n, int n2, RenderBlocks renderBlocks) {
        }

        public boolean shouldRender3DInInventory(int n) {
            return true;
        }

        public int getRenderId() {
            return this.renderID;
        }
    }

    public static class TextureCache
    extends HashMap<ResourceLocation, ITexture> {
    }

    public static interface IModel {
        public AxisAlignedBB getBounds();

        public void addBoxesToList(Trans3 var1, List var2);

        public void render(Trans3 var1, IRenderTarget var2, ITexture ... var3);
    }

    public static interface IRenderTarget {
        public boolean isRenderingBreakEffects();

        public void setTexture(ITexture var1);

        public void setColor(double var1, double var3, double var5, double var7);

        public void setNormal(Vector3 var1);

        public void beginTriangle();

        public void beginQuad();

        public void addVertex(Vector3 var1, double var2, double var4);

        public void addProjectedVertex(Vector3 var1, EnumFacing var2);

        public void endFace();
    }

    public static interface ITiledTexture
    extends ITexture {
        public ITexture tile(int var1, int var2);
    }

    public static interface ITexture {
        public ResourceLocation location();

        public int tintIndex();

        public double red();

        public double green();

        public double blue();

        public double interpolateU(double var1);

        public double interpolateV(double var1);

        public boolean isEmissive();

        public boolean isProjected();

        public boolean isSolid();

        public ITexture tinted(int var1);

        public ITexture colored(double var1, double var3, double var5);

        public ITexture projected();

        public ITexture emissive();

        public ITiledTexture tiled(int var1, int var2);
    }

    public static interface ICustomRenderer {
        public void renderBlock(IBlockAccess var1, BlockPos var2, IBlockState var3, IRenderTarget var4, EnumWorldBlockLayer var5, Trans3 var6);

        public void renderItemStack(ItemStack var1, IRenderTarget var2, Trans3 var3);
    }
}

