/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseRenderTarget;
import gcewing.architecture.Vector3;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class BaseGLRenderTarget
extends BaseRenderTarget {
    public static boolean debugGL = false;
    protected boolean usingLightmap;
    protected int glMode;
    protected int emissiveMode;
    protected int texturedMode;

    public BaseGLRenderTarget() {
        super(0.0, 0.0, 0.0, null);
    }

    public void start(boolean bl) {
        this.usingLightmap = bl;
        if (debugGL) {
            System.out.printf("BaseGLRenderTarget: glPushAttrib()\n", new Object[0]);
        }
        GL11.glPushAttrib((int)266304);
        if (debugGL) {
            System.out.printf("BaseGLRenderTarget: glEnable(GL_RESCALE_NORMAL)\n", new Object[0]);
        }
        GL11.glEnable((int)32826);
        this.glMode = 0;
        this.emissiveMode = -1;
        this.texturedMode = -1;
    }

    @Override
    public void setTexture(BaseModClient.ITexture iTexture) {
        if (this.texture != iTexture) {
            super.setTexture(iTexture);
            ResourceLocation resourceLocation = iTexture.location();
            if (resourceLocation != null) {
                this.setGLMode(0);
                if (debugGL) {
                    System.out.printf("BaseGLRenderTarget: bindTexture(%s)\n", resourceLocation);
                }
                BaseModClient.bindTexture(resourceLocation);
            }
            this.setTexturedMode(!iTexture.isSolid());
            this.setEmissiveMode(iTexture.isEmissive());
        }
    }

    protected void setEmissiveMode(boolean bl) {
        int n;
        int n2 = n = bl ? 1 : 0;
        if (this.emissiveMode != n) {
            if (debugGL) {
                System.out.printf("BaseGLRenderTarget: glSetEnabled(GL_LIGHTING, %s)\n", !bl);
            }
            this.glSetEnabled(2896, !bl);
            if (this.usingLightmap) {
                this.setLightmapEnabled(!bl);
            }
            this.emissiveMode = n;
        }
    }

    protected void setTexturedMode(boolean bl) {
        int n;
        int n2 = n = bl ? 1 : 0;
        if (this.texturedMode != n) {
            this.setGLMode(0);
            if (debugGL) {
                System.out.printf("BaseGLRenderTarget: glSetEnabled(GL_TEXTURE_2D, %s)\n", bl);
            }
            this.glSetEnabled(3553, bl);
            this.texturedMode = n;
        }
    }

    protected void setLightmapEnabled(boolean bl) {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        this.glSetEnabled(3553, bl);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    protected void glSetEnabled(int n, boolean bl) {
        if (bl) {
            GL11.glEnable((int)n);
        } else {
            GL11.glDisable((int)n);
        }
    }

    @Override
    protected void rawAddVertex(Vector3 vector3, double d, double d2) {
        this.setGLMode(this.verticesPerFace);
        GL11.glColor4f((float)this.r(), (float)this.g(), (float)this.b(), (float)this.a());
        GL11.glNormal3d((double)this.normal.x, (double)this.normal.y, (double)this.normal.z);
        GL11.glTexCoord2d((double)d, (double)d2);
        if (debugGL) {
            System.out.printf("BaseGLRenderTarget: glVertex3d: %s (%.4f,%.4f)\n", vector3, d, d2);
        }
        GL11.glVertex3d((double)vector3.x, (double)vector3.y, (double)vector3.z);
    }

    protected void setGLMode(int n) {
        if (this.glMode != n) {
            if (this.glMode != 0) {
                if (debugGL) {
                    System.out.printf("BaseGLRenderTarget: glEnd()\n", new Object[0]);
                }
                GL11.glEnd();
            }
            this.glMode = n;
            switch (this.glMode) {
                case 0: {
                    break;
                }
                case 3: {
                    if (debugGL) {
                        System.out.printf("BaseGLRenderTarget: glBegin(GL_TRIANGLES)\n", new Object[0]);
                    }
                    GL11.glBegin((int)4);
                    break;
                }
                case 4: {
                    if (debugGL) {
                        System.out.printf("BaseGLRenderTarget: glBegin(GL_QUADS)\n", new Object[0]);
                    }
                    GL11.glBegin((int)7);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Invalid glMode %s", this.glMode));
                }
            }
        }
    }

    @Override
    public void finish() {
        this.setGLMode(0);
        this.setEmissiveMode(false);
        this.setTexturedMode(true);
        if (debugGL) {
            System.out.printf("BaseGLRenderTarget: glPopAttrib()\n", new Object[0]);
        }
        GL11.glPopAttrib();
        super.finish();
    }
}

