/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseItemBlock;
import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BlockPos;
import gcewing.architecture.BlockState;
import gcewing.architecture.EnumWorldBlockLayer;
import gcewing.architecture.IBlockState;
import gcewing.architecture.IProperty;
import gcewing.architecture.InventoryHelper;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BaseBlock<TE extends TileEntity>
extends BlockContainer
implements BaseMod.IBlock {
    public static boolean debugState = false;
    protected static Random RANDOM = new Random();
    private static TileEntity tileEntityHarvested;
    public static IOrientationHandler orient1Way;
    protected MapColor mapColor;
    protected final BlockState blockState;
    protected IBlockState defaultBlockState;
    protected IProperty[] properties;
    protected Object[][] propertyValues;
    protected int numProperties;
    protected int renderID;
    protected Class<? extends TileEntity> tileEntityClass = null;
    protected IOrientationHandler orientationHandler = orient1Way;
    protected String[] textureNames;
    protected BaseMod.ModelSpec modelSpec;

    @Override
    public Class getDefaultItemClass() {
        return BaseItemBlock.class;
    }

    public BaseBlock(Material material) {
        this(material, null, null, null);
    }

    public BaseBlock(Material material, IOrientationHandler iOrientationHandler) {
        this(material, iOrientationHandler, null, null);
    }

    public BaseBlock(Material material, Class<TE> clazz) {
        this(material, null, clazz, null);
    }

    public BaseBlock(Material material, IOrientationHandler iOrientationHandler, Class<TE> clazz) {
        this(material, iOrientationHandler, clazz, null);
    }

    public BaseBlock(Material material, Class<TE> clazz, String string) {
        this(material, null, clazz, string);
    }

    public BaseBlock(Material material, IOrientationHandler iOrientationHandler, Class<TE> clazz, String string) {
        super(material);
        if (iOrientationHandler == null) {
            iOrientationHandler = orient1Way;
        }
        this.orientationHandler = iOrientationHandler;
        this.tileEntityClass = clazz;
        if (clazz != null) {
            if (string == null) {
                string = clazz.getName();
            }
            try {
                GameRegistry.registerTileEntity(clazz, (String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.blockState = this.createBlockState();
        this.defaultBlockState = this.blockState.getBaseState();
    }

    public IOrientationHandler getOrientationHandler() {
        return this.orientationHandler;
    }

    protected void defineProperties() {
        this.properties = new IProperty[4];
        this.propertyValues = new Object[4][];
        this.getOrientationHandler().defineProperties(this);
    }

    protected void addProperty(IProperty iProperty) {
        if (debugState) {
            System.out.printf("BaseBlock.addProperty: %s to %s\n", iProperty, this.getClass().getName());
        }
        if (this.numProperties >= 4) {
            throw new IllegalStateException("Block " + this.getClass().getName() + " has too many properties");
        }
        int n = this.numProperties++;
        this.properties[n] = iProperty;
        Object[] objectArray = BaseUtils.arrayOf(iProperty.getAllowedValues());
        this.propertyValues[n] = objectArray;
        if (debugState) {
            System.out.printf("BaseBlock.addProperty: %s now has %s properties\n", this.getClass().getName(), this.numProperties);
        }
    }

    protected BlockState createBlockState() {
        if (debugState) {
            System.out.printf("BaseBlock.createBlockState: Defining properties\n", new Object[0]);
        }
        this.defineProperties();
        if (debugState) {
            this.dumpProperties();
        }
        this.checkProperties();
        IProperty[] iPropertyArray = Arrays.copyOf(this.properties, this.numProperties);
        if (debugState) {
            System.out.printf("BaseBlock.createBlockState: Creating BlockState with %s properties\n", iPropertyArray.length);
        }
        return new BlockState((Block)this, iPropertyArray);
    }

    private void dumpProperties() {
        System.out.printf("BaseBlock: Properties of %s:\n", this.getClass().getName());
        for (int i = 0; i < this.numProperties; ++i) {
            System.out.printf("%s: %s\n", i, this.properties[i]);
            Object[] objectArray = this.propertyValues[i];
            for (int j = 0; j < objectArray.length; ++j) {
                System.out.printf("   %s: %s\n", j, objectArray[j]);
            }
        }
    }

    protected void checkProperties() {
        int n = 1;
        for (int i = 0; i < this.numProperties; ++i) {
            n *= this.propertyValues[i].length;
        }
        if (n > 16) {
            throw new IllegalStateException(String.format("Block %s has %s combinations of property values (16 allowed)", this.getClass().getName(), n));
        }
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public final IBlockState getDefaultState() {
        return this.defaultBlockState;
    }

    public IBlockState getActualState(IBlockState iBlockState, IBlockAccess iBlockAccess, BlockPos blockPos) {
        return iBlockState;
    }

    public int getMetaFromState(IBlockState iBlockState) {
        int n = 0;
        for (int i = this.numProperties - 1; i >= 0; --i) {
            int n2;
            Object t = iBlockState.getValue(this.properties[i]);
            Object[] objectArray = this.propertyValues[i];
            for (n2 = objectArray.length - 1; n2 > 0 && !objectArray[n2].equals(t); --n2) {
            }
            if (debugState) {
                System.out.printf("BaseBlock.getMetaFromState: property %s value %s --> %s of %s\n", i, t, n2, objectArray.length);
            }
            n = n * objectArray.length + n2;
        }
        if (debugState) {
            System.out.printf("BaseBlock.getMetaFromState: %s --> %s\n", iBlockState, n);
        }
        return n & 0xF;
    }

    public IBlockState getStateFromMeta(int n) {
        IBlockState iBlockState = this.getDefaultState();
        int n2 = n;
        for (int i = this.numProperties - 1; i >= 0; --i) {
            Object[] objectArray = this.propertyValues[i];
            int n3 = objectArray.length;
            int n4 = n2 % n3;
            n2 /= n3;
            iBlockState = iBlockState.withProperty(this.properties[i], (Comparable)objectArray[n4]);
        }
        if (debugState) {
            System.out.printf("BaseBlock.getStateFromMeta: %s --> %s\n", n, iBlockState);
        }
        return iBlockState;
    }

    @Override
    public int getNumSubtypes() {
        return 1;
    }

    public void setModelAndTextures(String string, String ... stringArray) {
        this.textureNames = stringArray;
        this.modelSpec = new BaseMod.ModelSpec(string, stringArray);
    }

    public void setModelAndTextures(String string, Vector3 vector3, String ... stringArray) {
        this.textureNames = stringArray;
        this.modelSpec = new BaseMod.ModelSpec(string, vector3, stringArray);
    }

    @Override
    public String[] getTextureNames() {
        return this.textureNames;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState iBlockState) {
        return this.modelSpec;
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer enumWorldBlockLayer) {
        return this.getBlockLayer() == enumWorldBlockLayer;
    }

    public EnumWorldBlockLayer getBlockLayer() {
        return EnumWorldBlockLayer.SOLID;
    }

    public int func_149645_b() {
        return this.renderID;
    }

    @Override
    public void setRenderType(int n) {
        this.renderID = n;
    }

    @Override
    public String getQualifiedRendererClassName() {
        String string = this.getRendererClassName();
        if (string != null) {
            string = this.getClass().getPackage().getName() + "." + string;
        }
        return string;
    }

    protected String getRendererClassName() {
        return null;
    }

    public Trans3 localToGlobalRotation(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return this.localToGlobalRotation(iBlockAccess, blockPos, BaseBlockUtils.getWorldBlockState(iBlockAccess, blockPos));
    }

    public Trans3 localToGlobalRotation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState) {
        return this.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState, Vector3.zero);
    }

    public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return this.localToGlobalTransformation(iBlockAccess, blockPos, BaseBlockUtils.getWorldBlockState(iBlockAccess, blockPos));
    }

    public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState) {
        return this.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState, Vector3.blockCenter(blockPos));
    }

    @Override
    public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Vector3 vector3) {
        IOrientationHandler iOrientationHandler = this.getOrientationHandler();
        return iOrientationHandler.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState, vector3);
    }

    public boolean hasTileEntity(int n) {
        return this.hasTileEntity(this.getStateFromMeta(n));
    }

    public boolean hasTileEntity(IBlockState iBlockState) {
        return this.tileEntityClass != null;
    }

    public TE getTileEntity(IBlockAccess iBlockAccess, BlockPos blockPos) {
        if (this.func_149716_u()) {
            return (TE)iBlockAccess.func_147438_o(blockPos.x, blockPos.y, blockPos.z);
        }
        return null;
    }

    public TileEntity func_149915_a(World world, int n) {
        if (this.tileEntityClass != null) {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    public IBlockState onBlockPlaced(World world, BlockPos blockPos, EnumFacing enumFacing, float f, float f2, float f3, int n, EntityLivingBase entityLivingBase) {
        return this.getOrientationHandler().onBlockPlaced((Block)this, world, blockPos, enumFacing, f, f2, f3, this.getStateFromMeta(n), entityLivingBase);
    }

    public void func_149726_b(World world, int n, int n2, int n3) {
        TE TE;
        super.func_149726_b(world, n, n2, n3);
        BlockPos blockPos = new BlockPos(n, n2, n3);
        int n4 = world.func_72805_g(n, n2, n3);
        if (this.hasTileEntity(n4) && (TE = this.getTileEntity((IBlockAccess)world, blockPos)) instanceof BaseMod.ITileEntity) {
            ((BaseMod.ITileEntity)TE).onAddedToWorld();
        }
        this.onBlockAdded(world, blockPos, this.getStateFromMeta(n4));
    }

    public void onBlockAdded(World world, BlockPos blockPos, IBlockState iBlockState) {
    }

    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        BlockPos blockPos = new BlockPos(n, n2, n3);
        IBlockState iBlockState = BaseBlockUtils.getWorldBlockState((IBlockAccess)world, blockPos);
        this.onBlockPlacedBy(world, blockPos, iBlockState, entityLivingBase, itemStack);
    }

    public void onBlockPlacedBy(World world, BlockPos blockPos, IBlockState iBlockState, EntityLivingBase entityLivingBase, ItemStack itemStack) {
    }

    public void func_149749_a(World world, int n, int n2, int n3, Block block, int n4) {
        TileEntity tileEntity;
        BlockPos blockPos = new BlockPos(n, n2, n3);
        this.breakBlock(world, blockPos, this.getStateFromMeta(n4));
        if (this.hasTileEntity(n4) && (tileEntity = world.func_147438_o(n, n2, n3)) instanceof IInventory) {
            InventoryHelper.dropInventoryItems(world, blockPos, (IInventory)tileEntity);
        }
        super.func_149749_a(world, n, n2, n3, block, n4);
    }

    public void breakBlock(World world, BlockPos blockPos, IBlockState iBlockState) {
    }

    public boolean canHarvestBlock(EntityPlayer entityPlayer, int n) {
        return this.canHarvestBlock(this.getStateFromMeta(n), entityPlayer);
    }

    public boolean canHarvestBlock(IBlockState iBlockState, EntityPlayer entityPlayer) {
        return super.canHarvestBlock(entityPlayer, this.getMetaFromState(iBlockState));
    }

    public boolean func_149727_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        int n5 = world.func_72805_g(n, n2, n3);
        IBlockState iBlockState = this.getStateFromMeta(n5);
        return this.onBlockActivated(world, new BlockPos(n, n2, n3), iBlockState, entityPlayer, BaseUtils.facings[n4], f, f2, f3);
    }

    public boolean onBlockActivated(World world, BlockPos blockPos, IBlockState iBlockState, EntityPlayer entityPlayer, EnumFacing enumFacing, float f, float f2, float f3) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return this.isSideSolid(iBlockAccess, new BlockPos(n, n2, n3), BaseUtils.facings[forgeDirection.ordinal()]);
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, BlockPos blockPos, EnumFacing enumFacing) {
        return super.isSideSolid(iBlockAccess, blockPos.x, blockPos.y, blockPos.z, ForgeDirection.VALID_DIRECTIONS[enumFacing.ordinal()]);
    }

    public boolean getWeakChanges(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return this.getWeakChanges(iBlockAccess, new BlockPos(n, n2, n3));
    }

    public boolean getWeakChanges(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return super.getWeakChanges(iBlockAccess, blockPos.x, blockPos.y, blockPos.z);
    }

    public void func_149695_a(World world, int n, int n2, int n3, Block block) {
        int n4 = world.func_72805_g(n, n2, n3);
        IBlockState iBlockState = this.getStateFromMeta(n4);
        this.onNeighborBlockChange(world, new BlockPos(n, n2, n3), iBlockState, block);
    }

    public void onNeighborBlockChange(World world, BlockPos blockPos, IBlockState iBlockState, Block block) {
    }

    public int func_149748_c(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = iBlockAccess.func_72805_g(n, n2, n3);
        IBlockState iBlockState = this.getStateFromMeta(n5);
        return this.getStrongPower(iBlockAccess, new BlockPos(n, n2, n3), iBlockState, BaseUtils.facings[n4]);
    }

    public int getStrongPower(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, EnumFacing enumFacing) {
        return 0;
    }

    public int func_149709_b(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = iBlockAccess.func_72805_g(n, n2, n3);
        IBlockState iBlockState = this.getStateFromMeta(n5);
        return this.getWeakPower(iBlockAccess, new BlockPos(n, n2, n3), iBlockState, BaseUtils.facings[n4]);
    }

    public int getWeakPower(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, EnumFacing enumFacing) {
        return 0;
    }

    public boolean shouldCheckWeakPower(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return this.shouldCheckWeakPower(iBlockAccess, new BlockPos(n, n2, n3), BaseUtils.facings[n4]);
    }

    public boolean shouldCheckWeakPower(IBlockAccess iBlockAccess, BlockPos blockPos, EnumFacing enumFacing) {
        return super.shouldCheckWeakPower(iBlockAccess, blockPos.x, blockPos.y, blockPos.z, enumFacing.ordinal());
    }

    public void spawnAsEntity(World world, BlockPos blockPos, ItemStack itemStack) {
        this.func_149642_a(world, blockPos.x, blockPos.y, blockPos.z, itemStack);
    }

    public int func_149692_a(int n) {
        return this.damageDropped(this.getStateFromMeta(n));
    }

    public int damageDropped(IBlockState iBlockState) {
        return 0;
    }

    public MapColor func_149728_f(int n) {
        if (this.mapColor != null) {
            return this.mapColor;
        }
        return super.func_149728_f(n);
    }

    public Item func_149650_a(int n, Random random, int n2) {
        return this.getItemDropped(this.getStateFromMeta(n), random, n2);
    }

    public Item getItemDropped(IBlockState iBlockState, Random random, int n) {
        return super.func_149650_a(this.getMetaFromState(iBlockState), random, n);
    }

    public ArrayList<ItemStack> getDrops(World world, int n, int n2, int n3, int n4, int n5) {
        IBlockState iBlockState = this.getStateFromMeta(n4);
        return this.getDrops((IBlockAccess)world, new BlockPos(n, n2, n3), iBlockState, n5);
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, int n) {
        int n2 = this.getMetaFromState(iBlockState);
        return super.getDrops((World)iBlockAccess, blockPos.x, blockPos.y, blockPos.z, n2, n);
    }

    public boolean func_149686_d() {
        return this.isFullCube();
    }

    public boolean isFullCube() {
        return super.func_149686_d();
    }

    public MovingObjectPosition func_149731_a(World world, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        return this.collisionRayTrace(world, new BlockPos(n, n2, n3), vec3, vec32);
    }

    public MovingObjectPosition collisionRayTrace(World world, BlockPos blockPos, Vec3 vec3, Vec3 vec32) {
        return super.func_149731_a(world, blockPos.x, blockPos.y, blockPos.z, vec3, vec32);
    }

    public void func_149719_a(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        this.setBlockBoundsBasedOnState(iBlockAccess, new BlockPos(n, n2, n3));
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iBlockAccess, BlockPos blockPos) {
        super.func_149719_a(iBlockAccess, blockPos.x, blockPos.y, blockPos.z);
    }

    public void func_149743_a(World world, int n, int n2, int n3, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        BlockPos blockPos = new BlockPos(n, n2, n3);
        IBlockState iBlockState = BaseBlockUtils.getWorldBlockState((IBlockAccess)world, blockPos);
        this.addCollisionBoxesToList(world, blockPos, iBlockState, axisAlignedBB, list, entity);
    }

    public void addCollisionBoxesToList(World world, BlockPos blockPos, IBlockState iBlockState, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        super.func_149743_a(world, blockPos.x, blockPos.y, blockPos.z, axisAlignedBB, list, entity);
    }

    public void func_149681_a(World world, int n, int n2, int n3, int n4, EntityPlayer entityPlayer) {
        tileEntityHarvested = world.func_147438_o(n, n2, n3);
    }

    public void func_149636_a(World world, EntityPlayer entityPlayer, int n, int n2, int n3, int n4) {
        this.harvestBlock(world, entityPlayer, new BlockPos(n, n2, n3), this.getStateFromMeta(n4), tileEntityHarvested);
    }

    public void harvestBlock(World world, EntityPlayer entityPlayer, BlockPos blockPos, IBlockState iBlockState, TileEntity tileEntity) {
        super.func_149636_a(world, entityPlayer, blockPos.x, blockPos.y, blockPos.z, this.getMetaFromState(iBlockState));
    }

    public ItemStack getPickBlock(MovingObjectPosition movingObjectPosition, World world, int n, int n2, int n3) {
        return this.getPickBlock(movingObjectPosition, world, new BlockPos(n, n2, n3));
    }

    public ItemStack getPickBlock(MovingObjectPosition movingObjectPosition, World world, BlockPos blockPos) {
        return super.getPickBlock(movingObjectPosition, world, blockPos.x, blockPos.y, blockPos.z);
    }

    public float func_149737_a(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        return this.getPlayerRelativeBlockHardness(entityPlayer, world, new BlockPos(n, n2, n3));
    }

    public float getPlayerRelativeBlockHardness(EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        return super.func_149737_a(entityPlayer, world, blockPos.x, blockPos.y, blockPos.z);
    }

    public float func_149712_f(World world, int n, int n2, int n3) {
        return this.getBlockHardness(world, new BlockPos(n, n2, n3));
    }

    public float getBlockHardness(World world, BlockPos blockPos) {
        return super.func_149712_f(world, blockPos.x, blockPos.y, blockPos.z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition movingObjectPosition, EffectRenderer effectRenderer) {
        BlockPos blockPos = new BlockPos(movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d);
        IBlockState iBlockState = this.getParticleState((IBlockAccess)world, blockPos);
        Block block = iBlockState.getBlock();
        int n = BaseBlockUtils.getMetaFromBlockState(iBlockState);
        int n2 = blockPos.getX();
        int n3 = blockPos.getY();
        int n4 = blockPos.getZ();
        float f = 0.1f;
        double d = (double)n2 + RANDOM.nextDouble() * (this.func_149753_y() - this.func_149704_x() - (double)(f * 2.0f)) + (double)f + this.func_149704_x();
        double d2 = (double)n3 + RANDOM.nextDouble() * (this.func_149669_A() - this.func_149665_z() - (double)(f * 2.0f)) + (double)f + this.func_149665_z();
        double d3 = (double)n4 + RANDOM.nextDouble() * (this.func_149693_C() - this.func_149706_B() - (double)(f * 2.0f)) + (double)f + this.func_149706_B();
        switch (movingObjectPosition.field_72310_e) {
            case 0: {
                d2 = (double)n3 + this.func_149665_z() - (double)f;
                break;
            }
            case 1: {
                d2 = (double)n3 + this.func_149669_A() + (double)f;
                break;
            }
            case 2: {
                d3 = (double)n4 + this.func_149706_B() - (double)f;
                break;
            }
            case 3: {
                d3 = (double)n4 + this.func_149693_C() + (double)f;
                break;
            }
            case 4: {
                d = (double)n2 + this.func_149704_x() - (double)f;
                break;
            }
            case 5: {
                d = (double)n2 + this.func_149753_y() + (double)f;
            }
        }
        EntityDiggingFX entityDiggingFX = new EntityDiggingFX(world, d, d2, d3, 0.0, 0.0, 0.0, block, n);
        effectRenderer.func_78873_a(entityDiggingFX.func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int n, int n2, int n3, int n4, EffectRenderer effectRenderer) {
        BlockPos blockPos = new BlockPos(n, n2, n3);
        IBlockState iBlockState = this.getParticleState((IBlockAccess)world, blockPos);
        Block block = iBlockState.getBlock();
        n4 = BaseBlockUtils.getMetaFromBlockState(iBlockState);
        int n5 = 4;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n5; ++j) {
                for (int k = 0; k < n5; ++k) {
                    double d = (double)blockPos.getX() + ((double)i + 0.5) / (double)n5;
                    double d2 = (double)blockPos.getY() + ((double)j + 0.5) / (double)n5;
                    double d3 = (double)blockPos.getZ() + ((double)k + 0.5) / (double)n5;
                    EntityDiggingFX entityDiggingFX = new EntityDiggingFX(world, d, d2, d3, d - (double)blockPos.getX() - 0.5, d2 - (double)blockPos.getY() - 0.5, d3 - (double)blockPos.getZ() - 0.5, block, n4);
                    effectRenderer.func_78873_a((EntityFX)entityDiggingFX);
                }
            }
        }
        return true;
    }

    public IBlockState getParticleState(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return BaseBlockUtils.getWorldBlockState(iBlockAccess, blockPos);
    }

    public int func_149701_w() {
        if (this.canRenderInLayer(EnumWorldBlockLayer.TRANSLUCENT)) {
            return 1;
        }
        return 0;
    }

    public boolean canRenderInPass(int n) {
        for (EnumWorldBlockLayer enumWorldBlockLayer : BaseModClient.passLayers[n + 1]) {
            if (!this.canRenderInLayer(enumWorldBlockLayer)) continue;
            return true;
        }
        return false;
    }

    static {
        orient1Way = new Orient1Way();
    }

    public static class Orient1Way
    implements IOrientationHandler {
        @Override
        public void defineProperties(BaseBlock baseBlock) {
        }

        @Override
        public IBlockState onBlockPlaced(Block block, World world, BlockPos blockPos, EnumFacing enumFacing, float f, float f2, float f3, IBlockState iBlockState, EntityLivingBase entityLivingBase) {
            return iBlockState;
        }

        @Override
        public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Vector3 vector3) {
            return new Trans3(vector3);
        }
    }

    public static interface IOrientationHandler {
        public void defineProperties(BaseBlock var1);

        public IBlockState onBlockPlaced(Block var1, World var2, BlockPos var3, EnumFacing var4, float var5, float var6, float var7, IBlockState var8, EntityLivingBase var9);

        public Trans3 localToGlobalTransformation(IBlockAccess var1, BlockPos var2, IBlockState var3, Vector3 var4);
    }
}

