/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.ArchitectureCraftClient;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.RenderShape;
import gcewing.architecture.ShapeKind;
import gcewing.architecture.ShapeTE;
import gcewing.architecture.Trans3;
import net.minecraft.util.EnumFacing;

public class RenderWindow
extends RenderShape {
    protected static ArchitectureCraftClient client;
    protected static WindowModels frameModels;
    protected static WindowModels cornerModels;
    protected static WindowModels mullionModels;
    protected boolean renderBase;
    protected boolean renderSecondary;
    protected ShapeKind.Window kind;

    protected static BaseModClient.IModel model(String string) {
        if (string != null) {
            return client.getModel("shape/window_" + string + ".smeg");
        }
        return null;
    }

    protected static BaseModClient.IModel[] models(String ... stringArray) {
        BaseModClient.IModel[] iModelArray = new BaseModClient.IModel[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            iModelArray[i] = RenderWindow.model(stringArray[i]);
        }
        return iModelArray;
    }

    protected static BaseModClient.IModel[] models(int n, String string) {
        BaseModClient.IModel[] iModelArray = new BaseModClient.IModel[n];
        BaseModClient.IModel iModel = RenderWindow.model(string);
        for (int i = 0; i < n; ++i) {
            iModelArray[i] = iModel;
        }
        return iModelArray;
    }

    public static void init(ArchitectureCraftClient architectureCraftClient) {
        client = architectureCraftClient;
        frameModels = new WindowModels(null, null, RenderWindow.models(4, "frame_side"), RenderWindow.models(4, "frame_end0"), RenderWindow.models(4, "frame_end1"), RenderWindow.model("glass"), RenderWindow.models(4, "glass_edge"));
        cornerModels = new WindowModels(RenderWindow.model("corner_centre"), RenderWindow.models("corner_centre_end0", null, "corner_centre_end2", null), RenderWindow.models("corner_topbot", "frame_side", "corner_topbot", "frame_side"), RenderWindow.models(4, "frame_end0"), RenderWindow.models("corner_topbot_end1", "frame_end1", "corner_topbot_end1", "frame_end1"), RenderWindow.model("corner_glass"), RenderWindow.models("corner_glass_edge", "glass_edge", "corner_glass_edge", "glass_edge"));
        mullionModels = new WindowModels(RenderWindow.model("mullion_centre"), RenderWindow.models("mullion_centre_end0", null, "mullion_centre_end2", null), RenderWindow.models("mullion_topbot", "frame_side", "mullion_topbot", "frame_side"), RenderWindow.models(4, "frame_end0"), RenderWindow.models(4, "frame_end1"), RenderWindow.model("glass"), RenderWindow.models("mullion_glass_edge", "glass_edge", "mullion_glass_edge", "glass_edge"));
    }

    public RenderWindow(ShapeTE shapeTE, BaseModClient.ITexture[] iTextureArray, Trans3 trans3, BaseModClient.IRenderTarget iRenderTarget, boolean bl, boolean bl2) {
        super(shapeTE, iTextureArray, trans3, iRenderTarget);
        this.renderBase = bl;
        this.renderSecondary = bl2;
        this.kind = (ShapeKind.Window)shapeTE.shape.kind;
    }

    @Override
    protected void render() {
        switch (this.te.shape) {
            case WindowFrame: {
                this.renderWindow(frameModels);
                break;
            }
            case WindowCorner: {
                this.renderWindow(cornerModels);
                break;
            }
            case WindowMullion: {
                this.renderWindow(mullionModels);
            }
        }
    }

    protected void renderWindow(WindowModels windowModels) {
        boolean[][] blArray = this.getFrameFlags();
        if (this.renderBase) {
            this.renderModel(this.t, windowModels.centre);
        }
        for (int i = 0; i <= 3; ++i) {
            int n = i - 1 & 3;
            int n2 = i + 1 & 3;
            Trans3 trans3 = this.t.t(this.kind.frameTrans[i]);
            if (this.renderBase) {
                if (blArray[i][1]) {
                    this.renderModel(trans3, windowModels.side[i]);
                } else if (windowModels.centreEnd != null) {
                    this.renderModel(this.t, windowModels.centreEnd[i]);
                }
                if (blArray[i][1] && !blArray[n][1] || blArray[i][0] && blArray[n][2]) {
                    this.renderModel(trans3, windowModels.end0[i]);
                }
                if (blArray[i][1] && !blArray[n2][1] || blArray[i][2] && blArray[n2][0]) {
                    this.renderModel(trans3, windowModels.end1[i]);
                }
            }
            if (!this.renderSecondary || blArray[i][1] || blArray[i][3]) continue;
            this.renderModel(trans3, windowModels.glassEdge[i]);
        }
        if (this.renderSecondary) {
            this.renderModel(this.t, windowModels.glass);
        }
    }

    protected void renderModel(Trans3 trans3, BaseModClient.IModel iModel) {
        if (iModel != null) {
            iModel.render(trans3, this.target, this.textures);
        }
    }

    protected boolean[][] getFrameFlags() {
        boolean[][] blArray = new boolean[4][4];
        if (this.blockWorld == null) {
            for (int i = 0; i <= 3; ++i) {
                blArray[i][1] = true;
            }
        } else {
            int n;
            EnumFacing[] enumFacingArray = new EnumFacing[4];
            ShapeTE[] shapeTEArray = new ShapeTE[4];
            for (n = 0; n <= 3; ++n) {
                enumFacingArray[n] = this.t.t(this.kind.frameSides[n]);
            }
            for (n = 0; n <= 3; ++n) {
                if (this.kind.frameAlways[n]) {
                    blArray[n][1] = true;
                    continue;
                }
                ShapeTE shapeTE = this.getConnectedNeighbourGlobal(this.te, enumFacingArray[n]);
                if (shapeTE == null) {
                    blArray[n][1] = true;
                    continue;
                }
                int n2 = n - 1 & 3;
                int n3 = n + 1 & 3;
                if (this.getConnectedNeighbourGlobal(shapeTE, enumFacingArray[n2]) == null) {
                    blArray[n2][2] = true;
                }
                if (this.getConnectedNeighbourGlobal(shapeTE, enumFacingArray[n3]) == null) {
                    blArray[n3][0] = true;
                }
                if (shapeTE.secondaryBlockState == null) continue;
                blArray[n][3] = true;
            }
        }
        return blArray;
    }

    protected void dumpFrameFlags(boolean[][] blArray) {
        if (this.te != null && this.te.secondaryBlockState != null) {
            System.out.printf("RenderWindow.getFrameFlags:\n", new Object[0]);
            for (int i = 0; i <= 3; ++i) {
                System.out.printf("Side %s: %s %s %s\n", i, blArray[i][0], blArray[i][1], blArray[i][2]);
            }
        }
    }

    protected ShapeTE getConnectedNeighbourGlobal(ShapeTE shapeTE, EnumFacing enumFacing) {
        return this.kind.getConnectedWindowGlobal(shapeTE, enumFacing);
    }

    protected void debug(String string, Object ... objectArray) {
        if (this.blockWorld != null && this.te.secondaryBlockState != null) {
            System.out.printf(string, objectArray);
        }
    }

    protected static class WindowModels {
        public BaseModClient.IModel centre;
        public BaseModClient.IModel[] centreEnd;
        public BaseModClient.IModel[] side;
        public BaseModClient.IModel[] end0;
        public BaseModClient.IModel[] end1;
        public BaseModClient.IModel glass;
        public BaseModClient.IModel[] glassEdge;

        public WindowModels(BaseModClient.IModel iModel, BaseModClient.IModel[] iModelArray, BaseModClient.IModel[] iModelArray2, BaseModClient.IModel[] iModelArray3, BaseModClient.IModel[] iModelArray4, BaseModClient.IModel iModel2, BaseModClient.IModel[] iModelArray5) {
            this.centre = iModel;
            this.centreEnd = iModelArray;
            this.side = iModelArray2;
            this.end0 = iModelArray3;
            this.end1 = iModelArray4;
            this.glass = iModel2;
            this.glassEdge = iModelArray5;
        }
    }
}

