/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseTileEntity;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;

public class BaseUtils {
    public static EnumFacing[] facings = EnumFacing.values();

    public static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static double min(double d, double d2) {
        return d < d2 ? d : d2;
    }

    public static double max(double d, double d2) {
        return d > d2 ? d : d2;
    }

    public static int ifloor(double d) {
        return (int)Math.floor(d);
    }

    public static int iround(double d) {
        return (int)Math.round(d);
    }

    public static int iceil(double d) {
        return (int)Math.ceil(d);
    }

    public static Object[] arrayOf(Collection collection) {
        int n = collection.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        for (Object e : collection) {
            objectArray[n2++] = e;
        }
        return objectArray;
    }

    public static Field getFieldDef(Class clazz, String string, String string2) {
        try {
            Field field;
            try {
                field = clazz.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                field = clazz.getDeclaredField(string2);
            }
            field.setAccessible(true);
            return field;
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Cannot find field %s or %s of %s", string, string2, clazz.getName()), exception);
        }
    }

    public static Object getField(Object object, String string, String string2) {
        Field field = BaseUtils.getFieldDef(object.getClass(), string, string2);
        return BaseUtils.getField(object, field);
    }

    public static Object getField(Object object, Field field) {
        try {
            return field.get(object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void setField(Object object, String string, String string2, Object object2) {
        Field field = BaseUtils.getFieldDef(object.getClass(), string, string2);
        BaseUtils.setField(object, field, object2);
    }

    public static void setField(Object object, Field field, Object object2) {
        try {
            field.set(object, object2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static int packedColor(double d, double d2, double d3) {
        return (int)(d * 255.0) << 16 | (int)(d2 * 255.0) << 8 | (int)(d3 * 255.0);
    }

    public static ItemStack blockStackWithState(IBlockState iBlockState, int n) {
        Block block = iBlockState.func_177230_c();
        int n2 = block.func_176201_c(iBlockState);
        return new ItemStack(block, n, n2);
    }

    public static ItemStack blockStackWithTileEntity(Block block, int n, BaseTileEntity baseTileEntity) {
        ItemStack itemStack = new ItemStack(block, n);
        if (baseTileEntity != null) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            baseTileEntity.writeToItemStackNBT(nBTTagCompound);
            itemStack.func_77982_d(nBTTagCompound);
        }
        return itemStack;
    }

    public static int turnToFace(EnumFacing enumFacing, EnumFacing enumFacing2) {
        return BaseUtils.turnToFaceEast(enumFacing) - BaseUtils.turnToFaceEast(enumFacing2) & 3;
    }

    public static int turnToFaceEast(EnumFacing enumFacing) {
        switch (enumFacing) {
            case SOUTH: {
                return 1;
            }
            case WEST: {
                return 2;
            }
            case NORTH: {
                return 3;
            }
        }
        return 0;
    }

    public static BlockPos readBlockPos(DataInput dataInput) {
        try {
            int n = dataInput.readInt();
            int n2 = dataInput.readInt();
            int n3 = dataInput.readInt();
            return new BlockPos(n, n2, n3);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void writeBlockPos(DataOutput dataOutput, BlockPos blockPos) {
        try {
            dataOutput.writeInt(blockPos.func_177958_n());
            dataOutput.writeInt(blockPos.func_177956_o());
            dataOutput.writeInt(blockPos.func_177952_p());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

