/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBakedRenderTarget;
import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseModelRenderer;
import gcewing.architecture.BaseSubsystem;
import gcewing.architecture.BaseTexture;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BaseWorldRenderTarget;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class BaseModClient<MOD extends BaseMod<? extends BaseModClient>>
implements IGuiHandler {
    public boolean debugModelRegistration = false;
    MOD base;
    boolean customRenderingRequired;
    boolean debugSound = false;
    Map<Integer, Class<? extends GuiScreen>> screenClasses = new HashMap<Integer, Class<? extends GuiScreen>>();
    protected Map<Block, ICustomRenderer> blockRenderers = new HashMap<Block, ICustomRenderer>();
    protected Map<Item, ICustomRenderer> itemRenderers = new HashMap<Item, ICustomRenderer>();
    protected Map<IBlockState, ICustomRenderer> stateRendererCache = new HashMap<IBlockState, ICustomRenderer>();
    protected Map<ResourceLocation, ITexture> textureCache = new HashMap<ResourceLocation, ITexture>();
    protected Map<ModelResourceLocation, IBakedModel> smartModels = new HashMap<ModelResourceLocation, IBakedModel>();
    private CustomBlockStateMapper customBlockStateMapper = new CustomBlockStateMapper();
    protected static String[] texturePrefixes = new String[]{"blocks/", "textures/"};
    protected static Trans3 itemTrans = Trans3.blockCenterSideTurn(0, 2);
    protected CustomBlockRendererDispatcher customBlockRendererDispatcher;
    protected CustomItemRenderDispatch customItemRenderDispatch;
    protected static IStateMapper dummyStateMapper = new DummyStateMapper();

    public BaseModClient(MOD MOD) {
        this.base = MOD;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        System.out.printf("BaseModClient.preInit\n", new Object[0]);
        this.registerSavedVillagerSkins();
        for (BaseSubsystem baseSubsystem : ((BaseMod)this.base).subsystems) {
            baseSubsystem.registerBlockRenderers();
            baseSubsystem.registerItemRenderers();
        }
        this.registerDefaultRenderers();
        this.registerDefaultModelLocations();
    }

    public void init(FMLInitializationEvent fMLInitializationEvent) {
        System.out.printf("BaseModClient.init\n", new Object[0]);
    }

    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        System.out.printf("BaseModClient.postInit\n", new Object[0]);
        for (BaseSubsystem baseSubsystem : ((BaseMod)this.base).subsystems) {
            baseSubsystem.registerModelLocations();
            baseSubsystem.registerTileEntityRenderers();
            baseSubsystem.registerEntityRenderers();
            baseSubsystem.registerScreens();
            baseSubsystem.registerOtherClient();
        }
        if (this.customRenderingRequired) {
            this.enableCustomRendering();
        }
    }

    void registerSavedVillagerSkins() {
        VillagerRegistry villagerRegistry = VillagerRegistry.instance();
        for (BaseMod.VSBinding vSBinding : ((BaseMod)this.base).registeredVillagers) {
            villagerRegistry.registerVillagerSkin(vSBinding.id, (ResourceLocation)vSBinding.object);
        }
    }

    void registerOther() {
    }

    void registerScreens() {
    }

    public void addScreen(Enum enum_, Class<? extends GuiScreen> clazz) {
        this.addScreen(enum_.ordinal(), clazz);
    }

    public void addScreen(int n, Class<? extends GuiScreen> clazz) {
        this.screenClasses.put(n, clazz);
    }

    protected void registerBlockRenderers() {
    }

    protected void registerItemRenderers() {
    }

    protected void registerEntityRenderers() {
    }

    protected void registerTileEntityRenderers() {
    }

    public void addTileEntityRenderer(Class<? extends TileEntity> clazz, TileEntitySpecialRenderer tileEntitySpecialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(clazz, (TileEntitySpecialRenderer)tileEntitySpecialRenderer);
    }

    public void addEntityRenderer(Class<? extends Entity> clazz, Render render) {
        RenderingRegistry.registerEntityRenderingHandler(clazz, (Render)render);
    }

    public void addEntityRenderer(Class<? extends Entity> clazz, Class<? extends Render> clazz2) {
        Render render;
        try {
            render = clazz2.newInstance();
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        this.addEntityRenderer(clazz, render);
    }

    protected void registerDefaultRenderers() {
        for (Block block : ((BaseMod)this.base).registeredBlocks) {
            String string;
            if (!(block instanceof BaseMod.IBlock) || this.blockRenderers.containsKey(block) || (string = ((BaseMod.IBlock)block).getQualifiedRendererClassName()) == null) continue;
            try {
                Class<?> clazz = Class.forName(string);
                this.addBlockRenderer(block, (ICustomRenderer)clazz.newInstance());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static void openClientGui(GuiScreen guiScreen) {
        FMLClientHandler.instance().getClient().func_147108_a(guiScreen);
    }

    public ResourceLocation textureLocation(String string) {
        return ((BaseMod)this.base).resourceLocation("textures/" + string);
    }

    public void bindTexture(String string) {
        BaseModClient.bindTexture(this.textureLocation(string));
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(resourceLocation);
    }

    public Object getServerGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return ((BaseMod)this.base).getServerGuiElement(n, entityPlayer, world, n2, n3, n4);
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return this.getClientGuiElement(n, entityPlayer, world, new BlockPos(n2, n3, n4));
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        Class<? extends GuiScreen> clazz;
        int n2 = n >> 16;
        n &= 0xFFFF;
        Object object = null;
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: for id %s\n", n);
        }
        if ((clazz = this.screenClasses.get(n)) != null) {
            block14: {
                Class<? extends Container> clazz2;
                if (((BaseMod)this.base).debugGui) {
                    System.out.printf("BaseModClient.getClientGuiElement: Instantiating %s\n", clazz);
                }
                if ((clazz2 = ((BaseMod)this.base).containerClasses.get(n)) != null) {
                    try {
                        Object object2;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Looking for constructor taking %s\n", clazz2);
                        }
                        Constructor<? extends GuiScreen> constructor = clazz.getConstructor(clazz2);
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating container\n", new Object[0]);
                        }
                        if ((object2 = ((BaseMod)this.base).createGuiElement(clazz2, entityPlayer, world, blockPos, n2)) == null) break block14;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating screen with container\n", new Object[0]);
                        }
                        try {
                            object = constructor.newInstance(object2);
                        }
                        catch (Exception exception) {
                            BaseMod.reportExceptionCause(exception);
                            return null;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (object == null) {
                object = ((BaseMod)this.base).createGuiElement(clazz, entityPlayer, world, blockPos, n2);
            }
        } else {
            object = this.getGuiScreen(n, entityPlayer, world, blockPos, n2);
        }
        ((BaseMod)this.base).setModOf(object);
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: returning %s\n", object);
        }
        return object;
    }

    GuiScreen getGuiScreen(int n, EntityPlayer entityPlayer, World world, BlockPos blockPos, int n2) {
        System.out.printf("%s: BaseModClient.getGuiScreen: No GuiScreen class found for gui id %d\n", this, n);
        return null;
    }

    public void addBlockRenderer(Block block, ICustomRenderer iCustomRenderer) {
        this.blockRenderers.put(block, iCustomRenderer);
        this.customRenderingRequired = true;
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            this.addItemRenderer(item, iCustomRenderer);
        }
    }

    public void addItemRenderer(Item item, ICustomRenderer iCustomRenderer) {
        this.itemRenderers.put(item, iCustomRenderer);
    }

    public ModelResourceLocation modelResourceLocation(String string, String string2) {
        return new ModelResourceLocation(((BaseMod)this.base).resourceLocation(string), string2);
    }

    public void registerModelLocations() {
    }

    protected void registerDefaultModelLocations() {
        CustomItemRenderDispatch customItemRenderDispatch = this.getCustomItemRenderDispatch();
        for (Block block : ((BaseMod)this.base).registeredBlocks) {
            Item item = Item.func_150898_a((Block)block);
            if (this.blockNeedsCustomRendering(block)) {
                this.registerSmartModelsForBlock(block);
                if (item == null) continue;
                this.registerRenderDispatcherForItem(item, customItemRenderDispatch);
                continue;
            }
            this.registerInventoryLocationForItem(item, block.func_149739_a());
        }
        for (Item item : ((BaseMod)this.base).registeredItems) {
            if (this.itemNeedsCustomRendering(item)) {
                this.registerRenderDispatcherForItem(item, customItemRenderDispatch);
                continue;
            }
            this.registerInventoryLocationForItem(item, item.func_77658_a());
        }
    }

    protected void registerSmartModelsForBlock(Block block) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)this.customBlockStateMapper);
        for (IBlockState iBlockState : block.func_176194_O().func_177619_a()) {
            ModelResourceLocation modelResourceLocation = this.customBlockStateMapper.func_178132_a(iBlockState);
            BlockParticleModel blockParticleModel = new BlockParticleModel(iBlockState);
            if (this.debugModelRegistration) {
                System.out.printf("BaseModClient.registerSmartModelsForBlock: Squirreling %s --> %s\n", modelResourceLocation, blockParticleModel);
            }
            this.smartModels.put(modelResourceLocation, blockParticleModel);
        }
    }

    protected boolean blockNeedsCustomRendering(Block block) {
        return this.blockRenderers.containsKey(block) || this.specifiesTextures(block);
    }

    protected boolean itemNeedsCustomRendering(Item item) {
        return this.itemRenderers.containsKey(item) || this.specifiesTextures(item);
    }

    protected boolean specifiesTextures(Object object) {
        return object instanceof BaseMod.ITextureConsumer && ((BaseMod.ITextureConsumer)object).getTextureNames() != null;
    }

    protected void registerRenderDispatcherForItem(Item item, CustomItemRenderDispatch customItemRenderDispatch) {
        this.registerModelLocationForSubtypes(item, customItemRenderDispatch.modelLocation);
    }

    protected void registerInventoryLocationForItem(Item item, String string) {
        String string2 = string.substring(5);
        this.registerModelLocationForSubtypes(item, new ModelResourceLocation(string2, "inventory"));
    }

    protected void registerModelLocationForSubtypes(Item item, ModelResourceLocation modelResourceLocation) {
        int n = 1;
        if (item.func_77614_k()) {
            n = this.getNumItemSubtypes(item);
        }
        if (this.debugModelRegistration) {
            System.out.printf("BaseModClient: Registering model location %s for %d subtypes of %s\n", modelResourceLocation, n, item.func_77658_a());
        }
        for (int i = 0; i < n; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)modelResourceLocation);
        }
    }

    private int getNumBlockSubtypes(Block block) {
        if (block instanceof BaseMod.IBlock) {
            return ((BaseMod.IBlock)block).getNumSubtypes();
        }
        return 1;
    }

    private int getNumItemSubtypes(Item item) {
        if (item instanceof BaseMod.IItem) {
            return ((BaseMod.IItem)item).getNumSubtypes();
        }
        if (item instanceof ItemBlock) {
            return this.getNumBlockSubtypes(Block.func_149634_a((Item)item));
        }
        return 1;
    }

    protected ICustomRenderer getCustomRenderer(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState) {
        Block block = iBlockState.func_177230_c();
        ICustomRenderer iCustomRenderer = this.blockRenderers.get(block);
        if (iCustomRenderer == null && block instanceof BaseMod.IBlock) {
            IBlockState iBlockState2 = block.func_176221_a(iBlockState, iBlockAccess, blockPos);
            iCustomRenderer = this.getCustomRendererForState(iBlockState2);
        }
        return iCustomRenderer;
    }

    protected ICustomRenderer getCustomRendererForSpec(int n, BaseMod.ModelSpec modelSpec) {
        IModel iModel = this.getModel(modelSpec.modelName);
        ITexture[] iTextureArray = new ITexture[modelSpec.textureNames.length];
        for (int i = 0; i < iTextureArray.length; ++i) {
            iTextureArray[i] = this.getTexture(n, modelSpec.textureNames[i]);
        }
        return new BaseModelRenderer(iModel, modelSpec.origin, iTextureArray);
    }

    protected ICustomRenderer getCustomRendererForState(IBlockState iBlockState) {
        BaseMod.ModelSpec modelSpec;
        Block block;
        ICustomRenderer iCustomRenderer = this.stateRendererCache.get(iBlockState);
        if (iCustomRenderer == null && (block = iBlockState.func_177230_c()) instanceof BaseMod.IBlock && (modelSpec = ((BaseMod.IBlock)block).getModelSpec(iBlockState)) != null) {
            iCustomRenderer = this.getCustomRendererForSpec(0, modelSpec);
            this.stateRendererCache.put(iBlockState, iCustomRenderer);
        }
        return iCustomRenderer;
    }

    public void renderBlockUsingModelSpec(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, IRenderTarget iRenderTarget, EnumWorldBlockLayer enumWorldBlockLayer, Trans3 trans3) {
        ICustomRenderer iCustomRenderer = this.getCustomRendererForState(iBlockState);
        if (iCustomRenderer != null) {
            iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, iRenderTarget, enumWorldBlockLayer, trans3);
        }
    }

    public void renderItemStackUsingModelSpec(ItemStack itemStack, IRenderTarget iRenderTarget, Trans3 trans3) {
        IBlockState iBlockState = BaseBlockUtils.getBlockStateFromItemStack(itemStack);
        BaseMod.IBlock iBlock = (BaseMod.IBlock)iBlockState.func_177230_c();
        BaseMod.ModelSpec modelSpec = iBlock.getModelSpec(iBlockState);
        ICustomRenderer iCustomRenderer = this.getCustomRendererForSpec(0, modelSpec);
        iCustomRenderer.renderItemStack(itemStack, iRenderTarget, trans3);
    }

    public IModel getModel(String string) {
        return ((BaseMod)this.base).getModel(string);
    }

    public ResourceLocation textureResourceLocation(int n, String string) {
        return ((BaseMod)this.base).resourceLocation(texturePrefixes[n] + string);
    }

    public ITexture getTexture(int n, String string) {
        ResourceLocation resourceLocation = this.textureResourceLocation(n, string);
        return this.textureCache.get(resourceLocation);
    }

    public TextureAtlasSprite getIcon(int n, String string) {
        return ((BaseTexture.Sprite)this.getTexture((int)n, (String)string)).icon;
    }

    @SubscribeEvent
    public void onTextureStitchEventPre(TextureStitchEvent.Pre pre) {
        this.textureCache.clear();
        for (Block block : ((BaseMod)this.base).registeredBlocks) {
            this.registerSprites(0, pre.map, block);
        }
        for (Item item : ((BaseMod)this.base).registeredItems) {
            this.registerSprites(1, pre.map, item);
        }
    }

    protected void registerSprites(int n, TextureMap textureMap, Object object) {
        if (this.debugModelRegistration) {
            System.out.printf("BaseModClient.registerSprites: for %s\n", object);
        }
        if (object instanceof BaseMod.ITextureConsumer) {
            String[] stringArray = ((BaseMod.ITextureConsumer)object).getTextureNames();
            if (this.debugModelRegistration) {
                System.out.printf("BaseModClient.registerSprites: texture names = %s\n", new Object[]{stringArray});
            }
            if (stringArray != null) {
                this.customRenderingRequired = true;
                for (String string : stringArray) {
                    ResourceLocation resourceLocation = this.textureResourceLocation(n, string);
                    if (this.textureCache.get(resourceLocation) != null) continue;
                    TextureAtlasSprite textureAtlasSprite = textureMap.func_174942_a(resourceLocation);
                    BaseTexture.Sprite sprite = BaseTexture.fromSprite(textureAtlasSprite);
                    this.textureCache.put(resourceLocation, sprite);
                }
            }
        }
    }

    protected boolean customRenderBlockToWorld(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, WorldRenderer worldRenderer, TextureAtlasSprite textureAtlasSprite, ICustomRenderer iCustomRenderer) {
        BaseWorldRenderTarget baseWorldRenderTarget = new BaseWorldRenderTarget(iBlockAccess, blockPos, worldRenderer, textureAtlasSprite);
        EnumWorldBlockLayer enumWorldBlockLayer = MinecraftForgeClient.getRenderLayer();
        iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, baseWorldRenderTarget, enumWorldBlockLayer, Trans3.blockCenter(blockPos));
        return baseWorldRenderTarget.end();
    }

    protected IBakedModel customRenderBlockToBakedModel(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, ICustomRenderer iCustomRenderer) {
        BaseBakedRenderTarget baseBakedRenderTarget = new BaseBakedRenderTarget(blockPos);
        Trans3 trans3 = Trans3.blockCenter;
        EnumWorldBlockLayer enumWorldBlockLayer = MinecraftForgeClient.getRenderLayer();
        BlockModelShapes blockModelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        TextureAtlasSprite textureAtlasSprite = blockModelShapes.func_178122_a(this.getBlockParticleState(iBlockState, iBlockAccess, blockPos));
        iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, baseBakedRenderTarget, enumWorldBlockLayer, trans3);
        return baseBakedRenderTarget.getBakedModel(textureAtlasSprite);
    }

    public IBlockState getBlockParticleState(IBlockState iBlockState, IBlockAccess iBlockAccess, BlockPos blockPos) {
        Block block = iBlockState.func_177230_c();
        if (block instanceof BaseMod.IBlock) {
            return ((BaseMod.IBlock)block).getParticleState(iBlockAccess, blockPos);
        }
        return block.func_176221_a(iBlockState, iBlockAccess, blockPos);
    }

    public boolean renderAlternateBlock(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, IRenderTarget iRenderTarget) {
        Block block = iBlockState.func_177230_c();
        if (!block.hasTileEntity(iBlockState)) {
            CustomBlockRendererDispatcher customBlockRendererDispatcher = this.getCustomBlockRendererDispatcher();
            WorldRenderer worldRenderer = ((BaseWorldRenderTarget)iRenderTarget).getWorldRenderer();
            return customBlockRendererDispatcher.func_175018_a(iBlockState, blockPos, iBlockAccess, worldRenderer);
        }
        return false;
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent modelBakeEvent) {
        if (this.debugModelRegistration) {
            System.out.printf("BaseModClient.ModelBakeEvent\n", new Object[0]);
        }
        this.getCustomItemRenderDispatch().install(modelBakeEvent);
        for (Map.Entry<ModelResourceLocation, IBakedModel> entry : this.smartModels.entrySet()) {
            if (this.debugModelRegistration) {
                System.out.printf("BaseModClient.onModelBakeEvent: Installing %s --> %s\n", entry.getKey(), entry.getValue());
            }
            modelBakeEvent.modelRegistry.func_82595_a((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    protected CustomBlockRendererDispatcher getCustomBlockRendererDispatcher() {
        if (this.customBlockRendererDispatcher == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            this.customBlockRendererDispatcher = new CustomBlockRendererDispatcher(minecraft.func_175602_ab());
            BaseUtils.setField(minecraft, "blockRenderDispatcher", "field_175618_aM", (Object)this.customBlockRendererDispatcher);
        }
        return this.customBlockRendererDispatcher;
    }

    protected CustomItemRenderDispatch getCustomItemRenderDispatch() {
        if (this.customItemRenderDispatch == null) {
            this.customItemRenderDispatch = new CustomItemRenderDispatch();
        }
        return this.customItemRenderDispatch;
    }

    public void enableCustomRendering() {
        this.getCustomBlockRendererDispatcher();
    }

    protected static class DummyStateMapper
    implements IStateMapper {
        private static Map<IBlockState, ModelResourceLocation> emptyMap = new HashMap<IBlockState, ModelResourceLocation>();

        protected DummyStateMapper() {
        }

        public Map<IBlockState, ModelResourceLocation> func_178130_a(Block block) {
            return emptyMap;
        }
    }

    protected class CustomItemRenderDispatch
    extends CustomRenderDispatch
    implements ISmartItemModel {
        public CustomItemRenderDispatch() {
            this.modelLocation = BaseModClient.this.modelResourceLocation("__custitem__", "");
        }

        public IBakedModel handleItemState(ItemStack itemStack) {
            Object object;
            Item item = itemStack.func_77973_b();
            ICustomRenderer iCustomRenderer = BaseModClient.this.itemRenderers.get(item);
            if (iCustomRenderer == null && item instanceof BaseMod.IItem && (object = ((BaseMod.IItem)item).getModelSpec(itemStack)) != null) {
                iCustomRenderer = BaseModClient.this.getCustomRendererForSpec(1, (BaseMod.ModelSpec)object);
            }
            if (iCustomRenderer == null && (object = Block.func_149634_a((Item)item)) != null) {
                iCustomRenderer = BaseModClient.this.getCustomRendererForState(object.func_176223_P());
            }
            if (iCustomRenderer != null) {
                GlStateManager.func_179103_j((int)7425);
                object = new BaseBakedRenderTarget();
                iCustomRenderer.renderItemStack(itemStack, (IRenderTarget)object, itemTrans);
                return ((BaseBakedRenderTarget)object).getBakedModel();
            }
            return null;
        }
    }

    protected class CustomRenderDispatch
    implements IBakedModel {
        public ModelResourceLocation modelLocation;

        protected CustomRenderDispatch() {
        }

        public void install(ModelBakeEvent modelBakeEvent) {
            if (BaseModClient.this.debugModelRegistration) {
                System.out.printf("BaseModClient: Installing %s at %s\n", this, this.modelLocation);
            }
            modelBakeEvent.modelRegistry.func_82595_a((Object)this.modelLocation, (Object)this);
        }

        public List<BakedQuad> func_177551_a(EnumFacing enumFacing) {
            return null;
        }

        public List<BakedQuad> func_177550_a() {
            return null;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_177553_d() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemCameraTransforms func_177552_f() {
            return null;
        }
    }

    protected class CustomBlockRendererDispatcher
    extends BlockRendererDispatcher {
        protected BlockRendererDispatcher base;

        public CustomBlockRendererDispatcher(BlockRendererDispatcher blockRendererDispatcher) {
            super(null, null);
            this.base = blockRendererDispatcher;
        }

        public BlockModelShapes func_175023_a() {
            return this.base.func_175023_a();
        }

        public BlockModelRenderer func_175019_b() {
            return this.base.func_175019_b();
        }

        public IBakedModel func_175022_a(IBlockState iBlockState, IBlockAccess iBlockAccess, BlockPos blockPos) {
            return this.base.func_175022_a(iBlockState, iBlockAccess, blockPos);
        }

        public void func_175016_a(IBlockState iBlockState, float f) {
            this.base.func_175016_a(iBlockState, f);
        }

        public boolean func_175021_a(Block block, int n) {
            return this.base.func_175021_a(block, n);
        }

        public void func_175020_a(IBlockState iBlockState, BlockPos blockPos, TextureAtlasSprite textureAtlasSprite, IBlockAccess iBlockAccess) {
            ICustomRenderer iCustomRenderer = BaseModClient.this.getCustomRenderer(iBlockAccess, blockPos, iBlockState);
            if (iCustomRenderer != null) {
                BaseBakedRenderTarget baseBakedRenderTarget = new BaseBakedRenderTarget(blockPos, textureAtlasSprite);
                Trans3 trans3 = Trans3.blockCenter;
                Block block = iBlockState.func_177230_c();
                for (EnumWorldBlockLayer enumWorldBlockLayer : EnumWorldBlockLayer.values()) {
                    if (!block.canRenderInLayer(enumWorldBlockLayer)) continue;
                    iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, baseBakedRenderTarget, enumWorldBlockLayer, trans3);
                }
                IBakedModel iBakedModel = baseBakedRenderTarget.getBakedModel();
                WorldRenderer worldRenderer = Tessellator.func_178181_a().func_178180_c();
                this.func_175019_b().func_178259_a(iBlockAccess, iBakedModel, iBlockState, blockPos, worldRenderer);
            } else {
                this.base.func_175020_a(iBlockState, blockPos, textureAtlasSprite, iBlockAccess);
            }
        }

        public boolean func_175018_a(IBlockState iBlockState, BlockPos blockPos, IBlockAccess iBlockAccess, WorldRenderer worldRenderer) {
            ICustomRenderer iCustomRenderer = BaseModClient.this.getCustomRenderer(iBlockAccess, blockPos, iBlockState);
            if (iCustomRenderer != null) {
                return BaseModClient.this.customRenderBlockToWorld(iBlockAccess, blockPos, iBlockState, worldRenderer, null, iCustomRenderer);
            }
            return this.base.func_175018_a(iBlockState, blockPos, iBlockAccess, worldRenderer);
        }
    }

    protected static class CustomBlockStateMapper
    extends DefaultStateMapper {
        protected CustomBlockStateMapper() {
        }

        public ModelResourceLocation func_178132_a(IBlockState iBlockState) {
            return super.func_178132_a(iBlockState);
        }
    }

    protected class BlockParticleModel
    implements IBakedModel {
        protected IBlockState state;

        public BlockParticleModel(IBlockState iBlockState) {
            this.state = iBlockState;
        }

        public List<BakedQuad> func_177551_a(EnumFacing enumFacing) {
            return null;
        }

        public List<BakedQuad> func_177550_a() {
            return null;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_177553_d() {
            return false;
        }

        public ItemCameraTransforms func_177552_f() {
            return null;
        }

        public TextureAtlasSprite func_177554_e() {
            String[] stringArray;
            Block block = this.state.func_177230_c();
            if (block instanceof BaseMod.IBlock && (stringArray = ((BaseMod.IBlock)block).getTextureNames()) != null && stringArray.length > 0) {
                return BaseModClient.this.getIcon(0, stringArray[0]);
            }
            return null;
        }
    }

    public static interface IModel {
        public AxisAlignedBB getBounds();

        public void addBoxesToList(Trans3 var1, List var2);

        public void render(Trans3 var1, IRenderTarget var2, ITexture ... var3);
    }

    public static interface IRenderTarget {
        public boolean isRenderingBreakEffects();

        public void setTexture(ITexture var1);

        public void setColor(double var1, double var3, double var5, double var7);

        public void setNormal(Vector3 var1);

        public void beginTriangle();

        public void beginQuad();

        public void addVertex(Vector3 var1, double var2, double var4);

        public void addProjectedVertex(Vector3 var1, EnumFacing var2);

        public void endFace();
    }

    public static interface ITiledTexture
    extends ITexture {
        public ITexture tile(int var1, int var2);
    }

    public static interface ITexture {
        public ResourceLocation location();

        public int tintIndex();

        public double red();

        public double green();

        public double blue();

        public double interpolateU(double var1);

        public double interpolateV(double var1);

        public boolean isEmissive();

        public boolean isProjected();

        public boolean isSolid();

        public ITexture tinted(int var1);

        public ITexture colored(double var1, double var3, double var5);

        public ITexture projected();

        public ITexture emissive();

        public ITiledTexture tiled(int var1, int var2);
    }

    public static interface ICustomRenderer {
        public void renderBlock(IBlockAccess var1, BlockPos var2, IBlockState var3, IRenderTarget var4, EnumWorldBlockLayer var5, Trans3 var6);

        public void renderItemStack(ItemStack var1, IRenderTarget var2, Trans3 var3);
    }
}

