/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class BaseInventoryUtils {
    public static InventorySide inventorySide(IInventory iInventory, EnumFacing enumFacing) {
        if (iInventory instanceof ISidedInventory) {
            return new SidedInventorySide((ISidedInventory)iInventory, enumFacing);
        }
        return new UnsidedInventorySide(iInventory);
    }

    public static class SidedInventorySide
    extends InventorySide {
        ISidedInventory base;
        EnumFacing side;
        int[] slots;

        public SidedInventorySide(ISidedInventory iSidedInventory, EnumFacing enumFacing) {
            this.base = iSidedInventory;
            this.side = enumFacing;
            this.slots = iSidedInventory.func_180463_a(enumFacing);
            this.size = this.slots.length;
        }

        @Override
        public ItemStack get(int n) {
            return this.base.func_70301_a(this.slots[n]);
        }

        @Override
        public boolean set(int n, ItemStack itemStack) {
            int n2 = this.slots[n];
            if (this.base.func_180462_a(n2, itemStack, this.side)) {
                this.base.func_70299_a(n2, itemStack);
                return true;
            }
            return false;
        }

        @Override
        public ItemStack extract(int n) {
            int n2 = this.slots[n];
            ItemStack itemStack = this.base.func_70301_a(n2);
            if (this.base.func_180461_b(n2, itemStack, this.side)) {
                return itemStack;
            }
            return null;
        }
    }

    public static class UnsidedInventorySide
    extends InventorySide {
        IInventory base;

        public UnsidedInventorySide(IInventory iInventory) {
            this.base = iInventory;
            this.size = iInventory.func_70302_i_();
        }

        @Override
        public ItemStack get(int n) {
            return this.base.func_70301_a(n);
        }

        @Override
        public boolean set(int n, ItemStack itemStack) {
            this.base.func_70299_a(n, itemStack);
            return true;
        }

        @Override
        public ItemStack extract(int n) {
            return this.get(n);
        }
    }

    public static abstract class InventorySide {
        public int size;

        public abstract ItemStack get(int var1);

        public abstract boolean set(int var1, ItemStack var2);

        public abstract ItemStack extract(int var1);
    }
}

