/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseBlockUtils {
    public static String getNameForBlock(Block block) {
        return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
    }

    public static boolean blockIsGettingExternallyPowered(World world, BlockPos blockPos) {
        for (EnumFacing enumFacing : BaseUtils.facings) {
            if (!BaseBlockUtils.isPoweringSide(world, blockPos.func_177972_a(enumFacing), enumFacing)) continue;
            return true;
        }
        return false;
    }

    static boolean isPoweringSide(World world, BlockPos blockPos, EnumFacing enumFacing) {
        IBlockState iBlockState = world.func_180495_p(blockPos);
        Block block = iBlockState.func_177230_c();
        if (block.func_180656_a((IBlockAccess)world, blockPos, iBlockState, enumFacing) > 0) {
            return true;
        }
        if (block.shouldCheckWeakPower((IBlockAccess)world, blockPos, enumFacing)) {
            for (EnumFacing enumFacing2 : BaseUtils.facings) {
                if (enumFacing2 == enumFacing.func_176734_d() || world.func_175627_a(blockPos.func_177972_a(enumFacing2), enumFacing2) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static IBlockState getBlockStateFromItemStack(ItemStack itemStack) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        int n = 0;
        if (itemStack.func_77973_b().func_77614_k()) {
            n = itemStack.func_77952_i() & 0xF;
        }
        return block.func_176203_a(n);
    }

    public static IBlockState getBlockStateFromMeta(Block block, int n) {
        return block.func_176203_a(n);
    }

    public static int getMetaFromBlockState(IBlockState iBlockState) {
        return iBlockState.func_177230_c().func_176201_c(iBlockState);
    }

    public static Block getWorldBlock(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return iBlockAccess.func_180495_p(blockPos).func_177230_c();
    }

    public static IBlockState getWorldBlockState(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return iBlockAccess.func_180495_p(blockPos);
    }

    public static void setWorldBlockState(World world, BlockPos blockPos, IBlockState iBlockState) {
        world.func_180501_a(blockPos, iBlockState, 3);
    }

    public static void markWorldBlockForUpdate(World world, BlockPos blockPos) {
        world.func_175689_h(blockPos);
    }

    public static void notifyWorldNeighborsOfStateChange(World world, BlockPos blockPos, Block block) {
        world.func_175685_c(blockPos, block);
    }

    public static TileEntity getWorldTileEntity(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return iBlockAccess.func_175625_s(blockPos);
    }

    public static World getTileEntityWorld(TileEntity tileEntity) {
        return tileEntity.func_145831_w();
    }

    public static BlockPos getTileEntityPos(TileEntity tileEntity) {
        return tileEntity.func_174877_v();
    }

    public static boolean blockCanRenderInLayer(Block block, EnumWorldBlockLayer enumWorldBlockLayer) {
        return block.canRenderInLayer(enumWorldBlockLayer);
    }
}

