/*
 * Decompiled with CFR 0.152.
 */
package c6h2cl2.mod.SolidXp.Util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class XpUtil {
    public static int getXpForLevel(int target) {
        int xp = 0;
        for (int i = 0; i < target; ++i) {
            xp += XpUtil.getXpCapForLevel(i);
        }
        return xp;
    }

    public static int getXpForLevel(int base, int target) {
        return XpUtil.getXpForLevel(target) - XpUtil.getXpForLevel(base);
    }

    public static int getXpCapForLevel(int level) {
        return level >= 30 ? 112 + (level - 30) * 9 : (level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2);
    }

    public static int getLevelForXp(int xp) {
        int level = 0;
        while (xp > XpUtil.getXpCapForLevel(level)) {
            xp -= XpUtil.getXpCapForLevel(level);
            ++level;
        }
        return level;
    }

    public static Map<Short, Short> getEnchantmentsFromItemStack(ItemStack itemStack) {
        NBTTagList tagList = itemStack.func_77986_q();
        if (tagList.func_82582_d()) {
            return null;
        }
        HashMap<Short, Short> enchants = new HashMap<Short, Short>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            if (!tagCompound.func_74764_b("id")) {
                return null;
            }
            enchants.put(tagCompound.func_74765_d("id"), tagCompound.func_74765_d("lvl"));
        }
        return enchants;
    }

    public static int getEnchantLevel(Map<Short, Short> enchants, Enchantment enchantment) {
        int enchantLevel = 0;
        for (Map.Entry<Short, Short> entry : enchants.entrySet()) {
            if (entry.getKey() != Enchantment.func_185258_b((Enchantment)enchantment)) continue;
            enchantLevel = entry.getValue().shortValue();
            break;
        }
        return enchantLevel;
    }

    public static int getEnchantLevel(ItemStack itemStack, Enchantment enchantment) {
        return XpUtil.getEnchantLevel(XpUtil.getEnchantmentsFromItemStack(itemStack), enchantment);
    }

    public static void decreasePlayerXp(EntityPlayer player, int amount) {
        int i = player.field_71067_cb;
        if (amount > i) {
            amount = i;
        }
        player.field_71067_cb -= amount;
        player.field_71068_ca = XpUtil.getLevelForXp(player.field_71067_cb);
        player.field_71106_cc = ((float)player.field_71067_cb - (float)XpUtil.getXpForLevel(player.field_71068_ca)) / (float)player.func_71050_bK();
    }
}

