/*
 * Decompiled with CFR 0.152.
 */
package c6h2cl2.mod.SolidXp.Event;

import c6h2cl2.mod.SolidXp.SolidXpRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class XpDropBoostEventHandler {
    @SubscribeEvent
    public void onLivingKilledByXpBoostedWeapon(LivingExperienceDropEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            return;
        }
        ItemStack itemStack = event.getAttackingPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (itemStack == null || itemStack.func_77986_q() == null) {
            return;
        }
        int xpBoostLevel = EnchantmentHelper.func_77506_a((Enchantment)SolidXpRegistry.XpBoostWeapon, (ItemStack)itemStack);
        if (xpBoostLevel == 0) {
            return;
        }
        Random random = event.getAttackingPlayer().field_70170_p.field_73012_v;
        float boost = 1.0f + random.nextFloat() * (float)xpBoostLevel;
        event.setDroppedExperience(Math.round((float)event.getOriginalExperience() * boost));
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        event.setResult(Event.Result.DEFAULT);
        event.setCanceled(false);
        int xp = event.getExpToDrop();
        xp = this.increaseXpByBreaking(event, xp);
        xp = this.increaseXpForCrops(event, xp);
        event.setExpToDrop(xp);
    }

    private int increaseXpByBreaking(BlockEvent.BreakEvent event, int xp) {
        if (event.getPlayer().func_184614_ca() != null && xp != 0) {
            ItemStack itemStack = event.getPlayer().func_184614_ca();
            int level = EnchantmentHelper.func_77506_a((Enchantment)SolidXpRegistry.XpBoostTool, (ItemStack)itemStack);
            Random random = event.getWorld().field_73012_v;
            float xpBoost = random.nextFloat() * (float)level;
            float boost = xpBoost <= 1.0f ? xpBoost + 1.0f : xpBoost;
            xp = Math.round((float)xp * boost);
        }
        return xp;
    }

    private int increaseXpForCrops(BlockEvent.BreakEvent event, int xp) {
        BlockCrops crops;
        IBlockState state;
        Block block;
        if (event.getPlayer().func_184614_ca() != null && event.getPlayer().func_184614_ca().func_77973_b() instanceof ItemHoe && (block = (state = event.getWorld().func_180495_p(event.getPos())).func_177230_c()) instanceof BlockCrops && (crops = (BlockCrops)block).func_185525_y(state)) {
            xp += EnchantmentHelper.func_77506_a((Enchantment)SolidXpRegistry.XpBoostTool, (ItemStack)event.getPlayer().func_184614_ca());
        }
        return xp;
    }
}

