/*
 * Decompiled with CFR 0.152.
 */
package com.pam.bonecraft;

import com.pam.bonecraft.BlockIconInfo;
import com.pam.bonecraft.BlockModel;
import com.pam.bonecraft.CustomTexture;
import com.pam.bonecraft.IBlockTextureProvider;
import com.pam.bonecraft.TextureRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModelGenertator {
    public static ModelGenertator INSTANCE = new ModelGenertator();
    public static HashMap<BlockIconInfo, TextureAtlasSprite> icons = new HashMap();
    public static ArrayList<BlockIconInfo> blockIconInfoList = new ArrayList();

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Pre event) {
        TextureMap textureMap = event.map;
        for (Block block : TextureRegistry.blocks) {
            if (!(block instanceof IBlockTextureProvider)) continue;
            IBlockTextureProvider blockTextureProvider = (IBlockTextureProvider)block;
            for (int i = 0; i < blockTextureProvider.amountOfVariants(); ++i) {
                for (EnumFacing side : EnumFacing.values()) {
                    String name = blockTextureProvider.getTextureName(block.func_176203_a(i), side);
                    TextureAtlasSprite texture = textureMap.getTextureExtry(name);
                    if (texture == null) {
                        texture = new CustomTexture(name);
                        textureMap.setTextureEntry(name, texture);
                    }
                    BlockIconInfo iconInfo = new BlockIconInfo(block, i, side);
                    icons.put(iconInfo, texture);
                    blockIconInfoList.add(iconInfo);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void bakeModels(ModelBakeEvent event) {
        ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        for (Block block : TextureRegistry.blocks) {
            if (!(block instanceof IBlockTextureProvider)) continue;
            IBlockTextureProvider textureProvdier = (IBlockTextureProvider)block;
            for (int i = 0; i < textureProvdier.amountOfVariants(); ++i) {
                HashMap<EnumFacing, TextureAtlasSprite> textureMap = new HashMap<EnumFacing, TextureAtlasSprite>();
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    for (BlockIconInfo iconInfo : blockIconInfoList) {
                        if (iconInfo.getBlock() != block || iconInfo.getMeta() != i || iconInfo.getSide() != side || !icons.containsKey(iconInfo)) continue;
                        textureMap.put(side, icons.get(iconInfo));
                    }
                }
                if (textureMap.isEmpty()) {
                    return;
                }
                BlockModel model = new BlockModel(textureMap, block.func_176203_a(i));
                ModelResourceLocation modelResourceLocation = TextureRegistry.getModelResourceLocation(block.func_176203_a(i));
                event.modelRegistry.func_82595_a((Object)modelResourceLocation, (Object)model);
                ModelResourceLocation inventory = TextureRegistry.getBlockinventoryResourceLocation(block);
                event.modelRegistry.func_82595_a((Object)inventory, (Object)model);
                itemModelMesher.func_178086_a(Item.func_150898_a((Block)block), i, inventory);
                event.modelRegistry.func_82595_a((Object)modelResourceLocation, (Object)model);
                itemModelMesher.func_178086_a(Item.func_150898_a((Block)block), i, modelResourceLocation);
            }
        }
    }
}

