/*
 * Decompiled with CFR 0.152.
 */
package com.pam.bonecraft;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.pam.bonecraft.CustomTexture;
import com.pam.bonecraft.IItemTexture;
import com.pam.bonecraft.ItemIconInfo;
import com.pam.bonecraft.TextureRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class ItemModelGenerator {
    public static ItemModelGenerator INSTANCE = new ItemModelGenerator();
    public static List<ItemIconInfo> icons = new ArrayList<ItemIconInfo>();

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Pre event) {
        TextureMap textureMap = event.map;
        icons.clear();
        for (Item item : TextureRegistry.items) {
            if (!(item instanceof IItemTexture)) continue;
            IItemTexture ItemTexture = (IItemTexture)item;
            for (int i = 0; i < ItemTexture.getMaxMeta(); ++i) {
                String name = ItemTexture.getTextureName(i);
                TextureAtlasSprite texture = textureMap.getTextureExtry(name);
                if (texture == null) {
                    texture = new CustomTexture(name);
                    textureMap.setTextureEntry(name, texture);
                }
                ItemIconInfo info = new ItemIconInfo(item, i, texture, name);
                icons.add(info);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void bakeModels(ModelBakeEvent event) {
        ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        block0: for (Item item : TextureRegistry.items) {
            if (!(item instanceof IItemTexture)) continue;
            IItemTexture textureProvdier = (IItemTexture)item;
            for (int i = 0; i < textureProvdier.getMaxMeta(); ++i) {
                TextureAtlasSprite texture = null;
                ItemIconInfo itemIconInfo = null;
                for (ItemIconInfo info : icons) {
                    if (info.damage != i || info.getItem() != item) continue;
                    texture = info.getSprite();
                    itemIconInfo = info;
                    break;
                }
                if (texture == null) continue block0;
                ModelResourceLocation inventory = textureProvdier.getMaxMeta() == 1 ? TextureRegistry.getItemInventoryResourceLocation(item) : new ModelResourceLocation(textureProvdier.getModID() + ":" + item.func_77667_c(new ItemStack(item, 1, i)).substring(5), "inventory");
                final TextureAtlasSprite finalTexture = texture;
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return finalTexture;
                    }
                };
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)new ResourceLocation(itemIconInfo.textureName));
                CustomModel itemLayerModel = new CustomModel((ImmutableList<ResourceLocation>)builder.build());
                IFlexibleBakedModel model = itemLayerModel.bake(ItemLayerModel.instance.getDefaultState(), DefaultVertexFormats.field_176599_b, textureGetter);
                event.modelRegistry.func_82595_a((Object)inventory, (Object)model);
                itemModelMesher.func_178086_a(item, i, inventory);
            }
        }
    }

    public class CustomBakedModel
    extends ItemLayerModel.BakedModel
    implements IPerspectiveAwareModel {
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        public final Matrix4f THIRD_PERSON_2D;
        public final Matrix4f FIRST_PERSON_FIX;

        public CustomBakedModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
            super(quads, particle, format);
            this.THIRD_PERSON_2D = ForgeHooksClient.getMatrix((ItemTransformVec3f)new ItemTransformVec3f(new Vector3f(4.8f, 0.0f, 0.0f), new Vector3f(0.0f, 0.07f, -0.2f), new Vector3f(0.55f, 0.55f, 0.55f)));
            this.FIRST_PERSON_FIX = ForgeHooksClient.getMatrix((ItemTransformVec3f)new ItemTransformVec3f(new Vector3f(0.0f, 4.0f, 0.5f), new Vector3f(-0.1f, 0.3f, 0.1f), new Vector3f(1.3f, 1.3f, 1.3f)));
            this.transforms = transforms;
        }

        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            if (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON) {
                return Pair.of(IFlexibleBakedModel.class.cast((Object)this), (Object)this.FIRST_PERSON_FIX);
            }
            if (cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON) {
                return Pair.of(IFlexibleBakedModel.class.cast((Object)this), (Object)this.THIRD_PERSON_2D);
            }
            return Pair.of(IFlexibleBakedModel.class.cast((Object)this), null);
        }
    }

    public class CustomModel
    extends ItemLayerModel {
        ImmutableList<ResourceLocation> textures;

        public CustomModel(ImmutableList<ResourceLocation> textures) {
            super(textures);
            this.textures = textures;
        }

        public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Optional transform = state.apply(Optional.absent());
            for (int i = 0; i < this.textures.size(); ++i) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)bakedTextureGetter.apply(this.textures.get(i));
                builder.addAll((Iterable)this.getQuadsForSprite(i, sprite, format, transform));
            }
            TextureAtlasSprite particle = (TextureAtlasSprite)bakedTextureGetter.apply((Object)(this.textures.isEmpty() ? new ResourceLocation("missingno") : (ResourceLocation)this.textures.get(0)));
            ImmutableMap transforms = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
            CustomBakedModel ret = new CustomBakedModel((ImmutableList<BakedQuad>)builder.build(), particle, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms);
            if (transforms.isEmpty()) {
                return ret;
            }
            return new IPerspectiveAwareModel.MapWrapper((IFlexibleBakedModel)ret, transforms);
        }
    }
}

